/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.statistics.interfaces;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesStatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesStatisticsNode;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.interfaces.InterfaceStatisticsRowSelectionEvent;
import com.sanrad.nms.client.event.vswitch.statistics.interfaces.InterfaceStatisticsRowSelectionListener;
import com.sanrad.nms.client.event.vswitch.statistics.interfaces.InterfacesStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrStatisticChart;
import com.sanrad.nms.client.gui.vswitch.statistics.interfaces.InterfacesStatisticsTableHeader;
import com.sanrad.nms.client.gui.vswitch.statistics.interfaces.SrInterfacesStatisticsTablePanel;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.util.StorageSize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;

public class SrInterfacesStatisticsChart
extends SrStatisticChart
implements InterfacesStatisticsListener,
InterfaceStatisticsRowSelectionListener {
    private static final String SERIES_IN_OCTETS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_INTERFACES_STATISTICS_CHART_IN_OCTETS);
    private static final String SERIES_OUT_OCTETS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_INTERFACES_STATISTICS_CHART_OUT_OCTETS);
    private static final String SERIES_OUT_ERRORS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_INTERFACES_STATISTICS_CHART_OUT_ERRORS);
    private SrInterfacesStatisticsTablePanel m_statTable;
    private HashMap m_inter2Rates;
    private InterfaceTableRow m_currentInterface;
    private boolean m_firstEvent;

    public SrInterfacesStatisticsChart(SrInterfacesStatisticsTablePanel statTable, int aPollingInterval) {
        super(aPollingInterval);
        this.addSeries(SERIES_IN_OCTETS);
        this.addSeries(SERIES_OUT_OCTETS);
        this.addSeries(SERIES_OUT_ERRORS);
        InterfacesStatisticsManager.getInstance().addInterfacesStatisticsListener(this);
        this.m_statTable = statTable;
        this.m_statTable.addInterfaceSelectionListener(this);
        this.m_inter2Rates = new HashMap();
        this.m_firstEvent = true;
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        if (this.m_firstEvent) {
            if (this.m_statTable.getTable().getRowCount() > 0) {
                int row = this.m_statTable.getSelectedRow();
                int aliasCol = this.m_statTable.getModel().getColumnIndex(InterfacesStatisticsTableHeader.ALIAS.getColumnName());
                AliasObject selectedInterfaceAlias = (AliasObject)this.m_statTable.getModel().getValueAt(row, aliasCol);
                this.interfaceStatisticsRowSelected(null, selectedInterfaceAlias);
            }
            this.m_firstEvent = false;
        }
        HashMap values = e.getValuesMap();
        InterfaceTableRow intID = (InterfaceTableRow)values.get(ClientParameterCode.INTERFACE_ID);
        Date currentTime = new Date();
        values.put("PointInTime", currentTime);
        List<HashMap> interValues = null;
        if (!this.m_inter2Rates.containsKey(intID)) {
            interValues = new ArrayList();
            this.m_inter2Rates.put(intID, interValues);
        } else {
            interValues = (List)this.m_inter2Rates.get(intID);
        }
        interValues.add(values);
        if (intID == null) {
            return;
        }
        if (intID.equals(this.m_currentInterface)) {
            this.updateStatisticsChart(values);
        }
    }

    @Override
    protected void updateStatisticsChart(HashMap newItem) {
        BigDecimal mega = new BigDecimal(StorageSize.MEGA.getValue());
        Long inOctets = (Long)newItem.get(ClientParameterCode.IFC_STATISTICS_IN_OCTETS_PER_SEC);
        Long outOctets = (Long)newItem.get(ClientParameterCode.IFC_STATISTICS_OUT_OCTETS_PER_SEC);
        Long outError = (Long)newItem.get(ClientParameterCode.IFC_STATISTICS_OUT_ERRORS_PER_SEC);
        Date time = (Date)newItem.get("PointInTime");
        if (inOctets != null) {
            BigDecimal inMb = new BigDecimal(inOctets);
            inMb = inMb.multiply(new BigDecimal(8));
            inMb = inMb.divide(mega, 3, 6);
            this.setSeriesValue(SERIES_IN_OCTETS, time, inMb);
        }
        if (outOctets != null) {
            BigDecimal outMb = new BigDecimal(outOctets);
            outMb = outMb.multiply(new BigDecimal(8));
            outMb = outMb.divide(mega, 3, 6);
            this.setSeriesValue(SERIES_OUT_OCTETS, time, outMb);
        }
        if (outError != null) {
            this.setSeriesValue(SERIES_OUT_ERRORS, time, outError);
        }
    }

    @Override
    public void removeListeners() {
        InterfacesStatisticsManager.getInstance().removeInterfacesStatisticsListener(this);
        this.m_statTable.removeInterfaceSelectionListener(this);
    }

    @Override
    public ChartPanel packChartToPanel() {
        ChartPanel panel = super.packChartToPanel();
        XYPlot plot = panel.getChart().getXYPlot();
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(2, ChartColor.LIGHT_RED);
        int aliasCol = this.m_statTable.getModel().getColumnIndex(InterfacesStatisticsTableHeader.ALIAS.getColumnName());
        AliasObject selectedInterfaceAlias = (AliasObject)this.m_statTable.getModel().getValueAt(0, aliasCol);
        this.getChartPanel().getChart().setTitle(selectedInterfaceAlias.toString());
        return panel;
    }

    public void interfaceStatisticsRowSelected(InterfacesStatisticsNode interfaceStatisticsTableRow, AliasObject selectedAlias) {
        this.getChartPanel().getChart().setTitle(selectedAlias.toString());
        this.m_currentInterface = (InterfaceTableRow)selectedAlias.getAdditionalValue();
        List data = null;
        data = this.m_inter2Rates.containsKey(this.m_currentInterface) ? (List)this.m_inter2Rates.get(this.m_currentInterface) : new ArrayList(0);
        this.switchItemChartDisplay(data);
    }

    @Override
    public void interfaceStatisticsRowSelected(InterfaceStatisticsRowSelectionEvent event) {
        this.interfaceStatisticsRowSelected(event.getInterfaceStatisticsTableRow(), event.getSelectedAlias());
    }

    @Override
    public void aliasChanged(InterfaceStatisticsRowSelectionEvent event) {
    }
}

