/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.statistics.interfaces;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.statistics.StatisticsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesStatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.SrInterfacesStatisticsTableModel;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.interfaces.InterfacesStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrStatisticsDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.vswitch.statistics.interfaces.SrInterfacesStatisticsChart;
import com.sanrad.nms.client.gui.vswitch.statistics.interfaces.SrInterfacesStatisticsDetailsPanel;
import com.sanrad.nms.client.gui.vswitch.statistics.interfaces.SrInterfacesStatisticsTablePanel;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTablePanel;
import java.util.Collections;
import java.util.GregorianCalendar;
import javax.swing.JFrame;
import org.jfree.chart.ChartPanel;

public class InterfacesStatisticsDialog
extends SrStatisticsDialog
implements InterfacesStatisticsListener {
    private static final String DIALOG_SPECIFIC_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_INTERFACES_STATISTICS_DIALOG_SPECIFIC_TITLE);

    public InterfacesStatisticsDialog(JFrame owner, VSwitchNode vswitchNode) {
        super(owner, ClientLoader.VSWITCH_DISPLAY_STRING + " " + vswitchNode.getName() + ": " + DIALOG_SPECIFIC_TITLE, vswitchNode);
        SrClientAction.waitAndInvokeController(Collections.singleton(StatisticsManager.activateDeactivateStatistics(this.getVswitchNode().getInterfacesStatisticsGroupNode(), true)), this);
        this.setSize(870, 570);
    }

    @Override
    public void doOnCancel() {
        SrClientAction.waitAndInvokeController(Collections.singleton(StatisticsManager.activateDeactivateStatistics(this.getVswitchNode().getInterfacesStatisticsGroupNode(), false)), this);
        InterfacesStatisticsManager.getInstance().clearStatisticNodeParamsList(this.getVswitchNode());
    }

    @Override
    protected void initDialogPanels() {
    }

    private SrTablePanel createInterfacesStatisticsTablePanel() {
        SrInterfacesStatisticsTableModel tableModel = new SrInterfacesStatisticsTableModel(this.getVswitchNode());
        SrInterfacesStatisticsTablePanel tablePanel = new SrInterfacesStatisticsTablePanel(tableModel);
        return tablePanel;
    }

    private SrInterfacesStatisticsDetailsPanel createInterfacesStatisticsDetailsPanel() {
        SrInterfacesStatisticsDetailsPanel panel = new SrInterfacesStatisticsDetailsPanel((SrInterfacesStatisticsTablePanel)this.m_statisticsTablePanel);
        panel.initFirst();
        return panel;
    }

    @Override
    protected SrPanel getStatisticsDetailsPanel() {
        return this.createInterfacesStatisticsDetailsPanel();
    }

    @Override
    protected SrTablePanel getStatisticsExtendedTablePanel() {
        return null;
    }

    @Override
    protected SrTablePanel getStatisticsTablePanel() {
        return this.createInterfacesStatisticsTablePanel();
    }

    @Override
    protected ChartPanel getStatisticsChartPanel() {
        this.m_statisticChart = new SrInterfacesStatisticsChart((SrInterfacesStatisticsTablePanel)this.m_statisticsTablePanel, this.m_vswitchNode.getStatisticsPollInterval());
        return this.m_statisticChart.packChartToPanel();
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        this.setLastUpdateTime(new GregorianCalendar());
    }

    @Override
    public void addListeners() {
        InterfacesStatisticsManager.getInstance().addInterfacesStatisticsListener(this);
    }

    @Override
    public void removeListeners() {
        InterfacesStatisticsManager.getInstance().removeInterfacesStatisticsListener(this);
    }
}

