/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.statistics.icmp;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.vswitch.statistics.icmp.ICMPStatisticsManager;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.icmp.ICMPStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigInteger;
import java.util.HashMap;

public class SrICMPStatisticsDetailsPanel
extends SrPanel
implements ICMPStatisticsListener {
    private static final String START_GUI_STR = "0/0";
    private SrClientLabel m_messagesReceivedSentLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_DETAILES_MESSAGES_RECEIVED_SENT));
    private SrClientLabel m_messagesReceivedSentValueLabel = new SrClientLabel("0/0");
    private SrClientLabel m_errorsInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_DETAILES_ERRORS_IN_OUT));
    private SrClientLabel m_errorsInOutValueLabel = new SrClientLabel("0/0");
    private SrClientLabel m_destUnreachedInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_DETAILES_DEST_UNREACHED_IN_OUT));
    private SrClientLabel m_destUnreachedInOutValueLabel = new SrClientLabel("0/0");
    private SrClientLabel m_timeExcdsInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_DETAILES_TIME_EXCDS_IN_OUT));
    private SrClientLabel m_timeExcdsInOutValueLabel = new SrClientLabel("0/0");
    private SrClientLabel m_paramProblemsInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_DETAILES_PARAM_PROBLEMS_IN_OUT));
    private SrClientLabel m_paramProblemsInOutValueLabel = new SrClientLabel("0/0");
    private SrClientLabel m_srcQuenchInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_DETAILES_SRC_QUENCH_IN_OUT));
    private SrClientLabel m_srcQuenchInOutValueLabel = new SrClientLabel("0/0");
    private SrClientLabel m_redirectInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_DETAILES_REDIRECT_IN_OUT));
    private SrClientLabel m_redirectInOutValueLabel = new SrClientLabel("0/0");
    private SrClientLabel m_echosInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_DETAILES_ECHOS_IN_OUT));
    private SrClientLabel m_echosInOutValueLabel = new SrClientLabel("0/0");
    private SrClientLabel m_echoReplyInOutLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_DETAILES_ECHO_REPLY_IN_OUT));
    private SrClientLabel m_echoReplyInOutValueLabel = new SrClientLabel("0/0");
    private SrClientLabel m_timestampsReceivedSentLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_DETAILES_TIMESTAMPS_RECEIVED_SENT));
    private SrClientLabel m_timestampsReceivedSentValueLabel = new SrClientLabel("0/0");
    private SrClientLabel m_timestampsReplyReceivedSentLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_DETAILES_TIMESTAMPS_REPLY_RECEIVED_SENT));
    private SrClientLabel m_timestampsReplyReceivedSentValueLabel = new SrClientLabel("0/0");
    private SrClientLabel m_addressMasksReceivedSentLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_DETAILES_ADDRESS_MASKS_RECEIVED_SENT));
    private SrClientLabel m_addressMasksReceivedSentValueLabel = new SrClientLabel("0/0");
    private SrClientLabel m_addressMasksReplyReceivedSentLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_DETAILES_ADDRESS_MASKS_REPLY_RECEIVED_SENT));
    private SrClientLabel m_addressMasksReplyReceivedSentValueLabel = new SrClientLabel("0/0");

    public SrICMPStatisticsDetailsPanel() {
        ICMPStatisticsManager.getInstance().addICMPStatisticsListener(this);
        this.initPanelComponents();
    }

    @Override
    public void removeListeners() {
        ICMPStatisticsManager.getInstance().removeICMPStatisticsListener(this);
    }

    private void initPanelComponents() {
        Dimension usedDim = this.setSizesOfComponents();
        this.buildAllPanels(usedDim);
    }

    private Dimension setSizesOfComponents() {
        Dimension dim = this.m_addressMasksReplyReceivedSentLabel.getPreferredSize();
        dim.width += 20;
        this.m_messagesReceivedSentLabel.setPreferredSize(dim);
        this.m_errorsInOutLabel.setPreferredSize(dim);
        this.m_destUnreachedInOutLabel.setPreferredSize(dim);
        this.m_timeExcdsInOutLabel.setPreferredSize(dim);
        this.m_paramProblemsInOutLabel.setPreferredSize(dim);
        this.m_srcQuenchInOutLabel.setPreferredSize(dim);
        this.m_redirectInOutLabel.setPreferredSize(dim);
        this.m_echosInOutLabel.setPreferredSize(dim);
        this.m_echoReplyInOutLabel.setPreferredSize(dim);
        this.m_timestampsReceivedSentLabel.setPreferredSize(dim);
        this.m_timestampsReplyReceivedSentLabel.setPreferredSize(dim);
        this.m_addressMasksReceivedSentLabel.setPreferredSize(dim);
        this.m_addressMasksReplyReceivedSentLabel.setPreferredSize(dim);
        return dim;
    }

    private void buildAllPanels(Dimension usedDim) {
        SrPanel panel = this.buildCountersPanel(usedDim);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(10, 10, 0, 10);
        this.add((Component)panel, c);
    }

    private void addDetailRow(SrPanel panelAll, SrClientLabel label, Color backColor, GridBagConstraints c, int gridx, int gridy, Insets insets) {
        SrPanel panel = new SrPanel(new BorderLayout(0, 0));
        panel.setBackground(backColor);
        c.gridx = gridx;
        c.gridy = gridy;
        if (insets != null) {
            c.insets = insets;
        }
        panel.add(label);
        if (panelAll == null) {
            this.add((Component)panel, c);
        } else {
            panelAll.add((Component)panel, c);
        }
    }

    private SrPanel buildCountersPanel(Dimension usedDim) {
        SrPanel panel = new SrPanel(new GridBagLayout());
        Color whiteBackground = LookAndFill.TABLE_BACKGROUND;
        panel.setBackground(whiteBackground);
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.1;
        c.weightx = 0.3;
        c.anchor = 23;
        c.fill = 1;
        this.addDetailRow(panel, this.m_messagesReceivedSentLabel, whiteBackground, c, 0, 0, new Insets(5, 10, 5, 0));
        this.addDetailRow(panel, this.m_messagesReceivedSentValueLabel, whiteBackground, c, 1, 0, new Insets(5, 0, 5, 10));
        this.addDetailRow(panel, this.m_errorsInOutLabel, whiteBackground, c, 0, 1, new Insets(0, 10, 5, 0));
        this.addDetailRow(panel, this.m_destUnreachedInOutLabel, whiteBackground, c, 0, 2, null);
        this.addDetailRow(panel, this.m_timeExcdsInOutLabel, whiteBackground, c, 0, 3, null);
        this.addDetailRow(panel, this.m_paramProblemsInOutLabel, whiteBackground, c, 0, 4, null);
        this.addDetailRow(panel, this.m_srcQuenchInOutLabel, whiteBackground, c, 0, 5, null);
        this.addDetailRow(panel, this.m_redirectInOutLabel, whiteBackground, c, 0, 6, null);
        this.addDetailRow(panel, this.m_echosInOutLabel, whiteBackground, c, 0, 7, null);
        this.addDetailRow(panel, this.m_echoReplyInOutLabel, whiteBackground, c, 0, 8, null);
        this.addDetailRow(panel, this.m_timestampsReceivedSentLabel, whiteBackground, c, 0, 9, null);
        this.addDetailRow(panel, this.m_timestampsReplyReceivedSentLabel, whiteBackground, c, 0, 10, null);
        this.addDetailRow(panel, this.m_addressMasksReceivedSentLabel, whiteBackground, c, 0, 11, null);
        this.addDetailRow(panel, this.m_addressMasksReplyReceivedSentLabel, whiteBackground, c, 0, 12, null);
        this.addDetailRow(panel, this.m_errorsInOutValueLabel, whiteBackground, c, 1, 1, new Insets(0, 0, 5, 10));
        this.addDetailRow(panel, this.m_destUnreachedInOutValueLabel, whiteBackground, c, 1, 2, null);
        this.addDetailRow(panel, this.m_timeExcdsInOutValueLabel, whiteBackground, c, 1, 3, null);
        this.addDetailRow(panel, this.m_paramProblemsInOutValueLabel, whiteBackground, c, 1, 4, null);
        this.addDetailRow(panel, this.m_srcQuenchInOutValueLabel, whiteBackground, c, 1, 5, null);
        this.addDetailRow(panel, this.m_redirectInOutValueLabel, whiteBackground, c, 1, 6, null);
        this.addDetailRow(panel, this.m_echosInOutValueLabel, whiteBackground, c, 1, 7, null);
        this.addDetailRow(panel, this.m_echoReplyInOutValueLabel, whiteBackground, c, 1, 8, null);
        this.addDetailRow(panel, this.m_timestampsReceivedSentValueLabel, whiteBackground, c, 1, 9, null);
        this.addDetailRow(panel, this.m_timestampsReplyReceivedSentValueLabel, whiteBackground, c, 1, 10, null);
        this.addDetailRow(panel, this.m_addressMasksReceivedSentValueLabel, whiteBackground, c, 1, 11, null);
        this.addDetailRow(panel, this.m_addressMasksReplyReceivedSentValueLabel, whiteBackground, c, 1, 12, null);
        return panel;
    }

    private void updateLabelFieldWithVal(HashMap statisticsValues, ClientParameterCode code1, ClientParameterCode code2, SrClientLabel label) {
        Object objVal1 = statisticsValues.get(code1);
        Object objVal2 = statisticsValues.get(code2);
        if (objVal1 != null || objVal2 != null) {
            String currentLabelText = label.getValue().toString();
            String currentVal1 = currentLabelText.substring(0, currentLabelText.indexOf(47));
            String currentVal2 = currentLabelText.substring(currentLabelText.indexOf(47) + 1);
            String newVal1 = objVal1 != null ? ((BigInteger)objVal1).toString() : currentVal1;
            String newVal2 = objVal2 != null ? ((BigInteger)objVal2).toString() : currentVal2;
            String newLabelText = newVal1 + "/" + newVal2;
            label.setText(newLabelText);
        }
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        HashMap statisticsValues = e.getValuesMap();
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.ICMP_STATISTICS_RECEIVED_MESSEGES, ClientParameterCode.ICMP_STATISTICS_SENT_MESSEGES, this.m_messagesReceivedSentValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.ICMP_STATISTICS_IN_ERRORS, ClientParameterCode.ICMP_STATISTICS_OUT_ERRORS, this.m_errorsInOutValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.ICMP_STATISTICS_IN_DESTINATION_UNREACHED, ClientParameterCode.ICMP_STATISTICS_OUT_DESTINATION_UNREACHED, this.m_destUnreachedInOutValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.ICMP_STATISTICS_IN_TIME_EXCEEDED, ClientParameterCode.ICMP_STATISTICS_OUT_TIME_EXCEEDED, this.m_timeExcdsInOutValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.ICMP_STATISTICS_IN_PARAMETER_PROBLEMS, ClientParameterCode.ICMP_STATISTICS_OUT_PARAMETER_PROBLEMS, this.m_paramProblemsInOutValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.ICMP_STATISTICS_IN_SOURCE_QUENCH, ClientParameterCode.ICMP_STATISTICS_OUT_SOURCE_QUENCH, this.m_srcQuenchInOutValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.ICMP_STATISTICS_IN_REDIRECT, ClientParameterCode.ICMP_STATISTICS_OUT_REDIRECT, this.m_redirectInOutValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.ICMP_STATISTICS_IN_ECHOS, ClientParameterCode.ICMP_STATISTICS_OUT_ECHOS, this.m_echosInOutValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.ICMP_STATISTICS_IN_ECHOS_REPLY, ClientParameterCode.ICMP_STATISTICS_OUT_ECHOS_REPLY, this.m_echoReplyInOutValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.ICMP_STATISTICS_RECEIVED_TIMESTAMPS, ClientParameterCode.ICMP_STATISTICS_SENT_TIMESTAMPS, this.m_timestampsReceivedSentValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.ICMP_STATISTICS_RECEIVED_TIMESTAMPS_REPLY, ClientParameterCode.ICMP_STATISTICS_SENT_TIMESTAMPS_REPLY, this.m_timestampsReplyReceivedSentValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.ICMP_STATISTICS_RECEIVED_ADDRESS_MASKS, ClientParameterCode.ICMP_STATISTICS_SENT_ADDRESS_MASKS, this.m_addressMasksReceivedSentValueLabel);
        this.updateLabelFieldWithVal(statisticsValues, ClientParameterCode.ICMP_STATISTICS_RECEIVED_ADDRESS_MASKS_REPLY, ClientParameterCode.ICMP_STATISTICS_SENT_ADDRESS_MASKS_REPLY, this.m_addressMasksReplyReceivedSentValueLabel);
    }
}

