/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.statistics.icmp;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.vswitch.statistics.icmp.ICMPStatisticsManager;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.icmp.ICMPStatisticsListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrStatisticChart;
import com.sanrad.nms.server.logic.ClientParameterCode;
import java.util.Date;
import java.util.HashMap;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;

public class SrICMPStatisticsChart
extends SrStatisticChart
implements ICMPStatisticsListener {
    private static final String SERIES_MESSAGES_RECEIVED = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_CHART_MESSAGES_RECEIVED);
    private static final String SERIES_MESSAGES_SENT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_CHART_MESSAGES_SENT);
    private static final String SERIES_IN_ERRORS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_CHART_IN_ERRORS);
    private static final String SERIES_OUT_ERRORS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ICMP_STATISTICS_CHART_OUT_ERRORS);

    public SrICMPStatisticsChart(int aPollingInterval) {
        super(aPollingInterval);
        this.addSeries(SERIES_MESSAGES_RECEIVED);
        this.addSeries(SERIES_MESSAGES_SENT);
        this.addSeries(SERIES_IN_ERRORS);
        this.addSeries(SERIES_OUT_ERRORS);
        ICMPStatisticsManager.getInstance().addICMPStatisticsListener(this);
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        HashMap values = e.getValuesMap();
        Long msgReceived = (Long)values.get(ClientParameterCode.ICMP_STATISTICS_RECEIVED_MESSEGES_PER_SEC);
        Long msgSent = (Long)values.get(ClientParameterCode.ICMP_STATISTICS_SENT_MESSEGES_PER_SEC);
        Long inError = (Long)values.get(ClientParameterCode.ICMP_STATISTICS_IN_ERRORS_PER_SEC);
        Long outError = (Long)values.get(ClientParameterCode.ICMP_STATISTICS_OUT_ERRORS_PER_SEC);
        Date time = new Date();
        if (msgReceived != null) {
            this.setSeriesValue(SERIES_MESSAGES_RECEIVED, time, msgReceived);
        }
        if (msgSent != null) {
            this.setSeriesValue(SERIES_MESSAGES_SENT, time, msgSent);
        }
        if (inError != null) {
            this.setSeriesValue(SERIES_IN_ERRORS, time, inError);
        }
        if (outError != null) {
            this.setSeriesValue(SERIES_OUT_ERRORS, time, outError);
        }
    }

    @Override
    public void removeListeners() {
        ICMPStatisticsManager.getInstance().removeICMPStatisticsListener(this);
    }

    @Override
    public ChartPanel packChartToPanel() {
        ChartPanel panel = super.packChartToPanel();
        XYPlot plot = panel.getChart().getXYPlot();
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(2, ChartColor.LIGHT_RED);
        renderer.setSeriesPaint(3, ChartColor.VERY_DARK_RED);
        return panel;
    }
}

