/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.interfaces.pscsi;

import com.sanrad.nms.client.data.InterfaceManager;
import com.sanrad.nms.client.data.vswitch.interfaces.pscsi.PSCSIInterfaceTableRow;
import com.sanrad.nms.client.data.vswitch.interfaces.pscsi.PSCSIInterfaceValidator;
import com.sanrad.nms.client.data.vswitch.interfaces.pscsi.SrPSCSIInterfacePropertiesTableModel;
import com.sanrad.nms.client.gui.vswitch.interfaces.SrInterfacePropertiesTablePanel;
import com.sanrad.nms.client.gui.vswitch.interfaces.pscsi.PSCSIInterfacePropertiesTableHeader;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.SrDefaultCellEditor;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.table.event.TableCellEditAdapter;
import com.sanrad.swing.table.event.TableCellEditEvent;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.table.TableColumn;

public class SrPSCSIInterfacePropertiesTablePanel
extends SrInterfacePropertiesTablePanel {
    public SrPSCSIInterfacePropertiesTablePanel(SrPSCSIInterfacePropertiesTableModel model, OperationController controller, JFrame owner) {
        super(model, controller, owner);
    }

    @Override
    protected void setRendererAndEditor() {
        SrPSCSIInterfacePropertiesTableModel model = (SrPSCSIInterfacePropertiesTableModel)this.getModel();
        int busCol = model.getColumnIndex(PSCSIInterfacePropertiesTableHeader.BUS_ID.getColumnName());
        TableColumn busColumn = this.getTable().getColumnModel().getColumn(busCol);
        busColumn.setCellEditor(new SrDefaultCellEditor(new SrIntegerTextField()));
        this.addTableCellEditListener(new PSCSIInterfaceListener());
    }

    @Override
    protected Class getTableHeaderClass() {
        return PSCSIInterfacePropertiesTableHeader.class;
    }

    private class PSCSIInterfaceListener
    extends TableCellEditAdapter {
        private PSCSIInterfaceListener() {
        }

        @Override
        public void tableEditingStopped(TableCellEditEvent e) {
            Object m_busIdValueBeforeEdit = e.getEditorOldValue();
            int newBusId = Integer.parseInt(e.getTableCellValue().toString());
            PSCSIInterfaceValidator validator = new PSCSIInterfaceValidator(newBusId);
            if (validator.isValidForCreation()) {
                int interfaceCol = SrPSCSIInterfacePropertiesTablePanel.this.getModel().getColumnIndex(PSCSIInterfacePropertiesTableHeader.ALIAS.getColumnName());
                PSCSIInterfaceTableRow pscsiInterface = (PSCSIInterfaceTableRow)SrPSCSIInterfacePropertiesTablePanel.this.getTable().getValueAt(e.getEditingRow(), interfaceCol);
                if (pscsiInterface.getBusId() != newBusId) {
                    HashMap<ClientParameterCode, Integer> params = new HashMap<ClientParameterCode, Integer>(1);
                    params.put(ClientParameterCode.PSCSI_IF_BUS_ID, new Integer(newBusId));
                    SrAction.blockActions(Collections.singleton(InterfaceManager.getInstance().changeInterfaceTableRow(pscsiInterface, params)), SrPSCSIInterfacePropertiesTablePanel.this.m_controller);
                }
            } else {
                SrPSCSIInterfacePropertiesTablePanel.this.m_controller.fail(validator.getErrorMessage());
            }
        }
    }
}

