/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.interfaces.fc;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.interfaces.fc.FCTopologyConstants;
import com.sanrad.nms.client.data.vswitch.interfaces.fc.SrFCInterfacePropertiesTableModel;
import com.sanrad.nms.client.gui.GenericTableCellRenderer;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.vswitch.interfaces.SrInterfacePropertiesTablePanel;
import com.sanrad.nms.client.gui.vswitch.interfaces.fc.FCInterfacePropertiesTableHeader;
import com.sanrad.nms.server.util.types.constants.FcAdminSpeedConstant;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.components.SrTreeComboBox;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JFrame;

public class SrFCInterfacePropertiesTablePanel
extends SrInterfacePropertiesTablePanel {
    private static ArrayList<FcAdminSpeedConstant> theFCSpeedValuesList = new ArrayList();

    public SrFCInterfacePropertiesTablePanel(SrFCInterfacePropertiesTableModel model, OperationController controller, JFrame owner) {
        super(model, controller, owner);
    }

    @Override
    protected void setRendererAndEditor() {
        for (int i = 0; i < this.getTable().getColumnCount(); ++i) {
            this.getTable().getColumnModel().getColumn(i).setCellRenderer(new GenericTableCellRenderer());
        }
        SrFCInterfacePropertiesTableModel model = (SrFCInterfacePropertiesTableModel)this.getModel();
        SrTreeComboBox topologyCombo = this.createComboBoxForTable(FCTopologyConstants.class);
        for (FCTopologyConstants value : FCTopologyConstants.getTopologies()) {
            topologyCombo.addTreeNodeItem(value);
        }
        this.setComboBoxColumn(FCInterfacePropertiesTableHeader.TOPOLOGY, topologyCombo, false);
        VSwitchNode vSwitch = model.getVSwitchNode();
        SrTreeComboBox speedCombo = this.createComboBoxForTable(FcAdminSpeedConstant.class);
        speedCombo.setTreeNodeProperties(new SpeedComboProperties(vSwitch.getVSwitchType().getFCSpeed()));
        for (FcAdminSpeedConstant value : theFCSpeedValuesList) {
            speedCombo.addTreeNodeItem(value);
        }
        this.setComboBoxColumn(FCInterfacePropertiesTableHeader.SPEED, speedCombo, false);
    }

    @Override
    protected Class getTableHeaderClass() {
        return FCInterfacePropertiesTableHeader.class;
    }

    private SrTreeComboBox createComboBoxForTable(Class c) {
        SrTreeComboBox combo = new SrTreeComboBox(FcAdminSpeedConstant.class){

            @Override
            protected int getIndentationForNode(Object aNode) {
                return 0;
            }
        };
        Insets cellInsets = combo.getCellInsets();
        cellInsets.left = 1;
        cellInsets.right = 1;
        combo.setCellInsets(cellInsets);
        return combo;
    }

    static {
        theFCSpeedValuesList.add(FcAdminSpeedConstant.FC_PORT_SPEED_AUTO);
        theFCSpeedValuesList.add(FcAdminSpeedConstant.FC_PORT_SPEED_ONE);
        theFCSpeedValuesList.add(FcAdminSpeedConstant.FC_PORT_SPEED_TWO);
        theFCSpeedValuesList.add(FcAdminSpeedConstant.FC_PORT_SPEED_FOUR);
    }

    private static class SpeedComboProperties
    implements SrTreeComboBox.TreeNodeProperties {
        private FcAdminSpeedConstant myMaxSpeed;

        SpeedComboProperties(FcAdminSpeedConstant aMaxSpeed) {
            this.myMaxSpeed = aMaxSpeed;
        }

        public String getDisabledToolTip(Object aNode) {
            if (((FcAdminSpeedConstant)aNode).compareTo(this.myMaxSpeed) > 0) {
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_FC_IF_UNSUPPORTED_SPEED_TOOLTIP);
            }
            return null;
        }

        public Icon getNodeIcon(Object aNode) {
            return null;
        }

        public String getTextForNode(Object aNode) {
            return null;
        }
    }
}

