/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.interfaces.fc;

import com.sanrad.nms.client.data.InterfaceManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.interfaces.fc.FCInterfaceTableRow;
import com.sanrad.nms.client.data.vswitch.interfaces.fc.SrFCInterfacePropertiesTableModel;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.vswitch.interfaces.InterfacePropertiesDialog;
import com.sanrad.nms.client.gui.vswitch.interfaces.SrInterfacePropertiesTablePanel;
import com.sanrad.nms.client.gui.vswitch.interfaces.fc.FCInterfacePropertiesTableHeader;
import com.sanrad.nms.client.gui.vswitch.interfaces.fc.SrFCInterfacePropertiesTablePanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTabbedPane;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public class FCInterfacePropertiesDialog
extends InterfacePropertiesDialog {
    private SrClientLabel wwnnLbl;
    private SrClientLabel funcLbl;
    private SrTextField wwnnFld;
    private SrTextField funcFld;
    public SrAction myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            SrFCInterfacePropertiesTableModel model = (SrFCInterfacePropertiesTableModel)FCInterfacePropertiesDialog.this.interfacesTable.getModel();
            int interfaceCol = model.getColumnIndex(FCInterfacePropertiesTableHeader.ALIAS.getColumnName());
            int topologyCol = model.getColumnIndex(FCInterfacePropertiesTableHeader.TOPOLOGY.getColumnName());
            int speedCol = model.getColumnIndex(FCInterfacePropertiesTableHeader.SPEED.getColumnName());
            HashMap newValues = new HashMap();
            for (int row = 0; row < FCInterfacePropertiesDialog.this.interfacesTable.getTable().getRowCount(); ++row) {
                FCInterfaceTableRow fcInterface = (FCInterfaceTableRow)FCInterfacePropertiesDialog.this.interfacesTable.getTable().getValueAt(row, interfaceCol);
                HashMap<ClientParameterCode, String> params = new HashMap<ClientParameterCode, String>(2);
                Object topologyValue = FCInterfacePropertiesDialog.this.interfacesTable.getTable().getValueAt(row, topologyCol);
                if (!fcInterface.getTopology().equals(topologyValue.toString())) {
                    params.put(ClientParameterCode.FC_IF_TOPOLOGY, topologyValue.toString());
                }
                Object speedValue = FCInterfacePropertiesDialog.this.interfacesTable.getTable().getValueAt(row, speedCol);
                if (!fcInterface.getSpeed().equals(speedValue.toString())) {
                    params.put(ClientParameterCode.FC_IF_SPEED, speedValue.toString());
                }
                newValues.put(fcInterface, params);
            }
            return InterfaceManager.getInstance().editInterfaceTableRow(newValues);
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };

    public FCInterfacePropertiesDialog(JFrame owner, VSwitchNode vswitchNode) {
        super(owner, vswitchNode);
        this.fixSizes();
        this.setSizeAndMoveToCenter(420, 400);
        this.setOKAction(this.myOKAction);
    }

    protected void fixSizes() {
        this.wwnnLbl.setPreferredSize(this.funcLbl.getPreferredSize());
    }

    @Override
    protected void setTitle() {
        this.setTitle(ClassID.VSWITCH + " " + this.vSwitchNode.getName() + " - FibreChannel Parameters");
    }

    @Override
    protected SrInterfacePropertiesTablePanel createTable() {
        SrFCInterfacePropertiesTableModel model = new SrFCInterfacePropertiesTableModel(this.vSwitchNode);
        this.interfacesTable = new SrFCInterfacePropertiesTablePanel(model, (OperationController)this, this.owner);
        return this.interfacesTable;
    }

    @Override
    protected void initComponents() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        SrTabbedPane tabsPanel = new SrTabbedPane();
        SrPanel generalPanel = this.createGeneralPanel();
        SrPanel interfacesPanel = this.createInterfacesPanel();
        tabsPanel.addTab("General", generalPanel);
        tabsPanel.addTab("Interfaces", interfacesPanel);
        mainPanel.add((Component)tabsPanel, "Center");
        this.addCenterPanel(mainPanel);
    }

    private SrPanel createGeneralPanel() {
        SrPanel generalPanel = new SrPanel();
        generalPanel.setLayout(new GridLayout(2, 1));
        SrPanel wwnnPanel = this.createWWNNPanel();
        SrPanel funcPanel = this.createFunctionsPanel();
        SrPanel panel = new SrPanel(new GridLayout(2, 1));
        panel.add(wwnnPanel);
        panel.add(funcPanel);
        generalPanel.add(panel);
        generalPanel.add(new SrPanel());
        return generalPanel;
    }

    private SrPanel createWWNNPanel() {
        this.wwnnLbl = new SrClientLabel("WWNN :");
        this.wwnnFld = new SrTextField();
        String wwnn = this.vSwitchNode.getWWNN();
        if (wwnn == null) {
            wwnn = "";
        }
        this.wwnnFld.setText(wwnn.toUpperCase());
        this.wwnnFld.setEditable(false);
        return this.createSrPanel(this.wwnnLbl, this.wwnnFld);
    }

    private SrPanel createFunctionsPanel() {
        this.funcLbl = new SrClientLabel("Functions :");
        this.funcFld = new SrTextField();
        this.funcFld.setPreferredSize(this.wwnnFld.getPreferredSize());
        String func = this.vSwitchNode.getFunctions();
        func = func == null ? "" : this.removeExtraChars(func);
        this.funcFld.setText(func);
        this.funcFld.setEditable(false);
        return this.createSrPanel(this.funcLbl, this.funcFld);
    }

    private String removeExtraChars(String str) {
        return str.substring(1, str.length() - 1);
    }

    private SrPanel createInterfacesPanel() {
        SrPanel panel = new SrPanel(new BorderLayout());
        panel.add((Component)this.createTable(), "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return panel;
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
        SrFCInterfacePropertiesTableModel model = (SrFCInterfacePropertiesTableModel)this.interfacesTable.getModel();
        model.removeListeners();
    }
}

