/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.target.qos.TargetQosGroupNode;
import com.sanrad.nms.client.data.target.qos.TargetQosGroupsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelFrame;
import com.sanrad.nms.client.gui.components.SrClientCheckBox;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.vswitch.dialogs.IPRouteTabPanel;
import com.sanrad.nms.client.gui.vswitch.dialogs.IPTabPanel;
import com.sanrad.nms.client.gui.vswitch.dialogs.InterfaceTabPanel;
import com.sanrad.nms.client.gui.vswitch.dialogs.PortalTabPanel;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.types.constants.IscsiTgtQosActivityConstant;
import com.sanrad.nms.server.util.types.constants.TempetureUnitConstant;
import com.sanrad.nms.server.util.types.constants.VSwitchStatusConstant;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrOptionPane;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrScrollPane;
import com.sanrad.swing.SrSliderPanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.ComponentHandler;
import com.sanrad.swing.components.SrCheckbox;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.text.LengthLimitedDocument;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class VSwitchPropertiesDialog
extends SrOKCancelFrame<VSwitchNode>
implements VSwitchListener {
    private static final String theContextComboLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_CONTEXT_COMBO_LABEL);
    private VSwitchNode vSwitchNode;
    private SrClientLabel nameLbl;
    private SrClientLabel myTypeLbl;
    private SrClientLabel descLbl;
    private SrClientLabel contactLbl;
    private SrClientLabel locationLbl;
    private SrClientLabel mgmIPAddLbl;
    private SrClientLabel lastResetLbl;
    private SrClientLabel dateAndTimeLbl;
    private SrClientLabel[] dateLbl;
    private SrClientLabel[] timeLbl;
    private SrClientLabel statusLbl;
    private SrTextField nameFld;
    private SrTextField myTypeFld;
    private SrClientLabel m_temperatureUnitsLbl;
    private SrComboBox<TempetureUnitConstant> m_temperatureUnitsCombo;
    private SrScrollPane scrol;
    private SrTextField contactFld;
    private SrTextField locationFld;
    private SrComboBox[] dateParams;
    private SrComboBox[] timeParams;
    private SrTextField realMgmIpFld;
    private SrTextField realLastResetFld;
    private SrTextField realStatusFld;
    private SrClientLabel snmpPortLbl;
    private SrClientLabel trapPortLbl;
    private SrClientLabel readCommLbl;
    private SrClientLabel writeCommLbl;
    private SrClientLabel timeoutLbl;
    private SrClientLabel timeoutUnitsLbl;
    private SrClientLabel retriesLbl;
    private SrIntegerTextField snmpPortFld;
    private SrIntegerTextField trapPortFld;
    private SrTextField readCommFld;
    private SrTextField writeCommFld;
    private SrIntegerTextField timeoutFld;
    private SrIntegerTextField retriesFld;
    private SrClientLabel snmpVersionLbl;
    private SrTextField snmpVersionFld;
    private JTextArea descArea;
    private SrClientLabel telnetPortLbl;
    private SrIntegerTextField telnetPortFld;
    private SrClientLabel switchIdLbl;
    private SrIntegerTextField switchIdFld;
    private SrClientLabel reportLUNsDiscoveryLbl;
    private SrClientCheckBox reportLUNsDiscoveryFld;
    private int m_hourTimeOnInit = 0;
    private int m_minTimeOnInit = 0;
    private int m_secTimeOnInit = 0;
    private SrCheckbox myQosEnableCheckbox;
    private SrClientLabel myQosLimitLbl;
    private SrSliderPanel myQosLimitSlider;
    private final int MAX_QOS_LIMIT_VALUE = 300;
    private final int MIN_QOS_LIMIT_VALUE = 0;
    private JTabbedPane tabs = new JTabbedPane();
    private InterfaceTabPanel m_interfaceTabPanel;
    private IPTabPanel m_ipTabPanel;
    private PortalTabPanel m_portalTabPanel;
    private IPRouteTabPanel m_ipRouteTabPanel;
    private ComponentHandler myCompHandler;
    private static final String[] YEARS = new String[]{"2002", "2003", "2004", "2005", "2006", "2007", "2008", "2009", "2010", "2011", "2012", "2013", "2014", "2015"};
    private static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] DAYS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    private static final String[] HOURS = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    private static final String[] MINUTES = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
    private static final String[] SECONDS = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
    private static final TempetureUnitConstant[] TEMPERATURE_UNITS = new TempetureUnitConstant[]{TempetureUnitConstant.CELZIUS, TempetureUnitConstant.FARENAIT};
    private TextFieldsInputListener m_textFieldsInputListener = new TextFieldsInputListener();

    public VSwitchPropertiesDialog(JFrame owner, VSwitchNode node) {
        super(owner, ClientLoader.VSWITCH_DISPLAY_STRING + " Properties - " + (node != null ? node.getName() : ""), SystemRootNode.getInstance().getClusterNodeOfSource(node));
        this.vSwitchNode = node;
        this.buttonsPanel.setBackground(LookAndFill.DIALOG_COLOR);
        this.initComponents();
        this.setResizable(true);
        if (this.vSwitchNode != null) {
            this.updateAllData();
        }
    }

    public VSwitchPropertiesDialog(JFrame owner, VSwitchNode node, boolean showIPTab) {
        this(owner, node);
        if (showIPTab) {
            this.tabs.setSelectedComponent(this.m_ipTabPanel);
        }
    }

    private void updateAllData() {
        this.updateGeneralPanel();
        this.updateSNMPPanel();
        this.updateAdvancedPanel();
        this.updateQosPanel();
        this.m_interfaceTabPanel.updateVswitchTabPanel(this.vSwitchNode);
        this.m_ipTabPanel.updateVswitchTabPanel(this.vSwitchNode);
        this.m_portalTabPanel.updateVswitchTabPanel(this.vSwitchNode);
        this.m_ipRouteTabPanel.updateVswitchTabPanel(this.vSwitchNode);
        if (this.vSwitchNode.getDate() == null) {
            this.setDisabledGeneralPanel();
        }
        this.setTitle(ClientLoader.VSWITCH_DISPLAY_STRING + " Properties - " + this.vSwitchNode.getName());
    }

    public void setDisabledGeneralPanel() {
        int i;
        this.myTypeFld.setEnabled(false);
        this.nameFld.setEnabled(false);
        this.descArea.setEnabled(false);
        this.contactFld.setEnabled(false);
        this.locationFld.setEnabled(false);
        this.realMgmIpFld.setEnabled(false);
        this.realLastResetFld.setEnabled(false);
        for (i = 0; i < this.dateParams.length; ++i) {
            this.dateParams[i].setEnabled(false);
        }
        for (i = 0; i < this.timeParams.length; ++i) {
            this.timeParams[i].setEnabled(false);
        }
        this.realStatusFld.setEnabled(false);
    }

    private void initComponents() {
        this.tabs.setBackground(LookAndFill.DIALOG_COLOR);
        SrPanel advancedTab = this.createAdvancedPanel();
        SrPanel snmpPanel = this.createSNMPPanel();
        SrPanel generalTab = this.createGeneralPanel();
        SrPanel qosPanel = this.createQosPanel();
        this.m_interfaceTabPanel = new InterfaceTabPanel(this, this.vSwitchNode);
        this.m_ipTabPanel = new IPTabPanel(this, this.vSwitchNode);
        this.m_portalTabPanel = new PortalTabPanel(this, this.vSwitchNode);
        this.m_ipRouteTabPanel = new IPRouteTabPanel(this, this.vSwitchNode);
        this.tabs.addTab(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_GENERAL_TAB), generalTab);
        this.tabs.addTab(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_INTERFACES_TAB), this.m_interfaceTabPanel);
        this.tabs.addTab(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_IP_TAB), this.m_ipTabPanel);
        this.tabs.addTab(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_PORTALS_TAB), this.m_portalTabPanel);
        this.tabs.addTab(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_IP_ROUTE_TAB), this.m_ipRouteTabPanel);
        this.tabs.addTab(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_QOS_TAB), qosPanel);
        this.tabs.addTab(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_SNMP_TAB), snmpPanel);
        this.tabs.addTab(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_ADVANCED_TAB), advancedTab);
        this.tabs.validate();
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.tabs, "Center");
        this.addCenterPanel(mainPanel);
        this.myCompHandler = new ComponentHandler(mainPanel);
        this.addTopContextBox(theContextComboLabel, SystemRootNode.getInstance(), VSwitchNode.class);
        this.setTopContextBoxSelection(this.vSwitchNode);
        this.fixSizes();
        this.pack();
    }

    @Override
    protected void systemNodeSelected(VSwitchNode aSysNode) {
        if (this.vSwitchNode != null) {
            this.vSwitchNode.removeDialog(VSwitchPropertiesDialog.class);
        }
        this.vSwitchNode = aSysNode;
        if (this.vSwitchNode != null) {
            this.myCompHandler.revertEnabledState();
            this.updateAllData();
            this.vSwitchNode.addDialog(this);
        } else {
            this.myCompHandler.setAllEnabled(false);
        }
        this.btnOK.setEnabled(this.vSwitchNode != null);
    }

    private void fixSizes() {
        Dimension dim = this.mgmIPAddLbl.getPreferredSize();
        this.myTypeLbl.setPreferredSize(dim);
        this.nameLbl.setPreferredSize(dim);
        this.descLbl.setPreferredSize(dim);
        this.contactLbl.setPreferredSize(dim);
        this.locationLbl.setPreferredSize(dim);
        this.lastResetLbl.setPreferredSize(dim);
        this.dateAndTimeLbl.setPreferredSize(dim);
        this.statusLbl.setPreferredSize(dim);
        this.telnetPortLbl.setPreferredSize(dim);
        this.switchIdLbl.setPreferredSize(dim);
        this.timeLbl[0].setPreferredSize(dim);
        this.dateLbl[0].setPreferredSize(dim);
        dim = this.nameFld.getPreferredSize();
        this.myTypeFld.setPreferredSize(dim);
        this.realLastResetFld.setPreferredSize(dim);
        this.realMgmIpFld.setPreferredSize(dim);
        this.realStatusFld.setPreferredSize(dim);
        this.contactFld.setPreferredSize(dim);
        this.locationFld.setPreferredSize(dim);
        this.timeParams[0].setPreferredSize(this.dateParams[0].getPreferredSize());
        this.scrol.setAlignmentY(5.5f);
        this.descLbl.setAlignmentY(5.5f);
        Dimension curDim = this.getPreferredSize();
        curDim.setSize(curDim.getWidth() + 40.0, curDim.getHeight());
        this.setPreferredSize(curDim);
    }

    private void updateSNMPPanel() {
        this.snmpPortFld.setText(Integer.toString(this.vSwitchNode.getSNMPPort()));
        this.trapPortFld.setText(Integer.toString(this.vSwitchNode.getTrapPort()));
        this.readCommFld.setText(this.vSwitchNode.getReadCommunity());
        this.writeCommFld.setText(this.vSwitchNode.getWriteCommunity());
        this.timeoutFld.setText(Long.toString(this.vSwitchNode.getTimeout()));
        this.retriesFld.setText(Integer.toString(this.vSwitchNode.getRetries()));
        this.snmpVersionFld.setText(this.vSwitchNode.getSnmpVersion().toString());
    }

    private void updateQosPanel() {
        if (this.vSwitchNode != null && this.vSwitchNode.isConnected()) {
            this.myQosEnableCheckbox.setEnableComponent(true);
            boolean isQosEnabled = Util.equalsWithNull(IscsiTgtQosActivityConstant.ENABLED, this.vSwitchNode.getQosEnable());
            this.myQosEnableCheckbox.setSelected(isQosEnabled);
            BigInteger qosRateLimit = this.vSwitchNode.getQosLimit();
            if (qosRateLimit != null) {
                this.myQosLimitSlider.setMaxValue(qosRateLimit.intValue());
            } else {
                this.myQosLimitSlider.setMaxValue(300);
            }
            TargetQosGroupNode qosGroup = TargetQosGroupsManager.getInstance().getQosGroup(this.vSwitchNode);
            if (qosGroup != null) {
                this.myQosLimitSlider.setValue(qosGroup.getMaxRate().intValue());
            } else {
                this.myQosLimitSlider.setValue(0);
            }
        } else {
            this.myQosLimitSlider.setMaxValue(300);
            this.myQosLimitSlider.setValue(0);
            this.myQosEnableCheckbox.setSelected(false);
            this.myQosEnableCheckbox.setEnableComponent(false);
        }
    }

    private SrPanel createSNMPPanel() {
        SrPanel snmpPanel = new SrPanel();
        snmpPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets.right = 5;
        c.insets.left = 5;
        c.insets.top = 7;
        c.insets.bottom = 7;
        c.anchor = 18;
        c.fill = 2;
        this.snmpPortLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_SNMP_UDP_PORT));
        this.snmpPortFld = new SrIntegerTextField();
        this.snmpPortFld.setFont(LookAndFill.GENERAL_FONT);
        c.weightx = 0.0;
        this.addToGrid(snmpPanel, this.snmpPortLbl, c, 0, 0);
        c.weightx = 0.5;
        this.addToGrid(snmpPanel, this.snmpPortFld, c, 1, 0);
        c.weightx = 0.0;
        this.trapPortLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_SNMP_TRAP_PORT));
        this.trapPortFld = new SrIntegerTextField();
        this.trapPortFld.setFont(LookAndFill.GENERAL_FONT);
        this.addToGrid(snmpPanel, this.trapPortLbl, c, 0, 1);
        this.addToGrid(snmpPanel, this.trapPortFld, c, 1, 1);
        this.readCommLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_SNMP_READ_COMMUNITY));
        this.readCommFld = new SrTextField();
        this.addToGrid(snmpPanel, this.readCommLbl, c, 0, 2);
        this.addToGrid(snmpPanel, this.readCommFld, c, 1, 2);
        this.writeCommLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_SNMP_WRITE_COMMUNITY));
        this.writeCommFld = new SrTextField();
        this.addToGrid(snmpPanel, this.writeCommLbl, c, 0, 3);
        this.addToGrid(snmpPanel, this.writeCommFld, c, 1, 3);
        this.timeoutLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_SNMP_TIMEOUT));
        this.timeoutUnitsLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_SNMP_TIMEOUT_UNIT));
        this.timeoutFld = new SrIntegerTextField();
        this.timeoutFld.setFont(LookAndFill.GENERAL_FONT);
        this.addToGrid(snmpPanel, this.timeoutLbl, c, 0, 4);
        this.addToGrid(snmpPanel, this.timeoutFld, c, 1, 4);
        c.weightx = 0.5;
        this.addToGrid(snmpPanel, this.timeoutUnitsLbl, c, 2, 4);
        c.weightx = 0.0;
        this.retriesLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_SNMP_RETRIES));
        this.retriesFld = new SrIntegerTextField();
        this.retriesFld.setFont(LookAndFill.GENERAL_FONT);
        this.addToGrid(snmpPanel, this.retriesLbl, c, 0, 5);
        this.addToGrid(snmpPanel, this.retriesFld, c, 1, 5);
        this.snmpVersionLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_SNMP_VERSION));
        this.snmpVersionFld = new SrTextField();
        this.snmpVersionFld.setForeground(LookAndFill.DISABLE_COLOR);
        this.snmpVersionFld.setEditable(false);
        c.weighty = 1.0;
        this.addToGrid(snmpPanel, this.snmpVersionLbl, c, 0, 6);
        this.addToGrid(snmpPanel, this.snmpVersionFld, c, 1, 6);
        return snmpPanel;
    }

    private void addToGrid(SrPanel p, Component comp, GridBagConstraints c, int x, int y) {
        int oldX = c.gridx;
        int oldY = c.gridy;
        c.gridx = x;
        c.gridy = y;
        p.add(comp, c);
        c.gridx = oldX;
        c.gridy = oldY;
    }

    private void updateAdvancedPanel() {
        if (this.vSwitchNode.getTelnetPort() != null) {
            this.telnetPortFld.setText(this.vSwitchNode.getTelnetPort().toString());
        } else {
            this.telnetPortFld.setText("");
            this.telnetPortFld.setEnabled(false);
        }
        if (this.vSwitchNode.getSwitchID() != null) {
            this.switchIdFld.setText(this.vSwitchNode.getSwitchID().toString());
        } else {
            this.switchIdFld.setText("");
        }
        this.m_temperatureUnitsCombo.setSelectedItem(this.vSwitchNode.getTempUnits());
        Boolean isLUNsDiscover = this.vSwitchNode.isReportLUNsDiscoveryEnable();
        if (isLUNsDiscover != null) {
            this.reportLUNsDiscoveryFld.setSelected(isLUNsDiscover);
        } else {
            this.reportLUNsDiscoveryFld.setSelected(false);
        }
    }

    private SrPanel createAdvancedPanel() {
        SrPanel advancedPanel = new SrPanel();
        advancedPanel.setLayout(new GridLayout(9, 1));
        this.telnetPortLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_ADVANCED_TELNET_PORT));
        this.telnetPortFld = new SrIntegerTextField(15, 1, ClientLoader.CONSTANSTS_BUNDLE.getIntResource(SrConstantsBundleKeys.SNMP_PORT_MAX_VALUE));
        this.telnetPortFld.setFont(LookAndFill.GENERAL_FONT);
        this.m_textFieldsInputListener.addTextField(this.telnetPortFld);
        SrPanel telnetPortPanel = this.createSrPanel(this.telnetPortLbl, this.telnetPortFld);
        this.switchIdLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_ADVANCED_SWITCH_ID));
        this.switchIdFld = new SrIntegerTextField(15);
        this.switchIdFld.setFont(LookAndFill.GENERAL_FONT);
        this.switchIdFld.setEnabled(false);
        SrPanel switchIdPanel = this.createSrPanel(this.switchIdLbl, this.switchIdFld);
        this.m_temperatureUnitsLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_ADVANCED_TEMPERTURE_UNITS));
        this.m_temperatureUnitsCombo = new SrComboBox<TempetureUnitConstant>((T[])TEMPERATURE_UNITS);
        this.m_temperatureUnitsCombo.setFont(LookAndFill.GENERAL_FONT);
        SrPanel temperatureUnitsPanel = this.createSrPanel(this.m_temperatureUnitsLbl, this.m_temperatureUnitsCombo);
        this.reportLUNsDiscoveryLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_ADVANCED_REPORT_LUN_DISCOVERY));
        this.reportLUNsDiscoveryFld = new SrClientCheckBox();
        SrPanel reportLUNsDiscoveryPanel = this.createSrPanel(this.reportLUNsDiscoveryLbl, this.reportLUNsDiscoveryFld);
        advancedPanel.add(telnetPortPanel);
        advancedPanel.add(switchIdPanel);
        advancedPanel.add(temperatureUnitsPanel);
        advancedPanel.add(reportLUNsDiscoveryPanel);
        return advancedPanel;
    }

    private SrPanel createQosPanel() {
        SrPanel qosPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.myQosEnableCheckbox = new SrCheckbox(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_ENABLE_QOS_CHECKBOX));
        this.myQosEnableCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VSwitchPropertiesDialog.this.myQosLimitSlider.setEnabled(VSwitchPropertiesDialog.this.myQosEnableCheckbox.isSelected());
            }
        });
        this.myQosLimitLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_QOS_LIMIT));
        this.myQosLimitSlider = new SrSliderPanel(0, 300, "MB/s", true);
        this.myQosLimitSlider.setMajorTickSpacing(100);
        this.myQosLimitSlider.showTicks(true);
        this.myQosLimitSlider.showLabels(true);
        this.myQosLimitSlider.setEnabled(false);
        c.insets.top = 8;
        c.insets.right = 8;
        c.insets.left = 8;
        c.insets.bottom = 15;
        c.anchor = 18;
        c.weighty = 0.0;
        c.weightx = 1.0;
        this.addToGrid(qosPanel, this.myQosEnableCheckbox, c, 0, 0);
        this.addToGrid(qosPanel, this.myQosLimitLbl, c, 0, 1);
        c.weighty = 1.0;
        c.weightx = 2.0;
        this.addToGrid(qosPanel, this.myQosLimitSlider, c, 0, 2);
        return qosPanel;
    }

    @Override
    protected SrPanel createSrPanel(JComponent c1, JComponent c2) {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(c1);
        panel.add(c2);
        return panel;
    }

    private boolean nameFieldShouldBeEnabled() {
        return true;
    }

    private void updateGeneralPanel() {
        this.myTypeFld.setText(this.vSwitchNode.getBoxType());
        this.nameFld.setText(this.vSwitchNode.getName());
        this.nameFld.setEnabled(this.nameFieldShouldBeEnabled());
        String descr = this.vSwitchNode.getDescription();
        if (descr != null) {
            this.descArea.setText(descr);
        }
        this.contactFld.setText(this.vSwitchNode.getContact());
        this.locationFld.setText(this.vSwitchNode.getLocation());
        this.realMgmIpFld.setText(this.vSwitchNode.getManagedIPAddress());
        Date lastResetDate = this.vSwitchNode.getLastReset();
        if (lastResetDate != null) {
            this.realLastResetFld.setText(lastResetDate.toString());
        } else {
            this.realLastResetFld.setText("");
        }
        Date d = null;
        if (this.vSwitchNode.isConnected()) {
            d = VSwitchManager.getInstance().getDateAndTimeFromServer(this.vSwitchNode);
        }
        this.vSwitchNode.setDate(d);
        this.setDateView(d);
        this.setTimeView(d, true);
        this.realStatusFld.setText(this.getStatusString());
    }

    private String getStatusString() {
        String conn = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_STATUS_DISCONNECTED);
        String statusStr = null;
        if (this.vSwitchNode.isConnected()) {
            conn = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_STATUS_CONNECTED);
            VSwitchStatusConstant vsStatus = this.vSwitchNode.getVSwitchStatus();
            statusStr = !VSwitchStatusConstant.OK.equals(vsStatus) ? ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_STATUS_FORMAT, conn, vsStatus.toDisplayString()) : conn;
        } else {
            statusStr = conn;
        }
        return statusStr;
    }

    public SrPanel createGeneralPanel() {
        SrPanel mainGeneralPanel = new SrPanel();
        mainGeneralPanel.setLayout(new BorderLayout());
        SrPanel generalPanel = new SrPanel();
        this.myTypeFld = new SrTextField(18);
        this.myTypeFld.setEnabled(false);
        this.myTypeLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_TYPE));
        SrPanel typePanel = this.createSrPanel(this.myTypeLbl, this.myTypeFld);
        this.nameFld = new SrTextField(18);
        this.nameLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_NAME));
        SrPanel namePanel = this.createSrPanel(this.nameLbl, this.nameFld);
        this.descLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_DESCRIPTION));
        this.descArea = new JTextArea(2, 25);
        this.descArea.setFont(LookAndFill.GENERAL_FONT);
        this.descArea.setForeground(LookAndFill.DISABLE_COLOR);
        this.descArea.setEditable(false);
        this.scrol = new SrScrollPane(this.descArea);
        SrPanel descPanel = this.createSrPanel(this.descLbl, this.scrol);
        this.descLbl.setAlignmentY(this.scrol.getAlignmentY() - 5.0f);
        this.contactFld = new SrTextField();
        this.contactLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_CONTACT));
        SrPanel contactPanel = this.createSrPanel(this.contactLbl, this.contactFld);
        this.locationLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_LOCATION));
        this.locationFld = new SrTextField();
        SrPanel locationPanel = this.createSrPanel(this.locationLbl, this.locationFld);
        this.mgmIPAddLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_MGNT_ADDR));
        this.realMgmIpFld = new SrTextField();
        this.realMgmIpFld.setEditable(false);
        this.realMgmIpFld.setForeground(LookAndFill.DISABLE_COLOR);
        SrPanel mgmIPPanel = this.createSrPanel(this.mgmIPAddLbl, this.realMgmIpFld);
        this.lastResetLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_LAST_RESET));
        this.lastResetLbl.setFont(LookAndFill.GENERAL_FONT);
        this.realLastResetFld = new SrTextField();
        this.realLastResetFld.setFont(LookAndFill.GENERAL_FONT);
        this.realLastResetFld.setForeground(LookAndFill.DISABLE_COLOR);
        this.realLastResetFld.setEditable(false);
        SrPanel lastResetPanel = this.createSrPanel(this.lastResetLbl, this.realLastResetFld);
        this.dateAndTimeLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_DATE_TIME));
        SrPanel datePanel = this.createDatePanel();
        SrPanel timePanel = this.createTimePanel();
        this.statusLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_STATUS));
        this.realStatusFld = new SrTextField();
        this.realStatusFld.setForeground(LookAndFill.DISABLE_COLOR);
        this.realStatusFld.setEditable(false);
        SrPanel statusPanel = this.createSrPanel(this.statusLbl, this.realStatusFld);
        generalPanel.setLayout(new GridLayout(10, 1));
        generalPanel.add(namePanel);
        generalPanel.add(typePanel);
        generalPanel.add(contactPanel);
        generalPanel.add(locationPanel);
        generalPanel.add(mgmIPPanel);
        generalPanel.add(lastResetPanel);
        generalPanel.add(datePanel);
        generalPanel.add(timePanel);
        generalPanel.add(statusPanel);
        mainGeneralPanel.add((Component)generalPanel, "Center");
        mainGeneralPanel.add((Component)descPanel, "South");
        mainGeneralPanel.setBackground(LookAndFill.DIALOG_COLOR);
        generalPanel.setBackground(LookAndFill.DIALOG_COLOR);
        return mainGeneralPanel;
    }

    private SrPanel createDatePanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        this.dateParams = new SrComboBox[3];
        this.dateParams[0] = new SrComboBox<String>((T[])YEARS);
        this.dateParams[1] = new SrComboBox<String>((T[])MONTHS);
        this.dateParams[2] = new SrComboBox<String>((T[])DAYS);
        this.dateLbl = new SrClientLabel[4];
        this.dateLbl[0] = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_DATE));
        this.dateLbl[1] = new SrClientLabel("");
        this.dateLbl[2] = new SrClientLabel("-");
        this.dateLbl[3] = new SrClientLabel("-");
        for (int i = 0; i < this.dateParams.length; ++i) {
            this.dateParams[i].setFont(LookAndFill.GENERAL_FONT);
            this.dateLbl[i].setFont(LookAndFill.GENERAL_FONT);
        }
        this.dateLbl[3].setFont(LookAndFill.GENERAL_FONT);
        panel.add(this.dateLbl[0]);
        panel.add(this.dateParams[0]);
        panel.add(this.dateLbl[2]);
        panel.add(this.dateParams[1]);
        panel.add(this.dateLbl[3]);
        panel.add(this.dateParams[2]);
        return panel;
    }

    private void setDateView(Date d) {
        if (d == null) {
            this.dateParams[0].setSelectedIndex(0);
            this.dateParams[1].setSelectedIndex(0);
            this.dateParams[2].setSelectedIndex(0);
            return;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        int year = cal.get(1);
        int mon = cal.get(2);
        int day = cal.get(5);
        String yearStr = Integer.toString(year);
        boolean isHere = false;
        for (int i = 0; i < this.dateParams[0].getItemCount(); ++i) {
            if (!this.dateParams[0].getItemAt(i).equals(yearStr)) continue;
            isHere = true;
            break;
        }
        if (!isHere) {
            this.dateParams[0].addItem(yearStr);
        }
        this.dateParams[0].setSelectedItem(yearStr);
        this.dateParams[1].setSelectedIndex(mon);
        this.dateParams[2].setSelectedIndex(day - 1);
    }

    private void setTimeView(Date d, boolean isDlgInit) {
        if (d == null) {
            this.timeParams[0].setSelectedIndex(0);
            this.timeParams[1].setSelectedIndex(0);
            this.timeParams[2].setSelectedIndex(0);
            return;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        if (isDlgInit) {
            this.m_hourTimeOnInit = hour;
            this.m_minTimeOnInit = min;
            this.m_secTimeOnInit = sec;
        }
        this.timeParams[0].setSelectedIndex(hour);
        this.timeParams[1].setSelectedIndex(min);
        this.timeParams[2].setSelectedIndex(sec);
    }

    private SrPanel createTimePanel() {
        SrPanel panel = new SrPanel();
        panel.setLayout(new FlowLayout(0));
        this.timeLbl = new SrClientLabel[4];
        this.timeLbl[0] = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_Time));
        this.timeLbl[1] = new SrClientLabel("");
        this.timeLbl[2] = new SrClientLabel(":");
        this.timeLbl[3] = new SrClientLabel(":");
        this.timeParams = new SrComboBox[3];
        this.timeParams[0] = new SrComboBox<String>((T[])HOURS);
        this.timeParams[1] = new SrComboBox<String>((T[])MINUTES);
        this.timeParams[2] = new SrComboBox<String>((T[])SECONDS);
        for (int i = 0; i < this.timeParams.length; ++i) {
            this.timeParams[i].setFont(LookAndFill.GENERAL_FONT);
            this.timeLbl[i].setFont(LookAndFill.GENERAL_FONT);
        }
        this.timeLbl[3].setFont(LookAndFill.GENERAL_FONT);
        panel.add(this.timeLbl[0]);
        panel.add(this.timeParams[0]);
        panel.add(this.timeLbl[2]);
        panel.add(this.timeParams[1]);
        panel.add(this.timeLbl[3]);
        panel.add(this.timeParams[2]);
        return panel;
    }

    @Override
    protected void doOnOK() {
        SrOptionPane.Option<String> choice;
        BigInteger telnetPort;
        String userTelnetPort;
        long actualTime;
        int newRateValue;
        int prevRateValue;
        String userName;
        String userContact;
        String userLocation;
        String userSnmpPort;
        int snmpPort;
        String userTrapPort;
        int trapPort;
        String userWriteComm;
        String userReadComm;
        int timeout;
        String userTimeout;
        int retries;
        HashMap<ClientParameterCode, Object> params = new HashMap<ClientParameterCode, Object>();
        String userRetries = this.retriesFld.getText().trim();
        if (userRetries != null && !userRetries.equals("") && (retries = Integer.parseInt(userRetries)) != this.vSwitchNode.getRetries()) {
            params.put(ClientParameterCode.VSWITCH_RETRIES, new Integer(retries));
        }
        if ((userTimeout = this.timeoutFld.getText().trim()) != null && userTimeout.length() > 0 && (long)(timeout = Integer.parseInt(userTimeout)) != this.vSwitchNode.getTimeout()) {
            params.put(ClientParameterCode.VSWITCH_TIMEOUT, new Long(timeout));
        }
        if (!(userReadComm = this.readCommFld.getText().trim()).equalsIgnoreCase(this.vSwitchNode.getReadCommunity())) {
            params.put(ClientParameterCode.VSWITCH_READ_COMMUNITY, userReadComm);
        }
        if (!(userWriteComm = this.writeCommFld.getText().trim()).equalsIgnoreCase(this.vSwitchNode.getWriteCommunity())) {
            params.put(ClientParameterCode.VSWITCH_WRITE_COMMUNITY, userWriteComm);
        }
        if ((trapPort = Integer.parseInt(userTrapPort = this.trapPortFld.getText().trim())) != this.vSwitchNode.getTrapPort()) {
            params.put(ClientParameterCode.VSWITCH_TRAP_PORT, new Integer(trapPort));
        }
        if ((snmpPort = Integer.parseInt(userSnmpPort = this.snmpPortFld.getText().trim())) != this.vSwitchNode.getSNMPPort()) {
            params.put(ClientParameterCode.VSWITCH_SNMP_PORT, new Integer(snmpPort));
        }
        if (!(userLocation = this.locationFld.getText().trim()).equalsIgnoreCase(this.vSwitchNode.getLocation())) {
            params.put(ClientParameterCode.VSWITCH_LOCATION, userLocation);
        }
        if (!(userContact = this.contactFld.getText().trim()).equalsIgnoreCase(this.vSwitchNode.getContact())) {
            params.put(ClientParameterCode.VSWITCH_CONTACT, userContact);
        }
        if (!(userName = this.nameFld.getText().trim()).equals(this.vSwitchNode.getName())) {
            params.put(ClientParameterCode.VSWITCH_NAME, userName);
        }
        IscsiTgtQosActivityConstant qosEnableVal = this.myQosEnableCheckbox.isSelected() ? IscsiTgtQosActivityConstant.ENABLED : IscsiTgtQosActivityConstant.DISABLED;
        IscsiTgtQosActivityConstant currentQosEnable = this.vSwitchNode.getQosEnable();
        if (!Util.equalsWithNull(currentQosEnable, qosEnableVal)) {
            params.put(ClientParameterCode.VSWITCH_TGT_QOS_ACTIVITY, qosEnableVal.intValue());
        }
        TargetQosGroupNode qosGroup = TargetQosGroupsManager.getInstance().getQosGroup(this.vSwitchNode);
        if (this.myQosEnableCheckbox.isSelected() && qosGroup != null && (prevRateValue = qosGroup.getMaxRate().intValue()) != (newRateValue = this.myQosLimitSlider.getValue())) {
            params.put(ClientParameterCode.TARGET_QOS_GROUP_RATE_LIMIT, Long.valueOf(newRateValue));
        }
        Date userDate = this.calcDate();
        long userTime = userDate.getTime();
        if (this.vSwitchNode.getDate() != null && (actualTime = this.vSwitchNode.getDate().getTime()) != userTime) {
            params.put(ClientParameterCode.VSWITCH_DATE_AND_TIME, new Long(userTime));
        }
        if ((userTelnetPort = this.telnetPortFld.getText()).length() > 0 && !(telnetPort = new BigInteger(userTelnetPort)).equals(this.vSwitchNode.getTelnetPort())) {
            JOptionPane.showMessageDialog(this, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_RESTART_AFTER_TELNET_PORT_CHANGE_MSG), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_RESTART_AFTER_TELNET_PORT_CHANGE_TITLE), 1);
            params.put(ClientParameterCode.VSWITCH_TELNET_PORT, telnetPort);
        }
        TempetureUnitConstant selectedTemperatureUnits = (TempetureUnitConstant)this.m_temperatureUnitsCombo.getSelectedItem();
        if (this.vSwitchNode.isConnected() && !selectedTemperatureUnits.equals(this.vSwitchNode.getTempUnits())) {
            params.put(ClientParameterCode.HW_TEMPERATURE_UNITS, selectedTemperatureUnits);
        }
        boolean reportLUNs = this.reportLUNsDiscoveryFld.isSelected();
        if (this.vSwitchNode.isReportLUNsDiscoveryEnable() != null && reportLUNs != this.vSwitchNode.isReportLUNsDiscoveryEnable()) {
            params.put(ClientParameterCode.VSWITCH_REPORT_LUN_DISCOVERY, new Boolean(reportLUNs));
        }
        ClusterNode cluster = (ClusterNode)this.vSwitchNode.getParent();
        if (params.containsKey(ClientParameterCode.VSWITCH_NAME) && cluster != null && cluster.getVswitchesCount() > 1 && SrOptionPaneUtil.CANCEL_BUTTON.equals(choice = SrOptionPaneUtil.showOkCancelConfirmDialog(this, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_CHANGE_NAME_WARN), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_DLG_CHANGE_NAME_WARN_TITLE)))) {
            return;
        }
        if (!params.isEmpty()) {
            SrAction.blockActions(Collections.singleton(VSwitchManager.getInstance().editVSwitches(Collections.singleton(this.vSwitchNode), params)), this);
        } else {
            this.success(null);
        }
    }

    private Date calcDate() {
        String selYear = (String)this.dateParams[0].getSelectedItem();
        int iSelYear = Integer.parseInt(selYear);
        int iSelMonth = this.dateParams[1].getSelectedIndex();
        String selDay = (String)this.dateParams[2].getSelectedItem();
        int iSelDay = Integer.parseInt(selDay);
        String selHour = (String)this.timeParams[0].getSelectedItem();
        int iSelHour = Integer.parseInt(selHour);
        String selMin = (String)this.timeParams[1].getSelectedItem();
        int iSelMin = Integer.parseInt(selMin);
        String selSec = (String)this.timeParams[2].getSelectedItem();
        int iSelSec = Integer.parseInt(selSec);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(iSelYear, iSelMonth, iSelDay, iSelHour, iSelMin, iSelSec);
        GregorianCalendar cal2 = new GregorianCalendar();
        if (this.vSwitchNode.getDate() != null) {
            cal2.setTime(this.vSwitchNode.getDate());
            int milisec = cal2.get(14);
            cal.set(14, milisec);
        } else {
            cal.set(14, 0);
        }
        Date d = cal.getTime();
        return d;
    }

    @Override
    public void removeListeners() {
        VSwitchManager.getInstance().removeVSwitchListener(this);
        this.m_interfaceTabPanel.getTablePanel().getModel().removeListeners();
        this.m_ipRouteTabPanel.getTablePanel().getModel().removeListeners();
        this.m_ipTabPanel.getTablePanel().getModel().removeListeners();
        this.m_portalTabPanel.getTablePanel().getModel().removeListeners();
        this.m_portalTabPanel.removeListeners();
    }

    @Override
    public void addListeners() {
        VSwitchManager.getInstance().addVSwitchListener(this);
        this.m_interfaceTabPanel.getTablePanel().getModel().addListeners();
        this.m_ipRouteTabPanel.getTablePanel().getModel().addListeners();
        this.m_ipTabPanel.getTablePanel().getModel().addListeners();
        this.m_portalTabPanel.getTablePanel().getModel().addListeners();
        this.m_portalTabPanel.addListeners();
    }

    @Override
    public void doOnCancel() {
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    @Override
    public void vSwitchCreated(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRemoved(VSwitchEvent e) {
        if (((VSwitch)this.vSwitchNode.getStub()).equals(e.getStub())) {
            this.requestFocus();
            this.dispose();
        }
    }

    @Override
    public void vSwitchRediscovered(VSwitchEvent e) {
    }

    @Override
    public void resetVSwitchStarted(VSwitchEvent event) {
    }

    @Override
    public void vSwitchPropertiesChanged(VSwitchEvent e) {
        BigInteger telnetPort;
        String name;
        String writeComm;
        String readComm;
        String location;
        String description;
        RemoteObject stub = e.getStub();
        if (this.vSwitchNode == null || this.vSwitchNode != null && !((VSwitch)this.vSwitchNode.getStub()).equals(stub)) {
            return;
        }
        Date date = e.getDate();
        this.setDateView(date);
        this.setTimeView(date, false);
        String contact = e.getContact();
        if (contact != null && !this.contactFld.getText().equalsIgnoreCase(contact)) {
            this.contactFld.setText(contact);
        }
        if ((description = e.getDescription()) != null && !this.descArea.getText().equalsIgnoreCase(description)) {
            this.descArea.setText(description);
        }
        if ((location = e.getLocation()) != null && !this.locationFld.getText().equalsIgnoreCase(location)) {
            this.locationFld.setText(location);
        }
        if ((readComm = e.getReadCommunity()) != null && !this.readCommFld.getText().equalsIgnoreCase(readComm)) {
            this.readCommFld.setText(readComm);
        }
        if ((writeComm = e.getWriteCommunity()) != null && !this.writeCommFld.getText().equalsIgnoreCase(writeComm)) {
            this.writeCommFld.setText(writeComm);
        }
        if ((name = e.getName()) != null && !this.nameFld.getText().equalsIgnoreCase(name)) {
            this.nameFld.setText(name);
        }
        if ((telnetPort = e.getTelnetPort()) != null) {
            String userTelnetPort = this.telnetPortFld.getText();
            if (!userTelnetPort.equals("")) {
                BigInteger tp = new BigInteger(userTelnetPort);
                if (!tp.equals(telnetPort.toString())) {
                    this.telnetPortFld.setText(telnetPort.toString());
                }
            } else if (telnetPort != null) {
                this.telnetPortFld.setText(telnetPort.toString());
            }
        }
        this.realStatusFld.setText(this.getStatusString());
        this.m_ipTabPanel.updateButtonsState();
        this.m_ipRouteTabPanel.updateButtonsState();
    }

    private class TextFieldsInputListener
    implements DocumentListener {
        ArrayList comps = new ArrayList();

        private TextFieldsInputListener() {
        }

        private void addTextField(SrTextField comp) {
            this.comps.remove(comp);
            this.comps.add(comp);
            comp.getDocument().addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            VSwitchPropertiesDialog.this.btnOK.setEnabled(this.isValid());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            VSwitchPropertiesDialog.this.btnOK.setEnabled(this.isValid());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            VSwitchPropertiesDialog.this.btnOK.setEnabled(this.isValid());
        }

        private boolean isValid() {
            int i = this.comps.size();
            while (i-- > 0) {
                if (((SrTextField)this.comps.get(i)).isComponentValid() || !((SrTextField)this.comps.get(i)).isEditable() || !((SrTextField)this.comps.get(i)).isEnabled()) continue;
                return false;
            }
            return true;
        }
    }

    private static class SNMPCommunityDocument
    extends LengthLimitedDocument {
        private static final long serialVersionUID = 1L;
        private static final String[] forbiddenChars = ClientLoader.CONSTANSTS_BUNDLE.getArrayResource(SrConstantsBundleKeys.SNMP_COMMUNITY_FORBBIDEN_CHARS);

        public SNMPCommunityDocument() {
            super(ClientLoader.CONSTANSTS_BUNDLE.getIntResource(SrConstantsBundleKeys.SNMP_COMMUNITY_MAX_LENGTH));
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str != null) {
                int i = forbiddenChars.length;
                while (i-- > 0) {
                    if (str.indexOf(forbiddenChars[i]) < 0) continue;
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            super.insertString(offset, str, attr);
        }

        @Override
        public void replace(int offset, int length, String str, AttributeSet attrs) throws BadLocationException {
            if (str != null) {
                int i = forbiddenChars.length;
                while (i-- > 0) {
                    if (str.indexOf(forbiddenChars[i]) < 0) continue;
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            super.replace(offset, length, str, attrs);
        }
    }
}

