/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.dialogs;

import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.OKCancelFrame;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.components.SrButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class TabPanel
extends SrPanel
implements ListSelectionListener {
    protected SrTablePanel table;
    protected JButton addButton;
    protected JButton deleteButton;
    protected VSwitchNode vSwitchNode;
    protected OKCancelFrame owner;
    protected boolean buttonsExist;

    public TabPanel(OKCancelFrame owner, VSwitchNode node) {
        this(owner, node, true);
    }

    public TabPanel(OKCancelFrame owner, VSwitchNode node, boolean buttonsExist) {
        this.vSwitchNode = node;
        this.owner = owner;
        this.buttonsExist = buttonsExist;
        this.initComponents();
        this.init();
    }

    void updateVswitchTabPanel(VSwitchNode aNode) {
        this.vSwitchNode = aNode;
        DeleteAction deleteAction = this.getDeleteAction();
        if (deleteAction != null) {
            this.deleteButton.setAction(deleteAction);
        }
        this.updateTable();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.table, "Center");
        this.add((Component)mainPanel, "Center");
        mainPanel.setBackground(LookAndFill.DIALOG_COLOR);
        SrPanel buttonsPanel = new SrPanel(new FlowLayout(0));
        this.addButton = new JButton("Add...");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabPanel.this.addButtonPressed();
            }
        });
        buttonsPanel.add(this.addButton);
        DeleteAction deleteAction = this.getDeleteAction();
        if (deleteAction != null) {
            this.deleteButton = new SrButton(deleteAction);
            buttonsPanel.add(this.deleteButton);
        }
        buttonsPanel.setBackground(LookAndFill.DIALOG_COLOR);
        if (this.buttonsExist) {
            this.add((Component)buttonsPanel, "South");
        }
        this.table.getTable().getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtonsState();
    }

    SrTablePanel getTablePanel() {
        return this.table;
    }

    void updateButtonsState() {
        this.addButton.setEnabled(this.getAddButtonEnabledState() && this.innerGetAddButtonEnabledState());
    }

    private boolean getAddButtonEnabledState() {
        return true;
    }

    protected boolean innerGetAddButtonEnabledState() {
        return true;
    }

    protected abstract void initComponents();

    protected abstract void updateTable();

    public abstract DeleteAction getDeleteAction();

    protected abstract void addButtonPressed();
}

