/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.InterfaceManager;
import com.sanrad.nms.client.data.vswitch.InterfaceTableRowNode;
import com.sanrad.nms.client.data.vswitch.SFPConnectedInterfaceTableRow;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.dialogs.SrInterfaceTableModel;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrClientTablePanel;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.vswitch.dialogs.InterfaceTableHeader;
import com.sanrad.nms.client.gui.vswitch.interfaces.InterfacePopupMenu;
import com.sanrad.nms.client.gui.vswitch.interfaces.SrSFPConnetcedInterfacePropertiesDialog;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.types.constants.IfJumboMtuConstant;
import com.sanrad.swing.SrDefaultCellEditor;
import com.sanrad.swing.SrTableModel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.table.SrTableCellTooltip;
import com.sanrad.swing.table.event.TableCellEditAdapter;
import com.sanrad.swing.table.event.TableCellEditEvent;
import com.sanrad.util.concurrent.SrFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class SrInterfaceTablePanel
extends SrClientTablePanel {
    private static final int INTERFACE_IDLE = 1;
    private static final int INTERFACE_RESET = 2;
    private static final String theResetPopUpText = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_IF_RESET_POP_UP);

    public SrInterfaceTablePanel(VSwitchNode aVS) {
        super(new SrInterfaceTableModel(aVS));
        this.setPopupMenu();
        this.getTable().setColumnSelectionAllowed(false);
        this.getTable().setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.setRendererAndEditor();
        this.addTableCellEditListener(new InterfaceEditorListener());
    }

    private void setRendererAndEditor() {
        int aliasColIndex = this.getModel().getColumnIndex(InterfaceTableHeader.ALIAS.getColumnName());
        TableColumn aliasColumn = this.getTable().getColumnModel().getColumn(aliasColIndex);
        SrDefaultCellEditor aliasEditor = new SrDefaultCellEditor(new JTextField());
        aliasEditor.setRollbackAfterEditing(true);
        aliasColumn.setCellEditor(aliasEditor);
        final SrComboBox mtuCombo = new SrComboBox();
        List<IfJumboMtuConstant> mtuValues = IfJumboMtuConstant.getValueList();
        mtuValues.remove(IfJumboMtuConstant.IF_JUMBO_MTU_0);
        mtuValues.remove(IfJumboMtuConstant.IF_JUMBO_MTU_16128);
        for (IfJumboMtuConstant val : mtuValues) {
            mtuCombo.addItem((IfJumboMtuConstant)val);
        }
        this.setComboBoxColumn(InterfaceTableHeader.MTU, mtuCombo, true);
        this.setColumnTooltip(InterfaceTableHeader.MTU, new SrTableCellTooltip(){

            @Override
            public String getTooltipText(int aRow, int aCol) {
                SrInterfaceTableModel model = (SrInterfaceTableModel)SrInterfaceTablePanel.this.getModel();
                List<InterfaceTableRowNode> ifs = model.getCurrentVSwitch().getInterfaceTable();
                ArrayList<InterfaceTableRowNode> interfaces = new ArrayList<InterfaceTableRowNode>(ifs);
                InterfaceTableRowNode ifRow = (InterfaceTableRowNode)interfaces.get(aRow);
                if (!ifRow.isSupportsJumboMtu()) {
                    return "Changing MTU is not supported for this type of Interface";
                }
                return mtuCombo.getSelectedItem().toString();
            }
        });
    }

    @Override
    public void setModel(SrTableModel aModel) {
        super.setModel(aModel);
        this.setPopupMenu();
    }

    private void setPopupMenu() {
        ArrayList<SrClientAction> actions = new ArrayList<SrClientAction>();
        actions.add(new InterfaceResetAction());
        actions.add(new SfpPropertiesAction());
        InterfacePopupMenu popup = new InterfacePopupMenu(this, actions);
        this.setTablePopUpMenuObject(popup);
    }

    public VSwitchNode getCurrentVSwitch() {
        return ((SrInterfaceTableModel)this.getModel()).getCurrentVSwitch();
    }

    public InterfaceTableRowNode getSelectedInterface() {
        List selectedInterfaces = this.getSelctedValues(InterfaceTableHeader.ALIAS.getColumnName());
        if (selectedInterfaces.size() == 1) {
            return (InterfaceTableRowNode)selectedInterfaces.get(0);
        }
        return null;
    }

    public void deleteSelectedRows(OperationController controller) {
    }

    @Override
    protected Class getTableHeaderClass() {
        return InterfaceTableHeader.class;
    }

    class InterfaceEditorListener
    extends TableCellEditAdapter {
        InterfaceEditorListener() {
        }

        @Override
        public void tableEditingStopped(TableCellEditEvent e) {
            Object newVal = null;
            Object oldVal = null;
            ClientParameterCode changedParameter = null;
            int changedColumn = e.getEditingColumn();
            int changedRow = e.getEditingRow();
            if (changedColumn == InterfaceTableHeader.ALIAS.getIndexInModel()) {
                changedParameter = ClientParameterCode.INTERFACE_ALIAS;
                newVal = e.getEditorValue();
                oldVal = e.getEditorOldValue();
            }
            if (changedColumn == InterfaceTableHeader.MTU.getIndexInModel()) {
                changedParameter = ClientParameterCode.INTERFACE_JUMBO_MTU;
                newVal = e.getEditorValue();
                oldVal = e.getTableCellOldValue();
            }
            if (newVal == null || newVal.equals(oldVal)) {
                return;
            }
            HashMap<ClientParameterCode, Object> paramsMap = new HashMap<ClientParameterCode, Object>();
            paramsMap.put(changedParameter, newVal);
            SrInterfaceTableModel model = (SrInterfaceTableModel)SrInterfaceTablePanel.this.getModel();
            List<InterfaceTableRowNode> interfaces = model.getCurrentVSwitch().getInterfaceTable();
            InterfaceTableRowNode ifRow = interfaces.get(changedRow);
            SrClientAction.blockActions(Collections.singleton(InterfaceManager.getInstance().changeInterfaceTableRow(ifRow, paramsMap)), StatusPanel.getInstance());
        }
    }

    private class SfpPropertiesAction
    extends SrClientAction<SFPConnectedInterfaceTableRow, Void> {
        public SfpPropertiesAction() {
            super("SFP Properties", true, true, new SrTableView<SFPConnectedInterfaceTableRow>((JTable)SrInterfaceTablePanel.this.m_table){

                @Override
                public Collection<SFPConnectedInterfaceTableRow> getValue() {
                    InterfaceTableRowNode selectedInterface = SrInterfaceTablePanel.this.getSelectedInterface();
                    if (!(selectedInterface instanceof SFPConnectedInterfaceTableRow)) {
                        return Collections.EMPTY_LIST;
                    }
                    return Collections.singleton((SFPConnectedInterfaceTableRow)selectedInterface);
                }
            }, SrLicenseTreePath.GENERAL_PATH, true);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<SFPConnectedInterfaceTableRow> arg) {
            final InterfaceTableRowNode selectedInterface = arg.iterator().next();
            Object uo = selectedInterface.getDialog(SrSFPConnetcedInterfacePropertiesDialog.class);
            if (uo == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFrame frame = new JFrame();
                        frame.setIconImage(ClientImageObject.APP_ICON.getImageIcon().getImage());
                        SrSFPConnetcedInterfacePropertiesDialog dlg = new SrSFPConnetcedInterfacePropertiesDialog(frame, selectedInterface.getParent(), (SFPConnectedInterfaceTableRow)selectedInterface);
                        selectedInterface.addDialog(dlg);
                        dlg.show();
                    }
                });
            } else {
                ((SrSFPConnetcedInterfacePropertiesDialog)uo).show();
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            InterfaceTableRowNode selectedInterface = (InterfaceTableRowNode)this.myView.getValue().iterator().next();
            VSwitchNode vSwitch = selectedInterface.getParent();
            if (!(selectedInterface instanceof SFPConnectedInterfaceTableRow)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.INTERFACES_VALIDATION_IF_IS_NOT_SFP_CONNECTED);
            }
            SFPConnectedInterfaceTableRow ifc = (SFPConnectedInterfaceTableRow)selectedInterface;
            if (ifc.isConnectorTypeUnknown()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.INTERFACES_VALIDATION_IF_CONNECTOR_IS_UNKNWON_OR_UNSPECIFIED);
            }
            return null;
        }

        @Override
        protected boolean shouldClientActionBeVisible() {
            Collection value = this.myView.getValue();
            if (value.isEmpty()) {
                return true;
            }
            InterfaceTableRowNode selectedInterface = (InterfaceTableRowNode)value.iterator().next();
            VSwitchNode vSwitch = selectedInterface.getParent();
            return vSwitch.isSupportSFP();
        }
    }

    private class InterfaceResetAction
    extends SrClientAction<InterfaceTableRowNode, Void> {
        public InterfaceResetAction() {
            super(theResetPopUpText, true, true, new SrTableView<InterfaceTableRowNode>((JTable)SrInterfaceTablePanel.this.m_table){

                @Override
                public Collection<InterfaceTableRowNode> getValue() {
                    InterfaceTableRowNode selectedInterface = SrInterfaceTablePanel.this.getSelectedInterface();
                    return Collections.singleton(selectedInterface);
                }
            }, SrLicenseTreePath.GENERAL_PATH, true);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<InterfaceTableRowNode> arg) {
            InterfaceTableRowNode selectedInterface = arg.iterator().next();
            HashMap<ClientParameterCode, Integer> params = new HashMap<ClientParameterCode, Integer>();
            params.put(ClientParameterCode.INTERFACE_RESET, 2);
            return Collections.singleton(InterfaceManager.getInstance().changeInterfaceTableRow(selectedInterface, params));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            InterfaceTableRowNode selectedInterface = (InterfaceTableRowNode)this.myView.getValue().iterator().next();
            if (selectedInterface != null && !selectedInterface.canBeReset()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.INTERFACES_VALIDATION_IF_IS_CANNNOT_BE_RESET);
            }
            return null;
        }
    }
}

