/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.dialogs;

import com.sanrad.nms.client.data.IPTableManager;
import com.sanrad.nms.client.data.vswitch.PortalTableRow;
import com.sanrad.nms.client.data.vswitch.SrTargetPortalTableRow;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.dialogs.SrPortalTableModel;
import com.sanrad.nms.client.event.IPTableEvent;
import com.sanrad.nms.client.event.IPTableListener;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.vswitch.VSwitchPropertiesController;
import com.sanrad.nms.client.gui.vswitch.dialogs.NewPortalDialog;
import com.sanrad.nms.client.gui.vswitch.dialogs.SrPortalTablePanel;
import com.sanrad.nms.client.gui.vswitch.dialogs.TabPanel;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.swing.OKCancelFrame;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFrame;

public class PortalTabPanel
extends TabPanel
implements IPTableListener {
    private DeleteAction myDeleteAction;

    public PortalTabPanel(OKCancelFrame owner, VSwitchNode vSwitchNode) {
        super(owner, vSwitchNode);
        this.updateAddButton();
    }

    @Override
    protected void initComponents() {
        SrPortalTableModel model = new SrPortalTableModel(this.vSwitchNode);
        this.table = new SrPortalTablePanel(model);
    }

    @Override
    protected void updateTable() {
        SrPortalTableModel model = new SrPortalTableModel(this.vSwitchNode);
        this.table.setModel(model);
        this.updateAddButton();
    }

    private void updateAddButton() {
        boolean enable = this.vSwitchNode != null && this.vSwitchNode.getIPTable().size() > 1;
        this.addButton.setEnabled(enable);
    }

    @Override
    public void removeListeners() {
        IPTableManager.getInstance().removeIPTableListener(this);
    }

    void addListeners() {
        IPTableManager.getInstance().addIPTableListener(this);
    }

    @Override
    public DeleteAction getDeleteAction() {
        if (this.myDeleteAction == null) {
            this.myDeleteAction = new DeleteAction<PortalTableRow>(((SrPortalTablePanel)this.table).myView, this.owner, new DeleteAction.Confirmator<PortalTableRow>(){

                @Override
                public Collection<PortalTableRow> confirmMultiple(Collection<PortalTableRow> arg) {
                    arg = super.confirmMultiple(arg);
                    ArrayList<PortalTableRow> retVal = new ArrayList<PortalTableRow>(arg);
                    for (PortalTableRow row : arg) {
                        retVal.addAll(VSwitchPropertiesController.getPortalRowsForRemoval((SrTargetPortalTableRow)row, PortalTabPanel.this.owner));
                    }
                    return retVal;
                }
            });
        }
        return this.myDeleteAction;
    }

    @Override
    protected void addButtonPressed() {
        new NewPortalDialog((JFrame)this.owner, this.vSwitchNode).show();
    }

    @Override
    public void ipTableRowCreated(IPTableEvent e) {
        VSwitch parentStub = e.getParentStub();
        if (parentStub.equals(this.vSwitchNode.getStub())) {
            this.updateAddButton();
        }
    }

    @Override
    public void ipTableRowRemoved(IPTableEvent e) {
        VSwitch parentStub = e.getParentStub();
        if (parentStub.equals(this.vSwitchNode.getStub())) {
            this.updateAddButton();
        }
    }

    @Override
    public void ipTableRowChanged(IPTableEvent e) {
    }
}

