/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.VSwitchGroupNode;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.SrSystemObjectComboBox;
import com.sanrad.nms.client.gui.SrTransientWindowPane;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.alarm.SrAlarmsTablePanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.ConstantView;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.ComponentHandler;
import com.sanrad.swing.components.SrIPTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class NewVSwitchDialog
extends SrOKCancelDialog<VSwitchGroupNode> {
    private static final String theDialogTitle = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_NEW_VSWITCH_DLG_TITLE);
    private static final String theContexComboLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_NEW_VSWITCH_DLG_CONTEX_COMBO_LABEL);
    private static final String theIpAddrLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_NEW_VSWITCH_DLG_IP_ADDR_LABEL);
    private static final String theOwnerVSwitchGroupLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_NEW_VSWITCH_DLG_CLUSTER_NAME_LABEL);
    private SrTextField myOwnerVSwitchGroupNameField;
    private SrIPTextField ipAddressField;
    private VSwitchGroupNode parent;
    private boolean mySingleSwitch;
    private boolean mySiteSwitch;
    private ComponentHandler myCompHandler;
    private Insets myFieldInsets = new Insets(5, 5, 5, 10);
    private final String IP_MASK = ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_IP_MASK);
    private final String SNMP_PORT = ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_PORT);
    private final String TRAP_PORT = ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_TRAP_PORT);
    private final String TIMEOUT = ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_TIMEOUT_MILISEC);
    private final String RETRIES = ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_NUM_OF_RETRIES);
    private final String READ_COMM = ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_READ_COMMUNITY);
    private final String WRITE_COMM = ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.SNMP_DEFAULT_WRITE_COMMUNITY);
    private SrAction myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){
        private String myLastIp;
        {
            this.myLastIp = null;
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String ownerVSwitchGroupName = null;
            if (NewVSwitchDialog.this.mySiteSwitch && (ownerVSwitchGroupName = NewVSwitchDialog.this.myOwnerVSwitchGroupNameField.getText().trim()).length() == 0) {
                String errorMessage = "The " + ClientLoader.STORAGE_RESOURCE_GROUP_DISPLAY_STRING + " is mandatory!";
                return Collections.singleton(new FailedFuture(new IllegalValueException(errorMessage), "NewVSwitchDialog.OKAction, no Owner VSwitch"));
            }
            String ip = NewVSwitchDialog.this.ipAddressField.getText();
            if (ip == null || ip.equals("")) {
                String errorMessage = "The " + ClientLoader.VSWITCH_DISPLAY_STRING + " IP Address is mandatory !";
                return Collections.singleton(new FailedFuture(new IllegalValueException(errorMessage), "NewVSwitchDialog.OKAction, no IP"));
            }
            if (NewVSwitchDialog.this.mySiteSwitch) {
                return Collections.singleton(SiteManager.getInstance().createVSwitch(ownerVSwitchGroupName, ip, NewVSwitchDialog.this.IP_MASK, Integer.parseInt(NewVSwitchDialog.this.SNMP_PORT), Integer.parseInt(NewVSwitchDialog.this.TRAP_PORT), NewVSwitchDialog.this.READ_COMM, NewVSwitchDialog.this.WRITE_COMM, Integer.parseInt(NewVSwitchDialog.this.TIMEOUT), Integer.parseInt(NewVSwitchDialog.this.RETRIES), null, null, null, NewVSwitchDialog.this.parent));
            }
            this.myLastIp = ip;
            return Collections.singleton(ClusterManager.getInstance().createVSwitch(ip, NewVSwitchDialog.this.IP_MASK, Integer.parseInt(NewVSwitchDialog.this.SNMP_PORT), Integer.parseInt(NewVSwitchDialog.this.TRAP_PORT), NewVSwitchDialog.this.READ_COMM, NewVSwitchDialog.this.WRITE_COMM, Integer.parseInt(NewVSwitchDialog.this.TIMEOUT), Integer.parseInt(NewVSwitchDialog.this.RETRIES), NewVSwitchDialog.this.parent));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            if (NewVSwitchDialog.this.getTopContextBoxSelection() == null) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VSWITCH_DLG_LOCATION_MISSING);
            }
            if (!NewVSwitchDialog.this.ipAddressField.isComponentValid()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VSWITCH_DLG_IP_MISSING);
            }
            if (NewVSwitchDialog.this.mySiteSwitch && NewVSwitchDialog.this.myOwnerVSwitchGroupNameField.getText().trim().length() == 0) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VSWITCH_DLG_CLUSTER_NAME_MISSING);
            }
            return null;
        }

        @Override
        protected void onActionFinished(Collection<? extends SrFuture<Void>> aFutures) {
            super.onActionFinished(aFutures);
            if (!NewVSwitchDialog.this.mySingleSwitch && 3.isSuccessful(aFutures, 1)) {
                ClusterNode cluster = (ClusterNode)NewVSwitchDialog.this.parent;
                SrTransientWindowPane.showAddNeighborStarted(ClientLoader.getMainFrame(), cluster.getAlias(), this.myLastIp, new SrAlarmsTablePanel.SourceAction<ClusterNode>((View<ClusterNode>)new ConstantView<ClusterNode>(Collections.singleton(cluster))));
            }
            this.myLastIp = null;
        }
    };

    public NewVSwitchDialog(JFrame owner, VSwitchGroupNode parent, boolean aIsSingleSwitch, boolean aIsSiteSwitch) {
        super(owner, theDialogTitle, SystemRootNode.getInstance().getClusterNodeOfSource(parent));
        this.parent = parent;
        this.mySingleSwitch = aIsSingleSwitch;
        this.mySiteSwitch = aIsSiteSwitch;
        this.initComponents();
        this.setTopContextBoxSelection(parent);
        this.setOKAction(this.myOKAction);
        this.pack();
        this.show();
    }

    @Override
    protected void systemNodeSelected(VSwitchGroupNode aSysNode) {
        this.parent = aSysNode;
        if (aSysNode == null) {
            this.myCompHandler.setAllEnabled(false);
            this.myOwnerVSwitchGroupNameField.setText("");
        } else {
            this.myCompHandler.revertEnabledState();
            this.mySiteSwitch = this.parent instanceof SiteNode;
            if (this.mySiteSwitch) {
                this.mySingleSwitch = true;
                this.myOwnerVSwitchGroupNameField.setText("");
            } else if (this.parent instanceof ClusterNode) {
                ClusterNode cluster = (ClusterNode)this.parent;
                this.mySingleSwitch = cluster.getVswitchesCount() == 0;
                this.myOwnerVSwitchGroupNameField.setText(cluster.getAlias());
            } else {
                throw new IllegalStateException("Cannot create a " + ClientLoader.VSWITCH_DISPLAY_STRING + " undere the selected node, " + this.parent + " ,its of class " + this.parent.getClass() + " is not supported");
            }
            this.myOwnerVSwitchGroupNameField.setEnabled(this.mySiteSwitch);
        }
    }

    private void initComponents() {
        this.myOwnerVSwitchGroupNameField = new SrTextField(15);
        this.myOwnerVSwitchGroupNameField.setFont(LookAndFill.GENERAL_FONT);
        this.ipAddressField = new SrIPTextField();
        this.ipAddressField.setFont(LookAndFill.GENERAL_FONT);
        SrPanel panel = new SrPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = this.myFieldInsets;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.setBackgroundColor(panel);
        this.createOwnerVSwitchGroupNamePanel(panel, c, 0);
        this.createIPAddressPanel(panel, c, 1);
        this.addCenterPanel(panel);
        this.setBackgroundColor(this.buttonsPanel);
        this.myCompHandler = new ComponentHandler(panel);
        SrSystemObjectComboBox.SingleTypeProperties nodeProperties = new SrSystemObjectComboBox.SingleTypeProperties(VSwitchGroupNode.class){

            @Override
            public String getDisabledToolTip(SrTreeNode aNode) {
                ClusterNode cluster;
                String msg = super.getDisabledToolTip(aNode);
                if (aNode instanceof ClusterNode && (cluster = (ClusterNode)aNode).getVswitchesCount() > 1) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.REACHED_MAX_VSWITCHES_PER_CLUSTER);
                }
                return msg;
            }

            @Override
            public String getTextForNode(SrTreeNode aNode) {
                if (aNode.equals(SystemRootNode.getInstance())) {
                    return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_SYS_OBJ_COMBO_SYS_ROOT_TEXT);
                }
                return super.getTextForNode(aNode);
            }

            @Override
            public Icon getNodeIcon(SrTreeNode aNode) {
                if (aNode.equals(SystemRootNode.getInstance())) {
                    return null;
                }
                return super.getNodeIcon(aNode);
            }
        };
        this.addTopContextBox(theContexComboLabel, new SrSystemObjectComboBox(SystemRootNode.getInstance(), VSwitchGroupNode.class, nodeProperties, true){

            @Override
            protected int getIndentationForNode(Object aNode) {
                int indentationFromRoot = super.getIndentationForNode(aNode);
                return indentationFromRoot > 0 ? indentationFromRoot - 1 : 0;
            }
        }, null);
        this.myOwnerVSwitchGroupNameField.getDocument().addDocumentListener(new View.ViewTextListener(this.myOKAction));
        this.ipAddressField.addDocumentListener(new View.ViewTextListener(this.myOKAction));
    }

    private void createOwnerVSwitchGroupNamePanel(SrPanel panel, GridBagConstraints c, int lineInPanel) {
        this.addLabelAndField(panel, c, theOwnerVSwitchGroupLabel, this.myOwnerVSwitchGroupNameField, lineInPanel);
    }

    private void createIPAddressPanel(SrPanel panel, GridBagConstraints c, int lineInPanel) {
        this.addLabelAndField(panel, c, theIpAddrLabel, this.ipAddressField, lineInPanel);
    }

    @Override
    public void doOnCancel() {
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    private void setBackgroundColor(JComponent c) {
        c.setBackground(LookAndFill.DIALOG_COLOR);
    }

    @Override
    protected void setClusterTitle() {
    }

    @Override
    public void removeListeners() {
    }
}

