/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.vswitch.IPTableRow;
import com.sanrad.nms.client.data.vswitch.PortalTableRow;
import com.sanrad.nms.client.data.vswitch.SrTargetPortalTableRow;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.vswitch.VSwitchPropertiesController;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.components.SrCheckbox;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class NewPortalDialog
extends SrOKCancelDialog {
    private static final String theIPAddressLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.ADD_PORTAL_DIALOG_IP_ADDR_LABEL);
    private static final String theTcpPortLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.ADD_PORTAL_DIALOG_TCP_PORT_LABEL);
    private static final String theApplyToNeighborCheckBoxLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.ADD_PORTAL_DIALOG_ADD_TO_NEIGHBOR_CHECKBOX_LABEL);
    private JLabel ipAddressLabel;
    private JLabel portLabel;
    private SrComboBox ipAddressField;
    private SrIntegerTextField portField;
    private VSwitchNode myVSwitchNode;
    private SrCheckbox myApplyToNeighborCheckBox;

    public NewPortalDialog(JFrame owner, VSwitchNode aVSwitchNode) {
        super(owner, ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.ADD_PORTAL_DIALOG_TITLE, aVSwitchNode.getName()), SystemRootNode.getInstance().getClusterNodeOfSource(aVSwitchNode));
        this.setModal(true);
        this.myVSwitchNode = aVSwitchNode;
        this.initComponents();
        this.setSizeAndMoveToCenter(330, 180);
        this.fixSizes();
        this.setOKAction(new OKAction());
    }

    private void initComponents() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new GridLayout(3, 1));
        this.setComponentBgColor(mainPanel);
        this.ipAddressLabel = new JLabel(theIPAddressLabel);
        this.ipAddressLabel.setFont(LookAndFill.GENERAL_FONT);
        this.ipAddressField = this.createCombo();
        this.ipAddressField.setFont(LookAndFill.GENERAL_FONT);
        SrPanel ipPanel = this.createPanel(this.ipAddressLabel, this.ipAddressField);
        this.setComponentBgColor(ipPanel);
        this.portLabel = new JLabel(theTcpPortLabel);
        this.portLabel.setFont(LookAndFill.GENERAL_FONT);
        this.portField = new SrIntegerTextField();
        this.portField.setFont(LookAndFill.GENERAL_FONT);
        this.portField.setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_PORTALS_DEFAULT_PORTAL));
        SrPanel portPanel = this.createPanel(this.portLabel, this.portField);
        this.setComponentBgColor(portPanel);
        this.myApplyToNeighborCheckBox = new SrCheckbox(theApplyToNeighborCheckBoxLabel);
        ClusterNode cluster = (ClusterNode)this.myVSwitchNode.getParent();
        if (cluster == null) {
            throw new IllegalStateException("V-Switch " + this.myVSwitchNode + " has no cluster parent.");
        }
        VSwitchNode otherVswitch = cluster.getOtherVSwitchInCluster(this.myVSwitchNode);
        if (otherVswitch != null) {
            this.myApplyToNeighborCheckBox.setSelected(true);
        } else {
            this.myApplyToNeighborCheckBox.setEnableComponent(false);
        }
        SrPanel checkboxPanel = new SrPanel(new FlowLayout(0));
        checkboxPanel.setOpaque(false);
        checkboxPanel.add(this.myApplyToNeighborCheckBox);
        mainPanel.add(ipPanel);
        mainPanel.add(portPanel);
        mainPanel.add(checkboxPanel);
        this.setComponentBgColor(this.buttonsPanel);
        this.addCenterPanel(mainPanel);
    }

    private SrComboBox createCombo() {
        Vector ips = this.myVSwitchNode.getIPTable();
        Vector<IPTableRow> comboIPs = new Vector<IPTableRow>(ips.size());
        String mgmIPAddress = this.myVSwitchNode.getManagedIPAddress();
        for (int i = 0; i < ips.size(); ++i) {
            IPTableRow row = (IPTableRow)ips.get(i);
            if (row.getIPAddress().equals(mgmIPAddress)) continue;
            comboIPs.addElement(row);
        }
        return new SrComboBox(comboIPs);
    }

    private void fixSizes() {
        Dimension dim = this.ipAddressLabel.getPreferredSize();
        this.portLabel.setPreferredSize(dim);
        this.portField.setPreferredSize(this.ipAddressField.getPreferredSize());
    }

    private boolean ipAlreadyExist(String ip, int port) {
        Vector<PortalTableRow> portals = this.myVSwitchNode.getPortalTable();
        for (int i = 0; i < portals.size(); ++i) {
            PortalTableRow row = portals.get(i);
            if (!row.isPortalRoleIncludeTarget()) continue;
            String ipAddress = row.getIPAddress();
            int p = ((SrTargetPortalTableRow)row).getPort();
            if (!ipAddress.equals(ip) || p != port) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doOnCancel() {
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    @Override
    public void removeListeners() {
    }

    public class OKAction
    extends SrClientAction<Void, Void> {
        public OKAction() {
            super(null, null, true, true, null, SrLicenseTreePath.GENERAL_PATH, false, false);
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            IPTableRow ipRow = (IPTableRow)NewPortalDialog.this.ipAddressField.getSelectedItem();
            String ip = ipRow.getIPAddress();
            if (ip != null && !ip.equals("")) {
                if (ip.equals(NewPortalDialog.this.myVSwitchNode.getManagedIPAddress())) {
                    return Collections.singleton(new FailedFuture(new IllegalValueException("The IP address cannot be the management IP address."), "NewPortalDialog.OKAction, Management IP"));
                }
                String strPort = NewPortalDialog.this.portField.getText();
                if (strPort.equals("")) {
                    return Collections.singleton(new FailedFuture(new IllegalValueException("You must enter the port."), "NewPortalDialog.OKAction, Port not set"));
                }
                Integer port = new Integer(Integer.parseInt(strPort));
                if (NewPortalDialog.this.ipAlreadyExist(ip, port)) {
                    return Collections.singleton(new FailedFuture(new IllegalValueException("IP and port already exist in " + ClientLoader.VSWITCH_DISPLAY_STRING + " " + NewPortalDialog.this.myVSwitchNode.getName() + "..."), "NewPortalDialog.OKAction, Portal exists"));
                }
                Collection<CommKeyClassId> switchesIds = null;
                switchesIds = NewPortalDialog.this.myApplyToNeighborCheckBox.isSelected() ? VSwitchPropertiesController.getSwitchesForAddPortal(NewPortalDialog.this.myVSwitchNode, NewPortalDialog.this, ip, port) : Collections.singletonList(NewPortalDialog.this.myVSwitchNode.getIdentifier());
                OKAction.blockActions();
                return Collections.singleton(ClientAOImpl.getInstance().createPortalTableRow(switchesIds, ip, port));
            }
            return Collections.singleton(new FailedFuture(new IllegalValueException("The IP field is mandatory."), "NewPortalDialog.OKAction, IP not set"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }

        @Override
        protected void onActionFinished(Collection<? extends SrFuture<Void>> aFutures) {
            super.onActionFinished(aFutures);
            OKAction.releaseActions();
        }
    }
}

