/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.vswitch.IPRouteTableRow;
import com.sanrad.nms.client.data.vswitch.InterfaceTableRowNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.vswitch.VSwitchPropertiesController;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrCheckbox;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrIPTextField;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.NetUtil;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class NewIPRouteDialog
extends SrOKCancelDialog {
    private static final String theIPAddressLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.ADD_IP_ROUTE_DIALOG_IP_ADDR_LABEL);
    private static final String theIPMaskLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.ADD_IP_ROUTE_DIALOG_IP_MASK_LABEL);
    private static final String theIPActivityLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.ADD_IP_ROUTE_DIALOG_ACTIVITY_LABEL);
    private static final String theIPInterfaceLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.ADD_IP_ROUTE_DIALOG_INTERFACE_LABEL);
    private static final String theApplyToNeighborCheckBoxLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.ADD_IP_ROUTE_DIALOG_ADD_TO_NEIGHBOR_CHECKBOX_LABEL);
    private JLabel ipAddressLabel;
    private JLabel ipMaskLabel;
    private JLabel gatewayLabel;
    private JLabel interfaceLabel;
    private SrIPTextField ipAddressField;
    private SrIPTextField ipMaskField;
    private SrIPTextField gatewayField;
    private SrComboBox interfaceCombo;
    private VSwitchNode myVSwitchNode;
    private SrCheckbox myApplyToNeighborCheckBox;
    private SrAction myOKAction = new SrClientAction<Void, Void>(null, null, true, true, null, SrLicenseTreePath.GENERAL_PATH, false, false){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String ip = NewIPRouteDialog.this.ipAddressField.getText();
            String mask = NewIPRouteDialog.this.ipMaskField.getText();
            String gateway = NewIPRouteDialog.this.gatewayField.getText();
            InterfaceTableRowNode interfaceRow = (InterfaceTableRowNode)NewIPRouteDialog.this.interfaceCombo.getSelectedItem();
            String intrfaceName = interfaceRow.getName();
            if (ip.equals("")) {
                return Collections.singleton(new FailedFuture(new IllegalValueException("Destination IP field is mandatory."), "NewIPRouteDialog.OKAction, DestIP is not set"));
            }
            if (mask.equals("")) {
                return Collections.singleton(new FailedFuture(new IllegalValueException("Mask is a mandatory field."), "NewIPRouteDialog.OKAction, Mask is not set"));
            }
            if (!NetUtil.isMaskValid(mask)) {
                return Collections.singleton(new FailedFuture(new IllegalValueException(ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.INVALID_MASK, mask)), "NewIPRouteDialog.OKAction, IP mask invalid"));
            }
            if (gateway.equals("")) {
                return Collections.singleton(new FailedFuture(new IllegalValueException("Gateway field is mandatory."), "NewIPRouteDialog.OKAction, Gateway is not set"));
            }
            if (intrfaceName.equals("")) {
                return Collections.singleton(new FailedFuture(new IllegalValueException("Interface field is mandatory."), "NewIPRouteDialog.OKAction, Interface is not set"));
            }
            if (!NewIPRouteDialog.this.validate(ip, gateway, intrfaceName, mask)) {
                return Collections.singleton(new FailedFuture(new IllegalValueException("This IP Route already exists in " + ClientLoader.VSWITCH_DISPLAY_STRING + " " + NewIPRouteDialog.this.myVSwitchNode.getName() + "..."), "NewIPRouteDialog.OKAction, Route exists"));
            }
            Collection<Object> switchesIds = null;
            switchesIds = NewIPRouteDialog.this.myApplyToNeighborCheckBox.isSelected() ? VSwitchPropertiesController.getSwitchesForAddIPRoute(NewIPRouteDialog.this.myVSwitchNode, ip, mask, NewIPRouteDialog.this) : Collections.singletonList(NewIPRouteDialog.this.myVSwitchNode.getIdentifier());
            1.blockActions();
            return Collections.singleton(ClientAOImpl.getInstance().createIPRouteTableRow(switchesIds, ip, mask, gateway, intrfaceName));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }

        @Override
        protected void onActionFinished(Collection<? extends SrFuture<Void>> aFutures) {
            super.onActionFinished(aFutures);
            1.releaseActions();
        }
    };

    public NewIPRouteDialog(JFrame owner, VSwitchNode vSwitchNode) {
        super(owner, ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.ADD_IP_ROUTE_DIALOG_TITLE, vSwitchNode.getName()), SystemRootNode.getInstance().getClusterNodeOfSource(vSwitchNode));
        this.setModal(true);
        this.myVSwitchNode = vSwitchNode;
        this.initComponents();
        this.setSizeAndMoveToCenter(330, 260);
        this.fixSizes();
        this.setOKAction(this.myOKAction);
    }

    private void initComponents() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new GridLayout(6, 1));
        this.setComponentBgColor(mainPanel);
        this.ipAddressLabel = new JLabel("IP Address: ");
        this.ipAddressLabel.setFont(LookAndFill.GENERAL_FONT);
        this.ipAddressField = new SrIPTextField();
        this.ipAddressField.setFont(LookAndFill.GENERAL_FONT);
        SrPanel ipPanel = this.createPanel(this.ipAddressLabel, this.ipAddressField);
        this.setComponentBgColor(ipPanel);
        this.ipMaskLabel = new JLabel("IP Mask: ");
        this.ipMaskLabel.setFont(LookAndFill.GENERAL_FONT);
        this.ipMaskField = new SrIPTextField();
        this.ipMaskField.setFont(LookAndFill.GENERAL_FONT);
        this.ipMaskField.setText("255.255.255.0");
        SrPanel maskPanel = this.createPanel(this.ipMaskLabel, this.ipMaskField);
        this.setComponentBgColor(maskPanel);
        this.gatewayLabel = new JLabel("Gateway: ");
        this.gatewayLabel.setFont(LookAndFill.GENERAL_FONT);
        this.gatewayField = new SrIPTextField();
        this.gatewayField.setFont(LookAndFill.GENERAL_FONT);
        SrPanel gatewayPanel = this.createPanel(this.gatewayLabel, this.gatewayField);
        this.setComponentBgColor(gatewayPanel);
        this.interfaceLabel = new JLabel("Interface: ");
        this.interfaceLabel.setFont(LookAndFill.GENERAL_FONT);
        List ei = this.myVSwitchNode.getEthernetInterfaces();
        Vector<SrTreeNode> interfaceItems = new Vector<SrTreeNode>();
        for (Object curObj : ei) {
            RemoteObject stub = (RemoteObject)curObj;
            SrTreeNode intr = SystemRootNode.getInstance().getRefByStub(stub);
            if (intr == null) continue;
            interfaceItems.addElement(intr);
        }
        this.interfaceCombo = new SrComboBox(interfaceItems);
        this.interfaceCombo.setFont(LookAndFill.GENERAL_FONT);
        SrPanel interfacePanel = this.createPanel(this.interfaceLabel, this.interfaceCombo);
        this.setComponentBgColor(interfacePanel);
        this.myApplyToNeighborCheckBox = new SrCheckbox(theApplyToNeighborCheckBoxLabel);
        ClusterNode cluster = (ClusterNode)this.myVSwitchNode.getParent();
        if (cluster == null) {
            throw new IllegalStateException("V-Switch " + this.myVSwitchNode + " has no cluster parent.");
        }
        VSwitchNode otherVswitch = cluster.getOtherVSwitchInCluster(this.myVSwitchNode);
        if (otherVswitch != null) {
            this.myApplyToNeighborCheckBox.setSelected(true);
        } else {
            this.myApplyToNeighborCheckBox.setEnableComponent(false);
        }
        SrPanel checkboxPanel = new SrPanel(new FlowLayout(0));
        checkboxPanel.setOpaque(false);
        checkboxPanel.add(this.myApplyToNeighborCheckBox);
        mainPanel.add(ipPanel);
        mainPanel.add(maskPanel);
        mainPanel.add(gatewayPanel);
        mainPanel.add(interfacePanel);
        mainPanel.add(checkboxPanel);
        this.setComponentBgColor(this.buttonsPanel);
        this.addCenterPanel(mainPanel);
    }

    private void fixSizes() {
        Dimension dim = this.ipAddressLabel.getPreferredSize();
        this.ipMaskLabel.setPreferredSize(dim);
        this.gatewayLabel.setPreferredSize(dim);
        this.interfaceLabel.setPreferredSize(dim);
    }

    private boolean validate(String ip, String gateway, String interfacename, String mask) {
        Vector ipRouts = this.myVSwitchNode.getIPRouteTable();
        for (int i = 0; i < ipRouts.size(); ++i) {
            IPRouteTableRow row = (IPRouteTableRow)ipRouts.get(i);
            String ipAdd = row.getDestIPAddress();
            String gatew = row.getGateway();
            InterfaceTableRowNode intr = row.getInterface();
            String msk = row.getDestIPMask();
            if (!ip.equals(ipAdd) || !gateway.equals(gatew) || !interfacename.equals(intr.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void doOnCancel() {
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    @Override
    public void removeListeners() {
    }
}

