/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.vswitch.IPTableRow;
import com.sanrad.nms.client.data.vswitch.InterfaceTableRowNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.vswitch.VSwitchPropertiesController;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.NetConfigActivityConstant;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrCheckbox;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrIPTextField;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.NetUtil;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class NewIPDialog
extends SrOKCancelDialog {
    private static final String theIPAddressLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.ADD_IP_DIALOG_IP_ADDR_LABEL);
    private static final String theIPMaskLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.ADD_IP_DIALOG_IP_MASK_LABEL);
    private static final String theIPActivityLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.ADD_IP_DIALOG_ACTIVITY_LABEL);
    private static final String theIPInterfaceLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.ADD_IP_DIALOG_INTERFACE_LABEL);
    private static final String theApplyToNeighborCheckBoxLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.ADD_IP_DIALOG_ADD_TO_NEIGHBOR_CHECKBOX_LABEL);
    private JLabel ipAddressLabel;
    private JLabel ipMaskLabel;
    private JLabel activityLabel;
    private JLabel interfaceLabel;
    private SrIPTextField ipAddressField;
    private SrIPTextField ipMaskField;
    private SrComboBox<NetConfigActivityConstant> myActivityComboBox;
    private SrComboBox interfaceCombo;
    private VSwitchNode myVSwitchNode;
    private SrCheckbox myApplyToNeighborCheckBox;
    private SrAction myOKAction = new SrClientAction<Void, Void>(null, null, true, true, null, SrLicenseTreePath.GENERAL_PATH, false, false){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String ipAdd = NewIPDialog.this.ipAddressField.getText();
            String ipMask = NewIPDialog.this.ipMaskField.getText();
            if (ipMask.equals("")) {
                return Collections.singleton(new FailedFuture(new IllegalValueException("Mask is a mandatory field please fill it."), "NewIPDialog.OKAction, IP mask not set"));
            }
            if (!NetUtil.isMaskValid(ipMask)) {
                return Collections.singleton(new FailedFuture(new IllegalValueException(ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.INVALID_MASK, ipMask)), "NewIPDialog.OKAction, IP mask invalid"));
            }
            InterfaceTableRowNode intrface = (InterfaceTableRowNode)NewIPDialog.this.interfaceCombo.getSelectedItem();
            if (intrface == null) {
                StringBuffer msg = new StringBuffer("Interface must be selected.");
                if (NewIPDialog.this.interfaceCombo.getItemCount() == 0) {
                    msg.append(" ");
                    msg.append(ClientLoader.PRODUCT_NAME);
                    msg.append(" didn't find any available interface - please check your ");
                    msg.append(ClientLoader.VSWITCH_DISPLAY_STRING);
                    msg.append(" connectivity.");
                }
                return Collections.singleton(new FailedFuture(new IllegalValueException(msg.toString()), "NewIPDialog.OKAction, Interface not selected"));
            }
            if (ipAdd != null && !ipAdd.equals("")) {
                if (!NewIPDialog.this.ipExistAlready(ipAdd)) {
                    NetConfigActivityConstant activityConstant = (NetConfigActivityConstant)NewIPDialog.this.myActivityComboBox.getSelectedItem();
                    if (!activityConstant.equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_INACTIVE) || NewIPDialog.this.myVSwitchNode.getSwitchID() != -1) {
                        List<CommKeyClassId> switchesIds = null;
                        switchesIds = NewIPDialog.this.myApplyToNeighborCheckBox.isSelected() ? VSwitchPropertiesController.getSwitchesForAddIP(NewIPDialog.this.myVSwitchNode, ipAdd.trim(), NewIPDialog.this) : Collections.singletonList(NewIPDialog.this.myVSwitchNode.getIdentifier());
                        1.blockActions();
                        return Collections.singleton(ClientAOImpl.getInstance().createIPTableRow(switchesIds, ipAdd.trim(), ipMask.trim(), activityConstant.toString(), intrface.getName()));
                    }
                    return Collections.singleton(new FailedFuture(new IllegalValueException("Cannot set inactive IP: " + ClientLoader.VSWITCH_DISPLAY_STRING + " ID not defined"), "NewIPDialog.OKAction, IP is inactive"));
                }
                return Collections.singleton(new FailedFuture(new IllegalValueException("IP already exists in " + ClientLoader.VSWITCH_DISPLAY_STRING + " " + NewIPDialog.this.myVSwitchNode.getName() + "..."), "NewIPDialog.OKAction, IP already exists"));
            }
            return Collections.singleton(new FailedFuture(new IllegalValueException("The IP address field is mandatory."), "NewIPDialog.OKAction, IP is not set"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }

        @Override
        protected void onActionFinished(Collection<? extends SrFuture<Void>> aFutures) {
            super.onActionFinished(aFutures);
            1.releaseActions();
        }
    };

    public NewIPDialog(JFrame owner, VSwitchNode vSwitchNode) {
        super(owner, ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.ADD_IP_DIALOG_TITLE, vSwitchNode.getName()), SystemRootNode.getInstance().getClusterNodeOfSource(vSwitchNode));
        this.setModal(true);
        this.myVSwitchNode = vSwitchNode;
        this.initComponents();
        this.setSizeAndMoveToCenter(330, 260);
        this.fixSizes();
        this.setOKAction(this.myOKAction);
    }

    private void initComponents() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new GridLayout(6, 1));
        this.setComponentBgColor(mainPanel);
        this.ipAddressLabel = new JLabel(theIPAddressLabel);
        this.ipAddressLabel.setFont(LookAndFill.GENERAL_FONT);
        this.ipAddressField = new SrIPTextField();
        this.ipAddressField.setFont(LookAndFill.GENERAL_FONT);
        SrPanel ipPanel = this.createPanel(this.ipAddressLabel, this.ipAddressField);
        this.setComponentBgColor(ipPanel);
        this.ipMaskLabel = new JLabel(theIPMaskLabel);
        this.ipMaskLabel.setFont(LookAndFill.GENERAL_FONT);
        this.ipMaskField = new SrIPTextField();
        this.ipMaskField.setFont(LookAndFill.GENERAL_FONT);
        this.ipMaskField.setText("255.255.255.0");
        SrPanel maskPanel = this.createPanel(this.ipMaskLabel, this.ipMaskField);
        this.setComponentBgColor(maskPanel);
        this.activityLabel = new JLabel(theIPActivityLabel);
        this.activityLabel.setFont(LookAndFill.GENERAL_FONT);
        ArrayList<NetConfigActivityConstant> activityItems = new ArrayList<NetConfigActivityConstant>();
        activityItems.add(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_ACTIVE);
        if (!((ClusterNode)this.myVSwitchNode.getParent()).isSingleVSwitchMode()) {
            activityItems.add(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_INACTIVE);
        }
        this.myActivityComboBox = new SrComboBox(activityItems);
        this.myActivityComboBox.setFont(LookAndFill.GENERAL_FONT);
        SrPanel activityPanel = this.createPanel(this.activityLabel, this.myActivityComboBox);
        this.setComponentBgColor(activityPanel);
        if (((ClusterNode)this.myVSwitchNode.getParent()).isSingleVSwitchMode()) {
            this.myActivityComboBox.setEnableComponent(false);
        }
        this.interfaceLabel = new JLabel(theIPInterfaceLabel);
        this.interfaceLabel.setFont(LookAndFill.GENERAL_FONT);
        List ei = this.myVSwitchNode.getEthernetInterfaces();
        Vector<InterfaceTableRowNode> interfaceItems = new Vector<InterfaceTableRowNode>();
        for (Object curObj : ei) {
            RemoteObject stub = (RemoteObject)curObj;
            InterfaceTableRowNode intr = (InterfaceTableRowNode)SystemRootNode.getInstance().getRefByStub(stub);
            if (intr == null || intr.isMgntInterface()) continue;
            interfaceItems.addElement(intr);
        }
        this.interfaceCombo = new SrComboBox(interfaceItems);
        this.interfaceCombo.setFont(LookAndFill.GENERAL_FONT);
        SrPanel interfacePanel = this.createPanel(this.interfaceLabel, this.interfaceCombo);
        this.setComponentBgColor(interfacePanel);
        this.myApplyToNeighborCheckBox = new SrCheckbox(theApplyToNeighborCheckBoxLabel);
        ClusterNode cluster = (ClusterNode)this.myVSwitchNode.getParent();
        if (cluster == null) {
            throw new IllegalStateException("V-Switch " + this.myVSwitchNode + " has no cluster parent.");
        }
        VSwitchNode otherVswitch = cluster.getOtherVSwitchInCluster(this.myVSwitchNode);
        if (otherVswitch != null) {
            this.myApplyToNeighborCheckBox.setSelected(true);
        } else {
            this.myApplyToNeighborCheckBox.setEnableComponent(false);
        }
        SrPanel checkboxPanel = new SrPanel(new FlowLayout(0));
        checkboxPanel.setOpaque(false);
        checkboxPanel.add(this.myApplyToNeighborCheckBox);
        mainPanel.add(ipPanel);
        mainPanel.add(maskPanel);
        mainPanel.add(activityPanel);
        mainPanel.add(interfacePanel);
        mainPanel.add(checkboxPanel);
        this.setComponentBgColor(this.buttonsPanel);
        this.addCenterPanel(mainPanel);
    }

    private void fixSizes() {
        Dimension dim = this.ipAddressLabel.getPreferredSize();
        this.ipMaskLabel.setPreferredSize(dim);
        this.activityLabel.setPreferredSize(dim);
        this.interfaceLabel.setPreferredSize(dim);
    }

    private boolean ipExistAlready(String ipAddress) {
        Vector ips = this.myVSwitchNode.getIPTable();
        for (int i = 0; i < ips.size(); ++i) {
            IPTableRow row = (IPTableRow)ips.get(i);
            String ip = row.getIPAddress();
            if (!ip.equals(ipAddress)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doOnCancel() {
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    @Override
    public void removeListeners() {
    }
}

