/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.dialogs;

import com.sanrad.nms.client.data.vswitch.IPRouteTableRow;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.dialogs.SrIPRouteTableModel;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.vswitch.VSwitchPropertiesController;
import com.sanrad.nms.client.gui.vswitch.dialogs.NewIPRouteDialog;
import com.sanrad.nms.client.gui.vswitch.dialogs.SrIPRouteTablePanel;
import com.sanrad.nms.client.gui.vswitch.dialogs.TabPanel;
import com.sanrad.swing.OKCancelFrame;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFrame;

public class IPRouteTabPanel
extends TabPanel {
    private DeleteAction myDeleteAction;

    public IPRouteTabPanel(OKCancelFrame owner, VSwitchNode vSwitchNode) {
        super(owner, vSwitchNode);
        this.updateButtonsState();
    }

    @Override
    protected void initComponents() {
        SrIPRouteTableModel model = new SrIPRouteTableModel(this.vSwitchNode);
        this.table = new SrIPRouteTablePanel(model);
    }

    @Override
    protected void updateTable() {
        SrIPRouteTableModel model = new SrIPRouteTableModel(this.vSwitchNode);
        this.table.setModel(model);
    }

    @Override
    public DeleteAction getDeleteAction() {
        if (this.myDeleteAction == null) {
            this.myDeleteAction = new DeleteAction<IPRouteTableRow>(((SrIPRouteTablePanel)this.table).myView, this.owner, new DeleteAction.Confirmator<IPRouteTableRow>(){

                @Override
                public Collection<IPRouteTableRow> confirmMultiple(Collection<IPRouteTableRow> arg) {
                    arg = super.confirmMultiple(arg);
                    ArrayList<IPRouteTableRow> retVal = new ArrayList<IPRouteTableRow>(arg);
                    for (IPRouteTableRow row : arg) {
                        retVal.addAll(VSwitchPropertiesController.getIPRouteRowsForRemoval(row, IPRouteTabPanel.this.owner));
                    }
                    return retVal;
                }
            });
        }
        return this.myDeleteAction;
    }

    @Override
    protected void addButtonPressed() {
        new NewIPRouteDialog((JFrame)this.owner, this.vSwitchNode).show();
    }

    protected boolean innerGetDeleteButtonEnabledState() {
        return this.vSwitchNode != null && this.vSwitchNode.isConnected();
    }
}

