/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.dialogs;

import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.gui.GenericTableCellRenderer;
import com.sanrad.nms.client.gui.SrClientTablePanel;
import com.sanrad.nms.client.gui.vswitch.dialogs.AttachRaidTableHeader;
import com.sanrad.nms.client.gui.vswitch.dialogs.AttachRaidTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class AttachRaidTablePanel
extends SrClientTablePanel {
    private static final long serialVersionUID = -7261320177524015693L;
    private static final int MAX_HEIGHT = 200;
    private static final int MAX_WIDTH = 30;

    public AttachRaidTablePanel() {
        super(new AttachRaidTableModel());
        this.setSelectionMode(0);
        this.getTable().setColumnSelectionAllowed(false);
        this.getTable().setCellSelectionEnabled(false);
        this.getTable().setRowSelectionAllowed(true);
        this.updateTableProperties();
        this.setPreferredSize(new Dimension(30, 200));
        this.enableSort(false);
    }

    private void updateTableProperties() {
        int cols = this.getTable().getColumnCount();
        for (int i = 0; i < cols; ++i) {
            TableColumn tableColumn = this.getTable().getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(new RaidCellRenderer());
        }
    }

    @Override
    protected Class<AttachRaidTableHeader> getTableHeaderClass() {
        return AttachRaidTableHeader.class;
    }

    public void addRaidToTable(RaidSystem aRaid) {
        if (aRaid == null) {
            return;
        }
        ((AttachRaidTableModel)this.getModel()).addRaidEntry(aRaid);
        this.updateDisabledRows();
    }

    public void removeRaidFromTable(RaidSystem aRaid) {
        if (aRaid == null) {
            return;
        }
        ((AttachRaidTableModel)this.getModel()).removeRaidEntry(aRaid);
        this.updateDisabledRows();
    }

    public void clearAndSetTable(List<RaidSystem> aRaids) {
        ((AttachRaidTableModel)this.getModel()).clearAndSetNewRaids(aRaids);
        this.updateDisabledRows();
    }

    public void selectRaid(RaidSystem aRaid) {
        AttachRaidTableModel curModel = (AttachRaidTableModel)this.getTable().getModel();
        int raidRow = curModel.findRow(aRaid);
        if (raidRow >= 0) {
            this.getTable().getSelectionModel().addSelectionInterval(raidRow, raidRow);
        }
    }

    public void clearSelection() {
        this.getTable().clearSelection();
    }

    public List<RaidSystem> getSelectedRaids() {
        AttachRaidTableModel model = (AttachRaidTableModel)this.getModel();
        int[] selectedRows = this.getSelectedRows();
        ArrayList<RaidSystem> selectedRaids = new ArrayList<RaidSystem>();
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedRaids.add(model.getRaidSystem(selectedRows[i]));
        }
        return selectedRaids;
    }

    public List<RaidSystem> getUnselectedRaids() {
        AttachRaidTableModel model = (AttachRaidTableModel)this.getModel();
        int[] unselectedRows = this.getUnselectedRows();
        ArrayList<RaidSystem> unselectedRaids = new ArrayList<RaidSystem>();
        for (int i = 0; i < unselectedRows.length; ++i) {
            unselectedRaids.add(model.getRaidSystem(unselectedRows[i]));
        }
        return unselectedRaids;
    }

    private void updateDisabledRows() {
    }

    public void setEnableRaid(RaidSystem aRaid, boolean aEnable) {
        AttachRaidTableModel curModel = (AttachRaidTableModel)this.getTable().getModel();
        int raidRow = curModel.findRow(aRaid);
        if (raidRow >= 0) {
            if (RaidSystem.Type.GDR_UNMANAGED_RAID.equals((Object)aRaid.getType())) {
                this.setEnabledRow(raidRow, false);
            } else {
                this.setEnabledRow(raidRow, aEnable);
            }
        }
    }

    public void addListSelectionListener(ListSelectionListener aListener) {
        this.getTable().getSelectionModel().addListSelectionListener(aListener);
    }

    public void removeListSelectionListener(ListSelectionListener aListener) {
        this.getTable().getSelectionModel().removeListSelectionListener(aListener);
    }

    private static class RaidCellRenderer
    extends GenericTableCellRenderer {
        private static final long serialVersionUID = 8369224578364144857L;

        private RaidCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof RaidSystem) {
                RaidSystem raidSys = (RaidSystem)value;
                this.setText(raidSys.getFullDescription());
            }
            return this;
        }
    }
}

