/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.dialogs;

import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.gui.vswitch.dialogs.AttachRaidTableHeader;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.List;

public class AttachRaidTableModel
extends SrTableModel {
    private static final long serialVersionUID = -6753165105731107446L;

    public AttachRaidTableModel() {
        super(new SrDefaultTableColumns(AttachRaidTableHeader.getColumnNames()));
    }

    public AttachRaidTableModel(List<RaidSystem> aRaids) {
        this();
        this.initModel(aRaids);
    }

    private void initModel(List<RaidSystem> aRaids) {
        this.clearAndSetNewRaids(aRaids);
    }

    public void clearAndSetNewRaids(List<RaidSystem> aRaids) {
        this.removeAllRows();
        if (aRaids == null) {
            return;
        }
        for (RaidSystem raidSys : aRaids) {
            this.addRaidEntry(raidSys);
        }
    }

    public void addRaidEntry(RaidSystem aRaid) {
        if (aRaid == null || RaidSystem.Type.GDR_UNMANAGED_RAID.equals((Object)aRaid.getType())) {
            return;
        }
        Object[] row = new Object[]{aRaid};
        this.addRow(row);
    }

    public void removeRaidEntry(RaidSystem aRaid) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!aRaid.equals(this.getRaidSystem(row))) continue;
            this.removeRow(row);
        }
    }

    @Override
    public void addListeners() {
    }

    @Override
    public void removeListeners() {
    }

    public RaidSystem getRaidSystem(int aRow) {
        return (RaidSystem)this.getValueAt(aRow, AttachRaidTableHeader.RAID_NAME.getIndexInModel());
    }
}

