/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.dialogs;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.raid.AttachedRaidManager;
import com.sanrad.nms.client.data.raid.RaidManager;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.storage.panels.RaidPanel;
import com.sanrad.nms.client.gui.vswitch.dialogs.AttachRaidDialog;
import com.sanrad.nms.client.gui.vswitch.dialogs.AttachRaidTableModel;
import com.sanrad.nms.client.gui.vswitch.dialogs.AttachRaidTablePanel;
import com.sanrad.swing.SrPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AttachRaidPanel
extends SrPanel {
    private static final long serialVersionUID = 7557591106084174969L;
    private VSwitchNode myVS = null;
    private AttachRaidTablePanel myTablePanel = null;
    private RaidPanel myRaidDetailsPanel = null;
    private static final int VERTICAL_GAP_SIZE = 15;
    private static final int HORIZONTAL_GAP_SIZE = 60;
    private AttachRaidDialog myOwner = null;

    public AttachRaidPanel(AttachRaidDialog aOwner) {
        super(new BorderLayout(60, 15));
        this.initComponents();
        this.myOwner = aOwner;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('[');
        sb.append(this.myVS);
        sb.append(']');
        return sb.toString();
    }

    private void initComponents() {
        this.myTablePanel = this.createTable();
        this.addListSelectionListenerToTable(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                for (int changedRow = e.getFirstIndex(); changedRow <= e.getLastIndex(); ++changedRow) {
                    if (changedRow < 0) {
                        return;
                    }
                    AttachRaidTableModel curModel = (AttachRaidTableModel)AttachRaidPanel.this.myTablePanel.getTable().getModel();
                    RaidSystem raidSys = curModel.getRaidSystem(changedRow);
                    boolean isSelection = AttachRaidPanel.this.myTablePanel.getTable().getSelectionModel().isSelectedIndex(changedRow);
                    if (!isSelection) {
                        if (AttachRaidPanel.this.myTablePanel.getSelectedRaids().isEmpty()) {
                            AttachRaidPanel.this.myRaidDetailsPanel.clearAllFields();
                        }
                    } else {
                        AttachRaidPanel.this.updateRaidDetailsOnTableSelection(raidSys);
                    }
                    AttachRaidPanel.this.myOwner.updatedTablesRaidSelection(AttachRaidPanel.this, raidSys, isSelection);
                }
            }
        });
        this.myRaidDetailsPanel = this.createRaidDetailsPanel();
        this.add((Component)this.myTablePanel, "Center");
        this.add((Component)this.myRaidDetailsPanel, "South");
    }

    private void updateRaidDetailsOnTableSelection(RaidSystem aRaid) {
        this.myRaidDetailsPanel.clearAllFields();
        if (aRaid.getType() == RaidSystem.Type.GDR_UNMANAGED_RAID) {
            this.myRaidDetailsPanel.setAllFieldsEnabled(false);
        }
        if (aRaid.getType() == RaidSystem.Type.GENERAL_UNMANAGED_RAID) {
            this.myRaidDetailsPanel.setAllFieldsEnabled(true);
        }
        if (aRaid.getType() == RaidSystem.Type.NEXSAN_MANAGED_RAID || aRaid.getType() == RaidSystem.Type.GENERAL_MANAGED_RAID) {
            this.myRaidDetailsPanel.setAllFieldsEnabled(false);
            this.myRaidDetailsPanel.updateFieldsFromRaid(aRaid);
        }
    }

    private AttachRaidTablePanel createTable() {
        return new AttachRaidTablePanel();
    }

    private RaidPanel createRaidDetailsPanel() {
        return new RaidPanel("RAID Details");
    }

    public VSwitchNode getVSwitch() {
        return this.myVS;
    }

    private void setVSwitch(VSwitchNode aVS) {
        this.myVS = aVS;
    }

    public void addRaidToPanel(RaidSystem aRaid) {
        this.myTablePanel.addRaidToTable(aRaid);
    }

    public void removeRaidFromPanel(RaidSystem aRaid) {
        this.myTablePanel.removeRaidFromTable(aRaid);
    }

    public void clearAndSetPanel(VSwitchNode aVS) {
        this.setVSwitch(aVS);
        this.myRaidDetailsPanel.clearAllFields();
        if (aVS == null) {
            this.myTablePanel.clearAndSetTable(null);
            return;
        }
        ClusterNode cluster = (ClusterNode)aVS.getAncestorOfType(ClusterNode.class);
        List<RaidSystem> raids = RaidManager.getInstance().getRaids(cluster);
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        this.setBorder(BorderFactory.createTitledBorder(loweredbevel, "[ " + aVS.getName() + " ] ", 2, 0));
        this.myTablePanel.clearAndSetTable(raids);
    }

    public void selectAttachedRaid() {
        this.myTablePanel.clearSelection();
        if (this.myVS == null) {
            return;
        }
        List<RaidSystem> attachedRaids = AttachedRaidManager.getInstance().getAttachedRaidSystems(this.myVS);
        for (RaidSystem raid : attachedRaids) {
            this.myTablePanel.selectRaid(raid);
            this.updateRaidDetailsOnTableSelection(raid);
        }
    }

    public List<RaidSystem> getSelectedRaids() {
        return this.myTablePanel.getSelectedRaids();
    }

    public List<RaidSystem> getUnselectedRaids() {
        return this.myTablePanel.getUnselectedRaids();
    }

    public boolean isRaidSelected() {
        return !this.getSelectedRaids().isEmpty();
    }

    public String getRaidName() {
        return this.myRaidDetailsPanel.getRaidName();
    }

    public String getRaidFirstIP() {
        return this.myRaidDetailsPanel.getRaidFirstIP();
    }

    public String getRaidSecondIP() {
        return this.myRaidDetailsPanel.getRaidSecondIP();
    }

    public boolean validateSelectedRaidParameters() {
        if (!this.isRaidSelected()) {
            return false;
        }
        return this.myRaidDetailsPanel.validateParameters();
    }

    public boolean areRaidParametersFieldsEmpty() {
        return this.myRaidDetailsPanel.isEmpty();
    }

    public void addListSelectionListenerToTable(ListSelectionListener aListSelectionListener) {
        this.myTablePanel.addListSelectionListener(aListSelectionListener);
    }

    public void addDocumentListenerToRaidDetails(DocumentListener aDocumentListener) {
        this.myRaidDetailsPanel.addDocumentListener(aDocumentListener);
    }

    public void setEnableRaidRowTable(RaidSystem aRaid, boolean aEnable) {
        this.myTablePanel.setEnableRaid(aRaid, aEnable);
    }
}

