/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch.dialogs;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.raid.AttachedRaidManager;
import com.sanrad.nms.client.data.raid.AttachedRaidNode;
import com.sanrad.nms.client.data.raid.RaidManager;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.raid.RaidEvent;
import com.sanrad.nms.client.event.raid.RaidManagerListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.SrSystemObjectComboBox;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.vswitch.dialogs.AttachRaidPanel;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.raid.AttachedRaid;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.border.EmptyBorder;

public class AttachRaidDialog
extends SrOKCancelDialog<ClusterNode> {
    private static final long serialVersionUID = 1L;
    private AttachRaidCenterPanel myCenterPanel = null;
    private static final String DIALOG_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_ATTACH_RAID_WINDOW_TITLE);
    private static final String SELECT_CLUSTER_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_SELECT_CLUSTER_TEXT);
    private static final String INFORMATION_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_ATTACH_RAID_WINDOW_INFORMATION);
    private static final int MAX_PANELS_PER_CLUSTER = 2;
    private static SrLogger theLogger = SrLogger.getLogger();
    private RaidManagerListener myRaidListener = new RaidManagerListener(){

        @Override
        public void RaidChanged(RaidEvent raidEvent) {
        }

        @Override
        public void RaidCreated(RaidEvent raidEvent) {
            RaidSystem raidSys = raidEvent.getRaid();
            if (raidSys != null && raidSys.getClusters().contains(AttachRaidDialog.this.m_workingCluster)) {
                AttachRaidDialog.this.myCenterPanel.addRaidToPanel(raidSys);
            }
        }

        @Override
        public void RaidRemoved(RaidEvent raidEvent) {
            RaidSystem raidSys = raidEvent.getRaid();
            if (raidSys != null && raidSys.getClusters().contains(AttachRaidDialog.this.m_workingCluster)) {
                AttachRaidDialog.this.myCenterPanel.removeRaidFromPanel(raidSys);
            }
        }

        @Override
        public void RaidAttached(RaidEvent raidEvent) {
            AttachRaidDialog.this.myCenterPanel.updatedPanelsWithAttachedRaidSelection();
        }

        @Override
        public void RaidDetached(RaidEvent raidEvent) {
            AttachRaidDialog.this.myCenterPanel.updatedPanelsWithAttachedRaidSelection();
        }
    };

    public static void showDialog(JFrame aOwner, ClusterNode aCluster) {
        Util.validateInputNotNull(aCluster, "Cluster");
        AttachRaidDialog attachDialog = (AttachRaidDialog)aCluster.getDialog(AttachRaidDialog.class);
        if (attachDialog == null) {
            attachDialog = new AttachRaidDialog(aOwner, aCluster);
            aCluster.addDialog(attachDialog);
            attachDialog.show();
        } else {
            attachDialog.toFront();
        }
    }

    private AttachRaidDialog(JFrame owner, ClusterNode aCluster) {
        super(owner, DIALOG_TITLE, aCluster);
        Util.validateInputNotNull(aCluster, "Cluster");
        this.initComponents();
        this.pack();
        this.setTopContextBoxSelection(aCluster);
        this.setModal(true);
        this.setOKAction(this.createOKAction());
        this.clearAndSetRaidPanels();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('[');
        sb.append(this.m_workingCluster);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
    }

    private void initComponents() {
        SrSystemObjectComboBox.SysNodeProperties comboBoxNodeProp = new SrSystemObjectComboBox.SysNodeProperties(){

            @Override
            protected boolean isItemInContext(Object aNode) {
                if (!(aNode instanceof ClusterNode)) {
                    return false;
                }
                ClusterNode cluster = (ClusterNode)aNode;
                return cluster.hasConnectedVSwitches();
            }

            @Override
            public String getDisabledToolTip(SrTreeNode node) {
                ClusterNode cluster;
                String msg = super.getDisabledToolTip(node);
                if (node instanceof ClusterNode && !(cluster = (ClusterNode)node).hasConnectedVSwitches()) {
                    return "You forgot to add connected V-Switches";
                }
                return msg;
            }
        };
        this.myCenterPanel = new AttachRaidCenterPanel();
        this.myCenterPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.addTopContextBox(SELECT_CLUSTER_TEXT, ClusterNode.class, comboBoxNodeProp, INFORMATION_TEXT);
        this.addCenterPanel(this.myCenterPanel);
    }

    private SrAction createOKAction() {
        SrClientAction<Void, Void> retOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                VSwitchNode curVs;
                List<AttachRaidPanel> curPanels = AttachRaidDialog.this.myCenterPanel.getActivePanels();
                ArrayList<ClientConfigElementData> raidsConfigurationList = new ArrayList<ClientConfigElementData>();
                for (AttachRaidPanel curPanel : curPanels) {
                    curVs = curPanel.getVSwitch();
                    List<RaidSystem> attachedRaids = AttachedRaidManager.getInstance().getAttachedRaidSystems(curVs);
                    List<RaidSystem> unselectedRaids = curPanel.getUnselectedRaids();
                    for (RaidSystem raidSys : unselectedRaids) {
                        String raidIp2;
                        if (!attachedRaids.contains(raidSys)) continue;
                        AttachedRaidNode attachedRaidNode = AttachedRaidManager.getInstance().findEquivalent(raidSys);
                        ClientConfigElementData detachRaidCed = new ClientConfigElementData((CommKeyClassId)attachedRaidNode.getIdentifier(), (CommKeyClassId)AttachRaidDialog.this.m_workingCluster.getIdentifier(), ConfigOperation.DELETE);
                        String raidIp1 = attachedRaidNode.getCtrlIp1();
                        if (raidIp1 != null) {
                            detachRaidCed.putValue(ClientParameterCode.ATTACHED_RAID_CTRL_IP1, raidIp1);
                        }
                        if ((raidIp2 = attachedRaidNode.getCtrlIp2()) != null) {
                            detachRaidCed.putValue(ClientParameterCode.ATTACHED_RAID_CTRL_IP2, raidIp2);
                        }
                        detachRaidCed.putValue(ClientParameterCode.VSWITCH_ID, curVs.getIdentifier());
                        raidsConfigurationList.add(detachRaidCed);
                    }
                }
                for (AttachRaidPanel curPanel : curPanels) {
                    curVs = curPanel.getVSwitch();
                    List<RaidSystem> selectedRaids = curPanel.getSelectedRaids();
                    for (RaidSystem selectedRaid : selectedRaids) {
                        String raidIp2;
                        if (AttachedRaidManager.getInstance().isAttached(selectedRaid, curVs)) continue;
                        ClientConfigElementData attachRaidCed = new ClientConfigElementData(ClassID.ATTACHED_RAID, (CommKeyClassId)AttachRaidDialog.this.m_workingCluster.getIdentifier(), ConfigOperation.CREATE);
                        if (selectedRaid.isIscsiRaid()) {
                            SrEntityNameFormat wwn = selectedRaid.getWWN();
                            attachRaidCed.putValue(ClientParameterCode.ATTACHED_RAID_UNIQUE_NAME, AttachedRaid.ISCSI_RAID_UNIQUE_NAME);
                            if (wwn != null) {
                                attachRaidCed.putValue(ClientParameterCode.ATTACHED_RAID_NAME, new String(wwn.getBytes()));
                            }
                        } else {
                            SrEntityNameFormat wwn;
                            String raidName = selectedRaid.getName();
                            String userRaidName = curPanel.getRaidName();
                            if (userRaidName != null && selectedRaids.size() == 1) {
                                raidName = userRaidName;
                            }
                            if (raidName != null) {
                                attachRaidCed.putValue(ClientParameterCode.ATTACHED_RAID_NAME, raidName);
                            }
                            if ((wwn = selectedRaid.getWWN()) != null) {
                                attachRaidCed.putValue(ClientParameterCode.ATTACHED_RAID_UNIQUE_NAME, wwn);
                            }
                        }
                        String raidIp1 = selectedRaid.getCtrlIp1();
                        if (raidIp1 == null && selectedRaids.size() == 1) {
                            raidIp1 = curPanel.getRaidFirstIP();
                        }
                        if (raidIp1 != null) {
                            attachRaidCed.putValue(ClientParameterCode.ATTACHED_RAID_CTRL_IP1, raidIp1);
                        }
                        if ((raidIp2 = selectedRaid.getCtrlIp2()) == null && selectedRaids.size() == 1) {
                            raidIp2 = curPanel.getRaidSecondIP();
                        }
                        if (raidIp2 != null) {
                            attachRaidCed.putValue(ClientParameterCode.ATTACHED_RAID_CTRL_IP2, raidIp2);
                        }
                        attachRaidCed.putValue(ClientParameterCode.VSWITCH_ID, curVs.getIdentifier());
                        List<DirectAccessDeviceNode> raidDisks = selectedRaid.getDisks();
                        attachRaidCed.putValue(ClientParameterCode.PHYSICAL_STORAGE_VENDOR_NAME, raidDisks.get(0).getVendor());
                        raidsConfigurationList.add(attachRaidCed);
                    }
                }
                if (raidsConfigurationList.isEmpty()) {
                    return Collections.emptyList();
                }
                ClientConfigElementData raidConfigurationCed = (ClientConfigElementData)raidsConfigurationList.remove(0);
                if (!raidsConfigurationList.isEmpty()) {
                    raidConfigurationCed.setPostConfigurationElement(raidsConfigurationList);
                }
                return Collections.singletonList(ClientAOImpl.getInstance().configureElementsTree(raidConfigurationCed));
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                if (AttachRaidDialog.this.m_workingCluster == null) {
                    return ClientLoader.BUNDLE.getString(SrDataValidationResourceBundleKeys.CLUSTER_NOT_SELECTED);
                }
                String err = VSwitchManager.getInstance().validateConnectedVswitchExists(AttachRaidDialog.this.m_workingCluster);
                if (err != null) {
                    return err;
                }
                for (AttachRaidPanel curPanel : AttachRaidDialog.this.myCenterPanel.getActivePanels()) {
                    if (curPanel == null || !curPanel.isRaidSelected()) continue;
                    List<RaidSystem> selectedRaids = curPanel.getSelectedRaids();
                    for (RaidSystem selectedRaid : selectedRaids) {
                        if (!curPanel.validateSelectedRaidParameters()) {
                            // empty if block
                        }
                        if (selectedRaid.getWWN() == null) {
                            return "The RAID doesn't have WWN";
                        }
                        List<DirectAccessDeviceNode> raidDisks = selectedRaid.getDisks();
                        if (!raidDisks.isEmpty()) continue;
                        return "RAID " + selectedRaid + " doesn't contain disks";
                    }
                }
                return null;
            }
        };
        for (AttachRaidPanel panel : this.myCenterPanel.getAllPanels()) {
            panel.addListSelectionListenerToTable(new View.ViewListSelectionListener(retOKAction));
            panel.addDocumentListenerToRaidDetails(new View.ViewTextListener(retOKAction));
        }
        return retOKAction;
    }

    @Override
    public void doOnCancel() {
        this.dispose();
    }

    @Override
    public void addListeners() {
        RaidManager.getInstance().addListener(this.myRaidListener);
    }

    @Override
    public void removeListeners() {
        RaidManager.getInstance().removeListener(this.myRaidListener);
    }

    private void clearAndSetRaidPanels() {
        this.myCenterPanel.clearAndSetNewCluster(this.m_workingCluster);
    }

    @Override
    protected void systemNodeSelected(ClusterNode aSelectedClusterNode) {
        ClusterNode prevCluster = this.m_workingCluster;
        this.m_workingCluster = aSelectedClusterNode;
        if (this.m_workingCluster != null) {
            this.setTitle(SystemRootNode.getInstance().getClusterTitle(DIALOG_TITLE, this.m_workingCluster));
            this.m_workingCluster.addDialog(this);
        }
        this.clearAndSetRaidPanels();
        if (prevCluster != null && !Util.equalsWithNull(prevCluster, this.m_workingCluster)) {
            prevCluster.removeDialog(this.getClass());
        }
    }

    public void updatedTablesRaidSelection(AttachRaidPanel aPanel, RaidSystem aRaid, boolean isSelection) {
        for (AttachRaidPanel curPanel : this.myCenterPanel.myPanels) {
            if (aPanel.equals(curPanel)) continue;
            curPanel.setEnableRaidRowTable(aRaid, !isSelection);
        }
    }

    private class AttachRaidCenterPanel
    extends SrPanel {
        private static final long serialVersionUID = 483050511091228365L;
        private ArrayList<AttachRaidPanel> myPanels;
        private int myVisiblePanelsCount;

        private AttachRaidCenterPanel() {
            super(new GridLayout(1, 2, 5, 0));
            this.myPanels = new ArrayList();
            this.initComponents();
        }

        private void initComponents() {
            for (int i = 0; i < 2; ++i) {
                AttachRaidPanel newPanel = new AttachRaidPanel(AttachRaidDialog.this);
                this.myPanels.add(newPanel);
            }
            this.add(this.myPanels.get(0));
            this.myVisiblePanelsCount = 1;
        }

        public List<AttachRaidPanel> getAllPanels() {
            return new ArrayList<AttachRaidPanel>(this.myPanels);
        }

        public List<AttachRaidPanel> getActivePanels() {
            ArrayList<AttachRaidPanel> retlist = new ArrayList<AttachRaidPanel>();
            for (AttachRaidPanel curPanel : this.myPanels) {
                if (curPanel.getVSwitch() == null) continue;
                retlist.add(curPanel);
            }
            return retlist;
        }

        public void addRaidToPanel(RaidSystem aRaid) {
            if (!aRaid.getClusters().contains(AttachRaidDialog.this.m_workingCluster)) {
                return;
            }
            for (AttachRaidPanel curPanel : this.myPanels) {
                curPanel.addRaidToPanel(aRaid);
            }
        }

        public void removeRaidFromPanel(RaidSystem aRaid) {
            if (!aRaid.getClusters().contains(AttachRaidDialog.this.m_workingCluster)) {
                return;
            }
            for (AttachRaidPanel curPanel : this.myPanels) {
                curPanel.removeRaidFromPanel(aRaid);
            }
        }

        public int getNumberOfVisiblePanels() {
            return AttachRaidDialog.this.m_workingCluster.getVswitchesCount();
        }

        public void clearAndSetNewCluster(ClusterNode aCluster) {
            if (aCluster == null) {
                for (AttachRaidPanel panel : this.myPanels) {
                    panel.clearAndSetPanel(null);
                }
                return;
            }
            VSwitchNode[] vswitches = aCluster.getVSwitches();
            for (int i = 0; i < this.myPanels.size(); ++i) {
                VSwitchNode vsToSet = vswitches.length > i ? vswitches[i] : null;
                this.myPanels.get(i).clearAndSetPanel(vsToSet);
            }
            int prevPanelCount = this.myVisiblePanelsCount;
            int newPanelCount = vswitches.length;
            if (prevPanelCount != newPanelCount) {
                int panelCountDifference = Math.abs(newPanelCount - prevPanelCount);
                GridLayout gridLayout = (GridLayout)AttachRaidDialog.this.myCenterPanel.getLayout();
                int gridLayoutGap = gridLayout.getHgap();
                int widthDiff = this.myPanels.get(0).getWidth() + gridLayoutGap;
                int oldH = AttachRaidDialog.this.getHeight();
                int oldW = AttachRaidDialog.this.getWidth();
                int newW = newPanelCount > prevPanelCount ? oldW + panelCountDifference * widthDiff : oldW - panelCountDifference * widthDiff;
                AttachRaidDialog.this.setSize(new Dimension(newW, oldH));
                int step = (newPanelCount - prevPanelCount) / panelCountDifference;
                if (step > 0) {
                    this.add(this.myPanels.get(1));
                } else {
                    this.remove(this.myPanels.get(1));
                }
            }
            this.myVisiblePanelsCount = newPanelCount;
            this.updatedPanelsWithAttachedRaidSelection();
        }

        private void updatedPanelsWithAttachedRaidSelection() {
            for (AttachRaidPanel panel : this.myPanels) {
                panel.selectAttachedRaid();
            }
        }
    }
}

