/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrMainTreeModel;
import com.sanrad.nms.client.data.vswitch.IPRouteTableRow;
import com.sanrad.nms.client.data.vswitch.IPTableRow;
import com.sanrad.nms.client.data.vswitch.InterfaceTableRowNode;
import com.sanrad.nms.client.data.vswitch.PortalTableRow;
import com.sanrad.nms.client.data.vswitch.SrTargetPortalTableRow;
import com.sanrad.nms.client.data.vswitch.TableRowNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.BundleKeysInterface;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class VSwitchPropertiesController {
    public static Collection<CommKeyClassId> getSwitchesForAddPortal(VSwitchNode aSwitchNode, Component aOwner, String aIP, int aPort) {
        if (aOwner == null) {
            throw new IllegalArgumentException("owner cannot be null, ip=" + aIP + ", port=" + aPort);
        }
        ArrayList<CommKeyClassId> retVal = new ArrayList<CommKeyClassId>();
        retVal.add((CommKeyClassId)aSwitchNode.getIdentifier());
        Vector<VSwitchNode> others = SrMainTreeModel.getInstance().getOtherVSwitches(aSwitchNode);
        for (VSwitchNode node : others) {
            if (node.isConnected()) {
                Vector<PortalTableRow> portalTable = node.getPortalTable();
                SrTargetPortalTableRow obj = VSwitchPropertiesController.existInPortalTable(portalTable, aIP, aPort);
                if (obj != null || !VSwitchPropertiesController.shouldOpen(node, aIP)) continue;
                retVal.add((CommKeyClassId)node.getIdentifier());
                continue;
            }
            JOptionPane.showMessageDialog(aOwner, ClientLoader.VSWITCH_DISPLAY_STRING + " " + node.getName() + " is disconnected.\nMake sure you set a portal " + aIP + ":" + aPort + " to that " + ClientLoader.VSWITCH_DISPLAY_STRING + " as well.", "Warning", 2);
        }
        return retVal;
    }

    private static boolean shouldOpen(VSwitchNode node, String ipAddress) {
        Vector iptable = node.getIPTable();
        int size = iptable.size();
        for (int i = 0; i < size; ++i) {
            IPTableRow row = (IPTableRow)iptable.get(i);
            if (!row.getIPAddress().equals(ipAddress)) continue;
            return true;
        }
        return false;
    }

    public static Collection<SrTargetPortalTableRow> getPortalRowsForRemoval(SrTargetPortalTableRow portalTableRow, Component owner) {
        VSwitchNode vswitchNode = portalTableRow.getParent();
        Vector<VSwitchNode> others = SrMainTreeModel.getInstance().getOtherVSwitches(vswitchNode);
        int size = others.size();
        ArrayList<SrTargetPortalTableRow> retVal = new ArrayList<SrTargetPortalTableRow>(size);
        for (VSwitchNode node : others) {
            int res;
            Vector<PortalTableRow> portalTable = node.getPortalTable();
            SrTargetPortalTableRow item = VSwitchPropertiesController.existInPortalTable(portalTable, portalTableRow.getIPAddress(), portalTableRow.getPort());
            if (item == null || (res = JOptionPane.showConfirmDialog(owner, VSwitchPropertiesController.getConfirmationMessage(vswitchNode, node, item), VSwitchPropertiesController.getConfirmationTitle(item), 0, 3)) != 0) continue;
            retVal.add(item);
        }
        return retVal;
    }

    private static String getConfirmationMessage(VSwitchNode vswitchNode, VSwitchNode neighborNode, TableRowNode obj) {
        String[] args = new String[]{neighborNode.getName(), vswitchNode.getName(), obj.toString(), obj.type()};
        return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.DELETE_TABLE_ROW_TITLE, args);
    }

    private static String getConfirmationTitle(TableRowNode item) {
        return new DeleteAction.Confirmator<TableRowNode>().getTitle(item);
    }

    public static Collection<CommKeyClassId> getSwitchesForAddIPRoute(VSwitchNode aSwitchNode, String aIp, String aMask, Component aOwner) {
        Vector<VSwitchNode> others = SrMainTreeModel.getInstance().getOtherVSwitches(aSwitchNode);
        ArrayList<CommKeyClassId> retVal = new ArrayList<CommKeyClassId>(others.size());
        retVal.add((CommKeyClassId)aSwitchNode.getIdentifier());
        for (VSwitchNode node : others) {
            if (node.isConnected()) {
                retVal.add((CommKeyClassId)node.getIdentifier());
                continue;
            }
            JOptionPane.showMessageDialog(aOwner, ClientLoader.VSWITCH_DISPLAY_STRING + " " + node.getName() + " is disconnected.\nMake sure you set an ip route " + aIp + " to that " + ClientLoader.VSWITCH_DISPLAY_STRING + " as well.", "Warning", 2);
        }
        return retVal;
    }

    public static Collection<IPRouteTableRow> getIPRouteRowsForRemoval(IPRouteTableRow aRow, Window aOwner) {
        VSwitchNode vswitchNode = aRow.getParent();
        Vector<VSwitchNode> others = SrMainTreeModel.getInstance().getOtherVSwitches(vswitchNode);
        ArrayList<IPRouteTableRow> retVal = new ArrayList<IPRouteTableRow>(others.size());
        for (VSwitchNode neighborNode : others) {
            int res;
            ArrayList<IPRouteTableRow> ipRouteTable = new ArrayList<IPRouteTableRow>(neighborNode.getIPRouteTable());
            IPRouteTableRow item = VSwitchPropertiesController.existInIPRouteTable(ipRouteTable, aRow);
            if (item == null || (res = JOptionPane.showConfirmDialog(aOwner, VSwitchPropertiesController.getConfirmationMessage(vswitchNode, neighborNode, item), "Delete IP Route", 0, 3)) != 0) continue;
            retVal.add(item);
        }
        return retVal;
    }

    public static List<CommKeyClassId> getSwitchesForAddIP(VSwitchNode aSwitchNode, String aIPAddress, Component aOwner) {
        Vector<VSwitchNode> others = SrMainTreeModel.getInstance().getOtherVSwitches(aSwitchNode);
        ArrayList<CommKeyClassId> retVal = new ArrayList<CommKeyClassId>();
        retVal.add((CommKeyClassId)aSwitchNode.getIdentifier());
        for (VSwitchNode node : others) {
            if (node.isConnected()) {
                Vector ipTable = node.getIPTable();
                IPTableRow obj = VSwitchPropertiesController.existInIPTable(ipTable, aIPAddress);
                if (obj != null) continue;
                retVal.add((CommKeyClassId)node.getIdentifier());
                continue;
            }
            JOptionPane.showMessageDialog(aOwner, ClientLoader.VSWITCH_DISPLAY_STRING + " " + node.getName() + " is disconnected.\nMake sure you set an ip " + aIPAddress + " to that " + ClientLoader.VSWITCH_DISPLAY_STRING + " as well.", "Warning", 2);
        }
        return retVal;
    }

    public static Collection<IPTableRow> getIPRowsForRemoval(IPTableRow aRow, Window aOwner) {
        VSwitchNode vswitchNode = aRow.getParent();
        Vector<VSwitchNode> others = SrMainTreeModel.getInstance().getOtherVSwitches(vswitchNode);
        ArrayList<IPTableRow> retVal = new ArrayList<IPTableRow>(others.size());
        for (VSwitchNode neighborNode : others) {
            int res;
            Vector ipTable = neighborNode.getIPTable();
            IPTableRow item = VSwitchPropertiesController.existInIPTable(ipTable, aRow.getIPAddress());
            if (item == null || (res = JOptionPane.showConfirmDialog(aOwner, VSwitchPropertiesController.getConfirmationMessage(vswitchNode, neighborNode, item), VSwitchPropertiesController.getConfirmationTitle(item), 0, 3)) != 0) continue;
            retVal.add(item);
        }
        return retVal;
    }

    private static IPTableRow existInIPTable(Vector ipTable, String aIPAddress) {
        int size = ipTable.size();
        for (int i = 0; i < size; ++i) {
            IPTableRow row = (IPTableRow)ipTable.get(i);
            String ipAddress = row.getIPAddress();
            if (!ipAddress.equalsIgnoreCase(aIPAddress)) continue;
            return row;
        }
        return null;
    }

    public static SrTargetPortalTableRow existInPortalTable(Vector portalTable, String ip, int port) {
        int size = portalTable.size();
        for (int i = 0; i < size; ++i) {
            PortalTableRow row = (PortalTableRow)portalTable.get(i);
            if (!row.isPortalRoleIncludeTarget()) continue;
            String rowIpAddress = row.getIPAddress();
            Integer rowPort = ((SrTargetPortalTableRow)row).getPort();
            if (!rowIpAddress.equalsIgnoreCase(ip) || rowPort != port) continue;
            return (SrTargetPortalTableRow)row;
        }
        return null;
    }

    private static IPRouteTableRow existInIPRouteTable(List<IPRouteTableRow> aRouteTableRows, IPRouteTableRow aRouteRow) {
        for (IPRouteTableRow row : aRouteTableRows) {
            String rowIpDest = aRouteRow.getDestIPAddress();
            if (rowIpDest == null) {
                throw new IllegalStateException("The route " + aRouteRow + " destination IP should not be null");
            }
            if (!rowIpDest.equalsIgnoreCase(row.getDestIPAddress())) continue;
            InterfaceTableRowNode if1 = aRouteRow.getInterface();
            InterfaceTableRowNode if2 = row.getInterface();
            String if1Name = if1.getName();
            if (if1Name == null) {
                throw new IllegalStateException("The inteface " + if1 + " name should not be null");
            }
            if (!if1Name.equalsIgnoreCase(if2.getName())) continue;
            return row;
        }
        return null;
    }
}

