/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.vswitch;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrMainTreePanel;
import com.sanrad.nms.client.gui.SrPopupMenu;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.EmptyAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.TreeView;
import com.sanrad.swing.components.SrMenu;
import com.sanrad.swing.components.SrMenuItem;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import de.mud.jta.TelnetFrame;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;

public class VSwitchPopupMenu
extends SrPopupMenu {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private SrAction openTelnetSession;

    public VSwitchPopupMenu(SrMainTreePanel workWith) {
        super(workWith);
        this.openTelnetSession = new SrClientAction<VSwitchNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_POP_UP_MENU_ITEM_TELNET), true, true, new TreeView<VSwitchNode>(this.myWorkWith.getTreeObject(), VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH, true){

            @Override
            public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
                TelnetInvoker telnetThread = new TelnetInvoker(arg.iterator().next());
                telnetThread.run();
                return Collections.singleton(new CompleteFuture("VSwitchPopupMenu.openTelnetSession"));
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return null;
            }
        };
        this.add(new SrMenuItem(workWith.resetVSwitch));
        this.add(new SrMenuItem(workWith.shutdownVSwitch));
        this.add(new SrMenuItem(workWith.wakeOnLANVSwitch));
        this.addSeparator();
        this.add(new SrMenuItem(workWith.attachOrDetachRaidActionForVs));
        SrMenu myIscsiMenu = this.createIscsiMenu(workWith);
        this.addSeparator();
        this.add(new SrMenuItem(this.openTelnetSession));
        this.addSeparator();
        this.add(new SrMenuItem(workWith.openFCProperties));
        this.add(new SrMenuItem(workWith.openPScsiProperties));
        this.add(myIscsiMenu);
        this.add(this.createStatisticsMenu(workWith));
        this.addSeparator();
        this.add(new SrMenuItem(workWith.vSwitchHardwareStatus));
        this.addSeparator();
        this.add(this.alarmsMenu);
        this.addSeparator();
        this.add(this.getDeleteItem());
        this.addSeparator();
        this.add(VSwitchPopupMenu.createPropertiesItem(this.myWorkWith.openVSwitchProperties));
    }

    private SrMenu createIscsiMenu(SrMainTreePanel workWith) {
        SrMenu iscsiMenu = new SrMenu(new SrPopupMenu.IscsiMenuAction<VSwitchNode>(new TreeView<VSwitchNode>(this.myWorkWith.getTreeObject(), VSwitchNode.class)){

            @Override
            protected String derivedClientUpdateEnabled() {
                return SrMainTreePanel.regularVSwitchTest((VSwitchNode)this.myView.getValue().iterator().next());
            }
        });
        iscsiMenu.add(new SrMenuItem(workWith.openIscsiInstanceInfo));
        SrMenu iscsiInitiatorMenu = new SrMenu(new EmptyAction(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_INITIATOR), true, true, SrLicenseTreePath.INITIATOR_PATH));
        iscsiInitiatorMenu.add(new SrMenuItem(workWith.openIscsiInitiator));
        iscsiInitiatorMenu.add(new SrMenuItem(workWith.iscsiInitiatorPortsStatistics));
        iscsiMenu.add(iscsiInitiatorMenu);
        iscsiMenu.add(this.m_iscsiRemoteTargetShowItem);
        iscsiMenu.add(this.m_iscsiRemoteDiscoveryPortalsShowItem);
        this.m_iscsiSessionsMenu.add(this.m_iscsiSessionsShowItem);
        this.m_iscsiSessionsMenu.add(this.m_iscsiSessionsStatisticsItem);
        iscsiMenu.add(this.m_iscsiSessionsMenu);
        iscsiMenu.add(this.m_iscsiConnectionsItem);
        this.m_iscsiConnectedInitiatorsMenu.add(this.m_iscsiConnectedInitiatorsShowItem);
        this.m_iscsiConnectedInitiatorsMenu.add(this.m_iscsiConnectedInitiatorsStatisticsItem);
        iscsiMenu.add(this.m_iscsiConnectedInitiatorsMenu);
        return iscsiMenu;
    }

    private SrMenu createStatisticsMenu(SrMainTreePanel workWith) {
        EmptyVSwitchAction menuAction = new EmptyVSwitchAction(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_STATISTICS), workWith);
        SrMenu statisticsMenu = new SrMenu(menuAction);
        statisticsMenu.add(new SrMenuItem(workWith.interfacesStatistics));
        statisticsMenu.add(new SrMenuItem(workWith.ipStatistics));
        statisticsMenu.add(new SrMenuItem(workWith.icmpStatistics));
        statisticsMenu.add(new SrMenuItem(workWith.tcpStatistics));
        statisticsMenu.add(new SrMenuItem(workWith.udpStatistics));
        return statisticsMenu;
    }

    private void openSSHSession() {
    }

    @Override
    protected DeleteAction getDeleteAction() {
        return this.myWorkWith.myRemoveVswitchAction;
    }

    @Override
    public AlarmAction getSpecificAlarmAction() {
        return this.myWorkWith.myOpenSpecificAlarmsAction;
    }

    @Override
    public AlarmAction getPropagatedAlarmAction() {
        return this.myWorkWith.myOpenPropagatedAlarmsAction;
    }

    protected void synchronizeItemSelected() {
    }

    @Override
    protected void innerReset() {
    }

    class TelnetInvoker {
        private VSwitchNode m_vSwitch;

        public TelnetInvoker(VSwitchNode vSwitch) {
            this.m_vSwitch = vSwitch;
        }

        public void run() {
            JFrame telnetFrame = (JFrame)this.m_vSwitch.getDialog(JFrame.class);
            if (telnetFrame == null) {
                BigInteger telPort = this.m_vSwitch.getTelnetPort();
                int telnetPort = telPort == null ? 23 : telPort.intValue();
                String[] args = new String[]{"-config", "default.conf", this.m_vSwitch.getIPAddress(), Integer.toString(telnetPort)};
                telnetFrame = new TelnetFrame(args);
                telnetFrame.setIconImage(ClientImageObject.APP_ICON.getImageIcon().getImage());
                this.m_vSwitch.addDialog(telnetFrame);
                SrSwingUtils.setLocationOnScreenCenter(telnetFrame);
                telnetFrame.setVisible(true);
            } else {
                telnetFrame.requestFocus();
            }
        }
    }

    class SSHInvoker {
        SSHInvoker() {
        }

        public void run() {
        }
    }

    public static class EmptyVSwitchAction
    extends SrClientAction<VSwitchNode, Void> {
        public EmptyVSwitchAction(String name, SrMainTreePanel workWith) {
            super(name, true, true, new TreeView<VSwitchNode>(workWith.getTreeObject(), VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH, true);
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return SrMainTreePanel.regularVSwitchTest((VSwitchNode)this.myView.getValue().iterator().next());
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "VSwitchPopupMenu.EmptyVSwitchAction performed, although it is empty");
            return Collections.singleton(new CompleteFuture("VSwitchPopupMenu.EmptyVSwitchAction"));
        }
    }
}

