/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.wizard.exchange;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrSystemObjectComboBox;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.volume.wizard.exchange.ExchangeVolumeParamsWizPanel;
import com.sanrad.nms.client.gui.volume.wizard.exchange.SrExchangeVolumeWizardFrame;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrRadioButtonsPanel;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.wizard.SrWizardPanel;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;

public class ExchangeVolumeSelectClusterWizPanel
extends SrWizardPanel {
    private static final String DESCRIPTION = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_EXCHANGE_VOLUME_WIZ_SELECT_TYPE_DESC);
    private static final String CLUSTERS_COMBO_LABEL = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_EXCHANGE_VOLUME_WIZ_CLUSTER_COMBO_LABEL);
    private static final String VOLUME_TYPE_OPTIONS_LABEL = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_EXCHANGE_VOLUME_WIZ_VOLUME_TYPE_OPTIONS_LABEL);
    private static final String LOG_OPTION = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_EXCHANGE_VOLUME_WIZ_LOG_TYPE_OPTION);
    private static final String DB_OPTION = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_EXCHANGE_VOLUME_WIZ_DB_TYPE_OPTION);
    private static final String DB_AND_LOG_OPTION = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_EXCHANGE_VOLUME_WIZ_DB_AND_LOG_TYPE_OPTION);
    private ClusterNode myCluster;
    private SrSystemObjectComboBox myClusterCombo;
    private SrRadioButtonsPanel myVolTypeRadioPanel;

    public ExchangeVolumeSelectClusterWizPanel(ClusterNode aCluster) {
        this.myCluster = aCluster;
        this.myClusterCombo = new SrSystemObjectComboBox(SystemRootNode.getInstance(), ClusterNode.class);
        this.myVolTypeRadioPanel = new SrRadioButtonsPanel();
        this.myVolTypeRadioPanel.addRadio(LOG_OPTION, (Object)SrExchangeVolumeWizardFrame.VolTypeOption.LOG);
        this.myVolTypeRadioPanel.addRadio(DB_OPTION, (Object)SrExchangeVolumeWizardFrame.VolTypeOption.DB);
        this.myVolTypeRadioPanel.addRadio(DB_AND_LOG_OPTION, (Object)SrExchangeVolumeWizardFrame.VolTypeOption.DB_AND_LOG);
        SrPanel panel = new SrPanel(new GridBagLayout());
        GridBagConstraints c = SrSwingUtils.getGridBagConstraintsForSimpleFields();
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)new SrLabelField(CLUSTERS_COMBO_LABEL), c);
        c.gridx = 1;
        c.gridy = 0;
        panel.add((Component)this.myClusterCombo, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        panel.add((Component)new SrLabelField(VOLUME_TYPE_OPTIONS_LABEL), c);
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 2;
        panel.add((Component)this.myVolTypeRadioPanel, c);
        this.add((Component)panel, "Center");
    }

    @Override
    public void back() {
    }

    @Override
    public void display() {
        this.setBackButtonEnabled(false);
        this.getOwner().clearParticipatingClusters();
        ClusterNode selectedCluster = (ClusterNode)this.wizardContext.getAttribute(SrExchangeVolumeWizardFrame.Key.SELECTED_CLUSTER);
        if (selectedCluster != null) {
            this.myClusterCombo.setSelectedItem(selectedCluster);
        } else {
            this.myClusterCombo.setSelectedItem(this.myCluster);
        }
        SrExchangeVolumeWizardFrame.VolTypeOption selectedType = (SrExchangeVolumeWizardFrame.VolTypeOption)((Object)this.wizardContext.getAttribute(SrExchangeVolumeWizardFrame.Key.SELECTED_VOL_TYPE));
        if (selectedType != null) {
            this.myVolTypeRadioPanel.setValue((Object)selectedType);
        } else {
            this.myVolTypeRadioPanel.setValue((Object)SrExchangeVolumeWizardFrame.VolTypeOption.DB_AND_LOG);
        }
    }

    @Override
    public Action getNextButtonAction() {
        SrClientAction<Void, Void> action = new SrClientAction<Void, Void>(true, true, null, SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> aArg) {
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                if (ExchangeVolumeSelectClusterWizPanel.this.myClusterCombo.getSelectedItem() == null) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.CLUSTER_NOT_SELECTED);
                }
                return null;
            }
        };
        this.myClusterCombo.addItemListener(new View.ToggleButtonListener(action));
        return action;
    }

    @Override
    public WizardPanel next() {
        ClusterNode cluster = (ClusterNode)this.myClusterCombo.getSelectedItem();
        this.getOwner().addParticipatingCluster(cluster);
        SrExchangeVolumeWizardFrame.VolTypeOption selectedVolumeType = (SrExchangeVolumeWizardFrame.VolTypeOption)((Object)this.myVolTypeRadioPanel.getValue());
        this.wizardContext.setAttribute(SrExchangeVolumeWizardFrame.Key.SELECTED_CLUSTER, cluster, this);
        this.wizardContext.setAttribute(SrExchangeVolumeWizardFrame.Key.SELECTED_VOL_TYPE, (Object)selectedVolumeType, this);
        SrExchangeVolumeWizardFrame.VolTypeOption nextWizardOption = SrExchangeVolumeWizardFrame.VolTypeOption.DB.equals((Object)selectedVolumeType) ? SrExchangeVolumeWizardFrame.VolTypeOption.DB : SrExchangeVolumeWizardFrame.VolTypeOption.LOG;
        return new ExchangeVolumeParamsWizPanel(nextWizardOption);
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public boolean validateNext(List list) {
        return true;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }
}

