/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.wizard.exchange;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.raid.AttachedRaidManager;
import com.sanrad.nms.client.data.raid.RaidManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceSpace;
import com.sanrad.nms.client.data.storage.StoragePoolSelector;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.target.qos.TargetQosGroupNode;
import com.sanrad.nms.client.data.target.qos.TargetQosGroupsManager;
import com.sanrad.nms.client.event.DirectAccessDeviceAdapter;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceAdapter;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.raid.RaidEvent;
import com.sanrad.nms.client.event.raid.RaidManagerListener;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.volume.AvailableStorageTablePanel;
import com.sanrad.nms.client.gui.volume.wizard.exchange.ExchangeVolumeSummaryWizPanel;
import com.sanrad.nms.client.gui.volume.wizard.exchange.SrExchangeVolumeWizardFrame;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.AllocationPolicy;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.swing.SrOptionPane;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrSliderPanel;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrCheckbox;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrDecimalTextField;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.text.AliasDocument;
import com.sanrad.swing.wizard.SrWizardPanel;
import com.sanrad.util.StorageSize;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExchangeVolumeParamsWizPanel
extends SrWizardPanel {
    private static final String DB_VOL_DESCRIPTION = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_EXCHANGE_VOLUME_WIZ_DB_VOLUME_DESC);
    private static final String LOG_VOL_DESCRIPTION = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_EXCHANGE_VOLUME_WIZ_LOG_VOLUME_DESC);
    private static final String YES = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_OPTION_PANE_YES);
    private static final String NO = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_OPTION_PANE_NO);
    private SrExchangeVolumeWizardFrame.VolTypeOption myVolType;
    private static final String ALIAS_SHOULD_BE_ENTERED = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VOLUME_WINDOW_ALIAS_SHOULD_BE_ENTERED);
    private static final String SIZE_SHOULD_BE_ENTERED = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VOLUME_WINDOW_SIZE_SHOULD_BE_ENTERED);
    private static final String SIZE_EXCEEDS_MAXIMUM = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VOLUME_WINDOW_SIZE_EXCEEDS_MAXIMUM);
    private static final String MIRROR_CHECK_BOX_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_MIRROR_CHECK_BOX_TEXT);
    private static final String ALIAS_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_ALIAS_LABEL_TEXT);
    private static final String SIZE_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_SIZE_LABEL_TEXT);
    private static final String OF_MAXIMUM_SIZE_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_OF_MAXIMUM_SIZE_LABEL_TEXT);
    private static final String NO_MAX_VALUE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_NO_MAX_VALUE);
    private static final String MIRROR_WARN_CAPTION = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_MIRROR_WARN_CAPTION);
    private static final String MIRROR_ONE_RAID_WARN_MSG = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_MIRROR_ONE_RAID_WARN_MSG);
    private static final String MIRROR_SPACE_WARN_MSG = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_MIRROR_SPACE_WARN_MSG);
    private static final String MIRROR_INFO = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_MIRROR_INFO);
    private static final String OPTION_PANE_OK = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_OPTION_PANE_OK);
    private static final int MAX_ALIAS_TEXT_FIELD_LENGTH = 20;
    private SrTextField myAliasTextField = new SrTextField(20);
    private static final String TARGET_ALIAS_ALLOWED_CHARS_REGEX = "[a-z[\\d*][\\.*]]";
    private SrCheckbox myMirrorCheckBox = new SrCheckbox(MIRROR_CHECK_BOX_TEXT);
    private SrDecimalTextField mySizeTextField = new SrDecimalTextField();
    private static final StorageSize[] theUnits = new StorageSize[]{StorageSize.MEGA, StorageSize.GIGA, StorageSize.TERA};
    private SrComboBox<StorageSize> mySizeUnitCombobox = new SrComboBox<StorageSize>((T[])theUnits);
    private SrLabelField myOfMaxLable = new SrLabelField();
    private BigDecimal myMaxSpace = BigDecimal.ZERO;
    private RaidManagerListener myRaidManagerListener = null;
    private static final String NEW_VOLUME_CREATION_NO_AVAILABLE_DISKS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_CREATION_NO_AVAILABLE_DISKS);
    private AvailableStorageTablePanel myStorageTable;
    private SrPanel myNoRaidLabelPanel;
    private SrSliderPanel myVolSizeSlider = new SrSliderPanel(0, 100, "%", false);
    private ChangeListener myVolSizeSliderListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            BigDecimal percentage = new BigDecimal(ExchangeVolumeParamsWizPanel.this.myVolSizeSlider.getValue());
            BigInteger maxSizeInt = ExchangeVolumeParamsWizPanel.this.getMaxSize(ExchangeVolumeParamsWizPanel.this.myStorageTable.getSelectedRow());
            BigDecimal maxSize = new BigDecimal(maxSizeInt.doubleValue());
            BigDecimal requestedSize = maxSize.multiply(percentage).divide(new BigDecimal(100));
            BigInteger sizeInUnits = StorageDeviceSpace.getSizeInUnit(requestedSize.toBigInteger(), (StorageSize)ExchangeVolumeParamsWizPanel.this.mySizeUnitCombobox.getSelectedItem());
            ExchangeVolumeParamsWizPanel.this.mySizeTextField.setText(sizeInUnits.toString());
        }
    };
    DirectAccessDeviceAdapter myDisksListener = new DirectAccessDeviceAdapter(){

        @Override
        public void directAccessDeviceChanged(DirectAccessDeviceEvent event) {
            StorageDeviceNode storage = event.getStorageNode();
            if (storage instanceof DirectAccessDeviceNode) {
                ExchangeVolumeParamsWizPanel.this.handleEventForChangeInStorage();
            }
        }

        @Override
        public void directAccessDeviceCreated(DirectAccessDeviceEvent event) {
            StorageDeviceNode storage = event.getStorageNode();
            if (storage instanceof DirectAccessDeviceNode) {
                ExchangeVolumeParamsWizPanel.this.handleEventForChangeInStorage();
            }
        }

        @Override
        public void directAccessDeviceDeExposed(DirectAccessDeviceEvent event) {
            StorageDeviceNode storage = event.getStorageNode();
            if (storage instanceof DirectAccessDeviceNode) {
                ExchangeVolumeParamsWizPanel.this.handleEventForChangeInStorage();
            }
        }

        @Override
        public void directAccessDeviceExposed(DirectAccessDeviceEvent event) {
            StorageDeviceNode storage = event.getStorageNode();
            if (storage instanceof DirectAccessDeviceNode) {
                ExchangeVolumeParamsWizPanel.this.handleEventForChangeInStorage();
            }
        }

        @Override
        public void directAccessDeviceRemoved(DirectAccessDeviceEvent event) {
            StorageDeviceNode storage = event.getStorageNode();
            if (storage instanceof DirectAccessDeviceNode) {
                ExchangeVolumeParamsWizPanel.this.handleEventForChangeInStorage();
            }
        }

        @Override
        public void directAccessDeviceStatusChanged(DirectAccessDeviceEvent event) {
            StorageDeviceNode storage = event.getStorageNode();
            if (storage instanceof DirectAccessDeviceNode) {
                ExchangeVolumeParamsWizPanel.this.handleEventForChangeInStorage();
            }
        }
    };
    SubDirectAccessDeviceAdapter mySubdisksListener = new SubDirectAccessDeviceAdapter(){

        @Override
        public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
            ExchangeVolumeParamsWizPanel.this.handleEventForChangeInStorage();
        }

        @Override
        public void subDirecetAccessDeviceRemoved(SubDirectAccessDeviceEvent event) {
            ExchangeVolumeParamsWizPanel.this.handleEventForChangeInStorage();
        }
    };
    private SrPanel myMainPanel;

    public ExchangeVolumeParamsWizPanel(SrExchangeVolumeWizardFrame.VolTypeOption aVolType) {
        Util.validateInputNotNull((Object)aVolType, "Exchange Volume type");
        this.myVolType = aVolType;
        this.initComponents();
    }

    @Override
    public void back() {
    }

    @Override
    public void display() {
        this.addListeners();
        this.clearAndSetStorageTable();
        this.selectPreferredRaidTableEntry();
        this.updateSelectedRaidsForVolumeCreation();
    }

    @Override
    public WizardPanel next() {
        ClientConfigElementData ced = null;
        ced = this.myMirrorCheckBox.isSelected() ? this.createAutoVolumeCed(this.getRequestedAlias(), ClassID.MIRROR_VOLUME) : this.createAutoVolumeCed(this.getRequestedAlias(), ClassID.GENERAL_VOLUME);
        String sizeTextForSummary = this.mySizeTextField.getText() + " " + this.mySizeUnitCombobox.getSelectedItem();
        String alias = this.myAliasTextField.getText();
        String isMirror = this.myMirrorCheckBox.isSelected() ? YES : NO;
        PhysicalStorageDriveTypeConstant driveType = this.myStorageTable.getStorageTypeAt(this.myStorageTable.getSelectedRow());
        PhysicalStorageRaidLevelConstant raidLevel = this.myStorageTable.getRaidLevelAt(this.myStorageTable.getSelectedRow());
        switch (this.myVolType) {
            case DB: {
                this.wizardContext.setAttribute(SrExchangeVolumeWizardFrame.Key.DB_VOLUME_SIZE_TEXT, sizeTextForSummary, this);
                this.wizardContext.setAttribute(SrExchangeVolumeWizardFrame.Key.DB_VOLUME_ALIAS_TEXT, alias, this);
                this.wizardContext.setAttribute(SrExchangeVolumeWizardFrame.Key.DB_VOLUME_IS_MIRROR, isMirror, this);
                this.wizardContext.setAttribute(SrExchangeVolumeWizardFrame.Key.DB_VOLUME_DRIVE_TYPE, driveType, this);
                this.wizardContext.setAttribute(SrExchangeVolumeWizardFrame.Key.DB_VOLUME_CED, ced, this);
                break;
            }
            case LOG: {
                this.wizardContext.setAttribute(SrExchangeVolumeWizardFrame.Key.LOG_VOLUME_SIZE_TEXT, sizeTextForSummary, this);
                this.wizardContext.setAttribute(SrExchangeVolumeWizardFrame.Key.LOG_VOLUME_SIZE, this.getRequestedVolumeSize().toBigInteger(), this);
                this.wizardContext.setAttribute(SrExchangeVolumeWizardFrame.Key.LOG_VOLUME_ALIAS_TEXT, alias, this);
                this.wizardContext.setAttribute(SrExchangeVolumeWizardFrame.Key.LOG_VOLUME_IS_MIRROR, isMirror, this);
                this.wizardContext.setAttribute(SrExchangeVolumeWizardFrame.Key.LOG_VOLUME_DRIVE_TYPE, driveType, this);
                this.wizardContext.setAttribute(SrExchangeVolumeWizardFrame.Key.LOG_VOLUME_RAID_LEVEL, raidLevel, this);
                this.wizardContext.setAttribute(SrExchangeVolumeWizardFrame.Key.LOG_VOLUME_CED, ced, this);
            }
        }
        SrExchangeVolumeWizardFrame.VolTypeOption userTypeSelection = (SrExchangeVolumeWizardFrame.VolTypeOption)((Object)this.wizardContext.getAttribute(SrExchangeVolumeWizardFrame.Key.SELECTED_VOL_TYPE));
        switch (userTypeSelection) {
            case DB: 
            case LOG: {
                return new ExchangeVolumeSummaryWizPanel();
            }
            case DB_AND_LOG: {
                switch (this.myVolType) {
                    case DB: {
                        return new ExchangeVolumeSummaryWizPanel();
                    }
                    case LOG: {
                        return new ExchangeVolumeParamsWizPanel(SrExchangeVolumeWizardFrame.VolTypeOption.DB);
                    }
                }
            }
        }
        throw new IllegalStateException("User type selection " + (Object)((Object)userTypeSelection) + " is invalid");
    }

    @Override
    public boolean validateNext(List list) {
        return true;
    }

    @Override
    public String getDescription() {
        switch (this.myVolType) {
            case DB: {
                return DB_VOL_DESCRIPTION;
            }
            case LOG: {
                return LOG_VOL_DESCRIPTION;
            }
        }
        throw new IllegalStateException("User type selection " + (Object)((Object)this.myVolType) + " is invalid");
    }

    private void initComponents() {
        SrLabelField noRaidLabel = new SrLabelField(ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_NO_RAID_ATTACHED));
        noRaidLabel.setForeground(Color.RED);
        SrPanel myUpperPanel = this.createNorthPanel();
        SrPanel myCenterPanel = this.createCenterPanel();
        this.myMainPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints c = SrSwingUtils.getGridBagConstraintsForSimpleFields();
        c.insets.left = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        this.myMainPanel.add((Component)myUpperPanel, c);
        c.insets.left = 5;
        c.gridx = 0;
        c.gridy = 1;
        c.weighty = 1.0;
        this.myMainPanel.add((Component)myCenterPanel, c);
        this.myNoRaidLabelPanel = new SrPanel();
        this.myNoRaidLabelPanel.setBorder(new EmptyBorder(20, 20, 0, 0));
        this.myNoRaidLabelPanel.add(noRaidLabel);
        this.setNoRaidLabelVisibility(false);
        this.add((Component)this.myNoRaidLabelPanel, "North");
        this.add((Component)this.myMainPanel, "Center");
    }

    private void handleEventForChangeInStorage() {
        this.clearAndSetStorageTable();
        this.updateSelectedRaidsForVolumeCreation();
    }

    private void handleEventForChangeInMirrorSelection() {
        this.updateSelectedRaidsForVolumeCreation();
    }

    private void updateSelectedRaidsForVolumeCreation() {
        this.updateMaxSizeText();
        this.updateVolumeSizeSlideBar();
    }

    private SrPanel createNorthPanel() {
        SrPanel panel = new SrPanel(new GridBagLayout());
        this.myAliasTextField.setDocument(new AliasDocument(TARGET_ALIAS_ALLOWED_CHARS_REGEX));
        SrPanel aliasPanel = new SrPanel(new FlowLayout(0));
        SrLabelField aliasLabel = new SrLabelField(ALIAS_LABEL_TEXT);
        aliasPanel.add(aliasLabel);
        aliasPanel.add(this.myAliasTextField);
        SrPanel mirrorPanel = new SrPanel(new FlowLayout(0));
        this.myMirrorCheckBox.setHorizontalTextPosition(2);
        this.myMirrorCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExchangeVolumeParamsWizPanel.this.handleEventForChangeInMirrorSelection();
                if (ExchangeVolumeParamsWizPanel.this.myMirrorCheckBox.isSelected()) {
                    int row;
                    boolean isSingleRaidCluster;
                    ClusterNode cluster = (ClusterNode)ExchangeVolumeParamsWizPanel.this.wizardContext.getAttribute(SrExchangeVolumeWizardFrame.Key.SELECTED_CLUSTER);
                    boolean bl = isSingleRaidCluster = AttachedRaidManager.getInstance().getAttachedRaids(cluster).size() < 2;
                    if (isSingleRaidCluster) {
                        SrOptionPane warningPane = new SrOptionPane(MIRROR_WARN_CAPTION, MIRROR_ONE_RAID_WARN_MSG, SrOptionPane.MessageType.WARNING_DIALOG, ExchangeVolumeParamsWizPanel.this.getOwner());
                        warningPane.addButton(new SrOptionPane.Option<String>(OPTION_PANE_OK), 0);
                        warningPane.show();
                    }
                    if ((row = ExchangeVolumeParamsWizPanel.this.myStorageTable.getSelectedRow()) > -1) {
                        PhysicalStorageDriveTypeConstant type = ExchangeVolumeParamsWizPanel.this.myStorageTable.getStorageTypeAt(row);
                        PhysicalStorageRaidLevelConstant raidLevel = ExchangeVolumeParamsWizPanel.this.myStorageTable.getRaidLevelAt(row);
                        BigInteger twoRaidsMirrorSize = StoragePoolSelector.getMaxMirrorSpace(cluster, type, raidLevel);
                        BigInteger requestedSize = ExchangeVolumeParamsWizPanel.this.getRequestedVolumeSize().toBigInteger();
                        if (requestedSize.compareTo(twoRaidsMirrorSize) > 0) {
                            SrOptionPane warningPane = new SrOptionPane(MIRROR_WARN_CAPTION, MIRROR_SPACE_WARN_MSG, SrOptionPane.MessageType.WARNING_DIALOG, ExchangeVolumeParamsWizPanel.this.getOwner());
                            warningPane.addButton(new SrOptionPane.Option<String>(OPTION_PANE_OK), 0);
                            warningPane.show();
                        }
                    }
                }
            }
        });
        this.myMirrorCheckBox.setFocusPainted(false);
        SrClientLabel imageLabel = new SrClientLabel();
        imageLabel.setIcon(ClientImageObject.INFORMATION.getImageIcon());
        imageLabel.setToolTipText(MIRROR_INFO);
        mirrorPanel.add(imageLabel);
        mirrorPanel.add(this.myMirrorCheckBox);
        GridBagConstraints c = SrSwingUtils.getGridBagConstraintsForSimpleFields();
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)aliasPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        panel.add((Component)mirrorPanel, c);
        return panel;
    }

    private SrPanel createCenterPanel() {
        this.myStorageTable = new AvailableStorageTablePanel();
        this.myStorageTable.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExchangeVolumeParamsWizPanel.this.updateMaxSizeText();
                ExchangeVolumeParamsWizPanel.this.updateVolumeSizeSlideBar();
            }
        });
        SrPanel sizePanel = new SrPanel(new GridBagLayout());
        SrLabelField sizeLable = new SrLabelField(SIZE_LABEL_TEXT);
        this.mySizeUnitCombobox.setSelectedItem(StorageSize.GIGA);
        this.myVolSizeSlider.addChangeListener(this.myVolSizeSliderListener);
        this.myVolSizeSlider.setMajorTickSpacing(10);
        this.myVolSizeSlider.setMinorTickSpacing(5);
        this.myVolSizeSlider.showTicks(true);
        this.myVolSizeSlider.showLabels(true);
        GridBagConstraints c = SrSwingUtils.getGridBagConstraintsForSimpleFields();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        sizePanel.add((Component)sizeLable, c);
        c.gridx = 1;
        sizePanel.add((Component)this.mySizeTextField, c);
        c.gridx = 2;
        sizePanel.add(this.mySizeUnitCombobox, c);
        c.gridx = 3;
        sizePanel.add((Component)this.myOfMaxLable, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 4;
        c.insets.left = 0;
        sizePanel.add((Component)this.myVolSizeSlider, c);
        return sizePanel;
    }

    private void setNoRaidLabelVisibility(boolean aVisible) {
        this.myNoRaidLabelPanel.setVisible(aVisible);
        this.myMainPanel.setVisible(!aVisible);
    }

    private void clearAndSetStorageTable() {
        ClusterNode cluster = (ClusterNode)this.wizardContext.getAttribute(SrExchangeVolumeWizardFrame.Key.SELECTED_CLUSTER);
        this.myStorageTable.updateTable(cluster);
        this.setNoRaidLabelVisibility(this.myStorageTable.getAllRows().isEmpty());
    }

    private void selectPreferredRaidTableEntry() {
        BigInteger logVolSize = (BigInteger)this.wizardContext.getAttribute(SrExchangeVolumeWizardFrame.Key.LOG_VOLUME_SIZE);
        boolean isConsiderLogSize = false;
        PhysicalStorageDriveTypeConstant logVolDriveType = (PhysicalStorageDriveTypeConstant)this.wizardContext.getAttribute(SrExchangeVolumeWizardFrame.Key.LOG_VOLUME_DRIVE_TYPE);
        PhysicalStorageRaidLevelConstant logVolRaidLevel = (PhysicalStorageRaidLevelConstant)this.wizardContext.getAttribute(SrExchangeVolumeWizardFrame.Key.LOG_VOLUME_RAID_LEVEL);
        if (SrExchangeVolumeWizardFrame.VolTypeOption.DB.equals((Object)this.myVolType) && logVolDriveType != null && logVolRaidLevel != null && logVolSize != null) {
            isConsiderLogSize = true;
        }
        int bestSasRow = -1;
        BigInteger maxSasSize = BigInteger.ZERO;
        int bestSataRow = -1;
        BigInteger maxSataSize = BigInteger.ZERO;
        int bestUnknownDriveTypeRow = -1;
        BigInteger maxUnknownDriveTypeSize = BigInteger.ZERO;
        for (int i = 0; i < this.myStorageTable.getRowCount(); ++i) {
            PhysicalStorageRaidLevelConstant currRaidLevel = this.myStorageTable.getRaidLevelAt(i);
            PhysicalStorageDriveTypeConstant currDriveType = this.myStorageTable.getStorageTypeAt(i);
            if (PhysicalStorageDriveTypeConstant.PHYS_STOR_DRIVE_TYPE_SAS.equals(currDriveType)) {
                BigInteger currSasSize = this.myStorageTable.getAvailableSpaceAt(i);
                if (isConsiderLogSize && PhysicalStorageDriveTypeConstant.PHYS_STOR_DRIVE_TYPE_SAS.equals(logVolDriveType) && logVolRaidLevel.equals(currRaidLevel)) {
                    currSasSize = currSasSize.subtract(logVolSize);
                }
                if (maxSasSize.compareTo(currSasSize) >= 0) continue;
                maxSasSize = currSasSize;
                bestSasRow = i;
                continue;
            }
            if (PhysicalStorageDriveTypeConstant.PHYS_STOR_DRIVE_TYPE_SATA.equals(currDriveType)) {
                BigInteger currSataSize = this.myStorageTable.getAvailableSpaceAt(i);
                if (isConsiderLogSize && PhysicalStorageDriveTypeConstant.PHYS_STOR_DRIVE_TYPE_SATA.equals(logVolDriveType) && logVolRaidLevel.equals(currRaidLevel)) {
                    currSataSize = currSataSize.subtract(logVolSize);
                }
                if (maxSataSize.compareTo(currSataSize) >= 0) continue;
                maxSataSize = currSataSize;
                bestSataRow = i;
                continue;
            }
            if (!PhysicalStorageDriveTypeConstant.PHYS_STOR_DRIVE_TYPE_OTHER.equals(currDriveType)) continue;
            BigInteger currJbodSize = this.myStorageTable.getAvailableSpaceAt(i);
            if (isConsiderLogSize && PhysicalStorageDriveTypeConstant.PHYS_STOR_DRIVE_TYPE_OTHER.equals(logVolDriveType) && logVolRaidLevel.equals(currRaidLevel)) {
                currJbodSize = currJbodSize.subtract(logVolSize);
            }
            if (maxUnknownDriveTypeSize.compareTo(currJbodSize) >= 0) continue;
            maxUnknownDriveTypeSize = currJbodSize;
            bestUnknownDriveTypeRow = i;
        }
        switch (this.myVolType) {
            case DB: {
                int n = bestSataRow > -1 ? bestSataRow : (bestSataRow = bestSasRow > -1 ? bestSasRow : bestUnknownDriveTypeRow);
                if (bestSataRow <= -1) break;
                this.myStorageTable.getTable().getSelectionModel().setSelectionInterval(bestSataRow, bestSataRow);
                break;
            }
            case LOG: {
                int n = bestSasRow > -1 ? bestSasRow : (bestSasRow = bestSataRow > -1 ? bestSataRow : bestUnknownDriveTypeRow);
                if (bestSasRow <= -1) break;
                this.myStorageTable.getTable().getSelectionModel().setSelectionInterval(bestSasRow, bestSasRow);
                break;
            }
            default: {
                throw new IllegalStateException("Volume type is not initialized porperly - " + (Object)((Object)this.myVolType));
            }
        }
    }

    private void updateMaxSizeText() {
        this.setMaxSize();
        this.myStorageTable.clearDisabledRowsState();
        for (int i = 0; i < this.myStorageTable.getRowCount(); ++i) {
            if (!BigInteger.ZERO.equals(this.getMaxSize(i))) continue;
            this.myStorageTable.setEnabledRow(i, false);
        }
        String maxSizeString = NO_MAX_VALUE;
        if (this.myMaxSpace != null) {
            StorageDeviceSpace space = new StorageDeviceSpace(this.myMaxSpace.toBigInteger());
            maxSizeString = space.toString();
        }
        String ofMaximumValue = OF_MAXIMUM_SIZE_LABEL_TEXT + " " + maxSizeString;
        this.myOfMaxLable.setText(ofMaximumValue);
    }

    private void updateVolumeSizeSlideBar() {
        double precentage;
        BigDecimal p = BigDecimal.ZERO;
        String volSizeStr = this.mySizeTextField.getText().trim();
        BigDecimal volSizeInKBytes = BigDecimal.ZERO;
        if (!volSizeStr.equals("")) {
            BigDecimal unitSize = new BigDecimal(((StorageSize)this.mySizeUnitCombobox.getSelectedItem()).getValue());
            volSizeInKBytes = new BigDecimal(volSizeStr).multiply(unitSize);
        }
        if (BigDecimal.ZERO.compareTo(volSizeInKBytes) < 0 && BigDecimal.ZERO.compareTo(this.myMaxSpace) != 0 && (p = new BigDecimal(precentage = volSizeInKBytes.doubleValue() * 100.0 / this.myMaxSpace.doubleValue())).compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalStateException("The volume size in precents = " + p + " is not valid");
        }
        this.myVolSizeSlider.setValue(p.intValue());
        if (this.myMaxSpace.compareTo(BigDecimal.ZERO) == 0) {
            this.myVolSizeSlider.setEnabled(false);
        } else {
            this.myVolSizeSlider.setEnabled(true);
        }
        this.myVolSizeSlider.setVisible(true);
    }

    private BigInteger getMaxSize(int aRow) {
        if (aRow < 0) {
            return BigInteger.ZERO;
        }
        BigInteger availableSpace = this.myStorageTable.getAvailableSpaceAt(aRow);
        if (SrExchangeVolumeWizardFrame.VolTypeOption.DB.equals((Object)this.myVolType)) {
            BigInteger logVolSize = (BigInteger)this.wizardContext.getAttribute(SrExchangeVolumeWizardFrame.Key.LOG_VOLUME_SIZE);
            PhysicalStorageDriveTypeConstant logVolDriveType = (PhysicalStorageDriveTypeConstant)this.wizardContext.getAttribute(SrExchangeVolumeWizardFrame.Key.LOG_VOLUME_DRIVE_TYPE);
            PhysicalStorageRaidLevelConstant logVolRaidLevel = (PhysicalStorageRaidLevelConstant)this.wizardContext.getAttribute(SrExchangeVolumeWizardFrame.Key.LOG_VOLUME_RAID_LEVEL);
            if (Util.equalsWithNull(this.myStorageTable.getStorageTypeAt(aRow), logVolDriveType) && Util.equalsWithNull(this.myStorageTable.getRaidLevelAt(aRow), logVolRaidLevel) && logVolSize != null) {
                availableSpace = availableSpace.subtract(logVolSize);
            }
        }
        if (this.myMirrorCheckBox.isSelected()) {
            return availableSpace.divide(new BigInteger("2"));
        }
        return availableSpace;
    }

    private void setMaxSize() {
        int selectedRow = this.myStorageTable.getSelectedRow();
        BigInteger maxSize = this.getMaxSize(selectedRow);
        this.myMaxSpace = maxSize != null ? new BigDecimal(maxSize) : null;
    }

    private String isValidForCreation() {
        ClusterNode cluster = (ClusterNode)this.wizardContext.getAttribute(SrExchangeVolumeWizardFrame.Key.SELECTED_CLUSTER);
        if (cluster == null) {
            throw new IllegalStateException("Selected cluster is null");
        }
        if (this.myStorageTable.getSelectedRow() < 0) {
            return NEW_VOLUME_CREATION_NO_AVAILABLE_DISKS;
        }
        if (this.myMaxSpace == null || this.myMaxSpace.equals(BigDecimal.ZERO)) {
            return NEW_VOLUME_CREATION_NO_AVAILABLE_DISKS;
        }
        String alias = this.myAliasTextField.getText();
        if (alias.trim().equals("")) {
            return ALIAS_SHOULD_BE_ENTERED;
        }
        String size = this.mySizeTextField.getText().trim();
        if (size.equals("")) {
            return SIZE_SHOULD_BE_ENTERED;
        }
        BigDecimal sizeInBytes = new BigDecimal(size).multiply(((StorageSize)this.mySizeUnitCombobox.getSelectedItem()).getDecimalValue());
        sizeInBytes = new BigDecimal(sizeInBytes.toBigInteger());
        if (this.myMaxSpace != null && sizeInBytes.compareTo(this.myMaxSpace) > 0) {
            return SIZE_EXCEEDS_MAXIMUM;
        }
        return null;
    }

    @Override
    public Action getNextButtonAction() {
        SrClientAction<Void, Void> nextAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return ExchangeVolumeParamsWizPanel.this.isValidForCreation();
            }
        };
        this.myAliasTextField.getDocument().addDocumentListener(new View.ViewTextListener(nextAction));
        this.myStorageTable.getTable().getSelectionModel().addListSelectionListener(new View.ViewListSelectionListener(nextAction));
        this.myMirrorCheckBox.addItemListener(new View.ToggleButtonListener(nextAction));
        this.mySizeTextField.getDocument().addDocumentListener(new View.ViewTextListener(nextAction));
        KeyAdapter sizeTextFieldToSliderListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ExchangeVolumeParamsWizPanel.this.myVolSizeSlider.removeChangeListener(ExchangeVolumeParamsWizPanel.this.myVolSizeSliderListener);
                ExchangeVolumeParamsWizPanel.this.updateVolumeSizeSlideBar();
                ExchangeVolumeParamsWizPanel.this.myVolSizeSlider.addChangeListener(ExchangeVolumeParamsWizPanel.this.myVolSizeSliderListener);
            }
        };
        this.mySizeTextField.addKeyListener(sizeTextFieldToSliderListener);
        ActionListener sizeUnitSelectedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExchangeVolumeParamsWizPanel.this.updateVolumeSizeSlideBar();
            }
        };
        this.mySizeUnitCombobox.addActionListener(sizeUnitSelectedListener);
        this.mySizeUnitCombobox.addItemListener(new View.ToggleButtonListener(nextAction));
        return nextAction;
    }

    private void addListeners() {
        DirectAccessDeviceManager.getInstance().addDirectAccessDeviceListener(this.myDisksListener);
        SubDirectAccessDeviceManager.getInstance().addSubDirectDeviceListener(this.mySubdisksListener);
        this.initRaidListeners();
        RaidManager.getInstance().addListener(this.myRaidManagerListener);
    }

    @Override
    public void removeListeners() {
        DirectAccessDeviceManager.getInstance().removeDirectAccessDeviceListener(this.myDisksListener);
        SubDirectAccessDeviceManager.getInstance().removeSubDirectDeviceListener(this.mySubdisksListener);
        RaidManager.getInstance().removeListener(this.myRaidManagerListener);
    }

    private void initRaidListeners() {
        this.myRaidManagerListener = new RaidManagerListener(){

            @Override
            public void RaidAttached(RaidEvent raidEvent) {
                ExchangeVolumeParamsWizPanel.this.handleEventForChangeInStorage();
            }

            @Override
            public void RaidChanged(RaidEvent raidEvent) {
            }

            @Override
            public void RaidCreated(RaidEvent raidEvent) {
                ExchangeVolumeParamsWizPanel.this.handleEventForChangeInStorage();
            }

            @Override
            public void RaidDetached(RaidEvent raidEvent) {
                ExchangeVolumeParamsWizPanel.this.handleEventForChangeInStorage();
            }

            @Override
            public void RaidRemoved(RaidEvent raidEvent) {
                ExchangeVolumeParamsWizPanel.this.handleEventForChangeInStorage();
            }
        };
    }

    private ClientConfigElementData createAutoVolumeCed(String aAlias, ClassID aVolumeType) {
        TargetQosGroupNode qos;
        ClusterNode cluster = (ClusterNode)this.wizardContext.getAttribute(SrExchangeVolumeWizardFrame.Key.SELECTED_CLUSTER);
        ClientConfigElementData volCed = new ClientConfigElementData(aVolumeType, (CommKeyClassId)cluster.getIdentifier(), ConfigOperation.CREATE);
        volCed.putValue(ClientParameterCode.VOLUME_ALIAS, aAlias);
        volCed.putValue(ClientParameterCode.VOLUME_SPACE, this.getRequestedVolumeSize().toBigInteger());
        volCed.putValue(ClientParameterCode.VOLUME_ALLOCATION_POLICY, AllocationPolicy.DONT_REUSE_ALLOCATED);
        int selectedRow = this.myStorageTable.getSelectedRow();
        if (selectedRow < 0) {
            throw new IllegalStateException("A row should be selected at this point");
        }
        volCed.putValue(ClientParameterCode.PHYSICAL_STORAGE_DRIVE_TYPE, this.myStorageTable.getStorageTypeAt(selectedRow));
        volCed.putValue(ClientParameterCode.PHYSICAL_STORAGE_RAID_LEVEL, this.myStorageTable.getRaidLevelAt(selectedRow));
        String targetName = TargetManager.getInstance().getAutoTargetNameForVolume(this.getRequestedAlias());
        volCed.putValue(ClientParameterCode.TARGET_NAME, targetName);
        volCed.putValue(ClientParameterCode.LU_LUN, new Long(0L));
        if (this.myVolType.equals((Object)SrExchangeVolumeWizardFrame.VolTypeOption.DB) && (qos = TargetQosGroupsManager.getInstance().getQosGroup(cluster)) != null) {
            volCed.putValue(ClientParameterCode.ISCSI_TARGET_QOS_GROUP_ID, qos.getIdentifier());
        }
        return volCed;
    }

    private BigDecimal getRequestedVolumeSize() {
        String size = this.mySizeTextField.getText().trim();
        if (size.length() == 0) {
            return BigDecimal.ZERO;
        }
        StorageSize sizeUnit = (StorageSize)this.mySizeUnitCombobox.getSelectedItem();
        BigDecimal volSize = new BigDecimal(size).multiply(sizeUnit.getDecimalValue());
        return volSize;
    }

    private String getRequestedAlias() {
        return this.myAliasTextField.getText().trim();
    }
}

