/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.wizard.clone;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.volume.MirrorVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.SrAllocateVolumeWizardPanel;
import com.sanrad.nms.client.gui.volume.wizard.clone.SrCloneSelectSrcVolumeWizardPanel;
import com.sanrad.nms.client.gui.volume.wizard.clone.SrCloneSummaryWizardPanel;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.wizard.ContextKey;
import com.sanrad.swing.wizard.SrHiddenWizardPanel;
import com.sanrad.swing.wizard.SrWizardFrame;
import com.sanrad.util.Util;
import com.sanrad.util.virtualization.ResourceAliasUtil;
import java.util.ArrayList;
import javax.swing.JFrame;

public abstract class SrCloneWizardFrame
extends SrWizardFrame {
    private static final String COPY_VOLUME_PREFIX = "Copy_of_";
    private boolean myIsAddMirrorWizard;

    public SrCloneWizardFrame(JFrame owner, final ClusterNode aCluster, final VolumeTreeNode aSrcVolume, boolean aIsAddMirrorWizard) {
        super(owner, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_TITLE), ClientImageObject.WIZARD.getImageIcon());
        this.myIsAddMirrorWizard = aIsAddMirrorWizard;
        if (this.myIsAddMirrorWizard) {
            this.m_wizTitle = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_MIRROR_WIZ_TITLE);
        }
        if (aSrcVolume == null) {
            this.setFirstPanel(new SrCloneSelectSrcVolumeWizardPanel(aCluster));
        } else {
            SrHiddenWizardPanel hiddenPanel = new SrHiddenWizardPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public WizardPanel next() {
                    String secondLegVolumeAlias = SrCloneWizardFrame.this.getSecondLegVolumeAlias(aCluster, aSrcVolume);
                    SrAllocateVolumeWizardPanel allocationWizPanel = new SrAllocateVolumeWizardPanel(aCluster, secondLegVolumeAlias, aSrcVolume.getAccessibleSpace(), aSrcVolume.getDriveType(), aSrcVolume.getRaidLevel(), aSrcVolume.getBlockSize(), Key.TARGET_VOL, new SrCloneSummaryWizardPanel(aCluster, SrCloneWizardFrame.this.myIsAddMirrorWizard)){

                        @Override
                        public void display() {
                            super.display();
                            this.setBackButtonEnabled(false);
                        }
                    };
                    if (SrCloneWizardFrame.this.myIsAddMirrorWizard) {
                        allocationWizPanel.setDescription(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_MIRROR_WIZ_SELECT_DST_DESC));
                    } else {
                        allocationWizPanel.setDescription(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_SELECT_DST_DESC));
                    }
                    this.wizardContext.setAttribute(Key.SOURCE_VOL, aSrcVolume, this);
                    return allocationWizPanel;
                }

                @Override
                public void removeListeners() {
                }
            };
            this.setFirstPanel(hiddenPanel);
        }
    }

    boolean isAddMirrorWizard() {
        return this.myIsAddMirrorWizard;
    }

    String getSecondLegVolumeAlias(ClusterNode aCluster, VolumeTreeNode aSrcVolume) {
        ArrayList<String> allAliases = new ArrayList<String>();
        allAliases.addAll(VolumeManager.getInstance().getAllVolumeAliases(aCluster));
        allAliases.addAll(StorageManager.getInstance().getAllAliases(aCluster));
        MirrorVolumeNode mirror = (MirrorVolumeNode)aSrcVolume.getAncestorOfType(MirrorVolumeNode.class);
        if (mirror == null) {
            String validAlias = Util.replaceInvalidCharacters(aSrcVolume.getAlias(), "[\\&#\\+\\-!\\*]");
            return ResourceAliasUtil.getRecommendedAlias(COPY_VOLUME_PREFIX + validAlias, allAliases);
        }
        for (VolumeTreeNode child : mirror.getChildrenOfType(VolumeTreeNode.class)) {
            String childAlias = child.getAlias();
            if (childAlias.startsWith(COPY_VOLUME_PREFIX)) continue;
            String validAlias = Util.replaceInvalidCharacters(childAlias, "[\\&#\\+\\-!\\*]");
            return ResourceAliasUtil.getRecommendedAlias(COPY_VOLUME_PREFIX + validAlias, allAliases);
        }
        VolumeTreeNode child = (VolumeTreeNode)mirror.getChildren().get(0);
        String validAlias = Util.replaceInvalidCharacters(child.getAlias(), "[\\&#\\+\\-!\\*]");
        return ResourceAliasUtil.getRecommendedAlias(COPY_VOLUME_PREFIX + validAlias, allAliases);
    }

    @Override
    protected String getClosingMessage() {
        if (this.myIsAddMirrorWizard) {
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_MIRROR_WIZ_FRAME_CLOSING_MSG);
        }
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_FRAME_CLOSING_MSG);
    }

    @Override
    protected String getFinishMessage() {
        if (this.myIsAddMirrorWizard) {
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_MIRROR_WIZ_FRAME_FINISH_MSG);
        }
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_FRAME_FINISH_MSG);
    }

    public static class Key
    extends ContextKey {
        public static final Key SOURCE_VOL = new Key(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_SUMMARY_SOURCE_KEY));
        public static final Key TARGET_VOL = new Key(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_SUMMARY_TARGET_KEY));

        private Key() {
        }

        private Key(String displayText) {
            super(displayText);
        }
    }
}

