/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.wizard.clone;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.MirrorVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperationNode;
import com.sanrad.nms.client.data.volume.copy.MirrorSyncOperationNode;
import com.sanrad.nms.client.data.volume.copy.MirrorSyncTableModelCollection;
import com.sanrad.nms.client.data.volume.copy.SrMirrorSyncTableModel;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrTransientWindowPane;
import com.sanrad.nms.client.gui.actions.ActionsPool;
import com.sanrad.nms.client.gui.actions.SrTransientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.dr.wizards.SrDRWizardPanel;
import com.sanrad.nms.client.gui.volume.wizard.clone.SrCloneWizardFrame;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrCheckbox;
import com.sanrad.swing.components.SrMultiLineLabel;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.jwf.Wizard;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.jwf.WizardTransaction;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;

public class SrCloneSummaryWizardPanel
extends SrDRWizardPanel {
    private static final long serialVersionUID = 1L;
    private static final String MIRROR_VOLUME_EXTENSION = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_MIRROR_WIZ_MIRROR_EXTENSION);
    private static final String CLONED_VOLUME_EXTENSION = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_CLONE_EXTENSION);
    private static final String AUTO_SYNC_CHECK_BOX_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_MIRROR_WIZ_AUTO_SYNC_TEXT);
    private SrClientLabel mySiteLabel;
    private SrClientLabel myClusterLabel;
    private SrClientLabel mySrcLabel;
    private SrClientLabel myDstLabel;
    private ClusterNode myClusterNode;
    private SrTextField myMirrorAliasTextFiled;
    private SrCheckbox myMirrorSyncCheckbox;
    private boolean myIsAddMirrorWizard;

    public SrCloneSummaryWizardPanel(ClusterNode aCluster, boolean aIsAddMirrorWizard) {
        this.myClusterNode = aCluster;
        this.myIsAddMirrorWizard = aIsAddMirrorWizard;
        this.initComponents();
        this.addWizardTransaction(new WizardTransaction(){

            @Override
            protected void transaction() {
                EventDispatcherTask.submit(new Runnable(){

                    @Override
                    public void run() {
                        SrCloneSummaryWizardPanel.this.setNextButtonEnabled(false);
                        SrCloneSummaryWizardPanel.this.setBackButtonEnabled(false);
                    }
                });
                this.stop();
            }
        });
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints mainPanelConstraints = new GridBagConstraints();
        int lineInMainPanel = -1;
        mainPanelConstraints.fill = 1;
        mainPanelConstraints.anchor = 18;
        SrClientLabel descLabel = this.myIsAddMirrorWizard ? new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_MIRROR_WIZ_SUMMARY_PANEL_TITLE)) : new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_SUMMARY_PANEL_TITLE));
        SrPanel descriptionPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 20, 40);
        constraints.fill = 2;
        descriptionPanel.add((Component)descLabel, constraints);
        mainPanelConstraints.gridx = 0;
        mainPanelConstraints.gridy = ++lineInMainPanel;
        mainPanelConstraints.gridwidth = 2;
        this.add((Component)descriptionPanel, mainPanelConstraints);
        SrPanel detailPanel = new SrPanel(new GridBagLayout());
        detailPanel.setBorder(BorderFactory.createEtchedBorder());
        Color valuesFgColor = new Color(102, 102, 255);
        SrClientLabel siteKey = new SrClientLabel();
        SrClientLabel clusterKey = new SrClientLabel();
        SrClientLabel srcKey = new SrClientLabel();
        SrClientLabel dstKey = new SrClientLabel();
        if (this.myIsAddMirrorWizard) {
            siteKey.setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_MIRROR_WIZ_SUMMARY_SITE_KEY));
            clusterKey.setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_MIRROR_WIZ_SUMMARY_CLUSTER_KEY));
            srcKey.setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_MIRROR_WIZ_SUMMARY_SOURCE_KEY));
            dstKey.setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_MIRROR_WIZ_SUMMARY_TARGET_KEY));
        } else {
            siteKey.setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_SUMMARY_SITE_KEY));
            clusterKey.setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_SUMMARY_CLUSTER_KEY));
            srcKey.setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_SUMMARY_SOURCE_KEY));
            dstKey.setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_SUMMARY_TARGET_KEY));
        }
        this.mySiteLabel = new SrClientLabel();
        this.mySiteLabel.setForeground(valuesFgColor);
        this.myClusterLabel = new SrClientLabel();
        this.myClusterLabel.setForeground(valuesFgColor);
        this.mySrcLabel = new SrClientLabel();
        this.mySrcLabel.setForeground(valuesFgColor);
        this.myDstLabel = new SrClientLabel();
        this.myDstLabel.setForeground(valuesFgColor);
        Insets keyInsets = new Insets(0, 10, 5, 0);
        Insets valInsets = new Insets(0, 0, 5, 0);
        if (this.myIsAddMirrorWizard) {
            mainPanelConstraints.gridwidth = 1;
            mainPanelConstraints.gridx = 0;
            mainPanelConstraints.gridy = ++lineInMainPanel;
            SrClientLabel aliasLabel = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VOLUME_NEW_VOLUME_DIALOG_ALIAS));
            this.add((Component)aliasLabel, mainPanelConstraints);
            mainPanelConstraints.gridx = 1;
            mainPanelConstraints.gridy = lineInMainPanel++;
            this.myMirrorAliasTextFiled = new SrTextField(15);
            this.add((Component)this.myMirrorAliasTextFiled, mainPanelConstraints);
            mainPanelConstraints.gridwidth = 2;
            mainPanelConstraints.gridx = 0;
            mainPanelConstraints.gridy = lineInMainPanel;
            this.myMirrorSyncCheckbox = new SrCheckbox(AUTO_SYNC_CHECK_BOX_TEXT);
            this.myMirrorSyncCheckbox.setSelected(true);
            this.add((Component)this.myMirrorSyncCheckbox, mainPanelConstraints);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int lineInDetailsPanel = -1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = ++lineInDetailsPanel;
        gridBagConstraints.insets = keyInsets;
        detailPanel.add((Component)siteKey, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = lineInDetailsPanel++;
        gridBagConstraints.insets = valInsets;
        detailPanel.add((Component)this.mySiteLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = lineInDetailsPanel;
        gridBagConstraints.insets = keyInsets;
        detailPanel.add((Component)clusterKey, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = lineInDetailsPanel++;
        gridBagConstraints.insets = valInsets;
        detailPanel.add((Component)this.myClusterLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = lineInDetailsPanel;
        gridBagConstraints.insets = keyInsets;
        detailPanel.add((Component)srcKey, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = lineInDetailsPanel++;
        gridBagConstraints.insets = valInsets;
        detailPanel.add((Component)this.mySrcLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = lineInDetailsPanel;
        gridBagConstraints.insets = keyInsets;
        detailPanel.add((Component)dstKey, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = lineInDetailsPanel;
        gridBagConstraints.insets = valInsets;
        detailPanel.add((Component)this.myDstLabel, gridBagConstraints);
        mainPanelConstraints.gridy = ++lineInMainPanel;
        mainPanelConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)detailPanel, mainPanelConstraints);
        String postActionText = this.myIsAddMirrorWizard ? ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_MIRROR_WIZ_SUMMARY_POST_ACTION_TEXT) : ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_SUMMARY_POST_ACTION_TEXT);
        SrMultiLineLabel postActionDescLebel = new SrMultiLineLabel();
        postActionDescLebel.setText(postActionText);
        mainPanelConstraints.gridy = ++lineInMainPanel;
        mainPanelConstraints.insets = new Insets(100, 0, 0, 0);
        this.add((Component)postActionDescLebel, mainPanelConstraints);
    }

    @Override
    public void display() {
        this.setButtonText("FINISH_I18N", Wizard.APPLY);
        this.setButtonVisible("NEXT_I18N", false);
        this.addWizardTransaction(new CloneVolumeTransaction());
        if (this.myClusterNode.getParent().equals(SystemRootNode.getInstance())) {
            if (this.myIsAddMirrorWizard) {
                this.mySiteLabel.setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_ADD_MIRROR_WIZ_SUMMARY_NO_CLUSTER_TEXT));
            } else {
                this.mySiteLabel.setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_SUMMARY_NO_CLUSTER_TEXT));
            }
        } else {
            this.mySiteLabel.setText(this.myClusterNode.getParent().toString());
        }
        this.myClusterLabel.setText(this.myClusterNode.getAlias());
        this.mySrcLabel.setText(this.wizardContext.getAttribute(SrCloneWizardFrame.Key.SOURCE_VOL).toString());
        this.myDstLabel.setText(this.wizardContext.getAttribute(SrCloneWizardFrame.Key.TARGET_VOL).toString());
        if (this.myIsAddMirrorWizard) {
            VolumeTreeNode srcVolume = (VolumeTreeNode)this.wizardContext.getAttribute(SrCloneWizardFrame.Key.SOURCE_VOL);
            MirrorVolumeNode mirror = (MirrorVolumeNode)srcVolume.getAncestorOfType(MirrorVolumeNode.class);
            if (mirror == null) {
                String aliasPrefix = Util.replaceInvalidCharacters(srcVolume.getAlias(), "[\\&#\\+\\-!\\*]");
                this.myMirrorAliasTextFiled.setText(aliasPrefix + MIRROR_VOLUME_EXTENSION);
            } else {
                this.myMirrorAliasTextFiled.setText(mirror.getAlias());
                this.myMirrorAliasTextFiled.setEnabled(false);
            }
        }
    }

    @Override
    public boolean validateNext(List list) {
        return false;
    }

    @Override
    public boolean canFinish() {
        return true;
    }

    @Override
    public boolean validateFinish(List list) {
        return true;
    }

    @Override
    public void back() {
    }

    @Override
    public void removeListeners() {
        ActionsPool.getInstance().releaseActions(this);
    }

    @Override
    public WizardPanel next() {
        return null;
    }

    @Override
    public Action getFinishButtonAction() {
        if (this.myIsAddMirrorWizard) {
            SrTransientAction<Void, Void> action = ActionsPool.getInstance().provide(this);
            SrTransientAction.AbstractProxy<Void, Void> actionProxy = new SrTransientAction.AbstractProxy<Void, Void>(){

                @Override
                public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> aArg) {
                    return Collections.EMPTY_LIST;
                }

                @Override
                public String derivedClientUpdateEnabled() {
                    if (SrCloneSummaryWizardPanel.this.myMirrorAliasTextFiled.getText().trim().isEmpty()) {
                        return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VOLUME_WINDOW_ALIAS_SHOULD_BE_ENTERED);
                    }
                    return null;
                }

                @Override
                public String getName() {
                    return "";
                }
            };
            action.setProxy(actionProxy);
            this.myMirrorAliasTextFiled.getDocument().addDocumentListener(new View.ViewTextListener(action));
            return action;
        }
        return null;
    }

    private SrFuture<Void> cloneVolume() {
        String alias;
        WizardContext context = this.getWizardContext();
        VolumeTreeNode src = (VolumeTreeNode)context.getAttribute(SrCloneWizardFrame.Key.SOURCE_VOL);
        VolumeTreeNode dst = (VolumeTreeNode)context.getAttribute(SrCloneWizardFrame.Key.TARGET_VOL);
        boolean isAutoSync = true;
        if (this.myIsAddMirrorWizard) {
            alias = this.myMirrorAliasTextFiled.getText().trim();
            isAutoSync = this.myMirrorSyncCheckbox.isSelected();
        } else {
            alias = src.getAlias() + CLONED_VOLUME_EXTENSION;
        }
        return ClientAOImpl.getInstance().addMirror((CommKeyClassId)src.getIdentifier(), (CommKeyClassId)dst.getIdentifier(), alias, isAutoSync);
    }

    private class CloneVolumeTransaction
    extends WizardTransaction {
        Runnable triggerTransientWindow = new Runnable(){

            @Override
            public void run() {
                SrMirrorSyncTableModel model = (SrMirrorSyncTableModel)MirrorSyncTableModelCollection.getInstance().getModel(SrCloneSummaryWizardPanel.this.myClusterNode);
                WizardContext context = SrCloneSummaryWizardPanel.this.getWizardContext();
                VolumeTreeNode src = (VolumeTreeNode)context.getAttribute(SrCloneWizardFrame.Key.SOURCE_VOL);
                VolumeTreeNode dst = (VolumeTreeNode)context.getAttribute(SrCloneWizardFrame.Key.TARGET_VOL);
                for (CopyOperationNode copyOperationNode : model.getCopyOperations()) {
                    MirrorSyncOperationNode operation = (MirrorSyncOperationNode)copyOperationNode;
                    if (!operation.getDestination().equals(dst)) continue;
                    SrTransientWindowPane.showMirrorSyncStarted(ClientLoader.getMainFrame(), src.getAlias(), dst.getAlias(), MainFrame.createShowConstantMirrorSyncOperationsAction(Collections.singleton(operation)));
                    break;
                }
            }
        };

        private CloneVolumeTransaction() {
        }

        @Override
        protected void transaction() {
            SrFuture actFuture = SrCloneSummaryWizardPanel.this.cloneVolume();
            this.waitAndBlockActions(actFuture, SrCloneSummaryWizardPanel.this.getOwner());
            EventDispatcherTask.submit(this.triggerTransientWindow);
        }
    }
}

