/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.wizard.clone;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.wizards.SrResourceTableModel;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrSystemObjectComboBox;
import com.sanrad.nms.client.gui.dr.wizards.SrAllocateVolumeWizardPanel;
import com.sanrad.nms.client.gui.dr.wizards.SrSelectResourceWizardPanel;
import com.sanrad.nms.client.gui.volume.wizard.clone.SrCloneSummaryWizardPanel;
import com.sanrad.nms.client.gui.volume.wizard.clone.SrCloneWizardFrame;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.jwf.WizardContext;
import com.sanrad.swing.jwf.WizardPanel;
import com.sanrad.swing.wizard.ContextKey;
import com.sanrad.swing.wizard.SrWizardPanel;
import com.sanrad.util.Util;
import com.sanrad.util.virtualization.ResourceAliasUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

public class SrCloneSelectSrcVolumeWizardPanel
extends SrSelectResourceWizardPanel {
    private static SrLogger theLogger = SrLogger.getLogger();

    public SrCloneSelectSrcVolumeWizardPanel(ClusterNode aCluster) {
        super(aCluster, false);
        this.initMainPanel(aCluster);
    }

    private void initMainPanel(ClusterNode aCluster) {
        this.add((Component)this.createNorthPanel(aCluster), "North");
    }

    private SrPanel createNorthPanel(ClusterNode aCluster) {
        SrPanel retVal = new SrPanel(new FlowLayout(0));
        retVal.add(new SrLabelField(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_SELECT_CLUSTER_TEXT)));
        SrSystemObjectComboBox clustersCombo = new SrSystemObjectComboBox(SystemRootNode.getInstance(), ClusterNode.class, SrSystemObjectComboBox.CLUSTER_PROPERTIES);
        Dimension comboSize = clustersCombo.getPreferredSize();
        comboSize.width = Math.max(150, comboSize.width);
        clustersCombo.setPreferredSize(comboSize);
        clustersCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent aEvent) {
                if (aEvent.getStateChange() == 1) {
                    SrCloneSelectSrcVolumeWizardPanel.this.m_table.getTable().getSelectionModel().clearSelection();
                    if (aEvent.getItem() instanceof ClusterNode) {
                        SrCloneSelectSrcVolumeWizardPanel.this.m_clusterNode = (ClusterNode)aEvent.getItem();
                        SrCloneSelectSrcVolumeWizardPanel.this.m_table.setModel(SrCloneSelectSrcVolumeWizardPanel.this.getResourceTableModel(SrCloneSelectSrcVolumeWizardPanel.this.m_clusterNode, null));
                    } else {
                        SrCloneSelectSrcVolumeWizardPanel.this.m_table.setModel(SrCloneSelectSrcVolumeWizardPanel.this.getResourceTableModel(null, null));
                    }
                }
            }
        });
        clustersCombo.setSelectedItem(aCluster);
        this.m_table.setModel(this.getResourceTableModel(this.m_clusterNode, null));
        retVal.add(clustersCombo);
        return retVal;
    }

    @Override
    protected ContextKey getContextKeyForSelectedResource() {
        return SrCloneWizardFrame.Key.SOURCE_VOL;
    }

    @Override
    protected WizardPanel doNext() {
        VolumeTreeNode srcVolume = (VolumeTreeNode)this.wizardContext.getAttribute(SrCloneWizardFrame.Key.SOURCE_VOL);
        ArrayList<String> allAliases = new ArrayList<String>();
        allAliases.addAll(VolumeManager.getInstance().getAllVolumeAliases(this.m_clusterNode));
        allAliases.addAll(StorageManager.getInstance().getAllAliases(this.m_clusterNode));
        String validAlias = Util.replaceInvalidCharacters(srcVolume.getAlias(), "[\\&#\\+\\-!\\*]");
        String secVolumeAlias = ResourceAliasUtil.getRecommendedAlias("Copy_of_" + validAlias, allAliases);
        SrAllocateVolumeWizardPanel nextPanel = new SrAllocateVolumeWizardPanel(this.m_clusterNode, secVolumeAlias, srcVolume.getAccessibleSpace(), srcVolume.getDriveType(), srcVolume.getRaidLevel(), srcVolume.getBlockSize(), SrCloneWizardFrame.Key.TARGET_VOL, new SrCloneSummaryWizardPanel(this.m_clusterNode, false));
        String desc = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_SELECT_DST_DESC);
        nextPanel.setDescription(desc);
        return nextPanel;
    }

    @Override
    protected SrWizardPanel getCreateVolumePanel() {
        return null;
    }

    @Override
    public SrResourceTableModel getResourceTableModel(ClusterNode cluster, WizardContext context) {
        return new SrCloneSrcResourceTableModel(cluster);
    }

    @Override
    protected String getPanelTitleDesc() {
        return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_SELECT_SRC_TITLE);
    }

    @Override
    public String getDescription() {
        return this.m_description != null ? this.m_description : ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLONE_WIZ_SELECT_SRC_DESC);
    }

    public class SrCloneSrcResourceTableModel
    extends SrResourceTableModel {
        public SrCloneSrcResourceTableModel(ClusterNode cluster) {
            super(cluster);
            this.initModel();
        }

        @Override
        protected boolean generalVolumeCheck(VolumeTreeNode vol) {
            if (vol == null) {
                return false;
            }
            String cloneMsg = vol.canBeCloned();
            if (cloneMsg == null) {
                return true;
            }
            theLogger.trace(SrLogCategories.INFORMATIVE, cloneMsg);
            return false;
        }

        public void setClusterNode(ClusterNode aCluster) {
            this.setCluster(aCluster);
            this.initModel();
        }
    }
}

