/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.snapshot.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.raid.AttachedRaidManager;
import com.sanrad.nms.client.data.raid.AttachedRaidNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.StoragePoolSelector;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.volume.VolumeAdapter;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.ActionsPool;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.SrTransientAction;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.spinner.PercentageSpinnerModel;
import com.sanrad.swing.spinner.SrSpinner;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.SrFuture;
import com.sanrad.util.virtualization.ResourceAliasUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TakeSnapshotDialog
extends SrOKCancelDialog {
    private static final String SNAPSHOT_SIZE_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TAKE_SNAPSHOT_SIZE_LABEL);
    private static final String TOTAL_DISK_SIZE_REQUIRED = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_TAKE_SNAPSHOT_TOTAL_SIZE_REQUIRED);
    private static final int theDefaultThreshold = ClientLoader.CONSTANSTS_BUNDLE.getIntResource(SrConstantsBundleKeys.SNAPSHOT_DEFAULT_THRESHOLD);
    private VolumeTreeNode mySourceVolume;
    private SrSpinner mySnapSizeSpinner;
    private SrLabelField myTotalSizeRequired;
    private VolumeAdapter myVolumeListener = new VolumeAdapter(){

        @Override
        public void volumeParametersChanged(VolumeEvent e) {
        }

        @Override
        public void volumeRemove(VolumeEvent e) {
            if (TakeSnapshotDialog.this.mySourceVolume.equals(e.getVolumeNode())) {
                TakeSnapshotDialog.this.dispose();
            }
        }
    };

    public TakeSnapshotDialog(VolumeTreeNode aSourceVolume) {
        super((JFrame)ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_TAKE_SNAPSHOT_TITLE, aSourceVolume.getAlias()), SystemRootNode.getInstance().getClusterNodeOfSource(aSourceVolume));
        Util.validateInputNotNull(aSourceVolume, "Source Volume");
        this.mySourceVolume = aSourceVolume;
        this.initComponents();
        this.updateTotalSpaceRequiredField();
        this.setOKAction(this.createActionForSnapshotCreate());
        this.pack();
    }

    private void initComponents() {
        GridBagConstraints c = TakeSnapshotDialog.getGridBagConstraintsForSimpleFields();
        SrPanel paramsPanel = new SrPanel(new GridBagLayout());
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        paramsPanel.add((Component)new SrLabelField(SNAPSHOT_SIZE_LABEL_TEXT), c);
        c.gridx = 1;
        c.gridy = 0;
        this.mySnapSizeSpinner = new SrSpinner(new PercentageSpinnerModel(1, 100, 100));
        this.mySnapSizeSpinner.setEditable(true);
        paramsPanel.add((Component)this.mySnapSizeSpinner, c);
        this.mySnapSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TakeSnapshotDialog.this.updateTotalSpaceRequiredField();
            }
        });
        JFormattedTextField spinnerTextField = this.mySnapSizeSpinner.getTextField();
        spinnerTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TakeSnapshotDialog.this.updateTotalSpaceRequiredField();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TakeSnapshotDialog.this.updateTotalSpaceRequiredField();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TakeSnapshotDialog.this.updateTotalSpaceRequiredField();
            }
        });
        c.gridx = 0;
        c.gridy = 1;
        paramsPanel.add((Component)new SrLabelField(TOTAL_DISK_SIZE_REQUIRED), c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        this.myTotalSizeRequired = new SrLabelField();
        paramsPanel.add((Component)this.myTotalSizeRequired, c);
        this.addCenterPanel(paramsPanel);
    }

    private void updateTotalSpaceRequiredField() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String formattedSpace = Util.bytesToLargerUnits(TakeSnapshotDialog.this.getSnapshotSizeFromField());
                TakeSnapshotDialog.this.myTotalSizeRequired.setText(formattedSpace);
            }
        });
    }

    private BigInteger getSnapshotSizeFromField() {
        PercentageSpinnerModel.PercentageValue percentageValue = (PercentageSpinnerModel.PercentageValue)this.mySnapSizeSpinner.getValueFromInput();
        if (percentageValue == null) {
            return BigInteger.ZERO;
        }
        BigInteger sourceSize = this.mySourceVolume.getAccessibleSpace();
        BigInteger percentage = new BigInteger(String.valueOf(percentageValue.getValue()));
        BigInteger snapSize = percentage.multiply(sourceSize).divide(new BigInteger("100"));
        BigInteger retVal = snapSize.add(SnapshotVolumeNode.getSnapshotHeaderSizeInBytes(this.mySourceVolume));
        return retVal;
    }

    private SrClientAction<Void, Void> createActionForSnapshotCreate() {
        final SrTransientAction<Void, Void> action = ActionsPool.getInstance().provide(this);
        SrTransientAction.AbstractProxy<Void, Void> actionProxy = new SrTransientAction.AbstractProxy<Void, Void>(){

            @Override
            public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> aArg) {
                ClientConfigElementData startSnapshotCed = new ClientConfigElementData(ClassID.SNAPSHOT_VOLUME, (CommKeyClassId)TakeSnapshotDialog.this.m_workingCluster.getIdentifier(), ConfigOperation.CHANGE);
                startSnapshotCed.putValue(ClientParameterCode.SNAPSHOT_ACTIVATE, SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE);
                ClientConfigElementData createSnapshotCed = new ClientConfigElementData(ClassID.SNAPSHOT_VOLUME, (CommKeyClassId)TakeSnapshotDialog.this.m_workingCluster.getIdentifier(), ConfigOperation.CREATE);
                createSnapshotCed.putValue(ClientParameterCode.VOLUME_SPACE, TakeSnapshotDialog.this.getSnapshotSizeFromField());
                String aliasPrefix = Util.replaceInvalidCharacters(TakeSnapshotDialog.this.mySourceVolume.getAlias(), "[\\&#\\+\\-!\\*]");
                ArrayList<String> allAliases = new ArrayList<String>();
                allAliases.addAll(VolumeManager.getInstance().getAllVolumeAliases(TakeSnapshotDialog.this.m_workingCluster));
                allAliases.addAll(StorageManager.getInstance().getAllAliases(TakeSnapshotDialog.this.m_workingCluster));
                String snapshotAlias = ResourceAliasUtil.getRecommendedAlias(aliasPrefix + ".snapshot", allAliases);
                createSnapshotCed.putValue(ClientParameterCode.VOLUME_ALIAS, snapshotAlias);
                createSnapshotCed.putValue(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE, TakeSnapshotDialog.this.mySourceVolume.getIdentifier());
                createSnapshotCed.putValue(ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD, theDefaultThreshold);
                List<DirectAccessDeviceNode> disks = TakeSnapshotDialog.this.mySourceVolume.getPhysicalResources();
                PhysicalStorageDriveTypeConstant type = disks.get(0).getDriveType();
                createSnapshotCed.putValue(ClientParameterCode.PHYSICAL_STORAGE_DRIVE_TYPE, type);
                PhysicalStorageRaidLevelConstant raidLevel = disks.get(0).getRaidLevel();
                createSnapshotCed.putValue(ClientParameterCode.PHYSICAL_STORAGE_RAID_LEVEL, raidLevel);
                startSnapshotCed.putNestedElementData(ClientParameterCode.ELEMENT_ID, createSnapshotCed);
                return Collections.singletonList(ClientAOImpl.getInstance().configureElementsTree(startSnapshotCed));
            }

            @Override
            public String derivedClientUpdateEnabled() {
                if (TakeSnapshotDialog.this.mySnapSizeSpinner.getValueFromInput() == null) {
                    return "No snapshot size is selected";
                }
                return TakeSnapshotDialog.this.validateTotalSpaceRequired();
            }

            @Override
            public String getName() {
                return OKCancelDialog.OK;
            }

            @Override
            public void addListeners() {
                TakeSnapshotDialog.this.mySnapSizeSpinner.addChangeListener(new View.ChangeComponentListener(action));
                JFormattedTextField sizeSpinnerTextField = TakeSnapshotDialog.this.mySnapSizeSpinner.getTextField();
                sizeSpinnerTextField.getDocument().addDocumentListener(new View.ViewTextListener(action));
            }
        };
        action.setProxy(actionProxy);
        action.addControllerAsListener(this);
        return action;
    }

    private String validateTotalSpaceRequired() {
        List<DirectAccessDeviceNode> disks = this.mySourceVolume.getPhysicalResources();
        if (disks.isEmpty()) {
            throw new IllegalStateException("No physical resources found for volume " + this.mySourceVolume);
        }
        PhysicalStorageDriveTypeConstant type = disks.get(0).getDriveType();
        PhysicalStorageRaidLevelConstant raidLevel = disks.get(0).getRaidLevel();
        BigInteger maxSize = StoragePoolSelector.getMaxVolumeSpace(this.m_workingCluster, type, raidLevel);
        List<AttachedRaidNode> raids = AttachedRaidManager.getInstance().getAttachedRaids(this.m_workingCluster);
        if (raids.isEmpty()) {
            return "There are no attached RAIDs";
        }
        if (this.getSnapshotSizeFromField().compareTo(maxSize) > 0) {
            return "There is not enough space on disks";
        }
        return null;
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void addListeners() {
        VolumeManager.getInstance().addVolumeListener(this.myVolumeListener);
    }

    @Override
    public void removeListeners() {
        VolumeManager.getInstance().removeVolumeListener(this.myVolumeListener);
        ActionsPool.getInstance().releaseActions(this);
    }
}

