/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.snapshot.dialogs;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.volume.snapshot.dialogs.SnapshotVolumesDialog;
import com.sanrad.util.Util;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;

public class SnapshotsVolumesDialogPool {
    private static SnapshotsVolumesDialogPool instance;
    private Map<SrTreeNode, SnapshotVolumesDialog> myClusterToDialogsMap = new HashMap<SrTreeNode, SnapshotVolumesDialog>();

    private SnapshotsVolumesDialogPool() {
    }

    public static synchronized SnapshotsVolumesDialogPool getInstance() {
        if (instance == null) {
            instance = new SnapshotsVolumesDialogPool();
        }
        return instance;
    }

    public SnapshotVolumesDialog getSnapshotsVolumeDialog(JFrame owner, ClusterNode clusterNode) {
        if (clusterNode != null) {
            SnapshotVolumesDialog dialog = this.myClusterToDialogsMap.get(clusterNode);
            if (dialog == null) {
                dialog = new SnapshotVolumesDialog(owner, clusterNode, null);
                this.myClusterToDialogsMap.put(clusterNode, dialog);
            }
            return dialog;
        }
        return new SnapshotVolumesDialog(owner, null);
    }

    public SnapshotVolumesDialog getSnapshotsVolumeDialog(JFrame owner, ClusterNode clusterNode, VolumeTreeNode node) {
        Util.validateInputNotNull(clusterNode, "Cluster node");
        Util.validateInputNotNull(node, "Volume node");
        SnapshotVolumesDialog dialog = this.myClusterToDialogsMap.get(node);
        if (dialog == null) {
            dialog = new SnapshotVolumesDialog(owner, clusterNode, node);
            this.myClusterToDialogsMap.put(node, dialog);
        }
        return dialog;
    }

    public void remove(SrTreeNode sourceVolume) {
        this.myClusterToDialogsMap.remove(sourceVolume);
    }

    public void clearAllSnapshotVolumes() {
        this.myClusterToDialogsMap.clear();
    }

    public void closeAllDialogs() {
        for (SnapshotVolumesDialog dialog : this.myClusterToDialogsMap.values()) {
            dialog.dispose();
        }
    }

    public static boolean hasInstance() {
        return instance != null;
    }
}

