/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.snapshot.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.snapshot.SrSnapshotsTableModel;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelRefreshDialog;
import com.sanrad.nms.client.gui.SrSystemObjectComboBox;
import com.sanrad.nms.client.gui.volume.snapshot.SrSnapshotsTablePanel;
import com.sanrad.nms.client.gui.volume.snapshot.dialogs.SnapshotsVolumesDialogPool;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrPanel;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.border.EmptyBorder;

public class SnapshotVolumesDialog
extends SrOKCancelRefreshDialog<ClusterNode> {
    private static final String theContextComboLabel = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOTS_DLG_CONTEXT_COMBO_LABEL);
    private static final String theTitle = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOTS_DLG_TITLE);
    protected VolumeTreeNode sourceVolume;
    protected SrSnapshotsTablePanel snapshotsTable;

    public SnapshotVolumesDialog(JFrame owner, ClusterNode clusterNode, VolumeTreeNode volumeSource) {
        super(owner, theTitle, false, clusterNode);
        this.sourceVolume = volumeSource;
        this.init(owner, clusterNode);
        if (volumeSource == null) {
            this.addTopContextBox(theContextComboLabel, ClusterNode.class, SrSystemObjectComboBox.CLUSTER_PROPERTIES, null);
            this.setTopContextBoxSelection(clusterNode);
        }
    }

    public SnapshotVolumesDialog(JFrame owner, ClusterNode clusterNode) {
        this(owner, clusterNode, null);
    }

    @Override
    protected void systemNodeSelected(ClusterNode aSysNode) {
        this.m_workingCluster = aSysNode;
        this.snapshotsTable.setModel(new SrSnapshotsTableModel(this.m_workingCluster, null));
    }

    protected void init(JFrame owner, ClusterNode clusterNode) {
        this.m_workingCluster = clusterNode;
        this.initComponents(owner);
        this.setSizeAndMoveToCenter(650, 400);
        this.startRefreshTimer(REFRESH_DELAY);
    }

    @Override
    protected void setCancelButtonText() {
        this.btnCancel.setText(OKCancelDialog.CLOSE);
    }

    protected void initComponents(JFrame owner) {
        this.snapshotsTable = this.createTable(owner);
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        SrPanel tablePanel = new SrPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        tablePanel.add((Component)this.snapshotsTable, "Center");
        mainPanel.add((Component)tablePanel, "Center");
        this.addCenterPanel(mainPanel);
        this.setComponentBgColor(this.buttonsPanel);
    }

    protected SrSnapshotsTablePanel createTable(JFrame owner) {
        this.snapshotsTable = new SrSnapshotsTablePanel(this.m_workingCluster, this.sourceVolume, this);
        return this.snapshotsTable;
    }

    @Override
    public void doOnCancel() {
    }

    @Override
    public void removeListeners() {
        CopyOperManager.getInstance().removeCopyOperationListener((SrSnapshotsTableModel)this.snapshotsTable.getModel());
        this.snapshotsTable.getModel().removeListeners();
        if (this.sourceVolume != null) {
            SnapshotsVolumesDialogPool.getInstance().remove(this.sourceVolume);
            return;
        }
        SnapshotsVolumesDialogPool.getInstance().remove(this.m_workingCluster);
    }

    private Collection<SrFuture<Void>> refresh() {
        ArrayList<SrFuture<Void>> futures = new ArrayList<SrFuture<Void>>(2);
        if (this.m_workingCluster != null) {
            SrFuture<Void> future2;
            SrFuture<Void> future1 = VolumeManager.getInstance().refreshSnapshotTable(this.m_workingCluster);
            if (future1 != null) {
                futures.add(future1);
            }
            if ((future2 = CopyOperManager.getInstance().refreshOperations(this.m_workingCluster)) != null) {
                futures.add(future2);
            }
        } else {
            futures.add(new CompleteFuture("SnapshotVolumesDialog.refresh"));
        }
        return futures;
    }

    @Override
    protected final Collection<SrFuture<Void>> doOnRefresh() {
        return this.refresh();
    }

    public void setSelectedVolumeNodes(Collection<SnapshotVolumeNode> volumes) {
        this.snapshotsTable.setSelectedVolumeNodes(volumes);
    }
}

