/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.snapshot.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotVolumeValidator;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.volume.dialogs.VolumePropertiesDialog;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrPercentTextField;
import com.sanrad.swing.components.SrTextField;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;

public class SnapshotVolumePropertiesDialog
extends VolumePropertiesDialog {
    private static final String UNKNOWN_VALUE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_UNKNOWN_VALUE);
    private static final String sourceLbl = "Volume source:";
    private SrTextField sourceFld;
    private static final String creationTimeLbl = "Snapshot Volume Creation Time:";
    private SrTextField creationTimeFld;
    private static final String loadLbl = "Snapshot Volume Load:";
    private SrTextField loadFld;
    private static final String threshLbl = "Snapshot Volume Threshold:";
    private SrPercentTextField threshFld;

    public SnapshotVolumePropertiesDialog(Window owner, VolumeNode volumeNode) {
        super(owner, volumeNode);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SnapshotVolumePropertiesDialog.this.volume.setUserObject(null);
            }
        });
        this.pack();
    }

    @Override
    public void dispose() {
        this.volume.setUserObject(null);
        super.dispose();
    }

    @Override
    protected SrPanel createMainPanel() {
        return new SrPanel(new GridLayout(10, 2));
    }

    @Override
    protected void addSpecificVolumeData() {
        SnapshotVolumeNode snapshotVolume = (SnapshotVolumeNode)this.volume;
        VolumeTreeNode<?> source = snapshotVolume.getSourceVolume();
        int load = snapshotVolume.getPercentageLoad();
        int threshold = snapshotVolume.getPercentageThreshold();
        Object creationTime = snapshotVolume.getDateAndTime();
        this.addSourcePanel(source);
        this.addLoadPanel(load);
        this.addThresholdPanel(threshold);
        this.addCreationTimePanel(creationTime);
    }

    private void addLoadPanel(int load) {
        this.loadFld = new SrTextField(15);
        if (load >= 0) {
            this.loadFld.setText(load + " %");
        } else {
            this.loadFld.setText(UNKNOWN_VALUE);
        }
        this.loadFld.setEditable(false);
        this.addLabelAndField(this.myMainPanel, this.myGridConstraints, loadLbl, this.loadFld, this.myNumOfLines++);
    }

    private void addThresholdPanel(int thresh) {
        this.threshFld = new SrPercentTextField();
        if (thresh >= 0) {
            this.threshFld.setValue(Integer.toString(thresh));
        }
        this.addLabelAndField(this.myMainPanel, this.myGridConstraints, threshLbl, this.threshFld, this.myNumOfLines++);
    }

    private void addCreationTimePanel(Object creationTime) {
        this.creationTimeFld = new SrTextField(15);
        this.creationTimeFld.setText(creationTime.toString());
        this.creationTimeFld.setEditable(false);
        this.addLabelAndField(this.myMainPanel, this.myGridConstraints, creationTimeLbl, this.creationTimeFld, this.myNumOfLines++);
    }

    private void addSourcePanel(VolumeTreeNode source) {
        this.sourceFld = new SrTextField(15);
        this.sourceFld.setText(source.toString());
        this.sourceFld.setEditable(false);
        this.addLabelAndField(this.myMainPanel, this.myGridConstraints, sourceLbl, this.sourceFld, this.myNumOfLines++);
    }

    @Override
    protected HashMap getChangedParameters() {
        HashMap params = super.getChangedParameters();
        String threshStr = (String)this.threshFld.getValue();
        SnapshotVolumeValidator snapValidator = new SnapshotVolumeValidator(threshStr);
        if (!snapValidator.isValidForCreation()) {
            this.fail(snapValidator.getErrorMessage());
            return null;
        }
        params.put(ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD, new Integer(threshStr));
        return params;
    }

    @Override
    public void volumeParametersChanged(VolumeEvent e) {
        RemoteObject stub = e.getStub();
        if (stub.equals(this.volume.getStub())) {
            int thresh = ((SnapshotVolumeNode)this.volume).getPercentageThreshold();
            this.threshFld.setValue(Integer.toString(thresh));
            int load = ((SnapshotVolumeNode)this.volume).getPercentageLoad();
            this.loadFld.setText(Integer.toString(load));
            VolumeTreeNode<?> source = ((SnapshotVolumeNode)this.volume).getSourceVolume();
            this.sourceFld.setText(source.toString());
            this.repaint();
        }
    }
}

