/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.snapshot;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.copy.RestoreOperationNode;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotsTableHeader;
import com.sanrad.nms.client.data.volume.snapshot.SrSnapshotsTableModel;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.ExposeInternalVolumeAction;
import com.sanrad.nms.client.gui.actions.RestartOperationAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.VolumeLUView;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteTreeAction;
import com.sanrad.nms.client.gui.actions.delete.UnexposeAction;
import com.sanrad.nms.client.gui.alarm.dialogs.FilteredAlarmsDialog;
import com.sanrad.nms.client.gui.alarm.dialogs.FilteredAlarmsDialogsPool;
import com.sanrad.nms.client.gui.volume.snapshot.SnapshotVolumeTableRenderer;
import com.sanrad.nms.client.gui.volume.snapshot.SrSnapshotsTablePopupMenu;
import com.sanrad.nms.client.gui.volume.snapshot.dialogs.SnapshotVolumePropertiesDialog;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.actions.ViewDecorator;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class SrSnapshotsTablePanel
extends SrTablePanel {
    private static final SrLogger theLogger = SrLogger.getLogger();
    protected MainFrame myOwner;
    public final OperationController myController;
    private VolumeLUView<SnapshotVolumeNode> myLuView;
    public final View<SnapshotVolumeNode> myView = new SrTableView<SnapshotVolumeNode>((JTable)this.getTable()){

        @Override
        public Collection<SnapshotVolumeNode> getValue() {
            return SrSnapshotsTablePanel.this.getSelectedVolumesNodes();
        }
    };
    public final AlarmAction myOpenSpecificAlarmsAction = new AlarmAction<SnapshotVolumeNode>(this.myView, true);
    public final AlarmAction myOpenPropagatedAlarmsAction = new AlarmAction<SnapshotVolumeNode>(this.myView, false);
    public final DeleteAction myDeleteAction;
    public final SrClientAction snapshotVolumeProperties = new SrClientAction<SnapshotVolumeNode, Void>(true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<SnapshotVolumeNode> arg) {
            int i = 0;
            for (SnapshotVolumeNode snapshot : arg) {
                Object uo = snapshot.getUserObject();
                if (uo == null) {
                    SrSnapshotsTablePanel.this.openPropertiesDialog(snapshot, i);
                } else {
                    ((JDialog)uo).requestFocus();
                }
                ++i;
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    private final View<RestoreOperationNode> myRestoreView = new SrTableView<RestoreOperationNode>((JTable)this.getTable()){

        @Override
        public Collection<RestoreOperationNode> getValue() {
            if (SrSnapshotsTablePanel.this.getSelectedVolumesNodes().size() != 1) {
                return Collections.EMPTY_LIST;
            }
            RestoreOperationNode[] operationsToDelete = SrSnapshotsTablePanel.this.getSelectedRestoreOperation();
            if (operationsToDelete == null) {
                return Collections.EMPTY_LIST;
            }
            return new LinkedList<RestoreOperationNode>(Arrays.asList(operationsToDelete));
        }
    };
    public final SrAction abortRestoreOperation = new SrClientAction<RestoreOperationNode, Void>("Abort", true, true, this.myRestoreView, SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<RestoreOperationNode> arg) {
            Collection<RestoreOperationNode> operationsToAbort = this.filterNotAbortedRestoreOperation(arg);
            Vector<RestoreOperationNode> opersToAbort = new Vector<RestoreOperationNode>();
            for (RestoreOperationNode current : operationsToAbort) {
                StringBuffer msg = CopyOperManager.getInstance().getAbortRollbackConfirmMsg((SnapshotVolumeNode)current.getSource());
                int result = JOptionPane.showConfirmDialog(SrSnapshotsTablePanel.this, msg.toString(), "Abort Rollback Confirmation", 2, 3);
                if (result == 2) continue;
                opersToAbort.add(current);
            }
            SrSnapshotsTablePanel.this.getTable().clearSelection();
            return Collections.singleton(CopyOperManager.getInstance().abortOperations(opersToAbort.toArray(new RestoreOperationNode[operationsToAbort.size()])));
        }

        private Collection<RestoreOperationNode> filterNotAbortedRestoreOperation(Collection<RestoreOperationNode> arg) {
            for (RestoreOperationNode snapshotRestoreOperationNode : arg) {
                if (CopyOperManager.getInstance().operationStatusActive(snapshotRestoreOperationNode.getCopyStatus())) continue;
                return Collections.EMPTY_LIST;
            }
            return arg;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            Collection<RestoreOperationNode> arg = this.myView.getValue();
            if (this.filterNotAbortedRestoreOperation(arg).isEmpty()) {
                return "Some of selected restore operations are inactive";
            }
            SnapshotVolumeNode snapshotVolumeNode = (SnapshotVolumeNode)arg.iterator().next().getSource();
            if (!snapshotVolumeNode.isInvolvedInAnotherActiveRestoreOperation()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_SNAPSHOT_IS_NOT_RESTORING);
            }
            return null;
        }
    };
    private final View<RestoreOperationNode> operView = new ViewDecorator<RestoreOperationNode, SnapshotVolumeNode>(this.myView){

        @Override
        public Collection<RestoreOperationNode> getValue() {
            Collection selectedVolumes = this.myView.getValue();
            ArrayList<RestoreOperationNode> restartedOperations = new ArrayList<RestoreOperationNode>();
            for (SnapshotVolumeNode snapshotNode : selectedVolumes) {
                RestoreOperationNode snapshotRestoreOperationNode = snapshotNode.getRestoreOperation();
                if (snapshotRestoreOperationNode == null) continue;
                restartedOperations.add(snapshotRestoreOperationNode);
            }
            return restartedOperations;
        }
    };
    public final SrAction startRestoreAction = new SrClientAction<SnapshotVolumeNode, Void>("Start", true, true, this.myView, SrLicenseTreePath.GENERAL_PATH, true){
        private RestartOperationAction util;
        {
            this.util = new RestartOperationAction<RestoreOperationNode>(SrSnapshotsTablePanel.this.operView){

                @Override
                protected Collection<RestoreOperationNode> confirm(Collection<RestoreOperationNode> arg) {
                    Vector<RestoreOperationNode> opersToRestart = new Vector<RestoreOperationNode>();
                    for (RestoreOperationNode current : arg) {
                        SnapshotVolumeNode snapshotVolume;
                        theLogger.logAndAssert(SrLogCategories.ERROR, current.getSource() instanceof SnapshotVolumeNode, new Object[]{"Volume " + current.getSource() + " is a source of restore copy operation, but is not a snapshot"});
                        StringBuffer msg = CopyOperManager.getInstance().getRollbackConfirmMsg((SnapshotVolumeNode)current.getSource());
                        int result = JOptionPane.showConfirmDialog(SrSnapshotsTablePanel.this, msg.toString(), "Restart rollback operation Confirmation", 2, 3);
                        if (result == 2 || !SrSnapshotsTablePanel.isLegitimateForRestoreOper(snapshotVolume = (SnapshotVolumeNode)current.getSource())) continue;
                        opersToRestart.add(current);
                    }
                    return opersToRestart;
                }

                @Override
                protected String derivedClientUpdateEnabled() {
                    return null;
                }
            };
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<SnapshotVolumeNode> selectedVolumes) {
            ArrayList<SnapshotVolumeNode> forStartedOperations = new ArrayList<SnapshotVolumeNode>();
            for (SnapshotVolumeNode snapshotNode : selectedVolumes) {
                RestoreOperationNode snapshotRestoreOperationNode = snapshotNode.getRestoreOperation();
                if (snapshotRestoreOperationNode != null) continue;
                forStartedOperations.add(snapshotNode);
            }
            Collection<SrFuture<Void>> retVal = this.util.derivedActionPerformed(SrSnapshotsTablePanel.this.operView.getValue());
            if (forStartedOperations.size() > 0) {
                SnapshotVolumeNode[] selectedSnapshotVolumes = new SnapshotVolumeNode[forStartedOperations.size()];
                SrFuture future = SrSnapshotsTablePanel.this.startNewRestoreOperations(forStartedOperations.toArray(selectedSnapshotVolumes));
                retVal.add(future);
            }
            SrSnapshotsTablePanel.this.getTable().clearSelection();
            return retVal;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            SnapshotVolumeNode selectedSnapshotVolume = (SnapshotVolumeNode)this.myView.getValue().iterator().next();
            boolean isInvolvedInActiveRestore = selectedSnapshotVolume.isInvolvedInAnotherActiveRestoreOperation();
            if (!isInvolvedInActiveRestore) {
                StringBuffer reason = new StringBuffer("");
                if (!CopyOperManager.getInstance().isLegitimateForRestoreOper(selectedSnapshotVolume, reason)) {
                    return reason.toString();
                }
            } else {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_SNAPSHOT_IS_ALREADY_RESTORING);
            }
            return null;
        }
    };
    public final DeleteAction myDeleteRestoreOperation;
    public final SrAction myExposeAction = new ExposeInternalVolumeAction<SnapshotVolumeNode>(this.myOwner, this.myView, SrLicenseTreePath.GENERAL_PATH);
    public final SrAction myUnexposeAction;

    public SrSnapshotsTablePanel(ClusterNode aClusterNode, VolumeTreeNode aSourceVolume, OperationController aController) {
        super(new SrSnapshotsTableModel(aClusterNode, aSourceVolume));
        this.myOwner = ClientLoader.getMainFrame();
        this.myController = aController;
        this.setSelectionMode(2);
        this.setRenderer();
        this.myDeleteAction = new DeleteTreeAction<SnapshotVolumeNode>(this.myView, this.myController){

            @Override
            protected String validateTreeDeletion(SnapshotVolumeNode aHeadNode) {
                return null;
            }
        };
        this.myDeleteRestoreOperation = new DeleteAction<RestoreOperationNode>("Clear", this.myRestoreView, this.myController, new DeleteAction.Confirmator(), false){

            @Override
            protected String getContextMismatchTooltip() {
                if (SrSnapshotsTablePanel.this.getSelectedVolumesNodes().size() == 1) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RESTORE_OPR_VALIDAION_THE_OPERATION_CANNOT_BE_DELETED);
                }
                return super.getContextMismatchTooltip();
            }
        };
        this.myLuView = new VolumeLUView<SnapshotVolumeNode>(this.myView);
        this.myUnexposeAction = new UnexposeAction(this.myLuView, this.myController){

            @Override
            protected String getContextMismatchTooltip() {
                String luViewTooltip = SrSnapshotsTablePanel.this.myLuView.getContextMismatchTooltip();
                if (luViewTooltip != null) {
                    return luViewTooltip;
                }
                return super.getContextMismatchTooltip();
            }
        };
        this.myOpenSpecificAlarmsAction.setOwnerComponent(this);
        this.myOpenPropagatedAlarmsAction.setOwnerComponent(this);
        SrSnapshotsTablePopupMenu popup = new SrSnapshotsTablePopupMenu(this);
        this.setTablePopUpMenuObject(popup);
    }

    public void releaseActions() {
        this.myOpenSpecificAlarmsAction.removeProxy();
        this.myOpenPropagatedAlarmsAction.removeProxy();
    }

    private void setRenderer() {
        for (int i = 0; i < this.getTable().getColumnCount(); ++i) {
            this.getTable().getColumnModel().getColumn(i).setCellRenderer(new SnapshotVolumeTableRenderer());
        }
    }

    protected Vector getSelectedVolumesStubs(Vector nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            SnapshotVolumeNode volume = (SnapshotVolumeNode)nodes.get(i);
            Object stub = volume.getStub();
            nodes.remove(volume);
            nodes.add(i, stub);
        }
        return nodes;
    }

    public Vector<SnapshotVolumeNode> getSelectedVolumesNodes() {
        int[] rows = this.getSelectedRows();
        int snapshotVolumeCol = ((SrSnapshotsTableModel)this.getModel()).getColumnIndex(SnapshotsTableHeader.SNAPSHOT.getColumnName());
        Vector<SnapshotVolumeNode> selection = new Vector<SnapshotVolumeNode>(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            selection.addElement((SnapshotVolumeNode)this.getTable().getValueAt(rows[i], snapshotVolumeCol));
        }
        return selection;
    }

    private void openPropertiesDialog(SnapshotVolumeNode node, int location) {
        SnapshotVolumePropertiesDialog prop = null;
        Window owner = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        prop = new SnapshotVolumePropertiesDialog(owner, node);
        prop.setIconImage(ClientImageObject.APP_ICON.getImageIcon().getImage());
        node.setUserObject(prop);
        int x = (int)prop.getLocation().getX();
        int y = (int)prop.getLocation().getY();
        prop.setLocation(x + location * 4, y + location * 4);
        prop.show();
    }

    public void success() {
    }

    public void fail(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Operation failed", 2);
    }

    public void inProccess(String msg) {
    }

    private static boolean isLegitimateForRestoreOper(SnapshotVolumeNode selectedSnapshotVolume) {
        boolean isInvolvedInActiveRestore = selectedSnapshotVolume.isInvolvedInAnotherActiveRestoreOperation();
        if (isInvolvedInActiveRestore) {
            return false;
        }
        StringBuffer reason = new StringBuffer();
        return CopyOperManager.getInstance().isLegitimateForRestoreOper(selectedSnapshotVolume, reason);
    }

    private SrFuture<Void> startNewRestoreOperations(SnapshotVolumeNode[] selectedSnapshotVolumes) {
        ArrayList<CommKeyClassId> allowedSnapshotForRestore = new ArrayList<CommKeyClassId>(selectedSnapshotVolumes.length);
        ClusterNode cluster = null;
        for (int index = 0; index < selectedSnapshotVolumes.length; ++index) {
            SnapshotVolumeNode snapshotNode = selectedSnapshotVolumes[index];
            if (!SrSnapshotsTablePanel.isLegitimateForRestoreOper(snapshotNode)) continue;
            JFrame frame = new JFrame();
            frame.setIconImage(ClientImageObject.APP_ICON.getImageIcon().getImage());
            StringBuffer msg = CopyOperManager.getInstance().getRollbackConfirmMsg(snapshotNode);
            int result = JOptionPane.showConfirmDialog(this, msg.toString(), "Start Rollback Operation Confirmation", 2, 3);
            if (result == 2) continue;
            allowedSnapshotForRestore.add((CommKeyClassId)snapshotNode.getIdentifier());
            cluster = SystemRootNode.getInstance().getClusterNodeOfSource(snapshotNode);
        }
        if (allowedSnapshotForRestore.isEmpty()) {
            return new CompleteFuture<Void>("SrSnapshotsTablePanel.startNewRestoreOperations");
        }
        return ClientAOImpl.getInstance().restoreSnapshots(cluster.getCopyOperManagerID(), allowedSnapshotForRestore);
    }

    private RestoreOperationNode[] getSelectedRestoreOperation() {
        Vector<SnapshotVolumeNode> selectedVolumes = this.getSelectedVolumesNodes();
        if (selectedVolumes != null) {
            ArrayList<RestoreOperationNode> restoreOperations = new ArrayList<RestoreOperationNode>(selectedVolumes.size());
            for (int index = 0; index < selectedVolumes.size(); ++index) {
                SnapshotVolumeNode snapshotNode = selectedVolumes.get(index);
                RestoreOperationNode snapshotRestoreOperationNode = snapshotNode.getRestoreOperation();
                if (snapshotRestoreOperationNode == null) continue;
                restoreOperations.add(snapshotRestoreOperationNode);
            }
            RestoreOperationNode[] array = new RestoreOperationNode[restoreOperations.size()];
            return restoreOperations.toArray(array);
        }
        return null;
    }

    private SnapshotVolumeNode[] getSelectedSnapshotVolumesNotInvolvedInRestoreOperation() {
        Vector<SnapshotVolumeNode> selectedVolumes = this.getSelectedVolumesNodes();
        if (selectedVolumes != null) {
            ArrayList<SnapshotVolumeNode> volumes = new ArrayList<SnapshotVolumeNode>(selectedVolumes.size());
            for (int index = 0; index < selectedVolumes.size(); ++index) {
                SnapshotVolumeNode snapshotNode = selectedVolumes.get(index);
                RestoreOperationNode snapshotRestoreOperationNode = snapshotNode.getRestoreOperation();
                if (snapshotRestoreOperationNode != null) continue;
                volumes.add(snapshotNode);
            }
            SnapshotVolumeNode[] array = new SnapshotVolumeNode[volumes.size()];
            return volumes.toArray(array);
        }
        return null;
    }

    private String[] getSelectedLUsAliases(Vector selectedVolumes) {
        String[] aliases = new String[selectedVolumes.size()];
        for (int index = 0; index < selectedVolumes.size(); ++index) {
            SnapshotVolumeNode currentSnapshotVolume = (SnapshotVolumeNode)selectedVolumes.get(index);
            if (!currentSnapshotVolume.isExposed()) continue;
            LUNode lu = currentSnapshotVolume.getLUNode();
            aliases[index] = lu.getLUN().toString();
        }
        return aliases;
    }

    private Object[] getSelectedLUs(Vector selectedVolumes) {
        ArrayList stubs = new ArrayList(selectedVolumes.size());
        for (int index = 0; index < selectedVolumes.size(); ++index) {
            SnapshotVolumeNode currentSnapshotVolume = (SnapshotVolumeNode)selectedVolumes.get(index);
            if (!currentSnapshotVolume.isExposed()) continue;
            LUNode lu = currentSnapshotVolume.getLUNode();
            stubs.add(lu.getStub());
        }
        Object[] retStubs = new Object[stubs.size()];
        return stubs.toArray(retStubs);
    }

    public void setSelectedVolumeNodes(Collection<SnapshotVolumeNode> volumes) {
        int snapshotVolumeCol = ((SrSnapshotsTableModel)this.getModel()).getColumnIndex(SnapshotsTableHeader.SNAPSHOT.getColumnName());
        HashSet<Integer> rows = new HashSet<Integer>(volumes.size());
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!volumes.contains(this.getTable().getValueAt(row, snapshotVolumeCol))) continue;
            rows.add(row);
        }
        this.setSelectedRows(rows);
    }

    private class OpenSpecificAlarmsAction
    extends SrClientAction<Void, Void> {
        public OpenSpecificAlarmsAction() {
            super(false, false, null, SrLicenseTreePath.GENERAL_PATH);
            this.setName("Specific...");
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            Vector<SnapshotVolumeNode> selectedVolumes = SrSnapshotsTablePanel.this.getSelectedVolumesNodes();
            Vector<SnapshotVolumeNode> toShow = new Vector<SnapshotVolumeNode>();
            for (int i = 0; i < selectedVolumes.size(); ++i) {
                SnapshotVolumeNode snapshotNode = selectedVolumes.get(i);
                if (snapshotNode == null) continue;
                toShow.addElement(snapshotNode);
            }
            FilteredAlarmsDialog dialog = FilteredAlarmsDialogsPool.getInstance().getFilteredDialog((Window)SrSnapshotsTablePanel.this.myOwner, toShow, true);
            dialog.requestFocus();
            dialog.show();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }
}

