/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.snapshot;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotsTableHeader;
import com.sanrad.nms.client.gui.RendererPanel;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.swing.LookAndFill;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class SnapshotVolumeTableRenderer
extends DefaultTableCellRenderer {
    private RendererPanel m_rendererPanel = new RendererPanel();

    public SnapshotVolumeTableRenderer() {
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setText(value.toString());
        if (hasFocus) {
            this.setBorder(noFocusBorder);
        }
        if (isSelected) {
            this.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
            this.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
        } else {
            this.setBackground(LookAndFill.TABLE_BACKGROUND);
            this.setForeground(LookAndFill.TABLE_FOREGROUND);
        }
        if (value instanceof VolumeTreeNode) {
            this.setIcon(((VolumeTreeNode)value).getNodeIcon());
            this.m_rendererPanel.restorePanel(this, (SrTreeNode)value);
            if (isSelected) {
                this.m_rendererPanel.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
            } else {
                this.m_rendererPanel.setBackground(Color.white);
            }
            return this.m_rendererPanel;
        }
        if (column == table.getColumnModel().getColumnIndex(SnapshotsTableHeader.UTILIZATION)) {
            int intValue = (Integer)value;
            if (intValue >= 0) {
                this.setText(intValue + " %");
            } else {
                this.setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_UNKNOWN_VALUE));
            }
        }
        return this;
    }
}

