/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.snapshot;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.raid.AttachedRaidManager;
import com.sanrad.nms.client.data.raid.AttachedRaidNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StoragePoolSelector;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotSchedulerManager;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotSchedulerNode;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotsTableHeader;
import com.sanrad.nms.client.data.volume.snapshot.SrSnapshotsTableModel;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.volume.VolumeAdapter;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.event.volume.snapshot.SnapshotSchedulerEvent;
import com.sanrad.nms.client.event.volume.snapshot.SnapshotSchedulerListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.ActionsPool;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.SrTransientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteTreeAction;
import com.sanrad.nms.client.gui.volume.snapshot.SrSnapshotsTablePanel;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotSchedulerStateConstant;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrUnderlinedLabelField;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrButton;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrFormattedField;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrRadioButtonsPanel;
import com.sanrad.swing.spinner.PercentageSpinnerModel;
import com.sanrad.swing.spinner.SrSpinner;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.SrFuture;
import com.sanrad.util.filter.SrFilterSimpleRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SnapshotSchedulerDialog
extends SrOKCancelDialog {
    private static final String SCHEDULER_PANEL_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_PANEL_TITLE);
    private static final String SNAPSHOTS_PANEL_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_TABLE_PANEL_TITLE);
    private static final String SNAPSHOT_SIZE_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_SIZE_LABEL);
    private static final String TOTAL_DISK_SIZE_REQUIRED = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_TOTAL_SIZE_REQUIRED);
    private static final String NUMBER_OF_SNAPS_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_POOL_SIZE_FORMAT);
    private static final String TAKE_SNAP_INTERVAL_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_INTERVAL_LABEL);
    private static final String START_AT_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_START_AT_LABEL);
    private static final String START_AT_NOW_RADIO_B_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_START_AT_NOW_OPTION);
    private static final String START_AT_TIME_RADIO_B_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_START_AT_TIME_OPTION);
    private static final String STOP = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_STOP_SCHEDULER);
    private static final String START = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_START_SCHEDULER);
    private static final String APPLY = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_CHANGE_SCHEDULER);
    private static final String DELETE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_DELETE_SCHEDULER);
    private static final int MAX_NUM_OF_SNAPSHOTS = VolumeManager.MAX_SNAPSHOTS_PER_VOLUME;
    private static final int DEFAULT_NUM_OF_SCHEDULE_SNAPSHOTS = ClientLoader.CONSTANSTS_BUNDLE.getIntResource(SrConstantsBundleKeys.VOLUME_DEFAULT_NUM_OF_SCHEDULER_SNAPSHOTS);
    private static final ArrayList<ScheduleInterval> theScheduleIntervalValues = new ArrayList();
    private static final SrFilterSimpleRule theSnapshotTableFilter;
    private SrSpinner mySnapSizeSpinner;
    private SrLabelField myTotalSizeRequired;
    private SrComboBox<Integer> mySnapCountCombobox;
    private SrComboBox<ScheduleInterval> mySnapshotIntervalCombobox;
    private SrRadioButtonsPanel myStartAtRadioPanel;
    private SrSpinner myStartAtSpinner;
    private SrUnderlinedLabelField myStartAtFormatLabel = new SrUnderlinedLabelField("HH:MM mm/dd/yy");
    private SrSnapshotsTablePanel mySnapshotsTable;
    private SrClientAction<Void, Void> myStartStopSchedulerAction;
    private VolumeTreeNode mySourceVolume;
    private SnapshotSchedulerNode myScheduler;
    private VolumeAdapter myVolumeListener = new VolumeAdapter(){

        @Override
        public void volumeParametersChanged(VolumeEvent e) {
            VolumeTreeNode volumeNode = e.getVolumeNode();
            if (volumeNode instanceof SnapshotVolumeNode) {
                SnapshotVolumeNode snapshotNode = (SnapshotVolumeNode)volumeNode;
                boolean isMySnapshot = VolumeManager.getInstance().getClusterSnapshotMap().isSnapshotOfSource(SnapshotSchedulerDialog.this.m_workingCluster, SnapshotSchedulerDialog.this.mySourceVolume, snapshotNode);
                if (isMySnapshot) {
                    this.replaceModel();
                }
            }
        }

        @Override
        public void volumeRemove(VolumeEvent e) {
            if (SnapshotSchedulerDialog.this.mySourceVolume.equals(e.getVolumeNode())) {
                SnapshotSchedulerDialog.this.dispose();
            }
        }

        @Override
        public void snapshotVolActiveStateChanged(VolumeEvent event) {
            SnapshotVolumeNode snapshotNode = (SnapshotVolumeNode)event.getVolumeNode();
            boolean isMySnapshot = VolumeManager.getInstance().getClusterSnapshotMap().isSnapshotOfSource(SnapshotSchedulerDialog.this.m_workingCluster, SnapshotSchedulerDialog.this.mySourceVolume, snapshotNode);
            if (isMySnapshot) {
                this.replaceModel();
            }
        }

        private void replaceModel() {
            SnapshotSchedulerDialog.this.mySnapshotsTable.getModel().removeListeners();
            SrSnapshotsTableModel model = new SrSnapshotsTableModel(SnapshotSchedulerDialog.this.m_workingCluster, SnapshotSchedulerDialog.this.mySourceVolume);
            model.addFilter(theSnapshotTableFilter);
            SnapshotSchedulerDialog.this.mySnapshotsTable.setModel(model);
        }
    };
    private SnapshotSchedulerListener mySchedulerListener = new SnapshotSchedulerListener(){

        @Override
        public void snapshotSchedulerChanged(SnapshotSchedulerEvent aEvent) {
            if (this.isRelevantEvent(aEvent)) {
                SnapshotSchedulerDialog.this.myStartStopSchedulerAction.setName(SnapshotSchedulerDialog.this.myScheduler.isRunning() ? STOP : START);
            }
            SnapshotSchedulerDialog.this.updateSchedulerValues();
        }

        @Override
        public void snapshotSchedulerCreated(SnapshotSchedulerEvent aEvent) {
            SnapshotSchedulerNode eventScheduler = aEvent.getSchedulerNode();
            if (SnapshotSchedulerDialog.this.mySourceVolume.equals(eventScheduler.getSourceVolume())) {
                SnapshotSchedulerDialog.this.dispose();
            }
        }

        @Override
        public void snapshotSchedulerRemoved(SnapshotSchedulerEvent aEvent) {
            if (this.isRelevantEvent(aEvent)) {
                SnapshotSchedulerDialog.this.dispose();
            }
        }

        private boolean isRelevantEvent(SnapshotSchedulerEvent aEvent) {
            return SnapshotSchedulerDialog.this.myScheduler != null && SnapshotSchedulerDialog.this.myScheduler.equals(aEvent.getSchedulerNode());
        }
    };

    public SnapshotSchedulerDialog(VolumeTreeNode aSourceVolume) {
        super((JFrame)ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_TITLE, aSourceVolume.getAlias()), SystemRootNode.getInstance().getClusterNodeOfSource(aSourceVolume));
        Util.validateInputNotNull(aSourceVolume, "Source Volume");
        this.mySourceVolume = aSourceVolume;
        this.myScheduler = SnapshotSchedulerManager.getInstance().getSnapshotSchedulerOfSource(this.mySourceVolume);
        if (this.isSchedulerExists()) {
            this.myStartStopSchedulerAction = this.createActionForStopStartScheduler();
            this.setModal(false);
        }
        this.initComponentsAndPack();
        this.updateSchedulerValues();
    }

    private void initComponentsAndPack() {
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        SrPanel schedulerPanel = new SrPanel(new BorderLayout());
        SrPanel schedulerParamsPanel = new SrPanel(new GridBagLayout());
        GridBagConstraints c = SnapshotSchedulerDialog.getGridBagConstraintsForSimpleFields();
        c.gridx = 0;
        c.gridy = 0;
        schedulerParamsPanel.add((Component)new SrLabelField(SNAPSHOT_SIZE_LABEL_TEXT), c);
        c.gridx = 1;
        c.gridy = 0;
        PercentageSpinnerModel spinnerModel = new PercentageSpinnerModel(1, 100, 100);
        this.mySnapSizeSpinner = new SrSpinner(spinnerModel);
        this.mySnapSizeSpinner.setEditable(true);
        schedulerParamsPanel.add((Component)this.mySnapSizeSpinner, c);
        this.mySnapSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SnapshotSchedulerDialog.this.updateTotalSpaceRequiredField();
            }
        });
        JFormattedTextField spinnerTextField = this.mySnapSizeSpinner.getTextField();
        spinnerTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SnapshotSchedulerDialog.this.updateTotalSpaceRequiredField();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SnapshotSchedulerDialog.this.updateTotalSpaceRequiredField();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SnapshotSchedulerDialog.this.updateTotalSpaceRequiredField();
            }
        });
        c.gridx = 0;
        c.gridy = 1;
        schedulerParamsPanel.add((Component)new SrLabelField(TOTAL_DISK_SIZE_REQUIRED), c);
        c.gridx = 1;
        c.gridy = 1;
        this.myTotalSizeRequired = new SrLabelField();
        schedulerParamsPanel.add((Component)this.myTotalSizeRequired, c);
        c.gridx = 0;
        c.gridy = 2;
        schedulerParamsPanel.add((Component)new SrLabelField(TAKE_SNAP_INTERVAL_LABEL_TEXT), c);
        this.mySnapshotIntervalCombobox = new SrComboBox<ScheduleInterval>(theScheduleIntervalValues);
        c.gridx = 1;
        c.gridy = 2;
        schedulerParamsPanel.add(this.mySnapshotIntervalCombobox, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        this.mySnapCountCombobox = new SrComboBox();
        schedulerParamsPanel.add((Component)new SrFormattedField(NUMBER_OF_SNAPS_LABEL_TEXT, this.mySnapCountCombobox), c);
        int maxNumberOfSnapsForCreation = this.getMaxNumberSnapshotForCreation();
        int numberOfExistSnapshots = this.isSchedulerExists() ? this.myScheduler.getSnapCount() : 0;
        int maxNumberOfSnaps = Math.max(maxNumberOfSnapsForCreation, numberOfExistSnapshots);
        for (int i = 1; i <= maxNumberOfSnaps; ++i) {
            Integer item = i;
            this.mySnapCountCombobox.addItem((Integer)item);
        }
        this.mySnapCountCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SnapshotSchedulerDialog.this.updateTotalSpaceRequiredField();
            }
        });
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 4;
        schedulerParamsPanel.add((Component)new SrLabelField(START_AT_LABEL_TEXT), c);
        c.gridx = 1;
        c.gridy = 4;
        this.myStartAtSpinner = new SrSpinner(new SpinnerDateModel());
        this.myStartAtSpinner.setEnabled(false);
        this.myStartAtFormatLabel.setEnabled(false);
        ((JSpinner.DateEditor)this.myStartAtSpinner.getEditor()).getTextField().setEditable(false);
        this.initStartAtRadioPanel();
        SrPanel p = new SrPanel(new GridBagLayout());
        GridBagConstraints pConstr = new GridBagConstraints();
        pConstr.anchor = 18;
        p.add((Component)this.myStartAtRadioPanel, pConstr);
        pConstr.gridx = 1;
        pConstr.insets.top = 20;
        pConstr.insets.left = 5;
        p.add((Component)this.myStartAtSpinner, pConstr);
        pConstr.gridy = 1;
        pConstr.insets.top = 0;
        p.add((Component)this.myStartAtFormatLabel, pConstr);
        schedulerParamsPanel.add((Component)p, c);
        List<SrButton> buttons = this.createSchedulerButtons();
        for (SrButton b : buttons) {
            this.buttonsPanel.add((Component)b, 0);
        }
        this.btnCancel.setText(CLOSE);
        schedulerPanel.add((Component)schedulerParamsPanel, "Center");
        this.buttonsPanel.setBorder(null);
        SrPanel tempButtonPanel = new SrPanel(new BorderLayout());
        tempButtonPanel.setBorder(new EtchedBorder());
        tempButtonPanel.add((Component)this.buttonsPanel, "East");
        schedulerPanel.add((Component)tempButtonPanel, "South");
        mainPanel.add(schedulerPanel);
        this.addCenterPanel(mainPanel);
        this.pack();
        if (this.isSchedulerExists()) {
            this.mySnapshotsTable = new SrSnapshotsTablePanel(this.m_workingCluster, this.mySourceVolume, this);
            this.mySnapshotsTable.getModel().addFilter(theSnapshotTableFilter);
            Dimension preferredTableSize = this.mySnapshotsTable.getTable().getPreferredScrollableViewportSize();
            preferredTableSize.height = schedulerPanel.getHeight();
            this.mySnapshotsTable.getTable().setPreferredScrollableViewportSize(preferredTableSize);
            mainPanel.add(this.mySnapshotsTable);
            schedulerPanel.setBorder(new TitledBorder(new EtchedBorder(), SCHEDULER_PANEL_TITLE));
            this.mySnapshotsTable.setBorder(new TitledBorder(new EtchedBorder(), SNAPSHOTS_PANEL_TITLE));
            this.pack();
        }
    }

    private List<SrButton> createSchedulerButtons() {
        ArrayList<SrButton> buttons = new ArrayList<SrButton>();
        if (this.isSchedulerExists()) {
            buttons.add(new SrButton(this.createActionForChangeScheduler()));
            buttons.add(new SrButton(this.createActionForRemoveScheduler()));
            buttons.add(new SrButton(this.myStartStopSchedulerAction));
        } else {
            buttons.add(new SrButton(this.createActionForSchedulerCreation()));
        }
        return buttons;
    }

    private void updateSchedulerValues() {
        if (this.isSchedulerExists()) {
            ScheduleInterval currInterval;
            long startAtValue = this.myScheduler.getStartAt();
            if (startAtValue > 0L) {
                this.myStartAtSpinner.setValue(new Date(startAtValue));
                this.myStartAtRadioPanel.setValue(START_AT_TIME_RADIO_B_TEXT);
            } else {
                this.myStartAtSpinner.setValue(new Date());
                this.myStartAtRadioPanel.setValue(START_AT_NOW_RADIO_B_TEXT);
            }
            Long periodMinutes = this.myScheduler.getPeriod().longValue();
            int index = theScheduleIntervalValues.size();
            while (index-- > 0 && (currInterval = theScheduleIntervalValues.get(index)).getIntervalMinutes() > periodMinutes) {
            }
            this.mySnapshotIntervalCombobox.setSelectedIndex(index);
            if (this.myScheduler.isRunning()) {
                this.mySnapshotIntervalCombobox.setEnableComponent(false);
                this.myStartAtRadioPanel.setEnableComponent(false);
                this.myStartAtSpinner.setEnabled(false);
                this.myStartAtFormatLabel.setEnabled(false);
            } else {
                this.mySnapshotIntervalCombobox.setEnableComponent(true);
                this.myStartAtRadioPanel.setEnableComponent(true);
                this.myStartAtSpinner.setEnabled(true);
                this.myStartAtFormatLabel.setEnabled(true);
            }
            int snapCount = this.myScheduler.getSnapCount();
            this.mySnapCountCombobox.setSelectedItem(snapCount);
            this.mySnapCountCombobox.setEnableComponent(false);
            PercentageSpinnerModel.PercentageValue percentageValue = new PercentageSpinnerModel.PercentageValue(this.myScheduler.getSnapshotSizePercentage());
            this.mySnapSizeSpinner.setValue(percentageValue);
            this.mySnapSizeSpinner.setEnabled(false);
        } else {
            Integer maxNumberOfSnapshots = (Integer)this.mySnapCountCombobox.getItemAt(this.mySnapCountCombobox.getItemCount() - 1);
            Integer defaultNumberOfSnapshots = Math.min(maxNumberOfSnapshots, DEFAULT_NUM_OF_SCHEDULE_SNAPSHOTS);
            this.mySnapCountCombobox.setSelectedItem(defaultNumberOfSnapshots);
        }
    }

    private void updateTotalSpaceRequiredField() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String formattedSpace = Util.bytesToLargerUnits(SnapshotSchedulerDialog.this.getTotalSpaceRequired());
                SnapshotSchedulerDialog.this.myTotalSizeRequired.setText(formattedSpace);
            }
        });
    }

    private BigInteger getTotalSpaceRequired() {
        Long snapshotBlocks = this.getSnapshotBlocksFromField();
        Long numberOfSanpshots = this.getNumberOfSnapshotsFromField();
        Long totalSizeRequired = snapshotBlocks * numberOfSanpshots * (long)this.mySourceVolume.getBlockSize().intValue();
        return new BigInteger(String.valueOf(totalSizeRequired));
    }

    private String validateTotalSpaceRequired() {
        List<AttachedRaidNode> raids;
        List<DirectAccessDeviceNode> disks = this.mySourceVolume.getPhysicalResources();
        if (disks.isEmpty()) {
            throw new IllegalStateException("No physical resources found for volume " + this.mySourceVolume);
        }
        PhysicalStorageDriveTypeConstant type = disks.get(0).getDriveType();
        PhysicalStorageRaidLevelConstant raidLevel = disks.get(0).getRaidLevel();
        BigInteger maxSize = StoragePoolSelector.getMaxVolumeSpace(this.m_workingCluster, type, raidLevel);
        if (this.isSchedulerExists()) {
            List<SnapshotVolumeNode> schedulerSnaps = this.myScheduler.getSnapshotVolumes();
            for (SnapshotVolumeNode snapshot : schedulerSnaps) {
                maxSize = maxSize.add(snapshot.getAccessibleSpace());
            }
        }
        if ((raids = AttachedRaidManager.getInstance().getAttachedRaids(this.m_workingCluster)).isEmpty()) {
            return "There are no attached RAIDs";
        }
        if (this.getTotalSpaceRequired().compareTo(maxSize) > 0) {
            return "There is not enough space on disks";
        }
        return null;
    }

    private String validateStartAtTime() {
        Date userDate = this.getStartAtFromField();
        if (userDate == null) {
            return "No start-at time is selected";
        }
        if (START_AT_TIME_RADIO_B_TEXT.equals(this.myStartAtRadioPanel.getValue())) {
            boolean isTimeChangeByUser;
            Date vswitchDate = this.getVswitchDate();
            boolean isTimeInThePast = vswitchDate != null && userDate.getTime() < vswitchDate.getTime();
            boolean bl = isTimeChangeByUser = this.isSchedulerExists() && userDate.getTime() != this.myScheduler.getStartAt().longValue();
            if (isTimeInThePast && (isTimeChangeByUser || !this.isSchedulerExists())) {
                return "Start time set to the past";
            }
        }
        return null;
    }

    private Date getVswitchDate() {
        LUNode luNode = this.mySourceVolume.getLUNode();
        if (luNode != null) {
            VSwitchNode vswitch = luNode.getTargetParent().getExposedOnVSwitchNode();
            return vswitch.getDate();
        }
        return null;
    }

    private Date getStartAtFromField() {
        if (START_AT_NOW_RADIO_B_TEXT.equals(this.myStartAtRadioPanel.getValue())) {
            return new Date(0L);
        }
        return (Date)this.myStartAtSpinner.getValueFromInput();
    }

    private Long getSnapshotBlocksFromField() {
        PercentageSpinnerModel.PercentageValue percentageValue = (PercentageSpinnerModel.PercentageValue)this.mySnapSizeSpinner.getValueFromInput();
        if (percentageValue == null) {
            return new Long(0L);
        }
        BigInteger sourceSize = this.mySourceVolume.getAccessibleSpace();
        BigInteger percentage = new BigInteger(String.valueOf(percentageValue.getValue()));
        BigInteger snapSize = percentage.multiply(sourceSize).divide(new BigInteger("100"));
        BigInteger snapshotBlocks = Util.bytesToBlocks(snapSize, this.mySourceVolume.getBlockSize());
        BigInteger withHeader = snapshotBlocks.add(SnapshotVolumeNode.getSnapshotHeaderSizeInBlocks(this.mySourceVolume));
        return withHeader.longValue();
    }

    private Long getPeriodFromField() {
        ScheduleInterval period = this.mySnapshotIntervalCombobox.getValue();
        return period.getIntervalMinutes();
    }

    private Long getNumberOfSnapshotsFromField() {
        Integer numberOfSnaps = this.mySnapCountCombobox.getValue();
        return numberOfSnaps.longValue();
    }

    private boolean isSchedulerExists() {
        return this.myScheduler != null;
    }

    private void initStartAtRadioPanel() {
        this.myStartAtRadioPanel = new SrRadioButtonsPanel(1);
        this.myStartAtRadioPanel.addRadio(new AbstractAction(START_AT_NOW_RADIO_B_TEXT){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotSchedulerDialog.this.myStartAtSpinner.setEnabled(false);
                SnapshotSchedulerDialog.this.myStartAtFormatLabel.setEnabled(false);
                SnapshotSchedulerDialog.this.myStartAtSpinner.setEditable(false);
            }
        }, (Object)START_AT_NOW_RADIO_B_TEXT);
        this.myStartAtRadioPanel.addRadio(new AbstractAction(START_AT_TIME_RADIO_B_TEXT){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotSchedulerDialog.this.myStartAtSpinner.setEnabled(true);
                SnapshotSchedulerDialog.this.myStartAtFormatLabel.setEnabled(true);
                SnapshotSchedulerDialog.this.myStartAtSpinner.setEditable(true);
            }
        }, (Object)START_AT_TIME_RADIO_B_TEXT);
        this.myStartAtRadioPanel.setValue(START_AT_NOW_RADIO_B_TEXT);
    }

    private int getMaxNumberSnapshotForCreation() {
        List<SnapshotVolumeNode> snapshots = VolumeManager.getInstance().getClusterSnapshotMap().getSnapshotsForSource(this.m_workingCluster, this.mySourceVolume);
        Iterator<SnapshotVolumeNode> i = snapshots.iterator();
        while (i.hasNext()) {
            if (!i.next().isScheduled()) continue;
            i.remove();
        }
        return MAX_NUM_OF_SNAPSHOTS - snapshots.size();
    }

    private SrClientAction<Void, Void> createActionForSchedulerCreation() {
        final SrTransientAction<Void, Void> action = ActionsPool.getInstance().provide(this);
        SrTransientAction.AbstractProxy<Void, Void> actionProxy = new SrTransientAction.AbstractProxy<Void, Void>(){

            @Override
            public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> aArgs) {
                ClientConfigElementData startSchedulerCed = new ClientConfigElementData(ClassID.SNAPSHOT_SCHEDULER, (CommKeyClassId)SnapshotSchedulerDialog.this.m_workingCluster.getIdentifier(), ConfigOperation.CHANGE);
                startSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_SCHEDULER_STATE, SnapshotSchedulerStateConstant.RUNNING);
                startSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE, SnapshotSchedulerDialog.this.mySourceVolume.getIdentifier());
                ClientConfigElementData createSchedulerCed = new ClientConfigElementData(ClassID.SNAPSHOT_SCHEDULER, (CommKeyClassId)SnapshotSchedulerDialog.this.m_workingCluster.getIdentifier(), ConfigOperation.CREATE);
                createSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_SCHEDULER_PERIOD, SnapshotSchedulerDialog.this.getPeriodFromField());
                createSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAP_COUNT, SnapshotSchedulerDialog.this.getNumberOfSnapshotsFromField());
                createSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAPSHOT_SIZE, SnapshotSchedulerDialog.this.getSnapshotBlocksFromField());
                createSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_SCHEDULER_START_AT, SnapshotSchedulerDialog.this.getStartAtFromField());
                createSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_SCHEDULER_STATE, SnapshotSchedulerStateConstant.STOPPED);
                createSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE, SnapshotSchedulerDialog.this.mySourceVolume.getIdentifier());
                startSchedulerCed.putNestedElementData(ClientParameterCode.ELEMENT_ID, createSchedulerCed);
                startSchedulerCed.setPreConfigurationElement(createSchedulerCed);
                return Collections.singletonList(ClientAOImpl.getInstance().configureElementsTree(startSchedulerCed));
            }

            @Override
            public String derivedClientUpdateEnabled() {
                if (SnapshotSchedulerDialog.this.isSchedulerExists()) {
                    return "Scheduler already exists";
                }
                if (SnapshotSchedulerDialog.this.mySnapSizeSpinner.getValueFromInput() == null) {
                    return "No snapshot size is selected";
                }
                String errorMsg = SnapshotSchedulerDialog.this.validateStartAtTime();
                if (errorMsg != null) {
                    return errorMsg;
                }
                return SnapshotSchedulerDialog.this.validateTotalSpaceRequired();
            }

            @Override
            public String getName() {
                return OKCancelDialog.OK;
            }

            @Override
            public void addListeners() {
                SnapshotSchedulerDialog.this.addActionListeners(action);
            }
        };
        action.setProxy(actionProxy);
        action.addControllerAsListener(this);
        return action;
    }

    private SrClientAction<Void, Void> createActionForChangeScheduler() {
        final SrTransientAction<Void, Void> action = ActionsPool.getInstance().provide(this);
        SrTransientAction.AbstractProxy<Void, Void> actionProxy = new SrTransientAction.AbstractProxy<Void, Void>(){

            @Override
            public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> aArg) {
                ClientConfigElementData changeSchedulerCed = SnapshotSchedulerDialog.this.getClientCedForChangeOperation();
                return Collections.singletonList(ClientAOImpl.getInstance().configureElementsTree(changeSchedulerCed));
            }

            @Override
            public String derivedClientUpdateEnabled() {
                if (SnapshotSchedulerDialog.this.isSchedulerExists()) {
                    if (SnapshotSchedulerDialog.this.myScheduler.isRunning()) {
                        return "Scheduler is running";
                    }
                    String errorMsg = SnapshotSchedulerDialog.this.validateStartAtTime();
                    if (errorMsg != null) {
                        return errorMsg;
                    }
                    return SnapshotSchedulerDialog.this.validateTotalSpaceRequired();
                }
                return null;
            }

            @Override
            public String getName() {
                return APPLY;
            }

            @Override
            public void addListeners() {
                SnapshotSchedulerDialog.this.addActionListeners(action);
            }
        };
        action.setProxy(actionProxy);
        action.addControllerAsListener(this);
        return action;
    }

    private SrClientAction<SnapshotSchedulerNode, Void> createActionForRemoveScheduler() {
        View.SingleElementView<SnapshotSchedulerNode> view = new View.SingleElementView<SnapshotSchedulerNode>(this.myScheduler);
        DeleteTreeAction<SnapshotSchedulerNode> action = new DeleteTreeAction<SnapshotSchedulerNode>("Remove", null, view, OperationController.ERROR_CONTROLLER, true, true){

            @Override
            protected String validateTreeDeletion(SnapshotSchedulerNode aHeadNode) {
                if (SnapshotSchedulerDialog.this.isSchedulerExists() && SnapshotSchedulerDialog.this.myScheduler.isRunning()) {
                    return "Scheduler is running";
                }
                return null;
            }
        };
        action.setName(DELETE);
        action.addControllerAsListener(this);
        action.setCheckBoxText("Delete all associated snapshots");
        return action;
    }

    private SrClientAction<Void, Void> createActionForStopStartScheduler() {
        SrTransientAction<Void, Void> action = ActionsPool.getInstance().provide(this);
        SrTransientAction.AbstractProxy<Void, Void> actionProxy = new SrTransientAction.AbstractProxy<Void, Void>(){

            @Override
            public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> aArg) {
                ClientConfigElementData startStopSchedulerCed = new ClientConfigElementData((CommKeyClassId)SnapshotSchedulerDialog.this.myScheduler.getIdentifier(), (CommKeyClassId)SnapshotSchedulerDialog.this.m_workingCluster.getIdentifier(), ConfigOperation.CHANGE);
                if (SnapshotSchedulerDialog.this.myScheduler.isRunning()) {
                    startStopSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_SCHEDULER_STATE, SnapshotSchedulerStateConstant.STOPPED);
                } else {
                    ClientConfigElementData changeSchedulerCed = SnapshotSchedulerDialog.this.getClientCedForChangeOperation();
                    startStopSchedulerCed.setPreConfigurationElement(changeSchedulerCed);
                    startStopSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_SCHEDULER_STATE, SnapshotSchedulerStateConstant.RUNNING);
                    startStopSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE, SnapshotSchedulerDialog.this.mySourceVolume.getIdentifier());
                }
                return Collections.singletonList(ClientAOImpl.getInstance().configureElementsTree(startStopSchedulerCed));
            }

            @Override
            public String derivedClientUpdateEnabled() {
                return null;
            }

            @Override
            public String getName() {
                return SnapshotSchedulerDialog.this.myScheduler.isRunning() ? STOP : START;
            }
        };
        action.setProxy(actionProxy);
        action.addControllerAsListener(this);
        return action;
    }

    @Override
    public void success(SrAction action) {
        super.success(action);
        String actionName = (String)action.getValue("Name");
        if (OK.equals(actionName)) {
            this.dispose();
        }
    }

    @Override
    public void doOnCancel() {
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myScheduler = null;
    }

    private ClientConfigElementData getClientCedForChangeOperation() {
        Long newSnapCount;
        Date newStartAt;
        Long newPeriod;
        ClientConfigElementData changeSchedulerCed = new ClientConfigElementData((CommKeyClassId)this.myScheduler.getIdentifier(), (CommKeyClassId)this.m_workingCluster.getIdentifier(), ConfigOperation.CHANGE);
        PercentageSpinnerModel.PercentageValue newPercentageValue = (PercentageSpinnerModel.PercentageValue)this.mySnapSizeSpinner.getValueFromInput();
        if (newPercentageValue.getValue() != this.myScheduler.getSnapshotSizePercentage()) {
            changeSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAPSHOT_SIZE, this.getSnapshotBlocksFromField());
        }
        if (!(newPeriod = this.getPeriodFromField()).equals(this.myScheduler.getPeriod().longValue())) {
            changeSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_SCHEDULER_PERIOD, newPeriod);
        }
        if ((newStartAt = this.getStartAtFromField()).getTime() != this.myScheduler.getStartAt().longValue()) {
            changeSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_SCHEDULER_START_AT, newStartAt);
        }
        if ((newSnapCount = this.getNumberOfSnapshotsFromField()) != (long)this.myScheduler.getSnapCount()) {
            changeSchedulerCed.putValue(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAP_COUNT, this.getNumberOfSnapshotsFromField());
        }
        return changeSchedulerCed;
    }

    private void addActionListeners(SrAction aAction) {
        this.mySnapCountCombobox.addItemListener(new View.ToggleButtonListener(aAction));
        this.mySnapSizeSpinner.addChangeListener(new View.ChangeComponentListener(aAction));
        JFormattedTextField sizeSpinnerTextField = this.mySnapSizeSpinner.getTextField();
        sizeSpinnerTextField.getDocument().addDocumentListener(new View.ViewTextListener(aAction));
        JFormattedTextField dateTextField = this.myStartAtSpinner.getTextField();
        dateTextField.getDocument().addDocumentListener(new View.ViewTextListener(aAction));
    }

    @Override
    public void addListeners() {
        VolumeManager.getInstance().addVolumeListener(this.myVolumeListener);
        SnapshotSchedulerManager.getInstance().addSnapshotSchedulerListener(this.mySchedulerListener);
    }

    @Override
    public void removeListeners() {
        VolumeManager.getInstance().removeVolumeListener(this.myVolumeListener);
        SnapshotSchedulerManager.getInstance().removeSnapshotSchedulerListener(this.mySchedulerListener);
        ActionsPool.getInstance().releaseActions(this);
        if (this.isSchedulerExists()) {
            this.mySnapshotsTable.releaseActions();
        }
    }

    static {
        theScheduleIntervalValues.add(new ScheduleInterval(1L));
        theScheduleIntervalValues.add(new ScheduleInterval(2L));
        theScheduleIntervalValues.add(new ScheduleInterval(3L));
        theScheduleIntervalValues.add(new ScheduleInterval(4L));
        theScheduleIntervalValues.add(new ScheduleInterval(6L));
        theScheduleIntervalValues.add(new ScheduleInterval(8L));
        theScheduleIntervalValues.add(new ScheduleInterval(12L));
        theScheduleIntervalValues.add(new ScheduleInterval(24L));
        theScheduleIntervalValues.add(new ScheduleInterval(48L));
        theScheduleIntervalValues.add(new ScheduleInterval(72L));
        theScheduleIntervalValues.add(new ScheduleInterval(96L));
        theScheduleIntervalValues.add(new ScheduleInterval(120L));
        theScheduleIntervalValues.add(new ScheduleInterval(144L));
        theScheduleIntervalValues.add(new ScheduleInterval(168L));
        theSnapshotTableFilter = new SrFilterSimpleRule<List>(){

            @Override
            public boolean isValid(List aTableRow, Object ... aParams) {
                int snapColIndex = SnapshotsTableHeader.SNAPSHOT.getIndexInModel();
                SnapshotVolumeNode snapshotNode = (SnapshotVolumeNode)aTableRow.get(snapColIndex);
                return snapshotNode.isScheduled();
            }
        };
    }

    private static class ScheduleInterval {
        private static ScheduleInterval ONE_MINUTE = new ScheduleInterval(1L){

            @Override
            long getIntervalMinutes() {
                return 1L;
            }

            @Override
            public String toString() {
                return "1 minute  ";
            }
        };
        private static ScheduleInterval TWO_MINUTES = new ScheduleInterval(1L){

            @Override
            long getIntervalMinutes() {
                return 2L;
            }

            @Override
            public String toString() {
                return "2 minute  ";
            }
        };
        private static ScheduleInterval THREE_MINUTES = new ScheduleInterval(1L){

            @Override
            long getIntervalMinutes() {
                return 3L;
            }

            @Override
            public String toString() {
                return "3 minute  ";
            }
        };
        private static ScheduleInterval FOUR_MINUTES = new ScheduleInterval(1L){

            @Override
            long getIntervalMinutes() {
                return 4L;
            }

            @Override
            public String toString() {
                return "4 minute  ";
            }
        };
        private static ScheduleInterval FIVE_MINUTES = new ScheduleInterval(1L){

            @Override
            long getIntervalMinutes() {
                return 5L;
            }

            @Override
            public String toString() {
                return "5 minute  ";
            }
        };
        private static ScheduleInterval TEN_MINUTES = new ScheduleInterval(1L){

            @Override
            long getIntervalMinutes() {
                return 10L;
            }

            @Override
            public String toString() {
                return "10 minute  ";
            }
        };
        private long myIntervalHours;

        static ScheduleInterval valueOf(long aIntervalSeconds) {
            switch ((int)aIntervalSeconds) {
                case 1: {
                    return ONE_MINUTE;
                }
                case 2: {
                    return TWO_MINUTES;
                }
                case 3: {
                    return THREE_MINUTES;
                }
                case 4: {
                    return FOUR_MINUTES;
                }
                case 5: {
                    return FIVE_MINUTES;
                }
                case 10: {
                    return TEN_MINUTES;
                }
            }
            return new ScheduleInterval(aIntervalSeconds / 60L);
        }

        ScheduleInterval(long aIntervalHours) {
            if (aIntervalHours <= 0L) {
                throw new IllegalArgumentException("Time interval " + aIntervalHours + " is not valid");
            }
            this.myIntervalHours = aIntervalHours;
        }

        long getIntervalMinutes() {
            return this.myIntervalHours * 60L;
        }

        long getIntervalHours() {
            return this.myIntervalHours;
        }

        private long getDays() {
            return this.myIntervalHours / 24L;
        }

        private long getIntervalHoursResidue() {
            return this.myIntervalHours % 24L;
        }

        public String toString() {
            long days = this.getDays();
            long hours = this.getIntervalHoursResidue();
            Object[] args = new Object[]{days, hours, hours == 0L ? Integer.valueOf(0) : (days == 0L ? Integer.valueOf(1) : Integer.valueOf(2))};
            String str = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_INTERVAL_FORMAT, args);
            return str + "  ";
        }

        public boolean equals(Object o) {
            return this.toString().equals(o.toString());
        }
    }
}

