/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.dialogs;

import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.event.volume.VolumeListener;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrScrollPane;
import com.sanrad.swing.SrTextPane;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.StorageSize;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class VolumePropertiesDialog
extends SrOKCancelDialog
implements VolumeListener {
    private static final String theVolumeAliasLbl = "Name:";
    protected SrTextField myVolAliasField;
    private static final String theVolumeTypeLbl = "Type:";
    protected SrTextField myVolTypeField;
    private static final String theVolumeActualCapacityLbl = "Actual Capacity:";
    protected SrTextField myVolActualCapacityField;
    private static final String theVolumePotentialCapacityLbl = "Potential Capacity:";
    protected SrTextField myVolPotetialCapacityField;
    private static final String theVolumeBlockSizeLbl = "Block Size:";
    protected SrTextField myVolBlockSizeField;
    private static final String theVolumeStateLbl = "Volume State:";
    protected SrTextPane myVolStatePane = new SrTextPane();
    protected VolumeNode<?> volume;
    protected int myNumOfLines = 0;
    protected SrPanel myMainPanel;
    protected GridBagConstraints myGridConstraints = VolumePropertiesDialog.getGridBagConstraintsForSimpleFields();
    private SrAction myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            HashMap params = VolumePropertiesDialog.this.getChangedParameters();
            if (params == null || params.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            return Collections.singleton(ClientAOImpl.getInstance().changeElements(Collections.singleton(VolumePropertiesDialog.this.volume.getIdentifier()), params));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };

    public VolumePropertiesDialog(Window owner, VolumeNode vol) {
        super(owner, "Volume Properties", false, SystemRootNode.getInstance().getClusterNodeOfSource(vol));
        this.volume = vol;
        this.myMainPanel = new SrPanel(new GridBagLayout());
        this.initComponents();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VolumePropertiesDialog.this.volume.setUserObject(null);
            }
        });
        this.myVolAliasField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VolumePropertiesDialog.this.volAliasChanged();
            }
        });
        this.setSizeAndMoveToCenter(275, 420);
        this.setOKAction(this.myOKAction);
        this.pack();
    }

    private void initComponents() {
        this.myVolAliasField = new SrTextField(15);
        this.myVolAliasField.setText(this.volume.getAlias());
        this.myVolAliasField.setEditable(true);
        this.addLabelAndField(this.myMainPanel, this.myGridConstraints, theVolumeAliasLbl, this.myVolAliasField, this.myNumOfLines++);
        this.myVolTypeField = new SrTextField(15);
        this.myVolTypeField.setText(this.volume.getVolType());
        this.myVolTypeField.setEditable(false);
        this.addLabelAndField(this.myMainPanel, this.myGridConstraints, theVolumeTypeLbl, this.myVolTypeField, this.myNumOfLines++);
        this.addSpecificVolumeData();
        String actCapacity = StorageSize.getSizeAsString(this.volume.getAccessibleSpace());
        this.myVolActualCapacityField = new SrTextField(15);
        this.myVolActualCapacityField.setText(actCapacity);
        this.myVolActualCapacityField.setEditable(false);
        this.addLabelAndField(this.myMainPanel, this.myGridConstraints, theVolumeActualCapacityLbl, this.myVolActualCapacityField, this.myNumOfLines++);
        String potCapacity = StorageSize.getSizeAsString(this.volume.getPotentialSpace());
        this.myVolPotetialCapacityField = new SrTextField(15);
        this.myVolPotetialCapacityField.setText(potCapacity);
        this.myVolPotetialCapacityField.setEditable(false);
        this.addLabelAndField(this.myMainPanel, this.myGridConstraints, theVolumePotentialCapacityLbl, this.myVolPotetialCapacityField, this.myNumOfLines++);
        String blockSize = this.volume.getBlockSize().toString();
        this.myVolBlockSizeField = new SrTextField(15);
        this.myVolBlockSizeField.setText(blockSize);
        this.myVolBlockSizeField.setEditable(false);
        this.addLabelAndField(this.myMainPanel, this.myGridConstraints, theVolumeBlockSizeLbl, this.myVolBlockSizeField, this.myNumOfLines++);
        SrScrollPane stateScroll = new SrScrollPane(this.myVolStatePane);
        this.setStateLabel();
        this.myVolStatePane.setEditable(false);
        stateScroll.setMaximumSize(new Dimension(15, 3));
        this.addLabelAndField(this.myMainPanel, this.myGridConstraints, theVolumeStateLbl, this.myVolStatePane, this.myNumOfLines++);
        this.addCenterPanel(this.myMainPanel);
    }

    protected SrPanel createMainPanel() {
        return new SrPanel(new GridLayout(7, 2));
    }

    protected void addSpecificVolumeData() {
    }

    @Override
    public void addListeners() {
        VolumeManager.getInstance().addVolumeListener(this);
    }

    @Override
    public void removeListeners() {
        VolumeManager.getInstance().removeVolumeListener(this);
    }

    @Override
    public void doOnCancel() {
        this.volume.setUserObject(null);
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
        this.dispose();
    }

    protected HashMap getChangedParameters() {
        String newAlias = this.myVolAliasField.getText();
        HashMap<ClientParameterCode, String> params = new HashMap<ClientParameterCode, String>();
        if (!newAlias.equals(this.volume.getAlias())) {
            params.put(ClientParameterCode.VOLUME_ALIAS, newAlias);
        }
        return params;
    }

    @Override
    public void volumeExposed(VolumeEvent e) {
        this.setStateLabel();
    }

    @Override
    public void volumeDeExposed(VolumeEvent e) {
        this.setStateLabel();
    }

    @Override
    public void volumeCreate(VolumeEvent e) {
    }

    @Override
    public void volumeRemove(VolumeEvent e) {
        if (e.getSource().equals(this.volume)) {
            // empty if block
        }
    }

    @Override
    public void volumeAliasChanged(VolumeEvent e) {
        this.myVolAliasField.setText(this.volume.getAlias());
    }

    @Override
    public void volumeStatusChanged(VolumeEvent e) {
        this.setStateLabel();
    }

    @Override
    public void volumeParametersChanged(VolumeEvent e) {
    }

    @Override
    public void snapshotSourceChanged(VolumeEvent e) {
    }

    @Override
    public void volumeStateChanged(VolumeEvent e) {
        this.setStateLabel();
    }

    @Override
    public void volumeConfigChanged(VolumeEvent e) {
    }

    private void setStateLabel() {
        String state = this.volume.getVolStateStr();
        this.myVolStatePane.setText(state);
    }

    private void volAliasChanged() {
        if (this.myVolAliasField.getText().indexOf("\n") > 0) {
            this.myOKAction.actionPerformed(null);
        }
    }

    @Override
    public void volumeCapacityChanged(VolumeEvent e) {
        SrTreeNode vol = SystemRootNode.getInstance().getRefByStub(e.getStub());
        if (vol != null && vol.equals(this.volume)) {
            String actCapacity = StorageSize.getSizeAsString(this.volume.getAccessibleSpace());
            this.myVolActualCapacityField.setText(actCapacity);
            String potCapacity = StorageSize.getSizeAsString(this.volume.getPotentialSpace());
            this.myVolPotetialCapacityField.setText(potCapacity);
        }
    }

    @Override
    public void addVolumeNodeToParent(VolumeEvent event, VolumeTreeNode parentNode, VolumeTreeNode childNode) {
    }

    @Override
    public void removeVolumeNodeFromParent(VolumeEvent event, VolumeTreeNode childNode) {
    }

    @Override
    public void snapshotVolActiveStateChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolActivateOnVSwitchChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolActivityStateChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolDateAndTimeChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageThresholdChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageUtilizationChanged(VolumeEvent event) {
    }
}

