/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.volume.dialogs.NewVolumeDialog;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.util.StorageSize;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.FlowLayout;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JFrame;

public class NewStripeVolumeDialog
extends NewVolumeDialog {
    private SrIntegerTextField sizeFld;
    private SrClientLabel sizeLbl;
    private SrComboBox<StorageSize> unitCombo;
    private final StorageSize[] UNITS = new StorageSize[]{StorageSize.KILO, StorageSize.MEGA, StorageSize.GIGA};

    public NewStripeVolumeDialog(JFrame owner, Vector<VolumeTreeNode> children, ClusterNode workingCluster) {
        super(owner, "New Stripe Volume", children, workingCluster);
        this.initComponents();
        this.sizeLbl.setPreferredSize(this.aliasLbl.getPreferredSize());
        this.setSizeAndMoveToCenter(280, 150);
        MyOKAction myOKAction = new MyOKAction();
        this.sizeFld.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.unitCombo.addItemListener(new View.ToggleButtonListener(myOKAction));
        this.setOKAction(myOKAction);
        this.show();
    }

    private void initComponents() {
        this.sizeLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VOLUME_NEW_STRIPE_VOLUME_DIALOG_SIZE));
        this.sizeFld = new SrIntegerTextField();
        this.unitCombo = new SrComboBox<StorageSize>((T[])this.UNITS);
        SrPanel sizePanel = new SrPanel();
        sizePanel.setLayout(new FlowLayout(0));
        sizePanel.add(this.sizeLbl);
        sizePanel.add(this.sizeFld);
        sizePanel.add(this.unitCombo);
        this.mainPanel.add(sizePanel);
    }

    @Override
    public void doOnCancel() {
    }

    public BigInteger getVolumeSize() {
        String sizeStr = this.sizeFld.getText();
        if (sizeStr == null || sizeStr.equals("")) {
            return null;
        }
        BigInteger retVal = new BigInteger(this.sizeFld.getText());
        StorageSize unit = (StorageSize)this.unitCombo.getSelectedItem();
        BigInteger bunit = unit.getValue();
        return retVal.multiply(bunit);
    }

    private boolean compareVolumesSizeToStripeSize(Vector<VolumeTreeNode> children, BigInteger volSize) {
        int size = children.size();
        if (volSize == null) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            VolumeTreeNode node = children.get(i);
            if (!(node instanceof DirectAccessDeviceNode ? ((DirectAccessDeviceNode)node).getTotalSpace().compareTo(volSize) <= 0 : node.getAccessibleSpace().compareTo(volSize) <= 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void removeListeners() {
    }

    private class MyOKAction
    extends SrClientAction<Void, Void> {
        public MyOKAction() {
            super(SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            return Collections.singleton(VolumeManager.getInstance().createStripeVolume(NewStripeVolumeDialog.this.aliasFld.getText(), NewStripeVolumeDialog.this.children, NewStripeVolumeDialog.this.getVolumeSize()));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            BigInteger stripeSize = NewStripeVolumeDialog.this.getVolumeSize();
            if (stripeSize == null) {
                return "Stripe size field is mandatory.";
            }
            if (!NewStripeVolumeDialog.this.compareVolumesSizeToStripeSize(NewStripeVolumeDialog.this.children, stripeSize)) {
                return "This Stripe size is too high, please insert a lower value. ";
            }
            return null;
        }
    }
}

