/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.dialogs;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotVolumeValidator;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.volume.dialogs.NewVolumeDialog;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JFrame;

public class NewSnapshotVolumeDialog
extends NewVolumeDialog {
    private VolumeTreeNode sourceVolume;
    private SrClientLabel thresholdLbl;
    private SrIntegerTextField thresholdFld;

    public NewSnapshotVolumeDialog(JFrame owner, VolumeTreeNode sourceNode, Vector<VolumeTreeNode> children, ClusterNode workingCluster) {
        super(owner, "New Snapshot Volume", children, workingCluster);
        this.sourceVolume = sourceNode;
        this.initComponents();
        this.aliasLbl.setPreferredSize(this.thresholdLbl.getPreferredSize());
        this.setDefaultSnapshotAlias();
        this.setSizeAndMoveToCenter(280, 150);
        MyOKAction myOKAction = new MyOKAction();
        this.thresholdFld.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.setOKAction(myOKAction);
        this.show();
    }

    private void setDefaultSnapshotAlias() {
        this.aliasFld.setText(VolumeManager.getInstance().getDefaultSnapshotAlias(this.sourceVolume));
    }

    private void initComponents() {
        this.thresholdLbl = new SrClientLabel("Load Threshold: ");
        this.thresholdFld = new SrIntegerTextField(3);
        this.thresholdFld.setText(Integer.toString(VolumeManager.SNAPSHOT_DEFAULT_THRESHOLD_VALUE));
        SrPanel thresholdPanel = this.createSrPanel(this.thresholdLbl, this.thresholdFld);
        SrClientLabel percentLbl = new SrClientLabel("[%]");
        SrPanel panel = this.createSrPanel(thresholdPanel, percentLbl);
        this.mainPanel.add(panel);
    }

    @Override
    public void removeListeners() {
    }

    private class MyOKAction
    extends SrClientAction<Void, Void> {
        public MyOKAction() {
            super(SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String volAlias = NewSnapshotVolumeDialog.this.aliasFld.getText();
            String threshold = NewSnapshotVolumeDialog.this.thresholdFld.getText();
            SnapshotVolumeValidator validator = new SnapshotVolumeValidator(threshold);
            return Collections.singleton(VolumeManager.getInstance().createSnapshotVolume(volAlias, NewSnapshotVolumeDialog.this.sourceVolume, NewSnapshotVolumeDialog.this.children, validator.getThresholdValue()));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            String threshold = NewSnapshotVolumeDialog.this.thresholdFld.getText();
            SnapshotVolumeValidator validator = new SnapshotVolumeValidator(threshold);
            if (!validator.isValidForCreation()) {
                return validator.getErrorMessage();
            }
            return null;
        }
    }
}

