/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.volume.dialogs.VolumePropertiesDialog;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrPercentTextField;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.util.SrConstantsBundleKeys;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JFrame;

public class JournalVolumePropertiesDialog
extends VolumePropertiesDialog {
    private JournalVolumeNode m_journal;
    private SrPercentTextField m_thresholdVal;
    private String m_threshold;
    private String m_vswitch;
    private SrComboBox m_activeOnVswitcheCombo;
    private static final String theThresholdLbl = "Threshold:";
    private static final String thePersentageUtilLbl = "Percentage Utilization:";
    private static final String theActiveOnVSwitchLbl = "Active On " + ClientLoader.VSWITCH_DISPLAY_STRING + ":";
    private static final String theCurrentActivityLbl = "Current Activity:";
    private static final String theJournalOperStatusLabel = "Operational Status:";
    private static final String theJournalErrorStatusLabel = "Error Status:";
    private SrPercentTextField m_persentageUtilVal;
    private SrTextField m_currentActivityValue;
    private SrTextField myJournalOperStatusField;
    private SrTextField myJournalErrorStatusField;

    public JournalVolumePropertiesDialog(JFrame owner, JournalVolumeNode vol) {
        super((Window)owner, vol);
        this.m_journal = vol;
        this.initNewProperties();
        this.pack();
    }

    private void initNewProperties() {
        GridBagConstraints c = JournalVolumePropertiesDialog.getGridBagConstraintsForSimpleFields();
        this.m_threshold = String.valueOf(this.m_journal.getPercentageThreshold());
        this.m_thresholdVal = new SrPercentTextField();
        this.m_thresholdVal.setValue(this.m_threshold);
        this.m_thresholdVal.setEnableComponent(true);
        int maxTreshold = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.JOURNAL_MAX_THRESHOLD));
        this.m_thresholdVal.setMaxValue(maxTreshold);
        this.addLabelAndField(this.myMainPanel, c, theThresholdLbl, this.m_thresholdVal, this.myNumOfLines++);
        String persentageUtil = String.valueOf(this.m_journal.getPercentageUtilization());
        this.m_persentageUtilVal = new SrPercentTextField();
        this.m_persentageUtilVal.setValue(persentageUtil);
        this.m_persentageUtilVal.setEnableComponent(false);
        this.addLabelAndField(this.myMainPanel, c, thePersentageUtilLbl, this.m_persentageUtilVal, this.myNumOfLines++);
        this.m_vswitch = this.m_journal.getActivateOnVSwitch();
        Vector<VSwitchNode> vs = VSwitchManager.getInstance().getAvailableVSwitches(SystemRootNode.getInstance().getClusterNodeOfSource(this.m_journal));
        Object[] comboItems = new Object[vs.size()];
        for (int i = 0; i < comboItems.length; ++i) {
            VSwitchNode vswitch = vs.get(i);
            comboItems[i] = vswitch.getName();
        }
        this.m_activeOnVswitcheCombo = new SrComboBox<Object>((T[])comboItems);
        this.m_activeOnVswitcheCombo.setSelectedItem(this.m_vswitch);
        this.m_activeOnVswitcheCombo.setEditable(false);
        this.m_activeOnVswitcheCombo.setEnabled(false);
        this.addLabelAndField(this.myMainPanel, c, theActiveOnVSwitchLbl, this.m_activeOnVswitcheCombo, this.myNumOfLines++);
        this.m_currentActivityValue = new SrTextField(this.m_journal.getActivityState().toString());
        this.m_currentActivityValue.setEnableComponent(false);
        this.addLabelAndField(this.myMainPanel, c, theCurrentActivityLbl, this.m_currentActivityValue, this.myNumOfLines++);
        this.myJournalOperStatusField = new SrTextField(this.m_journal.getOperationalStatus().toString());
        this.myJournalOperStatusField.setEnableComponent(false);
        this.addLabelAndField(this.myMainPanel, c, theJournalOperStatusLabel, this.myJournalOperStatusField, this.myNumOfLines++);
        this.myJournalErrorStatusField = new SrTextField(this.m_journal.getErrorStatus().toString());
        this.myJournalErrorStatusField.setEnableComponent(false);
        this.addLabelAndField(this.myMainPanel, c, theJournalErrorStatusLabel, this.myJournalErrorStatusField, this.myNumOfLines++);
    }

    @Override
    protected HashMap getChangedParameters() {
        HashMap params = super.getChangedParameters();
        String currentThreshold = (String)this.m_thresholdVal.getValue();
        String selectedVSwitch = (String)this.m_activeOnVswitcheCombo.getValue();
        if (currentThreshold != null && currentThreshold.length() > 0 && !currentThreshold.equals(this.m_threshold)) {
            Integer threshold = new Integer(Integer.parseInt(currentThreshold));
            params.put(ClientParameterCode.JOURNAL_VOLUME_PRECENT_THRESH, threshold);
        } else if (currentThreshold.length() == 0) {
            this.fail(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.DR_JOURNAL_VALIDAION_THRESHOLD_EMPTY));
            return null;
        }
        if (selectedVSwitch != null && !selectedVSwitch.equals(this.m_vswitch)) {
            Vector<VSwitchNode> vs = VSwitchManager.getInstance().getAvailableVSwitches(SystemRootNode.getInstance().getClusterNodeOfSource(this.m_journal));
            Object[] comboItems = new Object[vs.size()];
            for (int i = 0; i < comboItems.length; ++i) {
                VSwitchNode vswitch = vs.get(i);
                if (!vswitch.getName().equals(selectedVSwitch)) continue;
                params.put(ClientParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID, vswitch.getIdentifier());
                break;
            }
        }
        return params;
    }

    @Override
    public void journalVolActivateOnVSwitchChanged(VolumeEvent event) {
        JournalVolumeNode journal = (JournalVolumeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        if (this.m_journal == journal) {
            this.m_activeOnVswitcheCombo.setSelectedItem(journal.getActivateOnVSwitch());
        }
    }

    @Override
    public void journalVolActivityStateChanged(VolumeEvent event) {
        JournalVolumeNode journal = (JournalVolumeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        if (this.m_journal == journal) {
            this.m_currentActivityValue.setText(journal.getActivityState().toString());
        }
    }

    @Override
    public void journalVolDateAndTimeChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageThresholdChanged(VolumeEvent event) {
        JournalVolumeNode journal = (JournalVolumeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        if (this.m_journal == journal) {
            this.m_thresholdVal.setValue(String.valueOf(journal.getPercentageThreshold()));
        }
    }

    @Override
    public void journalVolPercentageUtilizationChanged(VolumeEvent event) {
        JournalVolumeNode journal = (JournalVolumeNode)SystemRootNode.getInstance().getRefByStub(event.getStub());
        if (this.m_journal == journal) {
            this.m_persentageUtilVal.setValue(String.valueOf(journal.getPercentageUtilization()));
        }
    }

    @Override
    public void volumeConfigChanged(VolumeEvent e) {
        super.volumeConfigChanged(e);
        this.myJournalOperStatusField.setText(this.m_journal.getOperationalStatus().toString());
        this.myJournalErrorStatusField.setText(this.m_journal.getErrorStatus().toString());
    }
}

