/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.copy.dialogs;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.copy.CopyOperationNode;
import com.sanrad.nms.client.event.volume.copy.CopyOperationTableEvent;
import com.sanrad.nms.client.event.volume.copy.CopyOperationTableListener;
import com.sanrad.nms.client.event.volume.copy.SrCopyOperationTableModel;
import com.sanrad.nms.client.gui.SrOKCancelRefreshDialog;
import com.sanrad.nms.client.gui.SrSystemObjectComboBox;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.volume.copy.SrCopyOperationTablePanel;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrTableModel;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.border.EmptyBorder;

public abstract class CopyOperationDialog
extends SrOKCancelRefreshDialog<ClusterNode>
implements CopyOperationTableListener {
    protected SrCopyOperationTablePanel myTable;
    protected JButton btnAbort = new JButton();

    protected CopyOperationDialog(JFrame owner, String title, ClusterNode cluster) {
        super(owner, title, false, cluster);
        this.m_workingCluster = cluster;
        this.initComponents();
        this.addTopContextBox(this.getContextBoxTitle(), ClusterNode.class, SrSystemObjectComboBox.CLUSTER_PROPERTIES, null);
        this.setTopContextBoxSelection(cluster);
        this.setSizeAndMoveToCenter(600, 500);
    }

    protected abstract String getContextBoxTitle();

    @Override
    protected void systemNodeSelected(ClusterNode aSysNode) {
        this.setCluster(aSysNode);
    }

    protected void setCluster(ClusterNode aCluster) {
        if (!Util.equalsWithNull(this.m_workingCluster, aCluster)) {
            this.m_workingCluster = aCluster;
            this.setTopContextBoxSelection(this.m_workingCluster);
            this.setClusterTitle();
            this.myTable.setModel(this.getModel());
        }
    }

    protected abstract SrTableModel getModel();

    @Override
    protected void setCancelButtonText() {
        this.btnCancel.setText("Close");
    }

    private void initComponents() {
        this.btnAbort.setPreferredSize(this.btnCancel.getPreferredSize());
        this.buttonsPanel.add((Component)this.btnAbort, 2);
        this.setLocation(300, 100);
        SrCopyOperationTableModel model = (SrCopyOperationTableModel)this.getModel();
        this.btnAbort.setEnabled(false);
        this.myTable = new SrCopyOperationTablePanel(this, model);
        this.myTable.addCopyTableListener(this);
        this.btnAbort.setAction(this.myTable.abortCopyOperationAction);
        SrPanel mainPanel = new SrPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.myTable, "Center");
        mainPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.addCenterPanel(mainPanel);
        this.setComponentBgColor(this.buttonsPanel);
        SrClientAction.blockActions(this.refresh(), this);
    }

    public ClusterNode getCluster() {
        return this.m_workingCluster;
    }

    @Override
    public void doOnCancel() {
        this.dispose();
    }

    @Override
    protected final Collection<? extends SrFuture<Void>> doOnRefresh() {
        return this.refresh();
    }

    protected Collection<? extends SrFuture<Void>> refresh() {
        if (this.m_workingCluster != null) {
            return Collections.singleton(CopyOperManager.getInstance().refreshOperations(this.m_workingCluster));
        }
        return Collections.singleton(new CompleteFuture("CopyOperationDialog.refresh"));
    }

    protected void startRefreshTimer() {
        this.startRefreshTimer(REFRESH_DELAY);
    }

    @Override
    public void show() {
        this.startRefreshTimer();
        super.show();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.startRefreshTimer();
        }
        super.setVisible(visible);
    }

    public void setAbortEnable(boolean enable) {
        this.btnAbort.setEnabled(enable);
    }

    @Override
    public void enableAbortBtn(CopyOperationTableEvent event) {
        this.setAbortEnable(event.getEnable());
    }

    public void setSelectedOperations(Collection<? extends CopyOperationNode> newSelection) {
        this.myTable.setSelectedOperations(newSelection);
    }
}

