/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.copy;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.volume.copy.CopyOperationNode;
import com.sanrad.nms.client.event.volume.copy.CopyOperationTableEvent;
import com.sanrad.nms.client.event.volume.copy.CopyOperationTableListener;
import com.sanrad.nms.client.event.volume.copy.SrCopyOperationTableModel;
import com.sanrad.nms.client.gui.SrClientTablePanel;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.actions.RestartOperationAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.volume.copy.CopyOperationTableHeader;
import com.sanrad.nms.client.gui.volume.copy.CopyOperationTableRenderer;
import com.sanrad.nms.client.gui.volume.copy.SrCopyOperationTablePopupMenu;
import com.sanrad.nms.client.gui.volume.copy.dialogs.CopyOperationDialog;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.actions.View;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JTable;

public class SrCopyOperationTablePanel
extends SrClientTablePanel {
    private OperationController clearSelectionController = new OperationController(){

        @Override
        public void fail(String message) {
        }

        @Override
        public void inProcess(String message) {
        }

        @Override
        public void success(SrAction action) {
            SrCopyOperationTablePanel.this.getTable().clearSelection();
        }
    };
    SrEventListenerManager.Informer<CopyOperationTableListener, CopyOperationTableEvent> enableAbortBtnInformer = new SrEventListenerManager.Informer<CopyOperationTableListener, CopyOperationTableEvent>(){

        @Override
        public void inform(CopyOperationTableListener listener, CopyOperationTableEvent event) {
            listener.enableAbortBtn(event);
        }
    };
    private CopyOperationDialog myDialog;
    private View<CopyOperationNode> myView = new SrTableView<CopyOperationNode>((JTable)this.getTable()){

        @Override
        public Collection<CopyOperationNode> getValue() {
            return Arrays.asList(SrCopyOperationTablePanel.this.getSelectedOperations());
        }
    };
    private static final String ABORT = "Abort";
    public final SrClientAction abortCopyOperationAction = new SrClientAction<CopyOperationNode, Void>("Abort", true, true, this.myView, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<CopyOperationNode> arg) {
            ArrayList<CommKeyClassId> operations = new ArrayList<CommKeyClassId>(arg.size());
            for (CopyOperationNode node : arg) {
                if (node.getCopyStatus().equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK)) continue;
                operations.add((CommKeyClassId)node.getIdentifier());
            }
            return Collections.singleton(ClientAOImpl.getInstance().abortCopyOperations(operations));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            if (!SrCopyOperationTablePanel.this.canBeAborted(SrCopyOperationTablePanel.this.m_table.getSelectedRows())) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_POPUP_CANNOT_ABORT);
            }
            return null;
        }
    };
    public final SrClientAction restartCopyOperationAction = new RestartOperationAction<CopyOperationNode>(this.myView);
    public final DeleteAction myDeleteCopyOperation;

    public SrCopyOperationTablePanel(CopyOperationDialog aDialog, SrCopyOperationTableModel model) {
        super(model);
        this.myDialog = aDialog;
        this.initTableColumnsInvisible();
        this.getTable().setSelectionMode(2);
        this.getTable().setColumnSelectionAllowed(false);
        this.getTable().setCellSelectionEnabled(false);
        this.getTable().setRowSelectionAllowed(true);
        int cols = this.getTable().getColumnCount();
        for (int i = 0; i < cols; ++i) {
            this.getTable().getColumnModel().getColumn(i).setCellRenderer(new CopyOperationTableRenderer());
        }
        this.abortCopyOperationAction.setConfirmationString("Are you sure you want to abort the operation?");
        this.abortCopyOperationAction.setConfirmationTitle("Abort operation");
        this.abortCopyOperationAction.addControllerAsListener(this.myDialog);
        this.abortCopyOperationAction.addControllerAsListener(this.clearSelectionController);
        this.restartCopyOperationAction.addControllerAsListener(this.myDialog);
        this.restartCopyOperationAction.addControllerAsListener(this.clearSelectionController);
        this.myDeleteCopyOperation = new DeleteAction<CopyOperationNode>(this.myView, (OperationController)this.myDialog, new DeleteAction.Confirmator()){

            @Override
            protected String derivedClientUpdateEnabled() {
                if (!SrCopyOperationTablePanel.this.canBeDeleted(SrCopyOperationTablePanel.this.m_table.getSelectedRows())) {
                    return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.COPY_OPR_POPUP_CANNOT_DELETE);
                }
                return super.derivedClientUpdateEnabled();
            }
        };
        this.myDeleteCopyOperation.addControllerAsListener(this.clearSelectionController);
        SrCopyOperationTablePopupMenu popup = new SrCopyOperationTablePopupMenu(this);
        this.setTablePopUpMenuObject(popup);
        this.setMouseListener();
        this.invokeColumnSortOnStartup(1, true);
    }

    protected void initTableColumnsInvisible() {
        this.hideTableColumn(CopyOperationTableHeader.COPY_OPER_NODE.getColumnName());
    }

    @Override
    protected void rowSelectionChanged(int[] rowIndices) {
        boolean canBeAborted = this.canBeAborted(this.getSelectedRows());
        CopyOperationTableEvent event = new CopyOperationTableEvent(this, canBeAborted);
        this.m_listeners.fireEvent(CopyOperationTableListener.class, event, this.enableAbortBtnInformer);
    }

    public void addCopyTableListener(CopyOperationTableListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeCopyTableListener(CopyOperationTableListener listener) {
        this.m_listeners.remove(listener);
    }

    protected void setMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SrCopyOperationTablePanel.this.rowSelectionChanged(new int[]{0});
            }
        });
    }

    public boolean canBeAborted(int[] selectedRows) {
        SrCopyOperationTableModel tableModel = (SrCopyOperationTableModel)this.getModel();
        return tableModel.canBeAborted(selectedRows);
    }

    public boolean canBeRestarted(int[] selectedRows) {
        SrCopyOperationTableModel tableModel = (SrCopyOperationTableModel)this.getModel();
        return tableModel.canBeRestarted(selectedRows);
    }

    public boolean canBeDeleted(int[] selectedRows) {
        SrCopyOperationTableModel tableModel = (SrCopyOperationTableModel)this.getModel();
        return tableModel.canBeDeleted(selectedRows);
    }

    private CopyOperationNode[] getSelectedOperations() {
        int[] copyIndices = this.getSelectedRows();
        CopyOperationNode[] copyOpers = new CopyOperationNode[copyIndices.length];
        int operCol = this.getModel().getColumnIndex(CopyOperationTableHeader.COPY_OPER_NODE.getColumnName());
        for (int i = 0; i < copyIndices.length; ++i) {
            copyOpers[i] = (CopyOperationNode)this.getModel().getValueAt(copyIndices[i], operCol);
        }
        return copyOpers;
    }

    public void setSelectedOperations(Collection<? extends CopyOperationNode> newSelection) {
        int operCol = this.getModel().getColumnIndex(CopyOperationTableHeader.COPY_OPER_NODE.getColumnName());
        HashSet<Integer> rows = new HashSet<Integer>(newSelection.size());
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!newSelection.contains(this.getTable().getValueAt(row, operCol))) continue;
            rows.add(row);
        }
        this.setSelectedRows(rows);
    }

    @Override
    protected Class getTableHeaderClass() {
        return CopyOperationTableHeader.class;
    }
}

