/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume.copy;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperationNode;
import com.sanrad.nms.client.gui.RendererPanel;
import com.sanrad.swing.LookAndFill;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class CopyOperationTableRenderer
extends DefaultTableCellRenderer {
    private RendererPanel m_rendererPanel = new RendererPanel();

    public CopyOperationTableRenderer() {
        this.setFont(LookAndFill.GENERAL_FONT);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
        if (isSelected) {
            this.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
            this.setForeground(LookAndFill.TABLE_SELECTION_FOREGROUND);
        } else {
            this.setBackground(LookAndFill.TABLE_BACKGROUND);
            this.setForeground(LookAndFill.TABLE_FOREGROUND);
        }
        if (value instanceof SrTreeNode) {
            if (value instanceof VolumeTreeNode) {
                this.setText(((VolumeTreeNode)value).getAlias());
            }
            this.setIcon(((SrTreeNode)value).getNodeIcon());
            this.m_rendererPanel.restorePanel(this, (SrTreeNode)value);
            if (isSelected) {
                this.m_rendererPanel.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
            } else {
                this.m_rendererPanel.setBackground(Color.white);
            }
            return this.m_rendererPanel;
        }
        if (value instanceof CopyOperationNode) {
            CopyOperationNode copyNode = (CopyOperationNode)value;
            VolumeTreeNode src = copyNode.getSource();
            this.setIcon(src.getNodeIcon());
            this.m_rendererPanel.restorePanel(this, (SrTreeNode)value);
            if (isSelected) {
                this.m_rendererPanel.setBackground(LookAndFill.TABLE_SELECTION_BACKGROUND);
            } else {
                this.m_rendererPanel.setBackground(Color.white);
            }
            return this.m_rendererPanel;
        }
        return this;
    }
}

