/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.VolumesTableModelCollection;
import com.sanrad.nms.client.gui.volume.VolumesDetailsViewPanel;
import com.sanrad.nms.client.gui.volume.VolumesTableViewPanel;
import com.sanrad.swing.DetailsViewPanel;
import com.sanrad.swing.ElementViewPanel;
import com.sanrad.swing.TableViewPanel;
import java.awt.Component;
import javax.swing.JFrame;

public abstract class VolumesViewPanel
extends ElementViewPanel {
    VolumesTableViewPanel volumesTableViewPanel;
    VolumesDetailsViewPanel volumesDetailsViewPanel;

    public VolumesViewPanel(JFrame owner) {
        this.volumesTableViewPanel = this.createVolumesTableViewPanel(owner);
        this.volumesDetailsViewPanel = this.createVolumesDetailsViewPanel(owner);
        if (this.volumesTableViewPanel != null) {
            this.addTablePanel(this.volumesTableViewPanel);
            this.addDetailsPanel(this.volumesDetailsViewPanel);
        } else {
            this.remove(this.splitPanel);
            this.add((Component)this.volumesDetailsViewPanel, "Center");
        }
    }

    @Override
    public TableViewPanel getTableViewPanel() {
        return this.volumesTableViewPanel;
    }

    @Override
    public DetailsViewPanel getDetailsViewPanel() {
        return this.volumesDetailsViewPanel;
    }

    private void revalidateAndRepaintTableViewPanel() {
        if (this.volumesTableViewPanel != null) {
            this.volumesTableViewPanel.getTable().revalidate();
            this.volumesTableViewPanel.getTable().repaint();
            this.volumesTableViewPanel.revalidate();
            this.volumesTableViewPanel.repaint();
        }
    }

    public void clear(ClusterNode clusterNode) {
        if (this.hasModelCollection()) {
            this.getModelCollection().clearModelOf(clusterNode);
        }
        if (clusterNode.isCurrentCluster()) {
            this.clear();
        }
        this.volumesDetailsViewPanel.clear();
    }

    public void clear() {
        if (this.volumesTableViewPanel != null) {
            this.volumesTableViewPanel.clear();
        }
        if (this.volumesDetailsViewPanel != null) {
            this.volumesDetailsViewPanel.clear();
        }
        this.revalidateAndRepaintTableViewPanel();
    }

    public void refresh() {
        if (this.volumesTableViewPanel != null) {
            this.volumesTableViewPanel.refresh();
        }
    }

    public void newClusterHasBeenSelected() {
        if (this.volumesTableViewPanel != null) {
            this.volumesTableViewPanel.newClusterHasBeenSelected();
        }
        this.volumesDetailsViewPanel.newClusterHasBeenSelected();
    }

    protected abstract VolumesTableViewPanel createVolumesTableViewPanel(JFrame var1);

    protected abstract VolumesDetailsViewPanel createVolumesDetailsViewPanel(JFrame var1);

    protected abstract VolumesTableModelCollection getModelCollection();

    protected abstract boolean hasModelCollection();
}

