/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.event.volume.VolumeListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrNotExposedVolumeTreePanel;
import com.sanrad.nms.client.gui.SrVolumeTreePanel;
import com.sanrad.swing.DetailsViewPanel;
import com.sanrad.swing.SrTreeExpandSelectionRestorer;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.tree.TreeNode;

public abstract class VolumesDetailsViewPanel
extends DetailsViewPanel
implements VolumeListener {
    protected SrVolumeTreePanel volumeTreeViewPanel;

    public VolumesDetailsViewPanel(JFrame owner) {
        super(ClientLoader.BUNDLE.getString(SrClientBundleKeys.VOLUMES_DETAILS_LABEL));
        VolumeManager.getInstance().addVolumeListener(this);
        this.volumeTreeViewPanel = this.createVolumeTreeViewPanel(owner);
        this.add((Component)this.volumeTreeViewPanel, "Center");
    }

    protected abstract SrVolumeTreePanel createVolumeTreeViewPanel(JFrame var1);

    @Override
    public void removeListeners() {
        VolumeManager.getInstance().removeVolumeListener(this);
    }

    protected void finalize() throws Throwable {
        this.removeListeners();
        super.finalize();
    }

    public void newClusterHasBeenSelected() {
        this.volumeTreeViewPanel.newClusterHasBeenSelected();
    }

    public SrVolumeTreePanel getVolumeTree() {
        return this.volumeTreeViewPanel;
    }

    protected void refreshTree() {
        SrTreeExpandSelectionRestorer restorer = new SrTreeExpandSelectionRestorer(this.volumeTreeViewPanel.getTreeObject());
        restorer.save();
        if (!(this.volumeTreeViewPanel instanceof SrNotExposedVolumeTreePanel)) {
            this.volumeTreeViewPanel.getTreeModel().nodeStructureChanged((TreeNode)this.volumeTreeViewPanel.getTreeModel().getRoot());
        }
        restorer.restore();
        this.volumeTreeViewPanel.getTreeObject().revalidate();
        this.volumeTreeViewPanel.getTreeObject().repaint();
    }

    @Override
    public void volumeExposed(VolumeEvent e) {
        this.refreshTree();
    }

    @Override
    public void volumeDeExposed(VolumeEvent e) {
        this.refreshTree();
    }

    @Override
    public void volumeCreate(VolumeEvent e) {
        this.refreshTree();
    }

    @Override
    public void volumeRemove(VolumeEvent e) {
        this.refreshTree();
    }

    @Override
    public void volumeAliasChanged(VolumeEvent e) {
        this.refreshTree();
    }

    @Override
    public void volumeStatusChanged(VolumeEvent e) {
        this.refreshTree();
    }

    @Override
    public void volumeConfigChanged(VolumeEvent e) {
        this.refreshTree();
    }

    @Override
    public void volumeStateChanged(VolumeEvent e) {
        this.refreshTree();
    }

    @Override
    public void volumeParametersChanged(VolumeEvent e) {
        this.refreshTree();
    }

    @Override
    public void snapshotSourceChanged(VolumeEvent e) {
        this.refreshTree();
    }

    @Override
    public void volumeCapacityChanged(VolumeEvent e) {
        this.refreshTree();
    }

    @Override
    public void addVolumeNodeToParent(VolumeEvent event, VolumeTreeNode parentNode, VolumeTreeNode childNode) {
    }

    @Override
    public void removeVolumeNodeFromParent(VolumeEvent event, VolumeTreeNode childNode) {
    }

    @Override
    public void snapshotVolActiveStateChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolActivateOnVSwitchChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolActivityStateChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolDateAndTimeChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageThresholdChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageUtilizationChanged(VolumeEvent event) {
    }

    public void clear() {
        this.volumeTreeViewPanel.clearTree();
    }
}

