/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume;

import com.sanrad.nms.client.data.volume.VolumeOperationHandler;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotOperationHandler;
import com.sanrad.nms.client.gui.volume.VolumeOperationFrame;
import com.sanrad.swing.SrActionLabel;
import com.sanrad.swing.ToolBarPanel;
import com.sanrad.swing.actions.SrAction;

public class VolumeOperationToolBarPanel
extends ToolBarPanel {
    private VolumeOperationHandler volOperHandler;
    private VolumeOperationFrame myWorkWith;

    public VolumeOperationToolBarPanel(VolumeOperationHandler opHandler, VolumeOperationFrame workWith) {
        this.volOperHandler = opHandler;
        this.myWorkWith = workWith;
        this.initToolBar();
    }

    protected void initToolBar() {
        this.addButtonMirror();
        this.addButtonStripe();
        this.addButtonConcatenation();
        this.addButtonTransparent();
        if (this.volOperHandler instanceof SnapshotOperationHandler) {
            this.addButtonSnapshot();
        }
        this.addSpace();
        if (this.volOperHandler.isVolumeOperation()) {
            this.addOperationButton();
        } else {
            this.addButtonExpose();
        }
        this.addButtonDelete();
        this.addButtonBasic();
        this.addButtonClose();
    }

    protected void addButtonMirror() {
        this.addButton(new SrActionLabel(this.myWorkWith.createMirrorVolumeAction));
    }

    protected void addButtonStripe() {
        this.addButton(new SrActionLabel(this.myWorkWith.createStripeVolumeAction));
    }

    protected void addButtonConcatenation() {
        this.addButton(new SrActionLabel(this.myWorkWith.createConcatinationVolumeAction));
    }

    private void addButtonTransparent() {
        SrAction btnTransparent = this.myWorkWith.createTransparentVolumeAction;
        this.addButton(new SrActionLabel(btnTransparent));
    }

    protected void addButtonExpose() {
        this.addButton(new SrActionLabel(this.myWorkWith.exposeVolumeAction));
    }

    private void addButtonDelete() {
        this.addButton(new SrActionLabel(this.myWorkWith.myDeleteAction));
    }

    private void addOperationButton() {
        SrAction<VolumeTreeNode, Void> btnOperation = this.myWorkWith.operationAction;
        this.addButton(new SrActionLabel(btnOperation));
    }

    private void addButtonClose() {
        this.addButton(new SrActionLabel(this.myWorkWith.closeAction));
    }

    private void addButtonBasic() {
        this.addButton(new SrActionLabel(this.myWorkWith.basicWindowAction));
    }

    private void addButtonSnapshot() {
        this.addButton(new SrActionLabel(this.myWorkWith.createSnapshotVolumeAction));
    }
}

