/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.LUManager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SrStorageTableModel;
import com.sanrad.nms.client.data.storage.SrVolOperStorageTableModel;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.NotExposedVolumeTreeModelCollection;
import com.sanrad.nms.client.data.volume.SrNotExposedVolumeTreeModel;
import com.sanrad.nms.client.data.volume.TransparentVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeOperationHandler;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotOperationHandler;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.DirectAccessDeviceListener;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceListener;
import com.sanrad.nms.client.event.VolumeCreationSelectionEvent;
import com.sanrad.nms.client.event.VolumeCreationSelectionListener;
import com.sanrad.nms.client.event.lu.LUEvent;
import com.sanrad.nms.client.event.lu.LUListener;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.event.volume.VolumeListener;
import com.sanrad.nms.client.event.volume.copy.CopyOperationEvent;
import com.sanrad.nms.client.event.volume.copy.CopyOperationListener;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrNotExposedVolumeTreePanel;
import com.sanrad.nms.client.gui.SrSystemObjectComboBox;
import com.sanrad.nms.client.gui.actions.ExposeInternalVolumeAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteTreeAction;
import com.sanrad.nms.client.gui.components.ClientComponentsUtil;
import com.sanrad.nms.client.gui.storage.SrStorageTablePanel;
import com.sanrad.nms.client.gui.storage.SrVolOperStorageTablePanel;
import com.sanrad.nms.client.gui.storage.VolOperStorageTableViewPanel;
import com.sanrad.nms.client.gui.volume.NewVolumeWindow;
import com.sanrad.nms.client.gui.volume.VolumeOperationToolBarPanel;
import com.sanrad.nms.client.gui.volume.dialogs.NewConcatinationVolumeDialog;
import com.sanrad.nms.client.gui.volume.dialogs.NewMirrorVolumeDialog;
import com.sanrad.nms.client.gui.volume.dialogs.NewSnapshotVolumeDialog;
import com.sanrad.nms.client.gui.volume.dialogs.NewStripeVolumeDialog;
import com.sanrad.nms.client.gui.volume.dialogs.NewTransparentVolumeDialog;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.DetailsViewPanel;
import com.sanrad.swing.FrameView;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrSplitPane;
import com.sanrad.swing.SrTreeModel;
import com.sanrad.swing.ToolBarEvent;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class VolumeOperationFrame
extends FrameView
implements VolumeCreationSelectionListener,
TreeSelectionListener,
VolumeListener,
LUListener,
OperationController,
DirectAccessDeviceListener,
SubDirectAccessDeviceListener,
CopyOperationListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    private VolumeTreeNode sourceNode;
    protected VolumeOperationHandler myOperationHandler;
    protected VolumeOperationToolBarPanel m_volumeOperationToolbarPanel;
    protected SrNotExposedVolumeTreePanel volumeTreeViewPanel;
    protected VolOperStorageTableViewPanel storageTableViewPanel;
    protected SrSplitPane jSplitPane1 = new SrSplitPane();
    public static BigInteger SNAPSHOT_LIMIT_PERCENTAGE = new BigInteger("100");
    protected int MAX_NUM_OF_CHILDREN = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.VOLUME_MAX_NUM_OF_CHILDREN));
    protected int MAX_NUM_OF_MIRROR_CHILDREN = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.VOLUME_MAX_NUM_OF_MIRROR_CHILDREN));
    protected ClusterNode m_workingCluster;
    public final SrAction<VolumeTreeNode, Void> operationAction;
    private boolean myIsDisposeOnSuccess = true;
    public final SrAction basicWindowAction = new SrClientAction<Void, Void>("Basic", (Icon)ClientImageObject.UP_ARROW.getImageIcon(), false, false, null, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            VolumeOperationFrame.this.dispose();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewVolumeWindow.show(ClientLoader.getMainFrame(), VolumeOperationFrame.this.m_workingCluster);
                }
            });
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrAction closeAction = new SrClientAction<Void, Void>("Close", (Icon)ClientImageObject.CLOSE.getImageIcon(), false, false, null, SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            VolumeOperationFrame.this.dispose();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    private final View<VolumeTreeNode> allSelectionView;
    public final SrAction createConcatinationVolumeAction;
    public final SrAction createMirrorVolumeAction;
    public final SrAction createStripeVolumeAction;
    public final SrAction createSnapshotVolumeAction;
    public final SrAction createTransparentVolumeAction;
    public final SrAction exposeVolumeAction;
    public final DeleteTreeAction<VolumeTreeNode> myDeleteAction;
    private SrSystemObjectComboBox myClustersCombobox;

    protected VolumeOperationFrame(VolumeTreeNode source, VolumeOperationHandler handler, ClusterNode workingCluster) {
        this.sourceNode = source;
        this.myOperationHandler = handler;
        this.m_workingCluster = workingCluster;
        this.myOperationHandler.setOwner(this);
        String title = this.createTitle();
        this.setViewTitle(title, true);
        this.setTitle(title);
        this.setLocation(200, 100);
        this.initInternalVolumesTree();
        this.initResourcesView();
        this.allSelectionView = new View<VolumeTreeNode>(){

            @Override
            public Collection<VolumeTreeNode> getValue() {
                return VolumeOperationFrame.this.getVolumeChildrenNodes();
            }

            @Override
            public void addListener(SrAction<VolumeTreeNode, ?> action) {
                VolumeOperationFrame.this.volumeTreeViewPanel.getTreeObject().addTreeSelectionListener(new View.ViewTreeSelectionListener(action));
                VolumeOperationFrame.this.storageTableViewPanel.getTable().getSelectionModel().addListSelectionListener(new View.ViewListSelectionListener(action));
            }

            @Override
            public void removeListener(SrAction<VolumeTreeNode, ?> action) {
                VolumeOperationFrame.this.volumeTreeViewPanel.getTreeObject().removeTreeSelectionListener(new View.ViewTreeSelectionListener(action));
                VolumeOperationFrame.this.storageTableViewPanel.getTable().getSelectionModel().removeListSelectionListener(new View.ViewListSelectionListener(action));
            }
        };
        OperationController deleteConroller = new OperationController(){

            @Override
            public void fail(String message) {
                VolumeOperationFrame.this.fail(message);
            }

            @Override
            public void inProcess(String message) {
                VolumeOperationFrame.this.inProcess(message);
            }

            @Override
            public void success(SrAction action) {
            }
        };
        this.myDeleteAction = new DeleteTreeAction<VolumeTreeNode>(this.allSelectionView, deleteConroller){

            @Override
            protected String validateTreeDeletion(VolumeTreeNode headNode) {
                return null;
            }
        };
        this.operationAction = new SrClientAction<VolumeTreeNode, Void>(this.myOperationHandler.getOperationName(), this.myOperationHandler.getIconForOperation(), true, true, this.allSelectionView, SrLicenseTreePath.GENERAL_PATH, true, this.myOperationHandler.shouldBlockAction()){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
                Collection<SrFuture<Void>> retVal = VolumeOperationFrame.this.myOperationHandler.operate(arg.iterator().next());
                if (!retVal.isEmpty()) {
                    4.blockActions();
                }
                VolumeOperationFrame.this.setVisible(false);
                return retVal;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                String retVal = VolumeOperationFrame.this.regularActionTest();
                if (retVal != null) {
                    return retVal;
                }
                return VolumeOperationFrame.this.isOperLegitimate((VolumeTreeNode)this.myView.getValue().iterator().next());
            }

            @Override
            protected void onActionFinished(Collection<? extends SrFuture<Void>> aFutures) {
                super.onActionFinished(aFutures);
                4.releaseActions();
            }
        };
        this.operationAction.addControllerAsListener(this);
        this.myOperationHandler.initAction(this.operationAction);
        this.createConcatinationVolumeAction = new SrClientAction<VolumeTreeNode, Void>("Concatenation", (Icon)ClientImageObject.CONCATINATION_VOLUME.getImageIcon(), true, true, this.allSelectionView, SrLicenseTreePath.GENERAL_PATH, false, false){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
                Vector<VolumeTreeNode> children = new Vector<VolumeTreeNode>(arg);
                new NewConcatinationVolumeDialog((JFrame)VolumeOperationFrame.this, children, VolumeOperationFrame.this.m_workingCluster);
                VolumeOperationFrame.this.clearSelection();
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                String retVal = VolumeOperationFrame.this.regularActionTest();
                if (retVal != null) {
                    return retVal;
                }
                Collection children = this.myView.getValue();
                return VolumeOperationFrame.this.multiSelectionTest(children, VolumeOperationFrame.this.MAX_NUM_OF_CHILDREN);
            }
        };
        this.createMirrorVolumeAction = new SrClientAction<VolumeTreeNode, Void>("Mirror", (Icon)ClientImageObject.MIRROR_VOLUME.getImageIcon(), true, true, this.allSelectionView, SrLicenseTreePath.GENERAL_PATH, false, false){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
                Vector<VolumeTreeNode> children = new Vector<VolumeTreeNode>(arg);
                new NewMirrorVolumeDialog((JFrame)VolumeOperationFrame.this, children, VolumeOperationFrame.this.m_workingCluster);
                VolumeOperationFrame.this.clearSelection();
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return VolumeOperationFrame.this.multiSelectionTest(this.myView.getValue(), VolumeOperationFrame.this.MAX_NUM_OF_MIRROR_CHILDREN);
            }
        };
        this.createStripeVolumeAction = new SrClientAction<VolumeTreeNode, Void>("Stripe", (Icon)ClientImageObject.STRIPE_VOLUME.getImageIcon(), true, true, this.allSelectionView, SrLicenseTreePath.GENERAL_PATH, false, false){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
                Vector<VolumeTreeNode> children = new Vector<VolumeTreeNode>(arg);
                new NewStripeVolumeDialog((JFrame)VolumeOperationFrame.this, children, VolumeOperationFrame.this.m_workingCluster);
                VolumeOperationFrame.this.clearSelection();
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return VolumeOperationFrame.this.multiSelectionTest(this.myView.getValue(), VolumeOperationFrame.this.MAX_NUM_OF_CHILDREN);
            }
        };
        this.createSnapshotVolumeAction = new SrClientAction<VolumeTreeNode, Void>("Snapshot", (Icon)ClientImageObject.SNAPSHOT.getImageIcon(), true, true, this.allSelectionView, SrLicenseTreePath.GENERAL_PATH, true, false){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
                Vector<VolumeTreeNode> children = new Vector<VolumeTreeNode>(arg);
                new NewSnapshotVolumeDialog((JFrame)VolumeOperationFrame.this, VolumeOperationFrame.this.sourceNode, children, VolumeOperationFrame.this.m_workingCluster);
                VolumeOperationFrame.this.clearSelection();
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                String retVal = VolumeOperationFrame.this.regularActionTest();
                if (retVal != null) {
                    return retVal;
                }
                if (!(VolumeOperationFrame.this.myOperationHandler instanceof SnapshotOperationHandler)) {
                    return "Selected operation is not a create snapshot one";
                }
                return VolumeOperationFrame.this.enableSnapshotCreation((VolumeTreeNode)this.myView.getValue().iterator().next());
            }
        };
        this.createTransparentVolumeAction = new SrClientAction<VolumeTreeNode, Void>("Transparent", (Icon)ClientImageObject.TRANSPARENT_VOLUME.getImageIcon(), true, true, this.allSelectionView, SrLicenseTreePath.GENERAL_PATH, true, false){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
                Vector<VolumeTreeNode> children = new Vector<VolumeTreeNode>(arg);
                AliasObject selectedChild = VolumeOperationFrame.this.getSelectedResource();
                StorageDeviceNode child = (StorageDeviceNode)selectedChild.getValue();
                String childAlias = child.getAlias();
                new NewTransparentVolumeDialog((JFrame)VolumeOperationFrame.this, children, ClientComponentsUtil.filterVolumeAliasChars(childAlias), VolumeOperationFrame.this.m_workingCluster);
                VolumeOperationFrame.this.clearSelection();
                return Collections.EMPTY_LIST;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                String retVal = VolumeOperationFrame.this.regularActionTest();
                if (retVal != null) {
                    return retVal;
                }
                if (VolumeOperationFrame.this.myOperationHandler.isVolumeOperation()) {
                    return "Transparent volume is not supported for selected operation";
                }
                VolumeTreeNode selectedVolume = (VolumeTreeNode)this.myView.getValue().iterator().next();
                if (!AlarmsManager.getInstance().isLegitimateForVolumeCreation(selectedVolume)) {
                    return "Selected item is not legitimate for volume creation";
                }
                if (!(selectedVolume instanceof StorageDeviceNode)) {
                    return "Selected item is not a physical storage device";
                }
                if (selectedVolume instanceof SubDirectAccessDeviceNode) {
                    return "Selected item is a subdisk";
                }
                if (((StorageDeviceNode)selectedVolume).hasVolumeParent()) {
                    return "Selected disk has a parent volume";
                }
                if (selectedVolume instanceof DirectAccessDeviceNode && ((DirectAccessDeviceNode)selectedVolume).hasSubdisks()) {
                    return "Selected disk has subdisks";
                }
                if (DRPairManager.getPairContainingVolume(selectedVolume) != null) {
                    return "Selected volume participates in a pair";
                }
                if (selectedVolume instanceof DirectAccessDeviceNode) {
                    ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(selectedVolume);
                    if (VolumeManager.getInstance().getClusterSnapshotMap().isSourceOfSnapshot(clusterNode, selectedVolume)) {
                        return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.TRANSPARENT_CAN_NOT_BE_CREATED_DISK_SOURCE_OF_SNAPSHOT);
                    }
                }
                ArrayList<VolumeTreeNode> selectedVolumeCollection = new ArrayList<VolumeTreeNode>();
                selectedVolumeCollection.add(selectedVolume);
                String virtualVolEnable = VolumeOperationFrame.virtualVolEnable(selectedVolumeCollection);
                if (virtualVolEnable != null) {
                    return virtualVolEnable;
                }
                return null;
            }
        };
        this.exposeVolumeAction = new ExposeInternalVolumeAction<VolumeTreeNode>((JFrame)this, this.allSelectionView, SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
                Collection<SrFuture<Void>> retVal = super.derivedActionPerformed(arg);
                VolumeOperationFrame.this.clearSelection();
                return retVal;
            }
        };
        this.initToolBarPanel();
        this.initFrame();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent aE) {
            }
        });
        this.setDefaultCloseOperation(2);
    }

    private String createTitle() {
        return this.myOperationHandler.toString();
    }

    @Override
    public void dispose() {
        this.removeListeners();
        super.dispose();
    }

    public void removeListeners() {
        this.myClustersCombobox.removeListeners();
        VolumeManager.getInstance().removeVolumeListener(this);
        LUManager.getInstance().removeLUListener(this);
        DirectAccessDeviceManager.getInstance().removeDirectAccessDeviceListener(this);
        SubDirectAccessDeviceManager.getInstance().removeSubDirectDeviceListener(this);
        CopyOperManager.getInstance().removeCopyOperationListener(this);
        this.volumeTreeViewPanel.removeVolumeCreationSelectionListener(this);
        this.volumeTreeViewPanel.removeTreeToolBarSanityListener(this);
        this.volumeTreeViewPanel.getTreeModel().removeTreeModelListener(this.volumeTreeViewPanel);
        this.volumeTreeViewPanel.setModel(new SrTreeModel(null));
        this.storageTableViewPanel.removeVolumeCreationSelectionListener(this);
        this.removeToolBarPanel(this.m_volumeOperationToolbarPanel);
    }

    private void initFrame() {
        this.controlToolbar();
        this.jSplitPane1.setOrientation(1);
        this.getMainPanel().add((Component)this.jSplitPane1, "Center");
        DetailsViewPanel volumesView = new DetailsViewPanel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.UNEXPOSED_VOLUMES_TREE_TITLE)){};
        volumesView.add((Component)this.volumeTreeViewPanel, "Center");
        this.jSplitPane1.add((Component)volumesView, "right");
        this.jSplitPane1.add((Component)this.storageTableViewPanel, "left");
        this.jSplitPane1.setDividerLocation(450);
        this.initSystemComboBox();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int h = screenSize.height / 3 * 2;
        int w = screenSize.width / 3 * 2;
        this.setSize(w, h);
        VolumeManager.getInstance().addVolumeListener(this);
        LUManager.getInstance().addLUListener(this);
        DirectAccessDeviceManager.getInstance().addDirectAccessDeviceListener(this);
        SubDirectAccessDeviceManager.getInstance().addSubDirectDeviceListener(this);
        CopyOperManager.getInstance().addCopyOperationListener(this);
    }

    protected void initSystemComboBox() {
        this.myClustersCombobox = new SrSystemObjectComboBox(SystemRootNode.getInstance(), ClusterNode.class, SrSystemObjectComboBox.CLUSTER_PROPERTIES);
        this.myClustersCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (VolumeOperationFrame.this.m_workingCluster != null) {
                        VolumeOperationFrame.this.m_workingCluster.removeDialog(VolumeOperationFrame.this.getClass());
                    }
                    boolean clusterChanged = false;
                    if (e.getItem() instanceof ClusterNode) {
                        VolumeOperationFrame.this.m_workingCluster = (ClusterNode)e.getItem();
                        clusterChanged = true;
                    } else if (e.getItem() == null) {
                        VolumeOperationFrame.this.m_workingCluster = null;
                        clusterChanged = true;
                    }
                    if (clusterChanged) {
                        SrNotExposedVolumeTreeModel model;
                        SrStorageTablePanel tablePanel = (SrStorageTablePanel)VolumeOperationFrame.this.storageTableViewPanel.getCurrentTablePanel();
                        tablePanel.getModel().removeListeners();
                        SrVolOperStorageTableModel tableModel = new SrVolOperStorageTableModel(VolumeOperationFrame.this.m_workingCluster);
                        tablePanel.setModel(tableModel);
                        if (VolumeOperationFrame.this.m_workingCluster != null) {
                            model = (SrNotExposedVolumeTreeModel)NotExposedVolumeTreeModelCollection.getInstance().getModel((RemoteObject)VolumeOperationFrame.this.m_workingCluster.getStub());
                            VolumeOperationFrame.this.volumeTreeViewPanel.setModel(model);
                            VolumeOperationFrame.this.m_workingCluster.addDialog(VolumeOperationFrame.this);
                        } else {
                            model = new SrNotExposedVolumeTreeModel();
                            VolumeOperationFrame.this.volumeTreeViewPanel.setModel(model);
                        }
                        VolumeOperationFrame.this.myOperationHandler.setWorkingCluster(VolumeOperationFrame.this.m_workingCluster);
                        String title = VolumeOperationFrame.this.myOperationHandler.toString();
                        VolumeOperationFrame.this.setTitle(title);
                        VolumeOperationFrame.this.setViewTitle(title, true);
                    }
                }
            }
        });
        Dimension boxPrefrredDim = this.myClustersCombobox.getPreferredSize();
        boxPrefrredDim.width += 30;
        this.myClustersCombobox.setPreferredSize(boxPrefrredDim);
        this.myClustersCombobox.setSelectedItem(this.m_workingCluster);
        SrPanel p = new SrPanel(new FlowLayout(0));
        SrLabelField label = new SrLabelField(ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_SELECT_CLUSTER_TEXT));
        p.setOpaque(false);
        p.add(label);
        p.add(this.myClustersCombobox);
        this.getMainPanel().add((Component)p, "North");
    }

    protected void initToolBarPanel() {
        this.m_volumeOperationToolbarPanel = new VolumeOperationToolBarPanel(this.myOperationHandler, this);
        this.addToolBarPanel(this.m_volumeOperationToolbarPanel);
    }

    private void initInternalVolumesTree() {
        this.volumeTreeViewPanel = this.getTreePanel();
        ToolTipManager.sharedInstance().registerComponent(this.volumeTreeViewPanel.getTreeObject());
        this.volumeTreeViewPanel.addTreeToolBarSanityListener(this);
        this.volumeTreeViewPanel.addVolumeCreationSelectionListener(this);
    }

    protected SrNotExposedVolumeTreePanel getTreePanel() {
        SrNotExposedVolumeTreePanel tree = null;
        if (this.m_workingCluster == null) {
            tree = new SrNotExposedVolumeTreePanel(new SrNotExposedVolumeTreeModel(), this, this.myOperationHandler);
        } else {
            SrNotExposedVolumeTreeModel model = (SrNotExposedVolumeTreeModel)NotExposedVolumeTreeModelCollection.getInstance().getModel((RemoteObject)this.m_workingCluster.getStub());
            tree = new SrNotExposedVolumeTreePanel(model, this, this.myOperationHandler);
        }
        return tree;
    }

    private void initResourcesView() {
        this.storageTableViewPanel = this.getTableViewPanel();
        this.storageTableViewPanel.addVolumeCreationSelectionListener(this);
    }

    protected VolOperStorageTableViewPanel getTableViewPanel() {
        return new VolOperStorageTableViewPanel(this, this.myOperationHandler, this.m_workingCluster);
    }

    private String multiSelectionTest(Collection<VolumeTreeNode> children, int maxChildren) {
        String retVal = this.regularActionTest();
        if (retVal != null) {
            return retVal;
        }
        if (children.size() == 1) {
            return "Only one item is selected";
        }
        String virtualVolEnable = VolumeOperationFrame.virtualVolEnable(children);
        if (virtualVolEnable != null) {
            return virtualVolEnable;
        }
        if (!VolumeOperationFrame.compareBlockSize(children)) {
            return "Selected items have different block size";
        }
        if (!AlarmsManager.getInstance().isLegitimateForVolumeCreation(children)) {
            return "Some of selected items is not legitimate for volume creation";
        }
        if (children.size() > maxChildren) {
            return "More then " + maxChildren + " children are not supported for this type of volume";
        }
        VolumeTreeNode volumeInPair = VolumeOperationFrame.findVolumeInPair(children);
        if (volumeInPair != null) {
            return "Volume " + volumeInPair.getAlias() + " participates in a DR pair";
        }
        return null;
    }

    private String regularActionTest() {
        String msg = this.validateStorageSelected();
        if (msg != null) {
            return msg;
        }
        String illegalVolumeSelected = this.illegalVolumeSelected();
        if (illegalVolumeSelected != null) {
            return illegalVolumeSelected;
        }
        return null;
    }

    protected void clearSelection() {
        this.volumeTreeViewPanel.clearSelection();
        this.storageTableViewPanel.getTable().clearSelection();
        this.controlToolbar();
    }

    public void openVolumeOperationFrame(ToolBarEvent e) {
        this.show();
    }

    @Override
    public void clearTableSelection(VolumeCreationSelectionEvent e) {
        this.storageTableViewPanel.getTable().clearSelection();
    }

    @Override
    public void clearTreeSelection(VolumeCreationSelectionEvent e) {
        this.volumeTreeViewPanel.clearSelection();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.controlToolbar();
    }

    private void controlToolbar() {
        Vector<VolumeTreeNode> children = this.getVolumeChildrenNodes();
        if (children.size() == 1) {
            this.oneResourceIsSelected(children);
        }
    }

    private static String virtualVolEnable(Collection<VolumeTreeNode> children) {
        for (VolumeTreeNode child : children) {
            String canBeOtherVolumeChild = VolumeManager.getInstance().canBeOtherVolumeChild(child);
            if (canBeOtherVolumeChild == null) continue;
            return canBeOtherVolumeChild;
        }
        return null;
    }

    private static VolumeTreeNode findVolumeInPair(Collection<VolumeTreeNode> children) {
        for (VolumeTreeNode child : children) {
            if (DRPairManager.getPairContainingVolume(child) == null) continue;
            return child;
        }
        return null;
    }

    private void oneResourceIsSelected(Vector<VolumeTreeNode> children) {
        VolumeTreeNode selectedVolume = children.get(0);
        if (this.myOperationHandler instanceof SnapshotOperationHandler) {
            this.enableSnapshotCreation(selectedVolume);
        }
    }

    private String enableSnapshotCreation(VolumeTreeNode selectedVolume) {
        String canBeOtherVolumeChild = VolumeManager.getInstance().canBeOtherVolumeChild(selectedVolume);
        if (canBeOtherVolumeChild != null) {
            return canBeOtherVolumeChild;
        }
        if (selectedVolume.equals(this.sourceNode)) {
            return "A volume cannot be a snapshot source of itself";
        }
        if (!selectedVolume.getBlockSize().equals(this.sourceNode.getBlockSize())) {
            return "The snapshot and its source must have the same block size";
        }
        BigInteger sourceAccessibleSize = this.sourceNode.getAccessibleSpace();
        if (this.sourceNode instanceof DirectAccessDeviceNode) {
            sourceAccessibleSize = ((DirectAccessDeviceNode)this.sourceNode).getTotalSpace();
        }
        BigInteger accessibleSize = selectedVolume.getAccessibleSpace();
        if (selectedVolume instanceof DirectAccessDeviceNode) {
            accessibleSize = ((DirectAccessDeviceNode)selectedVolume).getTotalSpace();
        }
        if (accessibleSize.multiply(SNAPSHOT_LIMIT_PERCENTAGE).compareTo(sourceAccessibleSize) < 0) {
            return "Accessible size of snapshot must be at least 1/" + SNAPSHOT_LIMIT_PERCENTAGE + " of its source";
        }
        return null;
    }

    private static boolean compareBlockSize(Collection<VolumeTreeNode> children) {
        int blockSize = -1;
        boolean isFirst = true;
        for (VolumeTreeNode nextNode : children) {
            int myBlockSize = nextNode.getBlockSize();
            if (isFirst) {
                blockSize = myBlockSize;
                isFirst = false;
            }
            if (blockSize == myBlockSize) continue;
            return false;
        }
        return true;
    }

    private AliasObject getSelectedResource() {
        Object[] selction = ((SrVolOperStorageTablePanel)this.storageTableViewPanel.getCurrentTablePanel()).getSelectedAliases();
        if (selction != null && selction.length > 0) {
            return (AliasObject)selction[0];
        }
        return null;
    }

    private Vector<VolumeTreeNode> getSelectedVolumesNodes() {
        Vector<VolumeTreeNode> selectedVolumes = new Vector<VolumeTreeNode>();
        TreePath[] treePaths = this.volumeTreeViewPanel.getSelectionPaths();
        if (treePaths != null) {
            for (int i = 0; i < treePaths.length; ++i) {
                if (treePaths[i].getLastPathComponent().equals(this.volumeTreeViewPanel.getTreeObject().getModel().getRoot())) continue;
                VolumeTreeNode node = (VolumeTreeNode)treePaths[i].getLastPathComponent();
                TreeNode parent = node.getParent();
                selectedVolumes.addElement(node);
            }
        }
        return selectedVolumes;
    }

    private Vector<StorageDeviceNode> getSelectedResourceNodes() {
        Vector<StorageDeviceNode> children = new Vector<StorageDeviceNode>();
        SrVolOperStorageTableModel tableModel = (SrVolOperStorageTableModel)this.storageTableViewPanel.getTable().getModel();
        int[] selectedRows = this.storageTableViewPanel.getTable().getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            Object alias = tableModel.getValueAt(selectedRows[i], 1);
            if (alias == null || !(alias instanceof AliasObject)) {
                alias = (AliasObject)tableModel.getValueAt(selectedRows[i], 0);
            }
            children.addElement((StorageDeviceNode)((AliasObject)alias).getValue());
        }
        return children;
    }

    private Vector<VolumeTreeNode> getVolumeChildrenNodes() {
        Vector<VolumeTreeNode> children = new Vector<VolumeTreeNode>();
        children.addAll(this.getSelectedResourceNodes());
        children.addAll(this.getSelectedVolumesNodes());
        return children;
    }

    private String illegalVolumeSelected() {
        TreePath[] treePaths = this.volumeTreeViewPanel.getSelectionPaths();
        if (treePaths != null) {
            for (int i = 0; i < treePaths.length; ++i) {
                if (treePaths[i].getLastPathComponent().equals(this.volumeTreeViewPanel.getTreeObject().getModel().getRoot())) continue;
                VolumeTreeNode node = (VolumeTreeNode)treePaths[i].getLastPathComponent();
                TreeNode parent = node.getParent();
                if (parent == null) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, "Disconnected volume tree node (having no parent)");
                    return node + " is disconnected";
                }
                if (!(parent instanceof VolumeTreeNode)) continue;
                return node + " is used for volume " + parent;
            }
        }
        return null;
    }

    private String validateStorageSelected() {
        Vector<StorageDeviceNode> selectedResources = this.getSelectedResourceNodes();
        for (int i = 0; i < selectedResources.size(); ++i) {
            StorageDeviceNode current = selectedResources.get(i);
            if (current.hasVolumeParent()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.STORAGE_HAS_PARENT_VOLUME, current.getAlias(), ((VolumeTreeNode)current.getParent()).getAlias());
            }
            if (current.isExposed()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.STORAGE_IS_EXPOSED, current.getAlias());
            }
            if (!current.isDisk() || !((DirectAccessDeviceNode)current).hasSubdisks()) continue;
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.STORAGE_HAS_SUBDISKS, current.getAlias());
        }
        return null;
    }

    @Override
    public void volumeExposed(VolumeEvent e) {
    }

    @Override
    public void volumeDeExposed(VolumeEvent e) {
    }

    @Override
    public void volumeCreate(VolumeEvent e) {
    }

    @Override
    public void volumeRemove(VolumeEvent e) {
    }

    @Override
    public void volumeAliasChanged(VolumeEvent e) {
    }

    @Override
    public void volumeStatusChanged(VolumeEvent e) {
    }

    @Override
    public void volumeConfigChanged(VolumeEvent e) {
    }

    @Override
    public void volumeStateChanged(VolumeEvent e) {
    }

    @Override
    public void volumeParametersChanged(VolumeEvent e) {
    }

    @Override
    public void snapshotSourceChanged(VolumeEvent e) {
    }

    @Override
    public void luRemoved(LUEvent event) {
    }

    @Override
    public void luCreated(LUEvent event) {
    }

    @Override
    public void luChanged(LUEvent event) {
    }

    @Override
    public void luStatusChanged(LUEvent event) {
    }

    private String isOperLegitimate(VolumeTreeNode vol) {
        if (vol instanceof TransparentVolumeNode) {
            return "The selected volume is transparent";
        }
        return this.myOperationHandler.isOperationLegitimate(vol);
    }

    public void newClusterHasBeenSelected() {
        this.volumeTreeViewPanel.newClusterHasBeenSelected();
        this.storageTableViewPanel.newClusterHasBeenSelected();
    }

    public void setNotDisposeOnSuccess() {
        this.myIsDisposeOnSuccess = false;
    }

    @Override
    public void success(SrAction aAction) {
        this.setCursor(null);
        if (this.myIsDisposeOnSuccess) {
            this.dispose();
        }
        this.myIsDisposeOnSuccess = true;
    }

    @Override
    public void fail(String msg) {
        this.setState(0);
        SrOptionPaneUtil.showErrorMessage(this, msg);
        this.setVisible(true);
        this.setCursor(null);
    }

    @Override
    public void inProcess(String message) {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void volumeCapacityChanged(VolumeEvent e) {
    }

    @Override
    public void directAccessDeviceAliasChanged(DirectAccessDeviceEvent event) {
    }

    @Override
    public void directAccessDeviceChanged(DirectAccessDeviceEvent event) {
        ((SrStorageTableModel)this.storageTableViewPanel.getTable().getModel()).directAccessDeviceChanged(event);
    }

    @Override
    public void directAccessDeviceExposed(DirectAccessDeviceEvent event) {
        this.storageTableViewPanel.getTable().repaint();
    }

    @Override
    public void directAccessDeviceDeExposed(DirectAccessDeviceEvent event) {
        this.storageTableViewPanel.getTable().repaint();
    }

    @Override
    public void directAccessDeviceInfoChanged(DirectAccessDeviceEvent event) {
    }

    @Override
    public void directAccessDeviceStatusChanged(DirectAccessDeviceEvent event) {
    }

    @Override
    public void directAccessDeviceRemoved(DirectAccessDeviceEvent event) {
    }

    @Override
    public void directAccessDeviceBlinkStateChange(DirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceRemoved(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceAliasChanged(SubDirectAccessDeviceEvent event) {
        ((SrStorageTableModel)this.storageTableViewPanel.getTable().getModel()).subDirecetAccessDeviceAliasChanged(event);
    }

    @Override
    public void subDirecetAccessDeviceInfoChanged(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirectAccessDeviceExposed(SubDirectAccessDeviceEvent event) {
        this.storageTableViewPanel.getTable().repaint();
    }

    @Override
    public void subDirectAccessDeviceDeExposed(SubDirectAccessDeviceEvent event) {
        this.storageTableViewPanel.getTable().repaint();
    }

    @Override
    public void subDirecetAccessDeviceStatusChanged(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void addVolumeNodeToParent(VolumeEvent event, VolumeTreeNode parentNode, VolumeTreeNode childNode) {
    }

    @Override
    public void removeVolumeNodeFromParent(VolumeEvent event, VolumeTreeNode childNode) {
    }

    @Override
    public void snapshotVolActiveStateChanged(VolumeEvent event) {
    }

    @Override
    public void directAccessDeviceCreated(DirectAccessDeviceEvent event) {
    }

    @Override
    public void journalVolActivateOnVSwitchChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolActivityStateChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolDateAndTimeChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageThresholdChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageUtilizationChanged(VolumeEvent event) {
    }

    @Override
    public void copyOperationChange(CopyOperationEvent e) {
        this.storageTableViewPanel.getTable().repaint();
    }

    @Override
    public void copyOperationCreate(CopyOperationEvent e) {
        this.storageTableViewPanel.getTable().repaint();
    }

    @Override
    public void copyOperationRemove(CopyOperationEvent e) {
        this.storageTableViewPanel.getTable().repaint();
    }

    @Override
    public void getAllCopyOperations(CopyOperationEvent e) {
    }
}

