/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.volume.SrVolumesTableModel;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionAdapter;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionEvent;
import com.sanrad.nms.client.gui.SrClientTablePanel;
import com.sanrad.nms.client.gui.volume.ExposedVolumesTableHeader;
import com.sanrad.swing.SrTableModel;
import com.sanrad.swing.table.ColoredTableCellRenderer;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JFrame;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public abstract class SrVolumesTablePanel
extends SrClientTablePanel {
    protected JFrame m_owner;

    public SrVolumesTablePanel(JFrame owner, SrTableModel model) {
        super(model);
        this.m_owner = owner;
        this.buildTable();
        this.setSelectionMode(2);
        this.initTableRenderer();
    }

    protected abstract SrTableModel getCurrentTableModel();

    protected abstract void initTableRenderer();

    protected void buildTable() {
        for (int k = 0; k < this.getModel().getColumnCount(); ++k) {
            ColoredTableCellRenderer renderer = new ColoredTableCellRenderer();
            renderer.setHorizontalAlignment(2);
            TableColumn column = this.getTable().getColumnModel().getColumn(k);
            column.setPreferredWidth(75);
            column.setCellRenderer(renderer);
        }
        JTableHeader header = this.getTable().getTableHeader();
        header.setUpdateTableInRealTime(true);
        header.setReorderingAllowed(true);
        header.setFont(new Font("Verdana", 0, 9));
        this.getScrollPane().getViewport().setBackground(Color.WHITE);
    }

    public void clear() {
        this.getCurrentTableModel().removeAllRows();
    }

    class VolumeSelectionAdapter
    extends AlarmSourceSelectionAdapter {
        VolumeSelectionAdapter() {
        }

        @Override
        public void volumeSelected(AlarmSourceSelectionEvent e) {
            SrTreeNode selected = e.getNode();
            if (selected != null) {
                VolumeTreeNode node = (VolumeTreeNode)selected;
                if (!node.isExposed()) {
                    return;
                }
                int col = ((SrVolumesTableModel)SrVolumesTablePanel.this.getModel()).getColumnIndex(ExposedVolumesTableHeader.VOLUME_NAME.getColumnName());
                for (int i = 0; i < SrVolumesTablePanel.this.getTable().getRowCount(); ++i) {
                    Object vol = SrVolumesTablePanel.this.getModel().getValueAt(i, col);
                    if (!vol.equals(node)) continue;
                    SrVolumesTablePanel.this.setRowSelectionSet(i, i);
                }
            }
        }
    }
}

