/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrDefaultPopupMenu;
import com.sanrad.nms.client.gui.SrVolumeTreePanel;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.EmptyAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.SynchronizeElementAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;

public abstract class SrVolumeTreePopupMenu
extends SrDefaultPopupMenu {
    private static SrLogger theLogger = SrLogger.getLogger();
    protected SrVolumeTreePanel m_tree;
    private static final String SNAPSHOT = "Snapshots";
    public static final String SHOW = "Show snapshots...";
    public static final String CREATE = "Create...";
    public static final String SCHEDULER_CREATE = "Create snapshot schedule...";
    public static final String SCHEDULER_EDIT = "Edit snapshot schedule...";
    public static final String TAKE_SNAPSHOT = "Take snapshot now...";
    private static final String COPY_MENU = "Copy";
    public static final String COPY = "Copy...";
    public static final String SHOW_COPY = "Show...";
    private final String MIRROR_MENU = "Mirror";
    public static final String MIRROR_SYNC = "Sync";
    public static final String MIRROR_ADD = "Add...";
    public static final String MIRROR_BREAK = "Break";
    public static final String SHOW_MIRROR_SYNC = "Show...";
    private final String RESIZE_MENU = "Resize";
    public static final String RESIZE = "Resize...";
    public static final String EXPAND = "Expand";
    public static final String RETRACT = "Retract";
    public static final String REPLACE = "Replace";
    public static final String RENAME = "Rename";
    public static final String RESTORE = "Rollback...";
    public static final String ABORT_RESTORE = "Abort";
    public static final String START_RESTORE = "Start";
    public static final String RESTART_RESTORE = "Restart";
    public static final String DELETE_RESTORE = "Clear";
    public static final int MAX_NUM_OF_CHILDREN = 4;
    protected SrAction m_delete;

    protected SrVolumeTreePopupMenu(SrVolumeTreePanel workWith) {
        super(workWith);
        Vector<Object> actions = new Vector<Object>(15);
        Vector<SrClientAction> snapshotMenuVec = new Vector<SrClientAction>();
        snapshotMenuVec.add(new SrClientAction<VolumeTreeNode, Void>(SNAPSHOT, true, true, this.m_tree.myView, SrLicenseTreePath.VOLUME_PATH, true){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
                theLogger.logAndAssert(SrLogCategories.ERROR, false, new Object[]{"BUG: An empty action performed"});
                return null;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return null;
            }

            @Override
            protected boolean shouldClientActionBeVisible() {
                Collection value = this.myView.getValue();
                if (value.isEmpty()) {
                    return false;
                }
                VolumeTreeNode node = (VolumeTreeNode)value.iterator().next();
                return !(node instanceof JournalVolumeNode) && !(node instanceof SnapshotVolumeNode);
            }
        });
        snapshotMenuVec.add(this.m_tree.createSnapshotAction);
        snapshotMenuVec.add(this.m_tree.snapshotSchedulerAction);
        snapshotMenuVec.add(this.m_tree.showSnapshotAction);
        Vector<SrClientAction> mirrorMenuVec = new Vector<SrClientAction>(5);
        mirrorMenuVec.add(new EmptyAction("Mirror", true, true, SrLicenseTreePath.VOLUME_PATH));
        mirrorMenuVec.add(this.m_tree.addMirrorAction);
        mirrorMenuVec.add(this.m_tree.breakMirrorAction);
        mirrorMenuVec.add(this.m_tree.mirrorSyncAction);
        mirrorMenuVec.add(this.m_tree.showMirrorSyncAction);
        Vector<SrClientAction> resizeMenuVec = new Vector<SrClientAction>(4);
        resizeMenuVec.add(new EmptyAction("Resize", true, true, SrLicenseTreePath.VOLUME_PATH));
        resizeMenuVec.add(this.m_tree.resizeAction);
        resizeMenuVec.add(this.m_tree.expandAction);
        resizeMenuVec.add(this.m_tree.retractAction);
        Vector<SrClientAction> copyMenuVec = new Vector<SrClientAction>(3);
        copyMenuVec.add(new SrClientAction<VolumeTreeNode, Void>(COPY_MENU, true, true, this.m_tree.myView, SrLicenseTreePath.VOLUME_PATH, true){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<VolumeTreeNode> arg) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "BUG: An empty Copy menu action performed");
                return null;
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return null;
            }

            @Override
            protected boolean shouldClientActionBeVisible() {
                Collection value = this.myView.getValue();
                return !value.isEmpty() && !(value.iterator().next() instanceof JournalVolumeNode);
            }
        });
        copyMenuVec.add(this.m_tree.copyAction);
        copyMenuVec.add(this.m_tree.copyShowAction);
        this.m_delete = this.getDeleteAction();
        this.defineMoreActions();
        actions.add(snapshotMenuVec);
        actions.add(mirrorMenuVec);
        actions.add(resizeMenuVec);
        actions.add(copyMenuVec);
        actions.add(this.m_tree.replaceVolumeAction);
        actions.add(workWith.activateSnapshot);
        actions.add(workWith.deactivateSnapshot);
        actions.add(this.m_tree.restoreSnapshotAction);
        actions.add(new JPopupMenu.Separator());
        actions.add(this.getSynchronizeAction());
        actions.add(new JPopupMenu.Separator());
        actions.add(this.getAlarmsMenu());
        actions.add(new JPopupMenu.Separator());
        actions.add(this.m_tree.renameAction);
        actions.add(this.m_delete);
        actions.add(new JPopupMenu.Separator());
        actions.add(SrVolumeTreePopupMenu.asProperties(this.m_tree.volumePropertiesAction));
        this.addActionItems(actions);
        this.attachActions(actions);
    }

    protected void addActionItems(Vector actions) {
    }

    @Override
    protected void setWorkWith(JComponent workWith) {
        super.setWorkWith(workWith);
        this.m_tree = (SrVolumeTreePanel)workWith;
    }

    protected abstract void defineMoreActions();

    @Override
    public SynchronizeElementAction getSynchronizeAction() {
        return null;
    }

    @Override
    public AlarmAction getSpecificAlarmsAction() {
        return this.m_tree.mySpecificAction;
    }

    @Override
    public AlarmAction getPropagatedAlarmsAction() {
        return this.m_tree.myPropagatedAction;
    }

    @Override
    public DeleteAction getDeleteAction() {
        return this.m_tree.getDeleteAction();
    }

    public static boolean isExposedOnDisconnectedVswitch(VolumeTreeNode<?> node) {
        if (!node.isExposed()) {
            return false;
        }
        if (node.getHeadLu() == null) {
            for (TreeNode parent = node; parent != null; parent = parent.getParent()) {
                System.err.println(parent + " :: " + parent.getClass());
            }
            node.getHeadLu().getTargetParent();
        }
        String exposedOnVswitch = node.getHeadLu().getTargetParent().getExposedOnVSwitchName();
        ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(node);
        VSwitchNode vs = cluster.getVSwitchByName(exposedOnVswitch);
        return !vs.isConnected();
    }
}

