/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.volume.ExposedVolumesTableModelCollection;
import com.sanrad.nms.client.data.volume.SrExposedVolumesTableModel;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.delete.UnexposeAction;
import com.sanrad.nms.client.gui.actions.delete.UnexposeAllTreeAction;
import com.sanrad.nms.client.gui.volume.ExposedVolumeCellRenderer;
import com.sanrad.nms.client.gui.volume.ExposedVolumesTableHeader;
import com.sanrad.nms.client.gui.volume.ExposedVolumesViewPanel;
import com.sanrad.nms.client.gui.volume.LUTableCellRenderer;
import com.sanrad.nms.client.gui.volume.SrExposedVolumePopupMenu;
import com.sanrad.nms.client.gui.volume.SrVolumesTablePanel;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.SrTableModel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrTableView;
import com.sanrad.swing.actions.View;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SrExposedVolumesTablePanel
extends SrVolumesTablePanel {
    private static SrLogger theLogger = SrLogger.getLogger();
    private View<LUNode> myLUNodeView = new SrTableView<LUNode>((JTable)this.getTable()){

        @Override
        public Collection<LUNode> getValue() {
            return SrExposedVolumesTablePanel.this.getSelectedLuNodes();
        }
    };

    public SrExposedVolumesTablePanel(JFrame owner, SrExposedVolumesTableModel model) {
        super(owner, model);
        for (int k = 0; k < this.getModel().getColumnCount(); ++k) {
            TableColumn column = this.getTable().getColumnModel().getColumn(k);
            column.setPreferredWidth(75);
        }
        this.invokeColumnSortOnStartup(1, true);
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SrExposedVolumesTablePanel.this.updateTree();
                }
            }
        });
        final TableModelListener tableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent aEvent) {
                SrExposedVolumesTablePanel.this.updateTree();
            }
        };
        this.getTable().getModel().addTableModelListener(tableModelListener);
        this.getTable().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent aEvt) {
                if (aEvt.getPropertyName().equals("model")) {
                    ((TableModel)aEvt.getOldValue()).removeTableModelListener(tableModelListener);
                    SrExposedVolumesTablePanel.this.getTable().getModel().addTableModelListener(tableModelListener);
                }
            }
        });
        int volumeIndexInModel = ExposedVolumesTableHeader.VOLUME_NAME.getIndexInModel();
        int storageIndexInModel = ExposedVolumesTableHeader.STORAGE_NAME.getIndexInModel();
        int luIndexInModel = ExposedVolumesTableHeader.LUN.getIndexInModel();
        this.getTable().getColumnModel().getColumn(volumeIndexInModel).setCellRenderer(new ExposedVolumeCellRenderer(ExposedVolumesTableHeader.LUN.getColumnName()));
        this.getTable().getColumnModel().getColumn(storageIndexInModel).setCellRenderer(new ExposedVolumeCellRenderer(ExposedVolumesTableHeader.LUN.getColumnName()));
        this.getTable().getColumnModel().getColumn(luIndexInModel).setCellRenderer(new LUTableCellRenderer());
        SrExposedVolumePopupMenu popup = new SrExposedVolumePopupMenu(this, this.myLUNodeView, owner, new UnexposeAction(this.myLUNodeView, (OperationController)StatusPanel.getInstance()), new UnexposeAllTreeAction(this.myLUNodeView, (OperationController)StatusPanel.getInstance()), new AlarmAction<LUNode>(this.myLUNodeView, false), new AlarmAction<LUNode>(this.myLUNodeView, true));
        this.setTablePopUpMenuObject(popup);
    }

    private void updateTree() {
        ExposedVolumesViewPanel parentPanel = (ExposedVolumesViewPanel)SrSwingUtils.getParentOfType(ExposedVolumesViewPanel.class, this);
        parentPanel.volumeTableSelectionChanged(this.getSelectedVolumes());
    }

    @Override
    protected Class getTableHeaderClass() {
        return ExposedVolumesTableHeader.class;
    }

    @Override
    protected SrTableModel getCurrentTableModel() {
        return (SrExposedVolumesTableModel)ExposedVolumesTableModelCollection.getInstance().getCurrentModel();
    }

    @Override
    protected void initTableRenderer() {
    }

    protected VolumeTreeNode[] getSelectedVolumes() {
        int[] selectedRows = this.getSelectedRows();
        ArrayList<VolumeTreeNode> volumeNodeList = new ArrayList<VolumeTreeNode>(selectedRows.length);
        int col = this.getModel().getColumnIndex(ExposedVolumesTableHeader.VOLUME_NAME.getColumnName());
        for (int i = 0; i < selectedRows.length; ++i) {
            if (selectedRows[i] >= this.getModel().getRowCount()) continue;
            VolumeTreeNode volumeNode = (VolumeTreeNode)this.getModel().getValueAt(selectedRows[i], col);
            volumeNodeList.add(volumeNode);
        }
        return volumeNodeList.toArray(new VolumeTreeNode[volumeNodeList.size()]);
    }

    public Collection<LUNode> getSelectedLuNodes() {
        int[] selectedRows = this.getSelectedRows();
        Vector<LUNode> retVal = new Vector<LUNode>(selectedRows.length);
        int col = this.getModel().getColumnIndex(ExposedVolumesTableHeader.LUN.getColumnName());
        for (int i = 0; i < selectedRows.length; ++i) {
            LUNode luNode = (LUNode)this.getModel().getValueAt(selectedRows[i], col);
            if (luNode == null) continue;
            retVal.add(luNode);
        }
        return retVal;
    }
}

