/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.LUManager;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemObjectNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.raid.AttachedRaidManager;
import com.sanrad.nms.client.data.raid.RaidManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceSpace;
import com.sanrad.nms.client.data.storage.StoragePoolSelector;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.DirectAccessDeviceListener;
import com.sanrad.nms.client.event.SubDirectAccessDeviceEvent;
import com.sanrad.nms.client.event.SubDirectAccessDeviceListener;
import com.sanrad.nms.client.event.raid.RaidEvent;
import com.sanrad.nms.client.event.raid.RaidManagerListener;
import com.sanrad.nms.client.event.target.TargetEvent;
import com.sanrad.nms.client.event.target.TargetListener;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.SrSystemObjectComboBox;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.target.dialogs.NewTargetDialog;
import com.sanrad.nms.client.gui.volume.AvailableStorageTablePanel;
import com.sanrad.nms.client.gui.volume.wizard.exchange.SrExchangeVolumeWizardFrame;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.swing.SrOptionPane;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrSliderPanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.ComponentHandler;
import com.sanrad.swing.components.SrButton;
import com.sanrad.swing.components.SrCheckbox;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrDecimalTextField;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.swing.components.SrMultiLineLabel;
import com.sanrad.swing.components.SrTextField;
import com.sanrad.swing.text.AliasDocument;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.StorageSize;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NewVolumeWindow
extends SrOKCancelDialog<SystemObjectNode>
implements TargetListener,
DirectAccessDeviceListener,
SubDirectAccessDeviceListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final int MAX_LUN_VALUE = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.MAX_LUN_VALUE));
    private static final String CLUSTER_SHOULD_BE_SELECTED = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VOLUME_WINDOW_CLUSTER_SHOULD_BE_SELECTED);
    private static final String ALIAS_SHOULD_BE_ENTERED = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VOLUME_WINDOW_ALIAS_SHOULD_BE_ENTERED);
    private static final String STORAGE_TYPE_SHOULD_BE_SELECTED = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VOLUME_WINDOW_STORAGE_TYPE_SHOULD_BE_SELECTED);
    private static final String SIZE_SHOULD_BE_ENTERED = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VOLUME_WINDOW_SIZE_SHOULD_BE_ENTERED);
    private static final String SIZE_EXCEEDS_MAXIMUM = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VOLUME_WINDOW_SIZE_EXCEEDS_MAXIMUM);
    private static final String TARGET_SHOULD_BE_SELECTED = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VOLUME_WINDOW_TARGET_SHOULD_BE_SELECTED);
    private static final String LUN_SHOULD_BE_ENTERED = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VOLUME_WINDOW_LUN_SHOULD_BE_ENTERED);
    private static final String MIRROR_CHECK_BOX_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_MIRROR_CHECK_BOX_TEXT);
    private static final String CAPTION = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_CAPTION);
    private static final String MIRROR_WARN_CAPTION = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_MIRROR_WARN_CAPTION);
    private static final String MIRROR_ONE_RAID_WARN_MSG = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_MIRROR_ONE_RAID_WARN_MSG);
    private static final String MIRROR_SPACE_WARN_MSG = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_MIRROR_SPACE_WARN_MSG);
    private static final String ALIAS_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_ALIAS_LABEL_TEXT);
    private static final String EXPOSED_ON_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_EXPOSED_ON_LABEL_TEXT);
    private static final String NEW_TARGET_BUTTON_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_NEW_TARGET_BUTTON_TEXT);
    private static final String LUN_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_LUN_LABEL_TEXT);
    private static final String SIZE_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_SIZE_LABEL_TEXT);
    private static final String OF_MAXIMUM_SIZE_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_OF_MAXIMUM_SIZE_LABEL_TEXT);
    private static final String LIST_OF_AVAILABLE_STORAGE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_LIST_OF_AVAILABLE_STORAGE);
    private static final String SERVER_VOL_WIZARD_BUTTON_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_SERVER_VOLUME_BUTTON);
    private static final String SERVER_VOL_WIZARD_BUTTON_TOOLTIP = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_SERVER_VOLUME_BUTTON_TOOLTIP);
    private static final String NO_MAX_VALUE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_NO_MAX_VALUE);
    private static final String SELECT_CLUSTER_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_SELECT_CLUSTER_TEXT);
    private static final String TARGET_PANEL_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_TARGET_PANEL_TITLE);
    private static final String LU_PANEL_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_LU_PANEL_TITLE);
    private static final String TARGET_AUTO_NAME_CHECKBOX_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_TARGET_AUTO_NAME_CHECKBOX);
    private static final String MIRROR_INFO = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_MIRROR_INFO);
    private static final String LU_AUTO_NUMBER_CHECKBOX_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_LU_AUTO_NUMBER_CHECKBOX_TEXT);
    private static final String ADVANCED_SHOW_BUTTON = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_ADVANCED_SHOW_BUTTON);
    private static final String ADVANCED_HIDE_BUTTON = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_ADVANCED_HIDE_BUTTON);
    private static final String OPTION_PANE_OK = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_OPTION_PANE_OK);
    private static final int MAX_ALIAS_TEXT_FIELD_LENGTH = 20;
    private SrTextField myAliasTextField = new SrTextField(20);
    private static final String VOLUME_ALIAS_ALLOWED_CHARS_REGEX = "[^#\\$\\+\\-!\\*]";
    private SrCheckbox myMirrorCheckBox = new SrCheckbox(MIRROR_CHECK_BOX_TEXT);
    private SrDecimalTextField mySizeTextField = new SrDecimalTextField();
    private static final StorageSize[] theUnits = new StorageSize[]{StorageSize.MEGA, StorageSize.GIGA, StorageSize.TERA};
    private SrComboBox<StorageSize> mySizeUnitCombobox = new SrComboBox<StorageSize>((T[])theUnits);
    private SrIntegerTextField myLunTextField = new SrIntegerTextField();
    private SrComboBox myTargetComboBox = new SrComboBox();
    private SrLabelField myOfMaxLable = new SrLabelField();
    private BigDecimal myMaxSpace = BigDecimal.ZERO;
    private static NewVolumeWindow theInstance = null;
    private ComponentHandler myComponentHandler;
    private SrPanel myStorageTablePanel;
    private SrCheckbox myTargetAutoNameCheckbox = new SrCheckbox(TARGET_AUTO_NAME_CHECKBOX_TEXT);
    private SrCheckbox myLuAutoNumberCheckbox = new SrCheckbox(LU_AUTO_NUMBER_CHECKBOX_TEXT);
    private AutoTargetNameItem myAutoTargetNameItem = new AutoTargetNameItem();
    private OperationController myOkActionController = null;
    private RaidManagerListener myRaidManagerListener = null;
    private static final String NEW_VOLUME_CREATION_NO_AVAILABLE_DISKS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_CREATION_NO_AVAILABLE_DISKS);
    private AvailableStorageTablePanel myStorageTable;
    private SrMultiLineLabel myNoRaidLabel = new SrMultiLineLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_NO_RAID_ATTACHED));
    private SrSliderPanel myVolSizeSlider = new SrSliderPanel(0, 100, "%", false);
    private ChangeListener myVolSizeSliderListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            BigDecimal percentage = new BigDecimal(NewVolumeWindow.this.myVolSizeSlider.getValue());
            BigInteger maxSizeInt = NewVolumeWindow.this.getMaxSize(NewVolumeWindow.this.myStorageTable.getSelectedRow());
            BigDecimal maxSize = new BigDecimal(maxSizeInt.doubleValue());
            BigDecimal requestedSize = maxSize.multiply(percentage).divide(new BigDecimal(100));
            BigInteger sizeInUnits = StorageDeviceSpace.getSizeInUnit(requestedSize.toBigInteger(), (StorageSize)NewVolumeWindow.this.mySizeUnitCombobox.getSelectedItem());
            NewVolumeWindow.this.mySizeTextField.setText(sizeInUnits.toString());
        }
    };

    private NewVolumeWindow(JFrame owner, ClusterNode aClusterToWorkWith) {
        super(owner, CAPTION, false, null);
        this.myNoRaidLabel.setForeground(Color.RED);
        this.myIsShouldDispose = false;
        this.myIsShowErrMsg = false;
        SrPanel myUpperPanel = this.createNorthPanel();
        SrPanel myCenterPanel = this.createCenterPanel();
        SrPanel myBottomPanel = this.createBottomPanel();
        SrPanel mainPanel = new SrPanel(new BorderLayout());
        this.addCenterPanel(mainPanel);
        mainPanel.add((Component)myUpperPanel, "North");
        mainPanel.add((Component)myCenterPanel, "Center");
        mainPanel.add((Component)myBottomPanel, "South");
        this.setButtonsPanelActions();
        this.myComponentHandler = new ComponentHandler(mainPanel);
        SrSystemObjectComboBox.SysNodeProperties comboBoxNodeProp = new SrSystemObjectComboBox.SysNodeProperties(){

            @Override
            protected boolean isItemInContext(Object aNode) {
                return aNode instanceof VSwitchNode || aNode instanceof ClusterNode;
            }
        };
        this.addTopContextBox(SELECT_CLUSTER_TEXT, ClusterNode.class, comboBoxNodeProp, null);
        this.setTopContextBoxSelection(aClusterToWorkWith);
        this.pack();
    }

    private void handleEventForChangeInStorage() {
        this.clearAndSetStorageTable();
        this.updateSelectedRaidsForVolumeCreation();
        this.updateAutoTargetNameItem();
        this.updateLuFieldItem();
    }

    private void handleEventForChangeInMirrorSelection() {
        this.updateSelectedRaidsForVolumeCreation();
    }

    private void updateSelectedRaidsForVolumeCreation() {
        this.updateMaxSizeText();
        this.updateVolumeSizeSlideBar();
    }

    private void clearVolumeAliasSizeFieldsAndSlider() {
        this.myAliasTextField.setText("");
        this.mySizeTextField.setText("");
        this.updateVolumeSizeSlideBar();
    }

    private SrPanel createNorthPanel() {
        SrPanel panel = new SrPanel(new GridLayout(2, 1, 5, 5));
        this.myAliasTextField.setDocument(new AliasDocument(VOLUME_ALIAS_ALLOWED_CHARS_REGEX));
        this.myAliasTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateAutoTargetName();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateAutoTargetName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateAutoTargetName();
            }

            private void updateAutoTargetName() {
                NewVolumeWindow.this.myAutoTargetNameItem.setName(TargetManager.getInstance().getAutoTargetNameForVolume(NewVolumeWindow.this.getRequestedAlias()));
                NewVolumeWindow.this.myTargetComboBox.repaint();
            }
        });
        SrPanel aliasPanel = new SrPanel(new FlowLayout(0));
        SrLabelField aliasLabel = new SrLabelField(ALIAS_LABEL_TEXT);
        aliasPanel.add(aliasLabel);
        aliasPanel.add(this.myAliasTextField);
        SrPanel mirrorPanel = new SrPanel(new FlowLayout(0));
        this.myMirrorCheckBox.setHorizontalTextPosition(2);
        this.myMirrorCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NewVolumeWindow.this.handleEventForChangeInMirrorSelection();
                if (NewVolumeWindow.this.myMirrorCheckBox.isSelected()) {
                    int row;
                    boolean isSingleRaidCluster;
                    boolean bl = isSingleRaidCluster = AttachedRaidManager.getInstance().getAttachedRaids(NewVolumeWindow.this.m_workingCluster).size() < 2;
                    if (isSingleRaidCluster) {
                        SrOptionPane warningPane = new SrOptionPane(MIRROR_WARN_CAPTION, MIRROR_ONE_RAID_WARN_MSG, SrOptionPane.MessageType.WARNING_DIALOG, NewVolumeWindow.this);
                        warningPane.addButton(new SrOptionPane.Option<String>(OPTION_PANE_OK), 0);
                        warningPane.show();
                    }
                    if ((row = NewVolumeWindow.this.myStorageTable.getSelectedRow()) > -1) {
                        PhysicalStorageDriveTypeConstant type = NewVolumeWindow.this.myStorageTable.getStorageTypeAt(row);
                        PhysicalStorageRaidLevelConstant raidLevel = NewVolumeWindow.this.myStorageTable.getRaidLevelAt(row);
                        BigInteger twoRaidsMirrorSize = StoragePoolSelector.getMaxMirrorSpace(NewVolumeWindow.this.m_workingCluster, type, raidLevel);
                        BigInteger requestedSize = NewVolumeWindow.this.getRequestedVolumeSize().toBigInteger();
                        if (requestedSize.compareTo(twoRaidsMirrorSize) > 0) {
                            SrOptionPane warningPane = new SrOptionPane(MIRROR_WARN_CAPTION, MIRROR_SPACE_WARN_MSG, SrOptionPane.MessageType.WARNING_DIALOG, NewVolumeWindow.this);
                            warningPane.addButton(new SrOptionPane.Option<String>(OPTION_PANE_OK), 0);
                            warningPane.show();
                        }
                    }
                }
            }
        });
        this.myMirrorCheckBox.setFocusPainted(false);
        SrClientLabel imageLabel = new SrClientLabel();
        imageLabel.setIcon(ClientImageObject.INFORMATION.getImageIcon());
        imageLabel.setToolTipText(MIRROR_INFO);
        mirrorPanel.add(imageLabel);
        mirrorPanel.add(this.myMirrorCheckBox);
        panel.add(aliasPanel);
        panel.add(mirrorPanel);
        panel.setBorder(new EmptyBorder(20, 20, 0, 0));
        return panel;
    }

    private SrPanel createCenterPanel() {
        SrPanel panel = new SrPanel(new BorderLayout());
        this.myStorageTable = new AvailableStorageTablePanel();
        this.myStorageTablePanel = this.createAvailableResourceTablePanel(this.myStorageTable, LIST_OF_AVAILABLE_STORAGE);
        panel.setBorder(new EmptyBorder(0, 20, 0, 20));
        panel.add((Component)this.myStorageTablePanel, "Center");
        SrPanel sizePanel = new SrPanel(new GridBagLayout());
        SrLabelField sizeLable = new SrLabelField(SIZE_LABEL_TEXT);
        this.mySizeUnitCombobox.setSelectedItem(StorageSize.GIGA);
        this.updateMaxSizeText();
        this.updateVolumeSizeSlideBar();
        this.myVolSizeSlider.addChangeListener(this.myVolSizeSliderListener);
        this.myVolSizeSlider.setMajorTickSpacing(10);
        this.myVolSizeSlider.setMinorTickSpacing(5);
        this.myVolSizeSlider.showTicks(true);
        this.myVolSizeSlider.showLabels(true);
        GridBagConstraints c = NewVolumeWindow.getGridBagConstraintsForSimpleFields();
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        sizePanel.add((Component)sizeLable, c);
        c.gridx = 1;
        sizePanel.add((Component)this.mySizeTextField, c);
        c.gridx = 2;
        sizePanel.add(this.mySizeUnitCombobox, c);
        c.gridx = 3;
        sizePanel.add((Component)this.myOfMaxLable, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 4;
        c.insets.left = 0;
        sizePanel.add((Component)this.myVolSizeSlider, c);
        panel.add((Component)sizePanel, "South");
        return panel;
    }

    private SrPanel createAvailableResourceTablePanel(AvailableStorageTablePanel table, String aTableTitle) {
        SrPanel panel = new SrPanel(new BorderLayout());
        SrLabelField title = new SrLabelField(aTableTitle);
        panel.add((Component)title, "North");
        panel.add((Component)this.myNoRaidLabel, "North");
        this.setNoRaidLabelVisibility(false);
        table.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                NewVolumeWindow.this.updateMaxSizeText();
                NewVolumeWindow.this.updateVolumeSizeSlideBar();
            }
        });
        panel.add((Component)table, "Center");
        return panel;
    }

    private void setNoRaidLabelVisibility(boolean aVisible) {
        this.myNoRaidLabel.setVisible(aVisible);
    }

    private SrPanel createBottomPanel() {
        final SrPanel panel = new SrPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(20, 20, 20, 20));
        final SrPanel targetAndLunPanel = this.createSizeTargetAndLuPanel();
        final SrButton advancedButton = new SrButton("");
        AbstractAction action = new AbstractAction(ADVANCED_SHOW_BUTTON){
            boolean isAdvancedShowing;
            {
                super(x0);
                this.isAdvancedShowing = false;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.isAdvancedShowing = !this.isAdvancedShowing;
                int windowW = NewVolumeWindow.this.getWidth();
                int windowH = NewVolumeWindow.this.getHeight();
                int hDiff = targetAndLunPanel.getPreferredSize().height;
                windowH = this.isAdvancedShowing ? windowH + hDiff : windowH - hDiff;
                NewVolumeWindow.this.setSize(new Dimension(windowW, windowH));
                if (this.isAdvancedShowing) {
                    panel.add((Component)targetAndLunPanel, "South");
                    advancedButton.setText(ADVANCED_HIDE_BUTTON);
                } else {
                    panel.remove(targetAndLunPanel);
                    advancedButton.setText(ADVANCED_SHOW_BUTTON);
                }
            }
        };
        advancedButton.setAction(action);
        SrPanel buttonPanel = new SrPanel(new BorderLayout());
        buttonPanel.add((Component)advancedButton, "West");
        panel.add((Component)buttonPanel, "North");
        return panel;
    }

    private SrPanel createLuPanel() {
        SrPanel retVal = new SrPanel(new GridBagLayout());
        final SrLabelField luNumberLabel = new SrLabelField(LUN_LABEL_TEXT);
        this.myLuAutoNumberCheckbox.setFocusPainted(false);
        this.myLuAutoNumberCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    luNumberLabel.setEnableComponent(false);
                    NewVolumeWindow.this.myLunTextField.setEnableComponent(false);
                    NewVolumeWindow.this.updateLuFieldItem();
                } else if (e.getStateChange() == 2) {
                    NewVolumeWindow.this.myLunTextField.setEnableComponent(true);
                    luNumberLabel.setEnableComponent(true);
                }
            }
        });
        this.myLuAutoNumberCheckbox.setSelected(true);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 5, 0);
        c.anchor = 18;
        retVal.add((Component)this.myLuAutoNumberCheckbox, c);
        c.insets.top = 5;
        c.insets.left = 23;
        c.gridx = 0;
        c.gridy = 1;
        this.myLunTextField.setMaxValue(MAX_LUN_VALUE);
        retVal.add((Component)this.myLunTextField, c);
        retVal.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LU_PANEL_TITLE, 0, 0));
        return retVal;
    }

    private SrPanel createSizeTargetAndLuPanel() {
        SrPanel panel = new SrPanel(new BorderLayout(0, 5));
        SrPanel targetPanel = new SrPanel(new GridBagLayout());
        SrPanel luPanel = this.createLuPanel();
        final SrLabelField exposedOnLabel = new SrLabelField(EXPOSED_ON_LABEL_TEXT);
        final SrButton newTargetButton = new SrButton(new AbstractAction(NEW_TARGET_BUTTON_TEXT){

            @Override
            public void actionPerformed(ActionEvent e) {
                new NewTargetDialog((JDialog)NewVolumeWindow.this, NewVolumeWindow.this.m_workingCluster);
            }
        });
        this.myTargetAutoNameCheckbox.setFocusPainted(false);
        this.myTargetAutoNameCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    NewVolumeWindow.this.myTargetComboBox.addItem(NewVolumeWindow.this.myAutoTargetNameItem);
                    NewVolumeWindow.this.myTargetComboBox.setSelectedItem(NewVolumeWindow.this.myAutoTargetNameItem);
                    NewVolumeWindow.this.myTargetComboBox.setEnableComponent(false);
                    exposedOnLabel.setEnableComponent(false);
                    newTargetButton.setEnableComponent(false);
                }
                if (e.getStateChange() == 2) {
                    NewVolumeWindow.this.myTargetComboBox.removeItem(NewVolumeWindow.this.myAutoTargetNameItem);
                    NewVolumeWindow.this.myTargetComboBox.setEnableComponent(true);
                    NewVolumeWindow.this.myTargetComboBox.setSelectedItem(null);
                    exposedOnLabel.setEnableComponent(true);
                    newTargetButton.setEnableComponent(true);
                }
                NewVolumeWindow.this.updateLuFieldItem();
            }
        });
        this.myTargetComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!NewVolumeWindow.this.myLuAutoNumberCheckbox.isSelected()) {
                    return;
                }
                NewVolumeWindow.this.updateLuFieldItem();
            }
        });
        this.myTargetAutoNameCheckbox.setSelected(true);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 5, 0);
        c.anchor = 18;
        c.gridwidth = 3;
        targetPanel.add((Component)this.myTargetAutoNameCheckbox, c);
        c.gridwidth = 1;
        c.insets.top = 5;
        c.insets.left = 23;
        c.gridx = 0;
        c.gridy = 1;
        targetPanel.add((Component)exposedOnLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        targetPanel.add((Component)this.myTargetComboBox, c);
        c.gridx = 2;
        c.gridy = 1;
        c.weightx = 1.0;
        targetPanel.add((Component)newTargetButton, c);
        targetPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TARGET_PANEL_TITLE, 0, 0));
        panel.add((Component)targetPanel, "Center");
        panel.add((Component)luPanel, "South");
        panel.setBorder(new EmptyBorder(20, 0, 0, 0));
        return panel;
    }

    private void setButtonsPanelActions() {
        this.setOKAction();
        SrButton exchangeVolWizButton = new SrButton(new AbstractAction(SERVER_VOL_WIZARD_BUTTON_TEXT){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewVolumeWindow.this.dispose();
                SrExchangeVolumeWizardFrame wiz = new SrExchangeVolumeWizardFrame(NewVolumeWindow.this.m_workingCluster);
                wiz.runWizard();
            }
        });
        exchangeVolWizButton.setToolTipText(SERVER_VOL_WIZARD_BUTTON_TOOLTIP);
        this.buttonsPanel.add(exchangeVolWizButton);
    }

    private void clearAndSetStorageTable() {
        this.myStorageTable.updateTable(this.m_workingCluster);
        this.setNoRaidLabelVisibility(this.myStorageTable.getAllRows().isEmpty());
        if (this.myStorageTable.getRowCount() == 1) {
            this.myStorageTable.getTable().getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void clearAndSetTargetList() {
        for (int i = 0; i < this.myTargetComboBox.getItemCount(); ++i) {
            if (this.myTargetComboBox.getItemAt(i).equals(this.myAutoTargetNameItem)) continue;
            this.myTargetComboBox.removeItem(this.myTargetComboBox.getItemAt(i));
        }
        if (this.m_workingCluster != null) {
            List<TargetNode> targetList = this.m_workingCluster.findAllInSubTree(TargetNode.class);
            Object sysNode = this.getTopContextBoxSelection();
            for (TargetNode target : targetList) {
                if (sysNode instanceof VSwitchNode) {
                    VSwitchNode vswitch = (VSwitchNode)sysNode;
                    if (!vswitch.getName().equals(target.getExposedOnVSwitchName())) continue;
                    this.myTargetComboBox.addItem(target);
                    continue;
                }
                this.myTargetComboBox.addItem(target);
            }
        }
        if (this.myTargetComboBox.getItemCount() > 1 && !this.myTargetAutoNameCheckbox.isSelected()) {
            this.myTargetComboBox.setSelectedItem(null);
        }
    }

    @Override
    protected void systemNodeSelected(SystemObjectNode aSystemNode) {
        if (this.m_workingCluster != null) {
            this.myComponentHandler.storeComponentsState();
        }
        if (aSystemNode == null) {
            this.myComponentHandler.setAllEnabled(false);
        } else {
            this.myComponentHandler.revertEnabledState();
        }
        ClusterNode prevCluster = this.m_workingCluster;
        if (aSystemNode != null) {
            this.m_workingCluster = (ClusterNode)((SrTreeNode)((Object)aSystemNode)).getAncestorOfType(ClusterNode.class);
        }
        this.clearAndSetTargetList();
        if (!Util.equalsWithNull(prevCluster, this.m_workingCluster)) {
            this.clearAndSetStorageTable();
            this.updateMaxSizeText();
        }
    }

    private void updateMaxSizeText() {
        this.setMaxSize();
        this.myStorageTable.clearDisabledRowsState();
        for (int i = 0; i < this.myStorageTable.getRowCount(); ++i) {
            if (!BigInteger.ZERO.equals(this.getMaxSize(i))) continue;
            this.myStorageTable.setEnabledRow(i, false);
        }
        String maxSizeString = NO_MAX_VALUE;
        if (this.myMaxSpace != null) {
            StorageDeviceSpace space = new StorageDeviceSpace(this.myMaxSpace.toBigInteger());
            maxSizeString = space.toString();
        }
        String ofMaximumValue = OF_MAXIMUM_SIZE_LABEL_TEXT + " " + maxSizeString;
        this.myOfMaxLable.setText(ofMaximumValue);
    }

    private void updateVolumeSizeSlideBar() {
        double precentage;
        BigDecimal p = BigDecimal.ZERO;
        String volSizeStr = this.mySizeTextField.getText().trim();
        BigDecimal volSizeInKBytes = BigDecimal.ZERO;
        if (!volSizeStr.equals("")) {
            BigDecimal unitSize = new BigDecimal(((StorageSize)this.mySizeUnitCombobox.getSelectedItem()).getValue());
            volSizeInKBytes = new BigDecimal(volSizeStr).multiply(unitSize);
        }
        if (BigDecimal.ZERO.compareTo(volSizeInKBytes) < 0 && BigDecimal.ZERO.compareTo(this.myMaxSpace) != 0 && (p = new BigDecimal(precentage = volSizeInKBytes.doubleValue() * 100.0 / this.myMaxSpace.doubleValue())).compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalStateException("The volume size in precents = " + p + " is not valid");
        }
        this.myVolSizeSlider.setValue(p.intValue());
        if (this.myMaxSpace.compareTo(BigDecimal.ZERO) == 0) {
            this.myVolSizeSlider.setEnabled(false);
        } else {
            this.myVolSizeSlider.setEnabled(true);
        }
        this.myVolSizeSlider.setVisible(true);
    }

    private BigInteger getMaxSize(int aRow) {
        if (aRow < 0) {
            return BigInteger.ZERO;
        }
        PhysicalStorageDriveTypeConstant type = this.myStorageTable.getStorageTypeAt(aRow);
        PhysicalStorageRaidLevelConstant raidLevel = this.myStorageTable.getRaidLevelAt(aRow);
        BigInteger size = StoragePoolSelector.getMaxVolumeSpace(this.m_workingCluster, type, raidLevel);
        if (this.myMirrorCheckBox.isSelected()) {
            return size.divide(new BigInteger("2"));
        }
        return size;
    }

    private void setMaxSize() {
        BigInteger maxSize = this.getMaxSize(this.myStorageTable.getSelectedRow());
        this.myMaxSpace = maxSize != null ? new BigDecimal(maxSize) : null;
    }

    private String isValidForCreation() {
        if (this.m_workingCluster == null) {
            return CLUSTER_SHOULD_BE_SELECTED;
        }
        if (this.myStorageTable.getSelectedRow() < 0) {
            return STORAGE_TYPE_SHOULD_BE_SELECTED;
        }
        if (this.myMaxSpace == null || this.myMaxSpace.equals(BigDecimal.ZERO)) {
            return NEW_VOLUME_CREATION_NO_AVAILABLE_DISKS;
        }
        String alias = this.myAliasTextField.getText();
        if (alias.trim().equals("")) {
            return ALIAS_SHOULD_BE_ENTERED;
        }
        String size = this.mySizeTextField.getText().trim();
        if (size.equals("")) {
            return SIZE_SHOULD_BE_ENTERED;
        }
        BigDecimal sizeInBytes = new BigDecimal(size).multiply(((StorageSize)this.mySizeUnitCombobox.getSelectedItem()).getDecimalValue());
        sizeInBytes = new BigDecimal(sizeInBytes.toBigInteger());
        if (this.myMaxSpace != null && sizeInBytes.compareTo(this.myMaxSpace) > 0) {
            return SIZE_EXCEEDS_MAXIMUM;
        }
        Object target = this.myTargetComboBox.getSelectedItem();
        if (target == null) {
            return TARGET_SHOULD_BE_SELECTED;
        }
        String lun = this.myLunTextField.getText();
        if (lun.trim().equals("")) {
            return LUN_SHOULD_BE_ENTERED;
        }
        return null;
    }

    private void setOKAction() {
        SrClientAction<Void, Void> myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

            @Override
            public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
                Object selectedTargetComboItem = NewVolumeWindow.this.myTargetComboBox.getSelectedItem();
                TargetNode target = null;
                if (selectedTargetComboItem instanceof TargetNode) {
                    target = (TargetNode)selectedTargetComboItem;
                }
                Integer lun = new Integer(NewVolumeWindow.this.myLunTextField.getText().trim());
                if (target != null) {
                    for (LUNode curLu : target.getLuNodes()) {
                        if (!lun.equals(curLu.getLUN())) continue;
                        SrAction.ActionValidationException exp = new SrAction.ActionValidationException("LUN " + lun + " is already in use in target " + target.getAlias());
                        SrFuture retFuture = new SrFuture("NewVolumeWindow.setOKAction$derivedActionPerformed");
                        retFuture.setException(exp);
                        return Collections.singleton(retFuture);
                    }
                }
                try {
                    ClientConfigElementData ced = null;
                    ced = NewVolumeWindow.this.myMirrorCheckBox.isSelected() ? NewVolumeWindow.this.createAutoVolumeCed(NewVolumeWindow.this.getRequestedAlias(), ClassID.MIRROR_VOLUME) : NewVolumeWindow.this.createAutoVolumeCed(NewVolumeWindow.this.getRequestedAlias(), ClassID.GENERAL_VOLUME);
                    NewVolumeWindow.this.myVolSizeSlider.setLock(true);
                    return Collections.singleton(ClientAOImpl.getInstance().configureElementsTree(ced));
                }
                catch (SrAction.ActionValidationException exp) {
                    SrFuture retFuture = new SrFuture("NewVolumeWindow.setOKAction$derivedActionPerformed");
                    retFuture.setException(exp);
                    return Collections.singleton(retFuture);
                }
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                return NewVolumeWindow.this.isValidForCreation();
            }
        };
        this.myOkActionController = new NewVolumeController(this);
        myOKAction.addControllerAsListener(this.myOkActionController);
        this.addItemListenerToTopContextBox(new View.ToggleButtonListener(myOKAction));
        this.myAliasTextField.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.myStorageTable.getTable().getSelectionModel().addListSelectionListener(new View.ViewListSelectionListener(myOKAction));
        this.myMirrorCheckBox.addItemListener(new View.ToggleButtonListener(myOKAction));
        this.myOfMaxLable.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.mySizeTextField.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        KeyListener sizeTextFieldToSliderListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                NewVolumeWindow.this.myVolSizeSlider.removeChangeListener(NewVolumeWindow.this.myVolSizeSliderListener);
                NewVolumeWindow.this.updateVolumeSizeSlideBar();
                NewVolumeWindow.this.myVolSizeSlider.addChangeListener(NewVolumeWindow.this.myVolSizeSliderListener);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        this.mySizeTextField.addKeyListener(sizeTextFieldToSliderListener);
        ActionListener sizeUnitSelectedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewVolumeWindow.this.updateVolumeSizeSlideBar();
            }
        };
        this.mySizeUnitCombobox.addActionListener(sizeUnitSelectedListener);
        this.mySizeUnitCombobox.addItemListener(new View.ToggleButtonListener(myOKAction));
        this.myLunTextField.getDocument().addDocumentListener(new View.ViewTextListener(myOKAction));
        this.myTargetComboBox.addItemListener(new View.ToggleButtonListener(myOKAction));
        this.setOKAction(myOKAction);
    }

    public static void show(JFrame aOwner, ClusterNode aWorkingCluster) {
        if (theInstance == null) {
            theInstance = new NewVolumeWindow(aOwner, aWorkingCluster);
        } else {
            theInstance.setTopContextBoxSelection(aWorkingCluster);
        }
        theInstance.setVisible(true);
        theInstance.toFront();
    }

    @Override
    public void dispose() {
        theInstance = null;
        super.dispose();
    }

    @Override
    public void doOnCancel() {
        this.dispose();
    }

    @Override
    public void addListeners() {
        TargetManager.getInstance().addTargetListener(this);
        DirectAccessDeviceManager.getInstance().addDirectAccessDeviceListener(this);
        SubDirectAccessDeviceManager.getInstance().addSubDirectDeviceListener(this);
        this.initRaidListeners();
        RaidManager.getInstance().addListener(this.myRaidManagerListener);
    }

    @Override
    public void removeListeners() {
        TargetManager.getInstance().removeTargetListener(this);
        DirectAccessDeviceManager.getInstance().removeDirectAccessDeviceListener(this);
        SubDirectAccessDeviceManager.getInstance().removeSubDirectDeviceListener(this);
    }

    @Override
    public void newTargetCreate(TargetEvent e) {
        this.updateAutoTargetNameItem();
        TargetNode newTarget = (TargetNode)e.getValue();
        this.myTargetComboBox.addItem(newTarget);
        if (!this.myTargetAutoNameCheckbox.isSelected()) {
            this.myTargetComboBox.setSelectedItem(newTarget);
        }
    }

    @Override
    public void targetAliasChanged(TargetEvent e) {
        RemoteObject stub = e.getStub();
        this.updateAutoTargetNameItem();
        int count = this.myTargetComboBox.getItemCount();
        boolean changed = false;
        for (int i = 0; i < count; ++i) {
            TargetNode tn = (TargetNode)this.myTargetComboBox.getItemAt(i);
            if (!((Target)tn.getStub()).equals(stub)) continue;
            changed = true;
        }
        if (changed) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewVolumeWindow.this.myTargetComboBox.repaint();
                }
            });
        }
    }

    @Override
    public void targetNameChanged(TargetEvent e) {
    }

    @Override
    public void targetRemove(TargetEvent e) {
        RemoteObject stub = e.getStub();
        this.updateAutoTargetNameItem();
        int count = this.myTargetComboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            TargetNode tn = (TargetNode)this.myTargetComboBox.getItemAt(i);
            if (!((Target)tn.getStub()).equals(stub)) continue;
            this.myTargetComboBox.removeItemAt(i);
            break;
        }
    }

    @Override
    public void targetStatusCanged(TargetEvent e) {
    }

    @Override
    public void targetUserNameChanged(TargetEvent e) {
    }

    @Override
    public void targetVSwitchNameChanged(TargetEvent e) {
    }

    @Override
    public void directAccessDeviceAliasChanged(DirectAccessDeviceEvent event) {
    }

    @Override
    public void directAccessDeviceBlinkStateChange(DirectAccessDeviceEvent event) {
    }

    @Override
    public void directAccessDeviceChanged(DirectAccessDeviceEvent event) {
        StorageDeviceNode storage = event.getStorageNode();
        if (storage instanceof DirectAccessDeviceNode) {
            this.handleEventForChangeInStorage();
        }
    }

    @Override
    public void directAccessDeviceCreated(DirectAccessDeviceEvent event) {
        StorageDeviceNode storage = event.getStorageNode();
        if (storage instanceof DirectAccessDeviceNode) {
            this.handleEventForChangeInStorage();
        }
    }

    @Override
    public void directAccessDeviceDeExposed(DirectAccessDeviceEvent event) {
        StorageDeviceNode storage = event.getStorageNode();
        if (storage instanceof DirectAccessDeviceNode) {
            this.handleEventForChangeInStorage();
        }
    }

    @Override
    public void directAccessDeviceExposed(DirectAccessDeviceEvent event) {
        StorageDeviceNode storage = event.getStorageNode();
        if (storage instanceof DirectAccessDeviceNode) {
            this.handleEventForChangeInStorage();
        }
    }

    @Override
    public void directAccessDeviceInfoChanged(DirectAccessDeviceEvent event) {
    }

    @Override
    public void directAccessDeviceRemoved(DirectAccessDeviceEvent event) {
        StorageDeviceNode storage = event.getStorageNode();
        if (storage instanceof DirectAccessDeviceNode) {
            this.handleEventForChangeInStorage();
        }
    }

    @Override
    public void directAccessDeviceStatusChanged(DirectAccessDeviceEvent event) {
        StorageDeviceNode storage = event.getStorageNode();
        if (storage instanceof DirectAccessDeviceNode) {
            this.handleEventForChangeInStorage();
        }
    }

    @Override
    public void subDirecetAccessDeviceAliasChanged(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceCreated(SubDirectAccessDeviceEvent event) {
        this.handleEventForChangeInStorage();
    }

    @Override
    public void subDirecetAccessDeviceInfoChanged(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirecetAccessDeviceRemoved(SubDirectAccessDeviceEvent event) {
        this.handleEventForChangeInStorage();
    }

    @Override
    public void subDirecetAccessDeviceStatusChanged(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirectAccessDeviceDeExposed(SubDirectAccessDeviceEvent event) {
    }

    @Override
    public void subDirectAccessDeviceExposed(SubDirectAccessDeviceEvent event) {
    }

    private void initRaidListeners() {
        this.myRaidManagerListener = new RaidManagerListener(){

            @Override
            public void RaidAttached(RaidEvent raidEvent) {
                NewVolumeWindow.this.handleEventForChangeInStorage();
            }

            @Override
            public void RaidChanged(RaidEvent raidEvent) {
            }

            @Override
            public void RaidCreated(RaidEvent raidEvent) {
                NewVolumeWindow.this.handleEventForChangeInStorage();
            }

            @Override
            public void RaidDetached(RaidEvent raidEvent) {
                NewVolumeWindow.this.handleEventForChangeInStorage();
            }

            @Override
            public void RaidRemoved(RaidEvent raidEvent) {
                NewVolumeWindow.this.handleEventForChangeInStorage();
            }
        };
    }

    private String getNextLu() {
        if (this.myTargetAutoNameCheckbox.isSelected()) {
            return "0";
        }
        Object selectedItem = this.myTargetComboBox.getSelectedItem();
        if (!(selectedItem instanceof TargetNode)) {
            return "N/A";
        }
        return String.valueOf(LUManager.getNextFreeLuNumber((TargetNode)selectedItem));
    }

    private ClientConfigElementData createAutoVolumeCed(String aAlias, ClassID aVolumeType) throws SrAction.ActionValidationException {
        ClientConfigElementData volCed = new ClientConfigElementData(aVolumeType, (CommKeyClassId)this.m_workingCluster.getIdentifier(), ConfigOperation.CREATE);
        volCed.putValue(ClientParameterCode.VOLUME_ALIAS, aAlias);
        volCed.putValue(ClientParameterCode.VOLUME_SPACE, this.getRequestedVolumeSize().toBigInteger());
        int selectedRow = this.myStorageTable.getSelectedRow();
        if (selectedRow < 0) {
            throw new IllegalStateException("A row should be selected at this point");
        }
        volCed.putValue(ClientParameterCode.PHYSICAL_STORAGE_DRIVE_TYPE, this.myStorageTable.getStorageTypeAt(selectedRow));
        volCed.putValue(ClientParameterCode.PHYSICAL_STORAGE_RAID_LEVEL, this.myStorageTable.getRaidLevelAt(selectedRow));
        Object target = this.myTargetComboBox.getSelectedItem();
        if (target instanceof TargetNode) {
            volCed.putValue(ClientParameterCode.TARGET_NAME, ((TargetNode)target).getName());
        } else {
            volCed.putValue(ClientParameterCode.TARGET_NAME, this.myAutoTargetNameItem.getName());
            Object selectedComboboxNode = this.getTopContextBoxSelection();
            if (selectedComboboxNode instanceof VSwitchNode) {
                VSwitchNode vswitch = (VSwitchNode)selectedComboboxNode;
                volCed.putValue(ClientParameterCode.VSWITCH_NAME, vswitch.getName());
            }
        }
        volCed.putValue(ClientParameterCode.LU_LUN, new Long(this.myLunTextField.getText()));
        return volCed;
    }

    private BigDecimal getRequestedVolumeSize() {
        String size = this.mySizeTextField.getText().trim();
        if (size.length() == 0) {
            return BigDecimal.ZERO;
        }
        StorageSize sizeUnit = (StorageSize)this.mySizeUnitCombobox.getSelectedItem();
        BigDecimal volSize = new BigDecimal(size).multiply(sizeUnit.getDecimalValue());
        return volSize;
    }

    private String getRequestedAlias() {
        return this.myAliasTextField.getText().trim();
    }

    private void updateAutoTargetNameItem() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewVolumeWindow.this.myAutoTargetNameItem.setName(TargetManager.getInstance().getAutoTargetNameForVolume(NewVolumeWindow.this.getRequestedAlias()));
                NewVolumeWindow.this.myTargetComboBox.refreshItem(NewVolumeWindow.this.myAutoTargetNameItem);
            }
        });
    }

    private void updateLuFieldItem() {
        this.myLunTextField.setValue(this.getNextLu());
    }

    private class NewVolumeController
    implements OperationController {
        Window myOwner = null;

        public NewVolumeController(Window aOwner) {
            this.myOwner = aOwner;
        }

        @Override
        public void fail(String message) {
            String msg = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_CREATE_FAILED);
            this.showContinueCreateVolumeDialog(msg + "\n\n" + message + "\n", SrOptionPane.MessageType.ERROR_DIALOG);
        }

        @Override
        public void inProcess(String message) {
        }

        @Override
        public void success(SrAction action) {
            String msg = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_CREATE_SUCCESS);
            this.showContinueCreateVolumeDialog(msg, SrOptionPane.MessageType.QUESTION_DIALOG);
        }

        private void showContinueCreateVolumeDialog(String aMsg, SrOptionPane.MessageType aMessageType) {
            NewVolumeWindow.this.myVolSizeSlider.setLock(false);
            NewVolumeWindow.this.clearVolumeAliasSizeFieldsAndSlider();
            SrOptionPane.Option<String> result = SrOptionPaneUtil.showYesNoConfirmDialog(CAPTION, aMsg + "\n" + ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_CREATE_ANOTHER_VOLUME), aMessageType, this.myOwner);
            if (result == SrOptionPaneUtil.NO_BUTTON) {
                this.myOwner.dispose();
                return;
            }
            NewVolumeWindow.this.handleEventForChangeInStorage();
        }
    }

    public static class AutoTargetNameItem {
        private String myName = "";

        String getName() {
            return this.myName;
        }

        public void setName(String aName) {
            this.myName = aName;
        }

        public String toString() {
            return String.valueOf(this.myName);
        }
    }
}

