/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui.volume;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.SrTableCellRenderer;
import com.sanrad.swing.SrTableModel;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;

public class ExposedVolumeCellRenderer
extends SrTableCellRenderer {
    private static String notAvailableValue = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE);
    private String m_lunColumnName;

    public ExposedVolumeCellRenderer(String lunColumnName) {
        this.m_lunColumnName = lunColumnName;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String strVal = value == null ? notAvailableValue : ((VolumeTreeNode)value).getAlias();
        ImageIcon icon = null;
        int luInd = ((SrTableModel)table.getModel()).getColumnIndex(this.m_lunColumnName);
        LUNode luNode = (LUNode)table.getModel().getValueAt(row, luInd);
        if (luNode == null) {
            strVal = "";
        } else if (value != null) {
            icon = SrSwingUtils.horizontallyJoinTwoIcons((ImageIcon)luNode.getAlarmIcon(), ClientImageObject.LU.getImageIcon(), 1);
        }
        super.getTableCellRendererComponent(table, strVal, isSelected, hasFocus, row, column);
        this.setIcon(icon);
        return this;
    }
}

